<?php
get_header();

global $post;
$clinicmaster_option = getDZThemeReduxOption();

$show_sidebar            = isset($clinicmaster_option['show_sidebar']) ? $clinicmaster_option['show_sidebar'] : true;
$layout                  = !empty($clinicmaster_option['layout']) ? $clinicmaster_option['layout'] : '';
$sidebar                 = !empty($clinicmaster_option['sidebar']) ? $clinicmaster_option['sidebar'] : '';
$sidebar_class 			 = !empty($clinicmaster_option['sidebar_bg_color']) ? $clinicmaster_option['sidebar_bg_color']: '';
$justify_content 		 = '';
$product_layout 		 = clinicmaster_get_post_meta($post->ID, 'product_layout');
$layout 				 = (!$show_sidebar) ? 'full' : $layout;

if ($layout == 'full' || !is_active_sidebar($sidebar)) {
	$classes = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
	$content_class = '';
} else {
	$classes = 'col-lg-8 col-md-12 m-b10 ';
	$content_class = 'sidebar';
}

$layout_checkout = clinicmaster_get_opt('shop_checkout_page');
if (isset($_GET['checkout_layout'])) {
	$layout_checkout = sanitize_text_field($_GET['checkout_layout']);
}

$layout_cart = clinicmaster_get_opt('shop_cart_page');
if (isset($_GET['cart_layout'])) {
	$layout_cart = sanitize_text_field($_GET['cart_layout']);
}

$page_text_class = 'dz-page-text';
if ( clinicmaster_is_woocommerce_active()
	|| (function_exists('is_account_page') && is_account_page())
	|| (function_exists('is_cart') && is_cart())
	|| (function_exists('is_checkout') && is_checkout())
	|| is_page('wishlist')
	|| is_page('Order Trading')
) {
	if (($layout_checkout == 'modern') && (is_checkout() || function_exists('is_checkout')) || ($layout_cart == 'modern') && (is_cart())) {
		$page_text_class = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
		if (($layout_checkout == 'modern') && (is_checkout() || function_exists('is_checkout'))) {
			$classes = 'col-lg-12 col-md-12 m-b10 ';
		}
	} else {
		$page_text_class = '';
		$classes = 'col-lg-10';
		$justify_content = 'justify-content-center';
	}
}

clinicmaster_get_banner(); ;
?>

<div class="content-inner-1 z-index-unset">
	<div class="container"> 
		<div class="row <?php echo esc_attr($justify_content); ?>">
			<!-- Left sidebar area -->
			<?php if ($layout == 'left' && is_active_sidebar($sidebar)) {   ?>
				<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
					<aside class="side-bar sticky-top mt-lg-0 mt-md-5 mt-3  <?php echo esc_attr($sidebar_class); ?>">
						<?php dynamic_sidebar($sidebar); ?>
					</aside>
				</div>
			<?php } ?>

			<div class="<?php echo esc_attr($classes); ?>">
				<?php 
				while (have_posts()) {
					the_post();
					if (!empty($content_class) || !empty($page_text_class)) {
				?>
						<div class="<?php echo esc_attr($content_class . ' ' . $page_text_class); ?>">
						<?php 
					} 
					the_content(); 
					if (!empty($content_class) || !empty($page_text_class)) {
						?>
						</div>
				<?php }
				} ?>

				<?php comments_template(); ?>

				<?php wp_link_pages(array('before' => '<div class="paginate-links">' . esc_html__('Pages: ', 'clinicmaster'), 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>')); ?>
			</div>

			<!-- Right sidebar area -->
			<?php if ($layout == 'right' && is_active_sidebar($sidebar)) {  ?>
				<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
					<aside class="side-bar sticky-top mt-lg-0 mt-md-5 mt-3  <?php echo esc_attr($sidebar_class); ?>">
						<?php dynamic_sidebar($sidebar); ?>
					</aside>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>