<?php
clinicmaster_bunch_global_variable();
$clinicmaster_option = getDZThemeReduxOption();

$site_favicon   = !empty($clinicmaster_option['site_favicon']) ? $clinicmaster_option['site_favicon']	: '';
$website_status = !empty($clinicmaster_option['website_status']) ? $clinicmaster_option['website_status']	: '';
$header_style   = !empty($clinicmaster_option['header_style']) ? $clinicmaster_option['header_style']	: '';
$color_skin_setting   = !empty($clinicmaster_option['color_skin_setting']) ? $clinicmaster_option['color_skin_setting']	: '';
$predefined_color_skin   = !empty($clinicmaster_option['predefined_color_skin']) ? $clinicmaster_option['predefined_color_skin']	: '';
if($color_skin_setting == 'custom_color_skin'){
	$skin_data = 'custom-color';
}else{
	$skin_data =	str_replace("_","-",$predefined_color_skin);
}
$preload   		= clinicmaster_get_opt('preload_image');
$bodyclass = ($skin_data == 'skin_9') ? 'pediatrics-typo' : '';
?>
<!DOCTYPE html>
<html <?php language_attributes();
		theme_direction(); ?>  data-theme-color="<?php echo esc_attr($skin_data); ?>">

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<?php if (!function_exists('has_site_icon') || !has_site_icon()) { ?>
		<link rel="shortcut icon" href="<?php echo esc_url($site_favicon); ?>" type="image/x-icon">
		<link rel="icon" href="<?php echo esc_url($site_favicon); ?>" type="image/x-icon">
	<?php } ?>
	<!-- Responsive -->
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<!-- MOBILE SPECIFIC -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

	<?php if (!empty($preload['url'])) { ?>
		<link rel="preload" href="<?php echo esc_url($preload['url']); ?>" as="image" type="text/css">
	<?php }
	wp_head(); ?>
	<link href="https://fonts.googleapis.com/css2?family=Arizonia&display=swap" rel="stylesheet"> 
</head>

<body id="bg" <?php echo body_class($bodyclass); clinicmaster_body_layout_style(); ?>>

	<?php
	wp_body_open();
	do_action('clinicmaster_subscription');
	?>

	<div class="page-wraper" id="scroll-container">
		<?php
		if (isWebsiteReadyForVisitor($website_status)) {
			/* Pre-loader START*/
			clinicmaster_get_loader();
			/* Pre-loader END */
			
				if (!empty($header_style)) {
					get_template_part('dz-inc/elements/header/' . $header_style);
				}
			
		}
		?>

		<div class="page-content">

			<?php
			do_action('clinicmaster_website_status');
