<?php 
	$clinicmaster_option = getDZThemeReduxOption();
	$sidebar_class 	= !empty($clinicmaster_option['sidebar_bg_color']) ? $clinicmaster_option['sidebar_bg_color']: '';
	$category_on = clinicmaster_get_opt('category_on',true);
	$date_on 	 = clinicmaster_get_opt('date_on',true);
	$tags_on 	 = clinicmaster_get_opt('tags_on',true);
	$page_options = clinicmaster_dzbase()->get_meta();
	$featured_image	= (isset($page_options['featured_image']))?clinicmaster_dzbase()->get_meta('featured_image'):true;
	$featured_img_on 	 = clinicmaster_get_opt('featured_img_on',true); /* From Theme Options */
	$views_arr = get_post_meta(get_the_id(),'_views_count');
	$views = (isset($views_arr[0]))?$views_arr[0]:0;
	$social_sharing = clinicmaster_get_opt('social_sharing_on_post');
	$bg_class =  'bg-light';
?>
<!-- Blog Large -->
<section class="content-inner <?php echo esc_attr($bg_class); ?>">
	
	<div class="min-container">	
		<div class="row">
			<div class="col-xl-12 col-lg-12 m-b50">
				<!-- blog start -->
				<?php while( have_posts() ){ the_post();  ?>
				<div class="dz-blog blog-single style-1">
				  <div class="post-header">
						<?php if(!clinicmaster_is_post_banner_enable()){ ?>
							<h1 class="dz-title text-center mt-5">
							  <?php the_title(); ?>
							</h1>
						<?php } ?>
						<div class="dz-meta">
							<ul class="justify-content-center">
								<?php if(!empty($date_on)) { ?>
									<li class="post-date">
										<i class="far fa-calendar fa-fw m-r10"></i>
										<?php echo the_date(); ?>
									</li>
								<?php } ?>
								
								<li class="dz-user">
									<i class="fa-solid fa-user fa-fw m-r10"></i>
									<?php esc_html_e('By', 'clinicmaster'); ?> 
									<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) )); ?>">
										<?php the_author(); ?> 
									</a>
								</li>
							
								<?php echo clinicmaster_show_post_view_count_view($views); ?>
								
								<?php if(has_category() && $category_on) { ?>
									<li class="post-category">
										<i class="fa-solid fa-tag"></i>
										<?php echo  get_the_category_list(', '); ?>
									</li>
								<?php } ?>
							</ul>
						</div>
					</div>		
				<?php if ($featured_image && $featured_img_on && has_post_thumbnail()) { ?>
						<div class="dz-media alignfullwide">
							<?php the_post_thumbnail('full'); ?>
						</div>
						<?php } 
					?>
					
					
					<div class="dz-info">
						<div class="dz-post-text">
							<?php the_content(); ?>
						</div>
						
						<?php if(has_tag() || $social_sharing) { ?>
								<div class="dz-share-post meta-bottom bg-white">
									<?php if(has_tag() && !empty($tags_on)) { ?>
										<div class="post-tags">
											<strong><?php echo esc_html__('Tags:','clinicmaster') ?></strong>
											<?php clinicmaster_get_post_tags(get_the_id()); ?>
										</div>
									<?php }
									if(!empty($social_sharing)){
									?>		
										<div class="dz-social-icon primary-light">
										<?php echo clinicmaster_share_us(get_the_id(),get_the_title(),'','',array('','')); ?>
										</div>
									<?php } ?>
								</div>
							<?php } ?>
					</div>
				</div>
			
				<?php get_template_part('dz-inc/elements/author_block_element');  ?>	
				<?php get_template_part('dz-inc/elements/pagination_element'); ?>    
				<?php wp_link_pages(array('before'=>'<div class="paginate-links">'.esc_html__('Pages: ', 'clinicmaster'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>
				<?php get_template_part('dz-inc/elements/related_element');  ?>	
				<!-- blog END --> 
				<?php comments_template(); ?>					
			
				<?php } ?>				
			</div>
		</div>
	</div>
</section>
