<?php 

$clinicmaster_option = clinicmaster_get_theme_option();

$comingsoon_image        = !empty($clinicmaster_option['comingsoon_image']) ? $clinicmaster_option['comingsoon_image'] : '';
$copyright_text            = !empty($clinicmaster_option['footer_template_1_footer_copyright_text']) ? $clinicmaster_option['footer_template_1_footer_copyright_text'] : '';
$comingsoon_page_title     = !empty($clinicmaster_option['comingsoon_page_title']) ? $clinicmaster_option['comingsoon_page_title'] : '';
$comingsoon_page_description     = !empty($clinicmaster_option['comingsoon_page_description']) ? $clinicmaster_option['comingsoon_page_description'] : '';
$comingsoon_page_subscribe = !empty($clinicmaster_option['comingsoon_page_subscribe']) ? $clinicmaster_option['comingsoon_page_subscribe'] : '';
$comingsoon_launch_date    = isset($clinicmaster_option['comingsoon_launch_date']) ? $clinicmaster_option['comingsoon_launch_date'] : '';
$comingsoon_social_links    = clinicmaster_get_opt('comingsoon_social_links');
$comingsoon_social_links_on = clinicmaster_get_opt('comingsoon_social_links_on');

$date = '';
if(!empty($comingsoon_launch_date))
{
	$date = date("d F Y", strtotime($comingsoon_launch_date));
}
?>
	
<section class="dz-coming-soon">
	<div class="row">
		<div class="col-xxl-6 col-xl-6 col-lg-6 px-0">
			<div class="dz-coming-bx">
				<div class="top-wrapper">
					<div class="coming-soon-logo">
						<?php do_action( 'clinicmaster_get_logo','site_logo');  ?>
					</div>
					<div class="dz-content">
						<?php if (!empty($comingsoon_page_title)) { ?>
							<h2 class="dz-title pe-xl-4"><?php echo wp_kses($comingsoon_page_title, clinicmaster_allowed_html_tag()); ?></h2>
						<?php } ?>
						<div class="countdown " data-date="<?php echo esc_attr($date); ?>">
							<div class="date">
								<span class="time" id="day">00</span>
								<span class=" text"> <?php echo esc_html__('Days', 'clinicmaster'); ?></span>
							</div>
							<div class="date">
								<span class="time" id="hour">00</span>
								<span class=" text"><?php echo esc_html__('Hours', 'clinicmaster'); ?></span>
							</div>
							<div class="date">
								<span class="time" id="min">00</span>
								<span class=" text"><?php echo esc_html__('Minutes', 'clinicmaster'); ?></span>
							</div>
							<div class="date">
								<div class="time lost" id="second">00</div>
								<span class=" text"><?php echo esc_html__('Seconds', 'clinicmaster'); ?></span>
							</div>
						</div>
						<?php if (!empty($comingsoon_page_description)) { ?>
							<p><?php echo wp_kses($comingsoon_page_description, 'string'); ?></p>
						<?php }
						if(!empty($comingsoon_page_subscribe)){ ?>
						<form class="dzSubscribe style-3 dz-subscription">
							<div class="dzSubscribeMsg dz-subscription"></div>
							<div class="form-group">
								<div class="input-group mb-0">
									<input name="dzEmail" required="required" type="email" class="form-control" placeholder="<?php echo esc_attr__('Enter Your Email Address', 'clinicmaster'); ?> ">
									<div class="input-group-addon">
										<button name="submit" value="Submit" type="submit" class="btn btn-primary btn-hover1">
											<span class="btn-text"><?php echo esc_html__('Subscribe Now', 'clinicmaster'); ?></span>
											<span class="btn-icon">
												<i class="fa-solid fa-paper-plane"></i>
											</span>
										</button>
									</div>
								</div>
							</div>
						</form>
						<?php } ?>
					</div>
				</div>
				<div class="bottom-wrapper">
					<?php if (!empty($comingsoon_social_links_on)) { ?>
						<div class="dz-social-icon style-4 m-b20">
							<ul>
								<?php echo clinicmaster_get_social_icons('header', ' ', $comingsoon_social_links); ?>	
							</ul>
						</div>
					<?php } ?>
					<?php if(!empty($copyright_text)){ ?>
						<p class="copyright-text m-0"><?php echo wp_kses($copyright_text, clinicmaster_allowed_html_tag()); ?></p>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php if(!empty($comingsoon_image['url'])){ ?>
		<div class="col-xxl-6 col-xl-6 col-lg-6 px-0">
			<div class="dz-coming-media">
				<img src="<?php echo esc_url($comingsoon_image['url']); ?>" alt="<?php echo esc_attr__('Image', 'clinicmaster'); ?>">
			</div>
		</div>
		<?php } ?>
	</div>
</section>
	
