<?php 
$author_box_on = clinicmaster_get_opt('author_box_on',false); 
$description = nl2br(get_the_author_meta('description'));
$short_description = clinicmaster_short_description($description, '', 20);
$author_signing = get_the_author_meta('author_signature',$post->post_author);
if($author_box_on) {
?>
<div class="col-lg-12 col-md-12 wow fadeInUp" data-wow-delay="0.1s">
	<div class="author-box m-b30 bg-white">
		<div class="author-profile-info">
			<div class="author-profile-pic">
				 <img src="<?php echo esc_url( get_avatar_url($post->post_author, array('size'=> '200'))); ?>" alt="<?php esc_attr_e('Profile Pic', 'clinicmaster');?>"> 
			</div>
			<div class="author-profile-content">
				<h6 class="title"><?php echo ucwords(get_the_author_meta('display_name'));?></h6>
				<p><?php echo wp_kses($short_description, clinicmaster_allowed_html_tag());?></p>
				<?php if(!empty($author_signing)){ ?>
				<img src="<?php echo esc_url($author_signing) ?>" alt="<?php echo esc_attr__('Author Signature','clinicmaster') ?>">
				<?php } ?>
				<ul class="social-icon m-b0">
					<?php
					$author_social_arr = clinicmaster_author_social_arr();
					
					foreach($author_social_arr as $social_key => $social_value)
						{ 
							$social_url = clinicmaster_get_super_user_data($social_key);
							if(!empty($social_url))
							{
							?>
						<li>
							<a href="<?php echo esc_url($social_url);?>" target="_blank" class="<?php echo esc_attr($social_value['icon']); ?>">
							</a>
						</li>
					<?php 	} 
						}
					?>
				</ul>
			</div>
		</div>
	</div>
</div>
<?php } ?>