<?php 
$author_box_on = clinicmaster_get_opt('author_box_on',false); 
$description = nl2br(get_the_author_meta('description'));
$short_description = clinicmaster_short_description($description, '', 20);
$class = (is_single())? 'style-1' : 'blog-user m-b60';

$avtar_url = get_avatar_url(get_the_author_meta('email'), array('size' => 200));

if($author_box_on) {
?>

<div class="author-box m-b60 <?php echo esc_attr($class); ?>">
	<div class="author-profile-info flex-md-row flex-column text-center text-md-start">
		<div class="author-profile-pic me-md-4 me-0 mb-md-0 mb-3">
			<img src="<?php echo esc_url( $avtar_url ); ?>" alt="<?php esc_attr_e('Profile Pic', 'clinicmaster');?>" />
		</div>
		<div class="author-profile-content">
			<h6 class="title"><?php echo ucwords(get_the_author_meta('display_name'));?></h6>
			<p>
				<?php echo wp_kses($short_description, clinicmaster_allowed_html_tag());?>
			</p>
				<ul class="social-icon m-b0">
					<?php
					$author_social_arr = clinicmaster_author_social_arr();
					
					foreach($author_social_arr as $social_key => $social_value)
						{ 
							$social_url = clinicmaster_get_super_user_data($social_key);
							if(!empty($social_url))
							{
							?>
						<li>
							<a href="<?php echo esc_url($social_url);?>" target="_blank" class="<?php echo esc_attr($social_value['icon']); ?>">
							</a>
						</li>
					<?php 	} 
						}
					?>
				</ul>
			
		</div>
	</div>
</div>

<?php } ?>