<?php
$query_args = array(
	'post_type' => 'dz_testimonial',
	'post_status' => 'publish',
	'posts_per_page'    => $testimonial_slider_4_element_no_of_posts,
	'orderby' => $testimonial_slider_4_element_orderby,
	'order' => $testimonial_slider_4_element_order,
	'ignore_sticky_posts' => true,
);

$testimonial_slider_4_element_image_preference = !empty($testimonial_slider_4_element_image_preference) ? $testimonial_slider_4_element_image_preference : 'all_posts';

if ($testimonial_slider_4_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($testimonial_slider_4_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}


if($testimonial_slider_4_element_background_color == "yes"){
	 $bg_color = "bg-white";
	}else{
		$bg_color = "bg-light";	
}


if (!empty($testimonial_slider_4_element_posts_in_categories) && !empty($testimonial_slider_4_element_posts_in_categories[0])) {

	$testimonial_slider_4_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($testimonial_slider_4_element_posts_in_categories, 'testimonial_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'testimonial_category',
		'field' => 'id',
		'terms' => $testimonial_slider_4_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$allowed_html_tags = clinicmaster_allowed_html_tag();
$element_content = !empty($testimonial_slider_4_element_content) ? $testimonial_slider_4_element_content : 'content-inner'; 
$content_text_limit = $testimonial_slider_4_element_text_limit;
$query = new WP_Query($query_args);

if (!empty($query->have_posts())) {
?>

<section class="content-inner-1 <?php echo esc_html($bg_color); ?>">
	<div class="container">
		<div class="section-head style-12	 m-b30 text-center">
			<?php if(!empty($testimonial_slider_4_element_subtitle)){ ?>
			<span class="sub-title text-primary sub-title-icon">
				 <?php echo esc_html( $testimonial_slider_4_element_subtitle ); ?>
			</span>
			<?php } 
			 if(!empty($testimonial_slider_4_element_title)){
			?>
			<h2 class="title m-b0"><?php echo $testimonial_slider_4_element_title; ?> </h2>
	        <?php } ?>
		</div>
		<div class="swiper testimonial-swiper6 h-100">
			<div class="swiper-wrapper">
                 
			<?php  while ($query->have_posts()) {
					$query->the_post();
					global $post;
					$post_id = $post->ID;
					$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
					$testimonial_heading = get_post_meta($post_id, 'testimonial_heading', true);	
					$testimonial_designation = get_post_meta($post_id, 'testimonial_designation', true);	
					$rating_title = get_post_meta($post_id, 'testimonial_rating_title', true);		
					$testimonial_rating = get_post_meta($post_id, 'testimonial_rating', true);	
					$testimonial_befor_img = get_post_meta($post_id, 'testimonial_befor_img', true);	
					$testimonial_after_img = get_post_meta($post_id, 'testimonial_after_img', true);	
					$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);
				?> 

				<div class="swiper-slide wow fadeInUp" data-wow-delay="0.6s" data-wow-duration="0.8s">
					<div class="row">
						<div class="col-lg-7 m-b15 d-lg-block d-none wow" >
							<div class="twentytwenty-box twentytwenty-sm ">
								<?php if( !empty($testimonial_befor_img['id']) || !empty($testimonial_after_img['id'])) { ?>
								<div class="twentytwenty-container">
									<img src="<?php echo esc_url($testimonial_befor_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
									<img src="<?php echo esc_url($testimonial_after_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
									
								</div>
								<?php } ?>
							</div>
						</div>
						<div class="col-lg-5 col-sm-12 m-b20 wow fadeInUp" data-wow-delay="0.6s" data-wow-duration="0.8s">
							<div class="testimonial-8">
								<div class="testimonial-detail">
									<div class="testimonial-head">
										<span class="icon-bx"><i class="flaticon-left-quote"></i></span>
										<?php if(!empty($testimonial_heading)){ ?>
										<h4 class="title"><?php echo esc_html($testimonial_heading); ?></h4>
									    <?php } ?>
										
									</div>

                                     <?php if(!empty($short_description)){ ?>
										<div class="testimonial-contant">
											<div class="testimonial-text">
												<p><?php echo esc_html($short_description); ?></p>
											</div>
										</div>
										<?php } ?>

									<div class="testimonial-info">
										<div class="clearfix">
											<?php if(!empty($post_title)){ ?>
										       <h5 class="testimonial-name"><?php echo esc_html($post_title); ?></h5>
								         	<?php } ?>
										</div>
										<?php if(has_post_thumbnail($post)){
											$img = get_the_post_thumbnail_url($post, 'thumbnail '); 
											?>
											<div class="dz-media">
												<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
											</div>
										<?php } ?>	
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>

	</div>
</section>


<?php } ?>