<?php
	$blog_view = "testimonial_listing_2";
	$page_no = 1;
	$post_type = 'dz_testimonial';
	
	$query_args = array(	
		'post_type' 		=> $post_type,
		'post_status' 		=> 'publish',
		'posts_per_page'   	=> $testimonial_listing_2_element_no_of_posts ,		
		'order' 			=> $testimonial_listing_2_element_order,
		'ignore_sticky_posts' => true,
	);
	
	if($testimonial_listing_2_element_orderby == 'views_count'){
		$query_args['meta_key']	= '_views_count';
	}
	else{
		$query_args['orderby']	= $testimonial_listing_2_element_orderby;
	}

  
	$testimonial_listing_2_element_image_preference = !empty($testimonial_listing_2_element_image_preference)?$testimonial_listing_2_element_image_preference:'all_posts';
	
	if($testimonial_listing_2_element_image_preference == 'image_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'EXISTS'
			),
		);
	}
	elseif($testimonial_listing_2_element_image_preference == 'text_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'Not EXISTS'
			),
		);
	}
	
	
	if(!empty($testimonial_listing_2_element_posts_in_categories) && !empty($testimonial_listing_2_element_posts_in_categories[0]))
	{			
		
		$testimonial_listing_2_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($testimonial_listing_2_element_posts_in_categories,'service_category');
		
		$query_args['tax_query'][] = array(
		'taxonomy' => 'testimonial_category',
		'field' => 'id',
		'terms' => $testimonial_listing_2_element_posts_in_categories1,
		'operator' => 'IN'
		); 
		$testimonial_listing_2_element_posts_in_categories = implode(',',$testimonial_listing_2_element_posts_in_categories);
	}else{
		$testimonial_listing_2_element_posts_in_categories = '';
	}		
	
	
	if($testimonial_listing_2_element_only_featured_posts == 'yes') 
	{ 		
		$query_args['meta_key'] = 'featured_post';		
		$query_args['meta_value'] = 1;				
		$query_args['meta_compare'] = 'LIKE';		
	}
	
	$query = new WP_Query($query_args);	
	
	
	
	$blog_view_container = '';
	if($testimonial_listing_2_element_pagination_style == 'load_more')
	{
		$blog_view_container = $blog_view."_LoadMoreContainer";
	}
	
	global $clinicmaster_query_result;
	$clinicmaster_query_result['posts'] = $query->posts;	
	
	$clinicmaster_query_result['posts_per_page'] = $testimonial_listing_2_element_no_of_posts;	
	$clinicmaster_query_result['current_page'] = $page_no;
	$clinicmaster_query_result['title_text_limit'] = $testimonial_listing_2_element_text_limit;
	$clinicmaster_query_result['blog_view_container'] = $blog_view_container;	
	$clinicmaster_query_result['element_style'] = $testimonial_listing_2_element_style;	
	$clinicmaster_query_result['avatar_style'] = $testimonial_listing_2_element_avatar;	
	$max_num_pages = $query->max_num_pages;	
	$class_load = (!empty($testimonial_listing_2_element_style) && ($testimonial_listing_2_element_style == 'style_1')) ? 'dz-separator style-3' :'';
	$element_content = !empty($testimonial_listing_2_element_content) ? $testimonial_listing_2_element_content :'content-inner-2';
	
	if($post_listing_1_element_background_color == 'yes'){
        $addclass = 'bg-light';
	}
	

	if($query->have_posts()) {	
	
?>




<section class="<?php echo esc_attr($element_content .' '. $addclass); ?>">
	<div class="container">
				<?php if(!empty($testimonial_listing_2_element_title)){ ?>
				<div class="section-head style-2 text-center m-b30">
					<h2 class="title m-b0"><?php echo wp_kses($testimonial_listing_2_element_title, 'string'); ?></h2>
				</div>
				<?php } ?>
				<div <?php if(!empty($blog_view_container)){ ?> id="<?php echo esc_attr($blog_view_container) ?>" <?php } ?> class="row justify-content-center">
					<?php get_template_part('dz-inc/elementor/ajax/testimonial_listing_2_ajax'); ?>
				</div>
			<!-- Side bar END -->
				<?php
					if($testimonial_listing_2_element_pagination_style == 'load_more')
					{	
						$blog_view_btn = $blog_view."_LoadMoreBtn";
						$blog_view_container = $blog_view."_LoadMoreContainer";
						
						if( 1 < $max_num_pages ) 
						{ 
						?>
						<!-- Pagination start -->
						<div class="reload-btn text-center mb-4 <?php echo esc_attr($class_load); ?>">
						<a href="javascript:void(0);" class="btn btn-lg btn-icon btn-primary loadmore-btn dz-load-more " id="<?php echo esc_attr($blog_view_btn); ?>"   
							data-ajax-container = "<?php echo esc_js($blog_view_container); ?>"					
							data-post-type = "<?php echo esc_js($post_type);?>" 
							data-blog-view = "<?php echo esc_js($blog_view);?>" 
							data-max-num-pages="<?php echo esc_js($max_num_pages);?>" 
							data-posts-per-page="<?php echo esc_js($testimonial_listing_2_element_no_of_posts);?>"
							data-only-featured-post="<?php echo esc_js($testimonial_listing_2_element_only_featured_posts); ?>" 
							data-post-order="<?php echo esc_js($testimonial_listing_2_element_order); ?>"	
							data-post-order-by="<?php echo esc_js($testimonial_listing_2_element_orderby); ?>"	
							data-element-style="<?php echo esc_js($testimonial_listing_2_element_style); ?>"	
							data-title-text-limit="<?php echo esc_js($testimonial_listing_2_element_text_limit);?>"
							data-posts-in-categories="<?php echo esc_js($testimonial_listing_2_element_posts_in_categories);?>"
							>
							<?php echo esc_html__('Load More', 'clinicmaster'); ?>
							<?php if(empty($class_load)){ ?>
								<span class="right-icon dz-load"><i class="feather icon-refresh-ccw"></i></span>
							<?php } ?>
							</a>
						</div>
						<!-- Pagination End -->
						<?php 
						}
					}
				?>
		
		
	</div>
</section>
<?php } ?>