<?php 
global $post;
$post_id = $post->ID;
$post_title = $post->post_title;
$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
$element_content = !empty($team_detail_2_element_content) ? $team_detail_2_element_content : 'content-inner';
?>
<section class="<?php echo esc_attr($element_content); ?> bg-light">
			<div class="container">
				<div class="row">
					<div class="col-xl-7 m-b10 pe-xl-5">
						<div class="section-head style-2 m-b30">
							<?php if(!empty($team_detail_2_element_subtitle)){ ?>
								<div class="sub-title"><?php echo esc_html($team_detail_2_element_subtitle); ?></div>
							<?php } ?>
							<?php if(!empty($post_title)){ ?>
								<h2 class="title"><?php echo esc_html($post_title); ?></h2>
							<?php } ?>
							<?php if(!empty($team_detail_2_element_description)){ ?>
							<p class="fw-normal"><?php echo wp_kses($team_detail_2_element_description, clinicmaster_allowed_html_tag()) ?></p>
							<?php } ?>
							
						</div>
						<?php if(!empty($team_detail_2_element_item)){ ?>
						<table class="table table-striped table-striped-white table-striped-rounded m-b40 m-md-b20">
							
							<tbody>
								<?php foreach($team_detail_2_element_item as $item){
								$text = $item['team_detail_2_element_item_text'];
								$value = $item['team_detail_2_element_item_value'];
									?>
									<tr>
									<?php if(!empty($text)){ ?>
										<th><?php echo esc_html($text); ?></th>
									<?php } 
										if(!empty($value)){ ?>
											<td><?php echo wp_kses($value, clinicmaster_allowed_html_tag()) ?></td>
									<?php } ?>
									</tr>
								<?php } ?>
								
							</tbody>
						</table>
						<?php } ?>
						<div class="clearfix m-b50 m-md-b20">
							<?php if($team_detail_2_element_feature_text){ ?>
								<h3 class="text-primary title-dashed-separator"><?php echo esc_html($team_detail_2_element_feature_text); ?></h3>
							<?php } ?>
							<?php if(!empty($team_detail_2_element_skils)){ ?>
									<ul class="list-check text-secondary fw-medium grid-2 m-b35">
									<?php foreach($team_detail_2_element_skils as $val){ ?>
										<li><?php echo esc_html($val['team_detail_2_element_feature_list']); ?></li>
									<?php } ?>
									
									</ul>
							<?php } ?>
						</div>
						<div class="info-widget widget-sm style-9 bg-white shadow-none m-b50 m-md-b20">
							<div class="widget-content">
								<?php if(!empty($team_detail_2_element_text)){ ?>
									<h2 class="title"><?php echo esc_html($team_detail_2_element_text); ?></h2>
								<?php }
								if(!empty($team_detail_2_element_schedule)){ ?>
								<ul>
									<?php foreach($team_detail_2_element_schedule as $schedule){ 
										
										$week = $schedule['team_detail_2_element_schedule_week'];
										$time = $schedule['team_detail_2_element_schedule_time'];
										if(!empty($week) && !empty($time)){
									?>
											<li><?php echo esc_html($week); ?> <span><?php echo esc_html($time); ?></span></li>
									<?php }
									} ?>
								</ul>
								<?php } ?>
							</div>
						</div>
						<?php if(!empty($team_detail_2_element_contact)){ ?>
						<div class="info-widget style-16 shadow-none m-b50 m-md-b20">
							<div class="row g-xl-5 g-4">
								<?php foreach($team_detail_2_element_contact as $con){ 
									$icon = $con['team_detail_2_element_contact_icon'];
									$text = $con['team_detail_2_element_contact_text'];
									$value = $con['team_detail_2_element_contact_value'];
								?>
										<div class="col-md-6">
											<div class="icon-bx-wraper style-1 align-items-center">
												<?php if(!empty($icon['value'])){ ?>
													<div class="icon-bx bg-primary">
														<span class="icon-cell">
															<?php 
															if(!empty($icon['value']['id']) && ($icon['library'] == 'svg') ){ 
																echo wp_get_attachment_image( $icon['value']['id'], 'thumbnail' ); 
															}elseif(!empty($icon['value'])){ ?>
																<i class="<?php echo esc_attr($icon['value']); ?>"></i>
															<?php } ?>
															
														</span>
													</div>
													<?php }if(!empty($text) || !empty($value)){ ?>	
														<div class="icon-content">
															<?php if(!empty($text)){ ?>	
																<h5 class="dz-title fw-semibold"><?php echo esc_html($text); ?></h5>
															<?php } ?>
															<?php if(!empty($value)){ ?>	
																<p class="text-body"><?php echo esc_html($value); ?></p>
															<?php } ?>
														</div>
													<?php } ?>
												
											</div>
										</div>
										
								<?php } ?>
							</div>
						</div>
						<?php } ?>
						<div class="clearfix">
							<?php if(!empty($team_detail_2_element_awards)){  ?>
							<h3 class="text-primary title-dashed-separator"><?php echo esc_html($team_detail_2_element_awards); ?></h3>
							<?php }
							if(!empty($team_detail_2_element_gift)){ ?>
							<div class="row">
								<?php foreach($team_detail_2_element_gift as $item){
									$title = $item['team_detail_2_element_gift_title'];
									$img = $item['team_detail_2_element_gift_img'];
									$description = $item['team_detail_2_element_gift_description'];
									$text = $item['team_detail_2_element_gift_text'];
									$link = $item['team_detail_2_element_gift_text_link'];
								?>
								<div class="col-md-6 m-b20">
									<div class="dz-img-box style-1">
										<?php if($img['id']){ ?>
											<div class="dz-media">
												<img src="<?php echo esc_url($img['url']); ?>" alt="<?php echo esc_attr__('Logo', 'clinicmaster'); ?>">
											</div>
										<?php } ?>
										<div class="dz-content">	
											<?php if(!empty($title)){ ?>
												<h3 class="title"><?php echo esc_html($title); ?></h3>
											<?php }
											if(!empty($description)){ ?>
												<p><?php echo wp_kses($description,'string'); ?></p>
											<?php } 
											 if(!empty($text) && !empty($link)){ ?>
												<a href="<?php echo esc_url($link); ?>" class="btn-link"><?php echo esc_html($text); ?></a>
											 <?php } ?>
										</div>
									</div>
								</div>
								<?php } ?>
							</div>
							<?php } ?>
						</div>
					</div>
					<div class="col-xl-5 m-b30">
						<aside class="side-bar sticky-top p-0">
							<?php if (has_post_thumbnail()) { ?>
								<div class="widget">
									<div class="dz-team style-7">
										<div class="dz-media">
											<?php echo the_post_thumbnail('full'); ?>
										</div>
									</div>
								</div>
							<?php } if(!empty($team_detail_2_element_title) || !empty($team_detail_2_element_contact_form)){?>
							<div class="form-wrapper style-2 bg-secondary">
								<div class="form-body">
									<?php if(!empty($team_detail_2_element_title)){ ?>
										<div class="title-head">
											<h2 class="form-title m-b20"><?php echo wp_kses($team_detail_2_element_title,clinicmaster_allowed_html_tag()); ?></h2>
										</div>
									<?php } ?>
									<?php if(!empty($team_detail_2_element_contact_form)){ ?>
									
										<?php 
											$form = get_page_by_path($team_detail_2_element_contact_form,OBJECT,'wpcf7_contact_form');
											if(!empty($form->ID)){
												echo do_shortcode('[contact-form-7 id="'.$form->ID.'"]');
											}
										?>
									
								<?php } ?>
								</div>
							</div>
							<?php } ?>
						</aside>
					</div>
				</div>
			</div>
		</section>