<?php 
  $element_content = !empty($tab_content_element_content) ? $tab_content_element_content : 'content-inner';
?>

<section class="clearfix <?php echo esc_attr($element_content); ?> bg-light">
    <div class="container">
        <div class="section-head style-1 m-b40 text-center">
            <?php if (!empty($service_tab_element_title)) { ?>
                <h2 class="title m-b0 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s">
                    <?php echo esc_html($service_tab_element_title); ?>
                </h2>
            <?php } ?>
        </div>

        <div class="product-description">
            <div class="dz-tabs style-3">
                <!-- Navigation Tabs -->
                <ul class="nav nav-tabs center" id="myTab1" role="tablist">
                    <?php foreach ($form_fields as $key => $items) {  
                          $icon = $items['tab_icon'];
                        ?>
                        
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo ($key == 0) ? 'active' : ''; ?>" 
                                    id="service-tab-<?php echo $key; ?>" 
                                    data-bs-toggle="tab" 
                                    data-bs-target="#service-tab-content-<?php echo $key; ?>" 
                                    type="button" role="tab" 
                                    aria-controls="service-tab-content-<?php echo $key; ?>" 
                                    aria-selected="<?php echo ($key == 0) ? 'true' : 'false'; ?>">
                                <?php if (!empty($items["tab_title_text"]) && !empty($items["tab_icon"]) ) { ?>
                                    <?php if(!empty($icon['value'])){ ?>
								<?php if( $icon['library'] == 'svg' && !empty($icon['value']['url'])){ 
											$response = wp_remote_get($icon['value']['url']);
											if (!is_wp_error($response)) {
												$svg_content = wp_remote_retrieve_body($response);
												echo '<span class="m-0">'.$svg_content.'</span>';
											}
									
									}else{ ?>
									
									<?php } }?>

                                    <?php echo ($items["tab_title_text"]); ?>
                                <?php } ?>
                            </button>
                        </li>
                    <?php } ?>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content" id="myTabContent">
                    <?php foreach ($form_fields as $key => $items) { ?>
                        <div class="tab-pane fade <?php echo ($key == 0) ? 'show active' : ''; ?>" 
                             id="service-tab-content-<?php echo $key; ?>" 
                             role="tabpanel" 
                             aria-labelledby="service-tab-<?php echo $key; ?>" 
                             tabindex="0">
                             
                            <div class="row service-wrapper style-1 align-items-center">
                                <div class="col-xl-6 order-xl-1 order-2">
                                    <div class="section-head m-b30">
                                        <?php if (!empty($items['tab_content_heading'])) { ?>
                                            <h2 class="title"><?php echo esc_html($items['tab_content_heading']); ?></h2>
                                        <?php } ?>
                                        <?php if (!empty($items['tab_content_description'])) { ?>
                                            <p><?php echo esc_html($items['tab_content_description']); ?></p>
                                        <?php } ?>
                                    </div>

                                    <?php 
                                    if (!empty( $items['element_feature_description'])) { 
                                        $linting = explode(',', $items['element_feature_description']);
                                        if (!empty($linting)) { ?>
                                            <ul class="list-check text-secondary fw-medium m-b30">
                                                <?php foreach ($linting as $val) { ?>	
                                                    <li><?php echo esc_html($val); ?></li>
                                                <?php } ?>
                                            </ul>
                                        <?php }
                                    }
                                    ?>
                                     
                                     <?php if(!empty($items['button_text']) && !empty($items['button_link']['url'])){
									$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($items['button_link']['url']);
									?>
									<a class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow" <?php echo esc_attr($anchor_attribute); ?> href="<?php echo esc_url($items['button_link']['url']); ?>">
										<?php echo esc_html($items['button_text']); ?>
										<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
									</a>	
								<?php } ?>
                                    
                                </div>

                                <div class="col-xl-6 m-b30 order-xl-2 order-1">
                                    <div class="content-media">
                                        <?php 
                                        $background_image = !empty($items['listing_background_image']['url']) 
                                            ? esc_url($items['listing_background_image']['url']) 
                                            : get_template_directory_uri() . '/wp-content/uploads/2025/04/default.png'; 
                                        ?>
                                        <div class="dz-media">
                                            <img src="<?php echo $background_image; ?>" alt="Baby Care Timeline">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
