<?php
	$blog_view = "service_listing_3";
	$page_no = 1;
	$post_type = 'dz_service';
	
	$query_args = array(	
		'post_type' 		=> $post_type,
		'post_status' 		=> 'publish',
		'posts_per_page'   	=> $service_listing_3_element_no_of_posts ,		
		'order' 			=> $service_listing_3_element_order,
		'ignore_sticky_posts' => true,
	);
	
	if($service_listing_3_element_orderby == 'views_count'){
		$query_args['meta_key']	= '_views_count';
	}
	else{
		$query_args['orderby']	= $service_listing_3_element_orderby;
	}

  
	$service_listing_3_element_image_preference = !empty($service_listing_3_element_image_preference)?$service_listing_3_element_image_preference:'all_posts';
	
	if($service_listing_3_element_image_preference == 'image_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'EXISTS'
			),
		);
	}
	elseif($service_listing_3_element_image_preference == 'text_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'Not EXISTS'
			),
		);
	}
	
	
	if(!empty($service_listing_3_element_posts_in_categories) && !empty($service_listing_3_element_posts_in_categories[0]))
	{			
		
		$service_listing_3_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($service_listing_3_element_posts_in_categories,'service_category');
		
		$query_args['tax_query'][] = array(
		'taxonomy' => 'service_category',
		'field' => 'id',
		'terms' => $service_listing_3_element_posts_in_categories1,
		'operator' => 'IN'
		); 
		$service_listing_3_element_posts_in_categories = implode(',',$service_listing_3_element_posts_in_categories);
	}else{
		$service_listing_3_element_posts_in_categories = '';
	}		
	
	
	if($service_listing_3_element_only_featured_posts == 'yes') 
	{ 		
		$query_args['meta_key'] = 'featured_post';		
		$query_args['meta_value'] = 1;				
		$query_args['meta_compare'] = 'LIKE';		
	}
	
	$query = new WP_Query($query_args);	
	
	
	
	$blog_view_container = '';
	if($service_listing_3_element_pagination_style == 'load_more')
	{
		$blog_view_container = $blog_view."_LoadMoreContainer";
	}
	
	global $clinicmaster_query_result;
	$clinicmaster_query_result['posts'] = $query->posts;	
	
	$clinicmaster_query_result['posts_per_page'] = $service_listing_3_element_no_of_posts;	
	$clinicmaster_query_result['current_page'] = $page_no;
	$clinicmaster_query_result['title_text_limit'] = $service_listing_3_element_text_limit;
	$clinicmaster_query_result['show_column'] = $service_listing_3_element_cols;
	$clinicmaster_query_result['blog_view_container'] = $blog_view_container;		
	$clinicmaster_query_result['element_style'] = $service_listin_3_element_style;
	$max_num_pages = $query->max_num_pages;	

	$element_content = !empty($service_listing_3_element_content) ? $service_listing_3_element_content : 'content-inner 1';
	
	
	if($query->have_posts()) {		
?>
<section class="<?php echo esc_attr($element_content ); ?> bg-light border-top" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>); background-size: cover; background-position: center;" <?php } ?>>
	<div class="container">
		<div  <?php if($service_listin_3_element_style == 'style_2' ) {?> class= "section-inner " <?php } ?> >	
			<div class="section-head style-5 m-b30 text-center">
				<?php if(!empty($service_listing_3_element_title) || !empty($service_listing_3_element_subtitle)){ ?>
					<span class="sub-title sub-title-icon">
					    <?php if(!empty($service_listing_3_element_icon['id'])){ ?>
							<img src="<?php echo esc_url($service_listing_3_element_icon['url']); ?>" alt="" srcset="">
						<?php } ?>
						<?php if(!empty($service_listing_3_element_subtitle)){ 
							echo wp_kses($service_listing_3_element_subtitle, clinicmaster_allowed_html_tag());
						 } ?>
					</span>
					<?php if(!empty($service_listing_3_element_title)){ ?>
						<h2 class="title"><?php echo wp_kses($service_listing_3_element_title, clinicmaster_allowed_html_tag()); ?></h2>
					<?php } ?>
				<?php } ?>
				
			</div>
			<div <?php if(!empty($blog_view_container)){ ?> id="<?php echo esc_attr($blog_view_container) ?>" <?php } ?> class="row justify-content-center">
				<?php get_template_part('dz-inc/elementor/ajax/service_listing_3_ajax'); ?>
			</div>
			<?php
				if($service_listing_3_element_pagination_style == 'load_more')
				{	
					$blog_view_btn = $blog_view."_LoadMoreBtn";
					$blog_view_container = $blog_view."_LoadMoreContainer";
					
					if( 1 < $max_num_pages ) 
					{ 
					?>
					<!-- Pagination start -->
					<div class="reload-btn text-center mb-4">
					<a href="javascript:void(0);" class="btn btn-lg btn-icon btn-primary loadmore-btn dz-load-more" id="<?php echo esc_attr($blog_view_btn); ?>"   
						data-ajax-container = "<?php echo esc_js($blog_view_container); ?>"					
						data-post-type = "<?php echo esc_js($post_type);?>" 
						data-blog-view = "<?php echo esc_js($blog_view);?>" 
						data-max-num-pages="<?php echo esc_js($max_num_pages);?>" 
						data-posts-per-page="<?php echo esc_js($service_listing_3_element_no_of_posts);?>"
						data-only-featured-post="<?php echo esc_js($service_listing_3_element_only_featured_posts)?>" 
						data-post-order="<?php echo esc_js($service_listing_3_element_order)?>"	
						data-post-order-by="<?php echo esc_js($service_listing_3_element_orderby)?>"	
						data-listing-bg-img="<?php echo esc_js($service_listing_3_element_listing_bg_img);?>"
						data-title-text-limit="<?php echo esc_js($service_listing_3_element_text_limit);?>"
						data-show-column="<?php echo esc_js($service_listing_3_element_cols);?>" 
						data-posts-in-categories="<?php echo esc_js($service_listing_3_element_posts_in_categories);?>"
						>
						<?php echo esc_html__('Load More', 'clinicmaster'); ?>
						<span class="right-icon dz-load"><i class="feather icon-refresh-ccw"></i></span>
					</div>
					<!-- Pagination End -->
					<?php 
					}
				}
			?>
			
			<?php if(!empty($service_listing_3_element_button_text) || !empty($service_listing_3_element_text)){ ?>
			<div class="dz-separator style-4  wow fadeInUp">
				<?php if(!empty($service_listing_3_element_text)){ ?>
					<h6 class="title"><?php echo esc_html($service_listing_3_element_text); ?></h6>
				<?php } ?>
				
	            

				<?php if(!empty($service_listing_3_element_button_text) && !empty($service_listing_3_element_button_link['url'])){
					$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($service_listing_3_element_button_link);
					?>	
					<a href="<?php echo esc_url($service_listing_3_element_button_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn btn-secondary separator-badge btn-rounded shadow-md"><?php echo esc_html($service_listing_3_element_button_text); ?></a>
				<?php } ?>
			</div>
			<?php } ?>
		</div>
	</div>
	
</section>		
	<?php } ?>