<?php 
$element_content = !empty($pricing_table_1_element_content) ? $pricing_table_1_element_content : 'content-inner';
?>		
<section class="<?php echo esc_attr($element_content); ?>">
	<div class="container">	
		<?php if(!empty($pricing_table_1_element_title) || !empty($pricing_table_1_element_description) || !empty($pricing_table_1_element_subtitle)){ ?>
		<div class="section-head style-1 text-center">
			<?php if(!empty($pricing_table_1_element_subtitle)){ ?>
				<span class="sub-title text-primary sub-title-icon">
					<?php if(!empty($pricing_table_1_element_icon_img['id'])){ ?>
						<img src="<?php echo esc_url($pricing_table_1_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
					<?php } ?>
					<?php echo esc_html($pricing_table_1_element_subtitle); ?>
				</span>
			<?php } ?>
			<?php if(!empty($pricing_table_1_element_title)){ ?>
			<h2 class="title wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.7s" style="visibility: visible; animation-duration: 0.7s; animation-delay: 0.2s; animation-name: fadeInUp;"><?php echo wp_kses($pricing_table_1_element_title,clinicmaster_allowed_html_tag()); ?></h2>
			<?php } 
			if(!empty($pricing_table_1_element_description)){ ?>
			<p class="wow fadeInUp" data-wow-delay="0.4s" data-wow-duration="0.7s" style="visibility: visible; animation-duration: 0.7s; animation-delay: 0.4s; animation-name: fadeInUp;"><?php echo wp_kses($pricing_table_1_element_description, 'string'); ?></p>
			<?php } ?>
		</div>
		<?php } ?>
		<div class="row">
			<div class="col-xl-3 col-md-6 m-b30">
				<div class="pricingtable-wrapper style-3 pricingtable-detail">
				<?php if(!empty($pricing_table_1_element_title2) && !empty($pricing_table_1_element_description2)){ ?>
					<div class="pricing-content-box">
						<div class="pricingtable-price"> 
							<?php if(!empty($pricing_table_1_element_title2)){ ?>
								<h2 class="pricingtable-bx"><?php echo wp_kses($pricing_table_1_element_title2,clinicmaster_allowed_html_tag()); ?></h2>
							<?php } ?>
							<?php if(!empty($pricing_table_1_element_description2)){ ?>
								<p class="text"><?php echo wp_kses($pricing_table_1_element_description2, 'string'); ?></p>
							<?php } ?>
						</div>
					</div>
					<?php } ?>
					<?php if(!empty($pricing_table_1_element_feature_list)){
						$feature_list = explode(',', $pricing_table_1_element_feature_list);
						?>
						<div class="pricingtable-list">
							<ul class="pricingtable-features">
								<?php foreach($feature_list as $val){ ?>
									<li><?php echo esc_html($val); ?></li>
								<?php } ?>
							</ul>
						</div>
					<?php } ?>
				</div>
			</div>
			<?php if(!empty($pricing_table_1_element_item)){ 
			$num =1;
			foreach($pricing_table_1_element_item as $val){
				$plan = $val['pricing_table_1_element_item_plan'];
				$unit = $val['pricing_table_1_element_item_unit'];
				$text = $val['pricing_table_1_element_item_text'];
				$content = $val['pricing_table_1_element_item_content'];
				$active_class = ($num == 2) ? 'active' :'';
				if($plan  == 'free'){
					$price = $val['pricing_table_1_element_item_free_plan'];
				}else{
					$price = $val['pricing_table_1_element_item_price'];
				}
			?>
			<div class="col-xl-3 col-md-6 m-b30">
				<div class="pricingtable-wrapper style-3 <?php echo esc_attr($active_class); ?>">
					<div class="pricing-content-box">
					<?php if(!empty($price)){ ?>
						<div class="pricingtable-price"> 
							<h2 class="pricingtable-bx"><?php echo esc_html($price); ?><small>/ <?php if(!empty($unit)){ echo esc_html($unit); } ?></small></h2>
						</div>
					<?php } ?>
					<?php if(!empty($text)){ ?>
						<div class="pricingtable-button">
							<a href="javascript:void(0);" class="btn btn-primary w-100 btn-rounded"><span><?php echo esc_html($text); ?></span></a>
						</div>
					<?php } ?>
					</div>
					<div class="pricingtable-list">
						<ul class="pricingtable-features">
							<?php echo wp_kses($content , clinicmaster_allowed_html_tag()); ?>
						</ul>
					</div>
				</div>
			</div>
			<?php $num++;
				}
			} ?>
		</div>
	</div>
</section>