<?php
$query_args = array(
	'post_type'         => 'post',
	'post_status'       => 'publish',
	'posts_per_page'    => $post_tiles_element_no_of_posts,
	'order'             => $post_tiles_element_order,
	'ignore_sticky_posts' => true,
);

if ($post_tiles_element_orderby == 'views_count') {
	$query_args['meta_key'] = '_views_count';
} else {
	$query_args['orderby']  = $post_tiles_element_orderby;
}

$post_tiles_element_image_preference = !empty($post_tiles_element_image_preference) ? $post_tiles_element_image_preference : 'all_posts';

if ($post_tiles_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($post_tiles_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}

if (!empty($post_tiles_element_posts_in_categories) && !empty($post_tiles_element_posts_in_categories[0])) {

	$post_tiles_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($post_tiles_element_posts_in_categories, 'category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'category',
		'field' => 'id',
		'terms' => $post_tiles_element_posts_in_categories1,
		'operator' => 'IN'
	);
}


if ($post_tiles_element_only_featured_posts == 'true') {
	$query_args['meta_key'] = 'featured_post';
	$query_args['meta_value'] = 1;
	$query_args['meta_compare'] = 'LIKE';
}

$content_calss = !empty($post_tiles_element_content) ? $post_tiles_element_content : 'content-inner-1';
$query = new WP_Query($query_args);

if ($query->have_posts()) {
?>
<section class="<?php echo esc_attr($content_calss); ?>">
	<div class="container">
		<div class="section-head style-1 m-b30 row align-items-end">
			<?php if(!empty($post_tiles_element_title) || !empty($post_tiles_element_subtitle)){ ?>
				<div class="col-lg-7 col-md-8 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s">
					<?php if(!empty($post_tiles_element_subtitle)){ ?>
						<span class="sub-title text-primary sub-title-icon">
							<?php if(!empty($post_tiles_element_icon_img['id'])){ ?>
								<img src="<?php echo esc_url($post_tiles_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
							<?php } ?>
							<?php echo esc_html($post_tiles_element_subtitle); ?>
						</span>
					<?php } ?>
					<?php if(!empty($post_tiles_element_title)){ ?>
						<h2 class="title m-b0"><?php echo wp_kses($post_tiles_element_title,clinicmaster_allowed_html_tag()); ?></h2>
					<?php } ?>
				</div>
			<?php }
			if(!empty($post_tiles_element_button_text) && !empty($post_tiles_element_button_link['url'])){ 
				$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($post_tiles_element_button_link);
			?>
			<div class="col-lg-5 col-md-4 text-md-end d-none d-md-block wow fadeInUp" data-wow-delay="0.4s" data-wow-duration="0.8s">
				<a href="<?php echo esc_url($post_tiles_element_button_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn-link btn-link-lg link-underline icon-link-hover-end">
					<span class="fw-medium"><?php echo esc_html($post_tiles_element_button_text); ?></span>
					<span class="right-icon m-l5"><i class="feather icon-arrow-right"></i></span>
				</a>
			</div> 
			<?php } ?>
		</div>
		<div class="row g-20">
			<?php
				$num = 1;
				$col_class = array('','col-lg-4','col-xl-5 col-lg-8','col-xl-3 col-lg-12');
				while ($query->have_posts()) {
					$query->the_post();
					global $post;
					$post_id = $post->ID;
					$content_text_limit = $post_tiles_element_text_limit;
					$post_title = clinicmaster_trim(get_the_title(), $content_text_limit);

					$post_img = get_the_post_thumbnail_url($post,'medium');
					$num = ($num == 5) ? 1 : $num;
				if($num == 1){
				?>
				<div class="col-lg-4 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s">
					<div class="dz-card style-2 dz-card-overlay overlay-none" <?php if($post_img){ ?> style="background-image: url(<?php echo esc_url($post_img); ?>);" <?php } ?>>
						<div class="dz-info">
							<div class="content-half">
								<div class="post-date"><?php echo esc_html(get_the_date('',$post)); ?></div>
								<?php if(!empty($post_title)){ ?>
								<h3 class="dz-title">
									<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
								</h3>
								<?php } ?>
							</div>
							<div class="bottom-info">
								<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-primary rounded-circle">
									<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M7 17L17 7" stroke="var(--bs-white)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" fill="none"></path>
										<path d="M7 7H17V17" stroke="var(--bs-white)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" fill="none"></path>
									</svg>
								</a>
							</div>
						</div>
					</div>
				</div>
			<?php }elseif($num == 2){ ?>
			<div class="col-xl-5 col-lg-8 wow fadeInUp" data-wow-delay="0.4s" data-wow-duration="0.8s">
				<div class="dz-card style-2 dz-card-overlay" <?php if($post_img){ ?> style="background-image: url(<?php echo esc_url($post_img); ?>);" <?php } ?>>
					<div class="dz-info">
						<div class="post-date"><?php echo esc_html(get_the_date('',$post)); ?></div>
						<div class="bottom-info">
							<h3 class="dz-title">
								<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
							</h3>
							<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-white rounded-circle">
								<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M7 17L17 7" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
									<path d="M7 7H17V17" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
								</svg>
							</a>
						</div>
					</div>
				</div>
			</div>
			<?php }elseif($num == 3){ ?>
			<?php if($num == 3){ echo '<div class="col-xl-3 col-lg-12"><div class="row g-20">'; }?>
			
					<div class="col-xl-12 col-md-6 wow fadeInUp" data-wow-delay="0.6s" data-wow-duration="0.8s">
						<div class="dz-card style-2 dz-card-overlay card-sm no-image">
							<div class="dz-info">
								<div class="post-date"><?php echo esc_html(get_the_date('',$post)); ?></div>
								<h3 class="dz-title">
									<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
								</h3>
								<div class="bottom-info ms-auto">
									<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-white rounded-circle">
										<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M7 17L17 7" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
											<path d="M7 7H17V17" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
										</svg>
									</a>
								</div>
							</div>
						</div>
					</div>
				<?php }elseif($num == 4){ ?>
					<div class="col-xl-12 col-md-6 wow fadeInUp" data-wow-delay="0.8s" data-wow-duration="0.8s">
						<div class="dz-card style-2 dz-card-overlay card-sm" <?php if($post_img){ ?> style="background-image: url(<?php echo esc_url($post_img); ?>);" <?php } ?>>
							<div class="dz-info">
								<div class="post-date"><?php echo esc_html(get_the_date('',$post)); ?></div>
								<div class="bottom-info">
									<h3 class="dz-title">
										<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
									</h3>
									<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-white rounded-circle">
										<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M7 17L17 7" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
											<path d="M7 7H17V17" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
										</svg>
									</a>
								</div>
							</div>
						</div>
					</div>
				<?php if($num == 4){ echo '</div></div>'; }?>
			<?php }
				$num++;
			} ?>
		</div>
	</div>
</section>
<?php } ?>