<?php 
  $content = $map_element_content ? $map_element_content : 'content-inner-2';
$zoom = 15;
$api_key = esc_html( get_option( 'elementor_google_maps_api_key' ) );
if(!empty($address)){
	$params = [
		rawurlencode( $address),
		absint( $zoom ),
	];
	if ( $api_key ) {
		$params[] = $api_key;

		$url = 'https://www.google.com/maps/embed/v1/place?key=%3$s&q=%1$s&amp;zoom=%2$d';
	} else {
		$url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;output=embed&amp;iwloc=near';
	}
$map_style = !empty($map_style) ? $map_style : 'style_1';
if($map_style == 'style_1'){
?>
							
								
						
		<div class="clearfix">
			<div class="map-wrapper style-2">
				<iframe loading="lazy" 
					src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
					title="<?php echo esc_attr( $address ); ?>"
					aria-label="<?php echo esc_attr( $address ); ?>">
				</iframe>	
				<div class="container">
					<div class="content-bx style-5 position-absolute">
						<div class="content-logo">
							<?php do_action( 'clinicmaster_get_logo','site_logo');  ?>
						</div>
						<div class="content-text">
							<p class="m-b0"><?php echo esc_html( $address) ?></p>
						</div>
						<div class="dz-footer">
							<a href="https://www.google.com/maps/" target="_blank" class="icon-link-hover-end"><?php echo esc_html__('Open Google Map','clinicmaster'); ?> <i class="feather icon-arrow-right"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
<?php }elseif($map_style == 'style_2'){ ?>	
		<div class="map-wrapper style-6">
			<iframe loading="lazy" class=""
					src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
					title="<?php echo esc_attr( $address ); ?>"
					aria-label="<?php echo esc_attr( $address ); ?>">
				</iframe>	
		</div>
		
		
<?php }elseif($map_style == 'style_3'){ ?>
<div class="bg-light  <?php echo esc_html($content) ?>">
	<div class="container">
		<div class="map-wrapper style-4">
			<iframe loading="lazy"
					src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
					title="<?php echo esc_attr( $address ); ?>"
					aria-label="<?php echo esc_attr( $address ); ?>">
				</iframe>	
		</div>
	</div>
</div>
<?php }
} ?>