<?php 
$element_content = !empty($contact_box_5_element_content) ? $contact_box_5_element_content : 'content-inner';
$element_class = !empty($contact_box_5_element_class) ? $contact_box_5_element_class : '';


$items = $contact_box_5_element_item;


?>

<section class="<?php echo esc_attr($element_content.' '.$element_class); ?> ">
	<div class="container">
		<?php if(!empty($contact_box_5_element_title)){ ?>
			<div class="section-head style-3 text-center">
				<h2 class="title m-b10"><?php echo esc_html($contact_box_5_element_title); ?></h2>
			</div>
		<?php } ?>
		
		<div class="row">
			<?php if(!empty($items)){ 
					foreach($items as $val){
						$title = $val['contact_box_5_element_item_title'];
						$map_img = $val['contact_box_5_element_item_map_img'];
						$country_flag = $val['contact_box_5_element_item_country_flag'];
						$phone_num = $val['contact_box_5_element_item_phone_num'];
						$address = $val['contact_box_5_element_item_address'];
						$link_text = $val['contact_box_5_element_item_link_text'];
						$link = $val['contact_box_5_element_item_link'];

						?>
					<div class="col-xl-3 col-md-6 m-b30">
						<div class="dz-img-box style-4">
							<?php if(!empty($title)){ ?>
							<div class="dz-head">
								<h3 class="title m-b10"><?php if(!empty($country_flag['id'])){ echo wp_get_attachment_image( $country_flag['id'], 'thumbnail' ); }  echo esc_html($title); ?></h3>
							</div>
							<?php }
							if(!empty($map_img['id'])){	?>
							<div class="dz-media">
								<?php echo wp_get_attachment_image( $map_img['id'], 'medium' ); ?>
							</div>
							<?php } 
							if(!empty($phone_num) || !empty($address)){ ?>
							<div class="dz-content">	
								<?php if(!empty($address)){ ?>
									<p class="m-b10"><?php echo esc_html($address); ?></p>
								<?php }
								if(!empty($phone_num)){ ?>
								<a href="tel:<?php echo esc_attr($phone_num); ?>" class="text-body"><?php echo esc_html($phone_num); ?></a> 
								<?php } ?>
							</div>
							<?php }
							if(!empty($link_text) && !empty($link)){ ?>
								<div class="dz-footer">
									<a href="<?php echo esc_url($link); ?>" target="_blank" class="icon-link-hover-end"><?php echo esc_html($link_text); ?> <i class="feather icon-arrow-up-right"></i></a>
								</div>
							<?php } ?>
						</div>
					</div>
			<?php }
			} ?>
		</div>
	</div>
</section>