<?php 

$zoom = 15;
$api_key = esc_html( get_option( 'elementor_google_maps_api_key' ) );

	$params = [
		rawurlencode( $address),
		absint( $zoom ),
	];
	if ( $api_key ) {
		$params[] = $api_key;

		$url = 'https://www.google.com/maps/embed/v1/place?key=%3$s&q=%1$s&amp;zoom=%2$d';
	} else {
		$url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;output=embed&amp;iwloc=near';
	}
?>

<section class="content-wrapper style-18 bg-light">				
			<div class="map-wrapper">
				
				<iframe loading="lazy"
					src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
					title="<?php echo esc_attr( $address ); ?>"
					aria-label="<?php echo esc_attr( $address ); ?>">
				</iframe>	
				<div class="container">
					<div class="content-bx style-5 alert alert-dismissible fade show m-b60 position-absolute bottom-0" role="alert">
						<div class="content-logo">
							<?php do_action( 'clinicmaster_get_logo','site_logo');  ?>
							
						</div>
						<?php if(!empty($appointment_form_2_element_address_text) || !empty($address)){ ?>
						<div class="content-text m-b20">
							<?php if(!empty($appointment_form_2_element_address_text)){ ?>
							<h6 class="m-b5"><?php echo esc_html($appointment_form_2_element_address_text); ?> </h6>
							<?php }
							if(!empty($address)){ ?>
							<p class="m-b0"><?php echo esc_html($address); ?></p>
							<?php } ?>
						</div>
						<?php } ?>
						<?php if(!empty($appointment_form_2_element_hours_text) || !empty($appointment_form_2_element_hours)){ ?>
						<div class="content-text">
							<?php if(!empty($appointment_form_2_element_hours_text)){ ?>
								<h6 class="m-b5"><?php echo esc_html($appointment_form_2_element_hours_text); ?> </h6>
							<?php }
							if(!empty($appointment_form_2_element_hours)){ ?>
							<p class="m-b0"><?php echo wp_kses($appointment_form_2_element_hours, clinicmaster_allowed_html_tag()); ?></p>
							<?php } ?>
						</div>
						<?php } ?>
						<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
							<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M22.5 7.5L7.5 22.5" stroke="#AFAAA4" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M7.5 7.5L22.5 22.5" stroke="#AFAAA4" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
						</button>
					</div>
				</div>
			</div>
			<div class="container">
				<div class="row justify-content-end">
					<div class="col-xxl-5 col-xl-6 col-lg-7 col-md-12">
						<div class="item1">
							<div class="form-wrapper style-2 bg-secondary">
								<div class="form-body">
									<?php if(!empty($appointment_form_2_element_title)){ ?>
									<div class="title-head">
										<h2 class="form-title m-b20"><?php echo esc_html($appointment_form_2_element_title); ?></h2>
									</div>
									<?php } ?>
									<?php if(!empty($appointment_form_2_element_contact_form)){ ?>
								
									<?php 
										$post = get_page_by_path($appointment_form_2_element_contact_form,OBJECT,'wpcf7_contact_form');
										if(!empty($post->ID)){
											echo do_shortcode('[contact-form-7 id="'.$post->ID.'"]');
										}
									?>
								
							<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>