<?php
$current_page = $GLOBALS['clinicmaster_query_result']['current_page'];
$posts_per_page = $GLOBALS['clinicmaster_query_result']['posts_per_page'];
$side_bar = $GLOBALS['clinicmaster_query_result']['side_bar'];
$show_column = $GLOBALS['clinicmaster_query_result']['show_column'];
$show_date = $GLOBALS['clinicmaster_query_result']['show_date'];
$title_text_limit = $GLOBALS['clinicmaster_query_result']['title_text_limit'];
$element_style = $GLOBALS['clinicmaster_query_result']['element_style'];
$current_post_number =  (($current_page * $posts_per_page) - $posts_per_page) + 1;
$blog_view_container = !empty($GLOBALS['clinicmaster_query_result']['blog_view_container']) && $GLOBALS['clinicmaster_query_result']['blog_view_container'];
$posts = $GLOBALS['clinicmaster_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */


if ($show_column == 'col_1') {
	$col_classes = 'col-lg-12 col-md-6 m-b25 ';
} elseif ($show_column == 'col_2') {
	$col_classes = 'col-lg-6 col-md-6 m-b25 ';
} elseif ($show_column == 'col_3') {
	$col_classes = 'col-xl-4 col-md-6 m-b25';
} else {
	$col_classes = 'col-xl-3 col-md-6 m-b25 ';
}


foreach ($posts as $post) {

	$post_layout = clinicmaster_dzbase()->get_meta('post_layout');
	$post_id  = $post->ID;
	$post_title =  clinicmaster_trim($post->post_title, $title_text_limit);

	/* implement post layout icons on listing post */
	$post_setting = get_post_meta($post_id, '_post_settings', true);
	$author_name = get_the_author_meta('display_name', $post->post_author);

	$is_featured_post = isset($post_setting['is_featured_post']) ? $post_setting['is_featured_post'] : 0;
	$cat_arr = get_the_category($post->ID);

	$views_arr = get_post_meta($post_id, '_views_count');
	$views = (isset($views_arr[0])) ? $views_arr[0] : 0;

	$excerpt = get_the_excerpt();
    $content = get_the_content();
    $short_description = clinicmaster_short_description($excerpt, $content, 25);

	$no_image_class = (!has_post_thumbnail()) ? 'no-image-box' : '';
	$media_class = ($post_layout == 'video_post') ? 'video-bx style-2 overlay-black-light' : '';
	$post_type_video	= clinicmaster_dzbase()->get_meta('post_type_video');
	$post_img = get_the_post_thumbnail_url($post,'medium');

?>

	
	<div id="post-<?php the_ID(); ?>" <?php echo post_class($col_classes); ?>>
		<?php if($element_style == 'style_1'){ ?>
			<div class="dz-card style-2 dz-card-overlay" <?php if(!empty($post_img)){ ?> style="background-image: url(<?php echo esc_url($post_img); ?>);" <?php } ?>>
				<div class="dz-info">
					<?php if(!empty($show_date)){ ?>
						<div class="post-date"><?php echo esc_html(get_the_date()); ?></div>
					<?php } ?>
					<div class="bottom-info">
						<h3 class="dz-title">
							<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
						</h3>
						<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-white rounded-circle">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M7 17L17 7" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
								<path d="M7 7H17V17" stroke="var(--bs-secondary)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
							</svg>
						</a>
					</div>
				</div>
			</div>
		<?php }elseif($element_style == 'style_2'){ ?>
			<div class="dz-card style-4">
			<?php if(has_post_thumbnail()){ ?>
				<div class="dz-media">
					<?php the_post_thumbnail('medium'); ?>
				</div>
			<?php } ?>
				<div class="dz-info">
					<div class="dz-meta">
						<ul>
							<?php if(!empty($show_date)){ ?>
							<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
							<?php } ?>
							<li class="post-author"><?php echo esc_html__('By ', 'clinicmaster'); ?> <a href="<?php echo esc_url(get_author_posts_url( $post->post_author )); ?>"><?php echo esc_html($author_name); ?></a></li>
						</ul>
					</div>
					<h3 class="dz-title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a></h3>
					<?php if(!empty($short_description)){ ?>
						<p><?php echo esc_html($short_description); ?></p>
					<?php } ?>
					<a href="<?php echo esc_url(get_permalink()); ?>" class="icon-link-hover-end d-block">
						<?php echo esc_html__('Read more', 'clinicmaster'); ?> <i class="feather icon-arrow-right"></i>
					</a>
				</div>
			</div>
		<?php }elseif($element_style == 'style_3'){ ?>
			<div class="dz-card style-1">
				<?php if(has_post_thumbnail()){ ?>
					<div class="dz-media">
						<?php the_post_thumbnail('medium'); ?>
					</div>
				<?php } ?>
				<div class="dz-info">
					
					<h3 class="dz-title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a></h3>
					<?php if(!empty($short_description)){ ?>
						<p><?php echo esc_html($short_description); ?></p>
					<?php } ?>
					<div class="dz-meta">
						<ul>
							<?php if(!empty($show_date)){ ?>
								<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
							<?php } ?>
							<li class="post-author"><?php echo esc_html__('By ', 'clinicmaster'); ?> <a href="<?php echo esc_url(get_author_posts_url( $post->post_author )); ?>"><?php echo esc_html($author_name); ?></a></li>
						</ul>
					</div>
				</div>
				<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-secondary rounded-circle">
					<i class="feather icon-arrow-up-right"></i>
				</a>
			</div>
		<?php } ?>
		
	</div>
	
	
<?php
}
wp_reset_postdata();
?>