<?php
/**
 * Register metabox for posts based on Redux Framework. Supported methods:
 *     isset_args( $post_type )
 *     set_args( $post_type, $redux_args, $metabox_args )
 *     add_section( $post_type, $sections )
 * Each post type can contains only one metabox. Pease note that each field id
 * leads by an underscore sign ( _ ) in order to not show that into Custom Field
 * Metabox from WordPress core feature.
 *
 * @param  clinicmaster_Post_Metabox $metabox
 */
 
/**
 * Get list menu.
 * @return array
 */

function clinicmaster_get_default_option($key, $default = '')
{
    if (empty($key))
    {
        return '';
    }
    $options = get_option(clinicmaster_get_opt_name() , array());
    $value = isset($options[$key]) ? $options[$key] : $default;

    return $value;
}

function clinicmaster_page_options_register($metabox)
{

    $post_layouts_options = clinicmaster_get_post_layouts_options();
    $sidebar_layout_options = clinicmaster_get_sidebar_layout_options();
    $header_style_options = clinicmaster_get_header_style_options();
    $page_banner_options = clinicmaster_get_page_banner_options();
    $post_banner_options = clinicmaster_get_post_banner_options();
    $footer_style_options = clinicmaster_get_footer_style_options();
    $banner_type = clinicmaster_banner_type();
	$banner_style = clinicmaster_get_page_banner_style_options();
	$social_link_options = clinicmaster_get_social_link_options();
	$page_banner_layout_options = clinicmaster_get_page_banner_layout_options();
	$header_social_links = $header_social_defaults = $header_social_defaults_1 = array();	
	if(!empty($social_link_options)){
		foreach ($social_link_options as $social_link)
		{

			$link_value = clinicmaster_get_opt('social_' . $social_link['id'] . '_url');
			
			if (!empty($link_value))
			{
				$header_social_links[$social_link['id']] = $social_link['title'];
				$header_social_defaults[$social_link['id']] = false;
			}
		}	
		;
		foreach ($header_social_links as $key => $value)
		{
			if (!empty($value))
			{
				$header_social_defaults_1[$key] = 1;
			}
			else
			{
				$header_social_defaults_1[$key] = 0;
			}
		} 
	}

    /**
     * Option for single posts.
     *
     */
    if (!$metabox->isset_args('post'))
    {
        $metabox->set_args('post', array(
            'opt_name' => clinicmaster_get_post_opt_name() ,
            'display_name' => esc_html__('Post Settings', 'clinicmaster') ,
            'show_options_object' => false,
            'hints' => array(
                'icon' => 'el el-question-sign',
                'icon_position' => 'right',
                'icon_color' => '#1085e4',
                'icon_size' => '10',
                'tip_style' => array(
                    'color' => '#1085e4',
                    'shadow' => true,
                    'rounded' => false,
                    'style' => '',
                ) ,
                'tip_position' => array(
                    'my' => 'top left',
                    'at' => 'bottom right',
                ) ,
                'tip_effect' => array(
                    'show' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'mouseover',
                    ) ,
                    'hide' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'click mouseleave',
                    )
                )
            )
        ) , array(
            'context' => 'advanced',
            'priority' => 'default'
        ));
    }
 
    $metabox->add_section('post', array(
        'title' => esc_html__('General', 'clinicmaster') ,
        'icon' => 'fa fa-newspaper-o',
        'fields' => array(
            array(
                'id' => 'featured_post',
                'type' => 'checkbox',
                'title' => esc_html__('Featured Post?', 'clinicmaster') ,
                'desc' => esc_html__('Check if you want to make this post as featured post', 'clinicmaster') ,
                'default' => ''
            ) ,
        )
    ));
	$metabox->add_section('post', array(
        'title' => esc_html__('Post Header', 'clinicmaster') ,
        'desc' => esc_html__('Header settings for the Post.', 'clinicmaster') ,
        'icon' => 'fa fa-window-maximize',
        'fields' => array(
			array(
                'id' => 'post_header_setting',
                'type' => 'button_set',
                'title' => esc_html__('Post Header Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
            ),
            array(
                'id' => 'post_header_style',
                'type' => 'image_select',
                'title' => esc_html__('Header Style', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose header style. White header is set as default header for this post.', 'clinicmaster') ,
                'options' => $header_style_options,
                'default' => clinicmaster_get_opt('header_style') ,
                'force_output' => true,
				'required' => array(
                    0 => 'post_header_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ) ,
		
			array(
				'id' 		=> 'post_header_menu',
				'type' 		=> 'button_set',
				'title'     => esc_html__('Header Menu Color', 'clinicmaster') ,
				'options' 	=> array(
					'header-light' 		=> esc_html__('Light', 'clinicmaster') ,
					'' 		=> esc_html__('Dark', 'clinicmaster') ,
				   
				) ,
				'default'   => 'header-light',
				'required' => array(
					
						0 => 'post_header_style',
						1 => 'equals',
						2 => 'header_2',
				),
			),
					
        )
    ));
	
    $metabox->add_section('post', array(
        'title' => esc_html__('Post Layout', 'clinicmaster') ,
        'icon' => 'fa fa-file-text-o',
        'fields' => array(
            array(
                'id' => 'post_layout',
                'type' => 'image_select',
                'height' => '55',
                'title' => esc_html__('Layout', 'clinicmaster') ,
                'subtitle' => esc_html__('Select a template.', 'clinicmaster') ,
                'desc' => esc_html__('Click on the template icon to select.', 'clinicmaster') ,
                'options' => $post_layouts_options,
                'default' => clinicmaster_get_opt('post_general_layout') ,
                'hint' => array(
                    'title' => esc_html__('How it Works?', 'clinicmaster') ,
                    'content' => esc_html__('Once you select the template from here, the template will apply for this page only.', 'clinicmaster')
                ),
				
            ) ,
            array(
                'id' => 'post_type_gallery1',
                'type' => 'gallery',
                'title' => esc_html__('Gallery', 'clinicmaster') ,
                'subtitle' => esc_html__('Select the gallery images', 'clinicmaster') ,
				'desc' => esc_html__('For better layout, Image size width greater than 1000 and height greater than 600', 'clinicmaster') ,
                'default' => '',
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'slider_post_1'
                )
            ) ,
            array(
                'id' => 'post_type_gallery2',
                'type' => 'gallery',
                'title' => esc_html__('Gallery', 'clinicmaster') ,
                'subtitle' => esc_html__('Select the gallery images', 'clinicmaster') ,
				'desc' => esc_html__('For better layout, Image size width greater than 1000 and height greater than 600', 'clinicmaster') ,
                'default' => '',
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'slider_post_2'
                )
            ) ,
            array(
                'id' => 'post_type_gallery3',
                'type' => 'gallery',
                'title' => esc_html__('Gallery', 'clinicmaster') ,
                'subtitle' => esc_html__('Select the gallery images', 'clinicmaster') ,
				'desc' => esc_html__('For better layout, Image size width greater than 1000 and height greater than 600', 'clinicmaster') ,
                'default' => '',
                'required' => array(
				0 => 'post_layout',
                    1 => 'equals',
                    2 => 'slider_post_3'
                )
            ) ,
            array(
                'id' => 'post_type_link',
                'type' => 'text',
                'title' => esc_html__('External Link', 'clinicmaster') ,
                'default' => '',
                'validate' => 'url',
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'link_post'
                )
            ) ,
            array(
                'id' => 'post_type_quote_author',
                'type' => 'text',
                'title' => esc_html__('Author Name', 'clinicmaster') ,
                'default' => esc_html__('Author Name', 'clinicmaster') ,
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'quote_post'
                )
            ) ,
            array(
                'id' => 'post_type_quote_text',
                'type' => 'textarea',
                'title' => esc_html__('Quote Text', 'clinicmaster') ,
                'default' => esc_html__('Quote Text', 'clinicmaster') ,
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'quote_post'
                )
            ) ,
            array(
                'id' => 'post_type_audio',
                'type' => 'text',
                'title' => esc_html__('Sound Cloud Link', 'clinicmaster') ,
                'default' => '',
                'validate' => 'url',
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'audio_post'
                )
            ) ,
            array(
                'id' => 'post_type_video',
                'type' => 'text',
                'title' => esc_html__('Video Link', 'clinicmaster') ,
                'default' => '',
                'validate' => 'url',
                'required' => array(
                    0 => 'post_layout',
                    1 => 'equals',
                    2 => 'video_post'
                )
            ) ,
            array(
                'id' => 'post_show_sidebar',
                'type' => 'switch',
                'title' => esc_html__('Sidebar', 'clinicmaster') ,
                'desc' => esc_html__('Show / hide sidebar from this posts detail page.', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('show_sidebar') ,
                'required' => array(
                    array(
                        0 => 'post_layout',
                        1 => '!=',
                        2 => 'gutenberg'
                    ) ,
                )
            ) ,
            array(
                'id' => 'post_sidebar_layout',
                'type' => 'image_select',
                'title' => esc_html__('Sidebar Layout', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose the layout for page. (Default : Right Side).', 'clinicmaster') ,
                'options' => $sidebar_layout_options,
                'default' => 'right',
                'required' => array(
                    0 => 'post_show_sidebar',
                    1 => 'equals',
                    2 => '1'
                )
            ) ,
            array(
                'id' => 'post_sidebar',
                'type' => 'select',
                'data' => 'sidebars',
                'title' => esc_html__('Sidebar', 'clinicmaster') ,
                'subtitle' => esc_html__('Select sidebar.', 'clinicmaster') ,
                'default' => 'dz_blog_sidebar',
                'required' => array(
                    0 => 'post_sidebar_layout',
                    1 => 'equals',
                    2 => array(
                        'right',
                        'left'
                    )
                )
            ) ,
            array(
                'id' => 'featured_image',
                'type' => 'switch',
                'title' => esc_html__('Show Feature Image', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => 1,
            ) ,
            array(
                'id' => 'post_pagination',
                'type' => 'switch',
                'title' => esc_html__('Show Post Pagination', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => 0,
            ) ,
        )
    ));
    $metabox->add_section('post', array(
        'title' => esc_html__('Post Banner', 'clinicmaster') ,
        'desc' => esc_html__('Settings for post banner.', 'clinicmaster') ,
        'icon' => 'fa fa-television',
        'fields' => array(
            array(
                'id' => 'post_banner_setting',
                'type' => 'button_set',
                'title' => esc_html__('Post Banner Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
            ) ,
            array(
                'id' => 'post_banner_on',
                'type' => 'switch',
                'title' => esc_html__('Post Banner', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('post_general_banner_on') ,
                'required' => array(
                    0 => 'post_banner_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ) ,
			array(
				'id' 		=> 'post_banner_layout',
				'type' 		=> 'image_select',
				'title' 	=> esc_html__('Post Banner Layout', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
				'height' 	=> '80',
				'options' 	=> $page_banner_layout_options,
				'default' 	=> 'banner_layout_1',
				'required' 	=> array(0 => 'post_banner_on', 1 => 'equals', 2 => '1')
			) ,
            array(
                'id' => 'post_banner_height',
                'type' => 'image_select',
                'title' => esc_html__('Post Banner Height', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose the height for all tag page banner. Default : Medium Banner', 'clinicmaster') ,
                'options' => $page_banner_options,
                'height' => '40',
                'default' => clinicmaster_get_opt('post_general_banner_height') ,
                'required' => array(
                    0 => 'post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
			array(
                'id' => 'post_banner_custom_height',
                'type' => 'slider',
                'title' => esc_html__('Post Banner Custom Height', 'clinicmaster') ,
                'desc' => esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('post_general_banner_custom_height') ,
                'min' => 100,
                'max' => 800,
                'display_value' => 'text',
                'required' => array(
                    0 => 'post_banner_height',
                    1 => 'equals',
                    2 => 'page_banner_custom'
                )
            ) ,
			array(
				'id' 		=> 'post_banner_image',
				'type' 		=> 'media',
				'url' 		=> true,
				'height' => '40',
				'width' => '40',
				'title' 	=> esc_html__('Post Banner Image', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter page banner image. It will work as default banner image for all pages', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' => array(
                    0 => 'post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
			) ,   

			array(
                'id' => 'post_banner_title_position',
                'type' => 'button_set',
                'options' => array(
                    'left' => esc_html__('Left', 'clinicmaster') ,
                    'center' => esc_html__('Center', 'clinicmaster')
                ),
                'title' => esc_html__('Post Banner Title Position', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose Banner Title Position To Display.', 'clinicmaster') ,
                'default' => 'center',
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
            ) ,
           array(
				'id' 		=> 'post_banner_social',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Post Banner Social', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,		
			array(
				'id' 		=> 'post_banner_small_image',
				'type' 		=> 'media',
				'title' 	=> esc_html__('Post Banner Small Image', 'clinicmaster') ,
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
			) ,	
			array(
				'id' 		=> 'post_banner_gallery',
				'type' 		=> 'gallery',
				'url' 		=> true,
				'title' 	=> esc_html__('Post Banner Gallery', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter post banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
			) , 
			
			array(
				'id' 		=> 'post_banner_contact_on',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Post Banner Contact Info', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,		
			array(
				'id' 		=> 'post_banner_text',
				'type' 		=> 'text',
				'title' 	=> esc_html__('Post Banner Text', 'clinicmaster') ,
				'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,	
   
			
			array(
				'id' 		=> 'post_banner_image_overlay',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,	
			
			array(
				'id' 		=> 'post_banner_star',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Star Image', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'post_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
				
			) ,
          
            array(
                'id' => 'post_breadcrumb',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumb Area', 'clinicmaster') ,
                'subtitle' => esc_html__('Click on the tab to Enable / Disable the website breadcrumb.', 'clinicmaster') ,
                'desc' => esc_html__('This setting affects only on this page.', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('show_breadcrumb') ,
                'required' => array(
                    0 => 'post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
        )
    ));
	 $metabox->add_section('post', array(
        'title' => esc_html__('Post Footer', 'clinicmaster') ,
        'desc' => esc_html__('Settings for footer area.', 'clinicmaster') ,
        'icon' => 'fa fa-home',
        'fields' => array(
			array(
                'id' => 'post_footer_setting',
                'type' => 'button_set',
                'title' => esc_html__('Post Footer Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
			),
			array(
		        'id'      => 'post_footer_on',
	            'type'    => 'switch',
	            'title'   => esc_html__('Footer', 'clinicmaster'),
	            'on'      => esc_html__('Enabled', 'clinicmaster'),
	            'off'     => esc_html__('Disabled', 'clinicmaster'),
				'default' => clinicmaster_get_opt( 'footer_on' ),
	            'required' => array(
                    0 => 'post_footer_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
		    ),
    		array(
	            'id'       => 'post_footer_style',
	            'type'     => 'image_select',
	            'height'   => '80',
	            'title'    => esc_html__('Footer Template', 'clinicmaster'),
	            'subtitle' => esc_html__('Choose a template for footer.', 'clinicmaster'),
	            'options'  => $footer_style_options,
	            'default'  => clinicmaster_get_opt( 'footer_style' ),
				'required' => array(
					array(
						0 => 'post_footer_setting',
						1 => 'equals',
						2 => 'custom'
					),
					array(
						0 => 'post_footer_on',
						1 => 'equals',
						2 => 1
					),
                )
	        ),
			
			
			
		)
    ));
    /**
     * Option for single pages.
     *
     */
    if (!$metabox->isset_args('page'))
    {
        $metabox->set_args('page', array(
            'opt_name' => clinicmaster_get_page_opt_name() ,
            'display_name' => esc_html__('Page Settings', 'clinicmaster') ,
            'show_options_object' => false,
            'hints' => array(
                'icon' => 'el el-question-sign',
                'icon_position' => 'right',
                'icon_color' => '#1085e4',
                'icon_size' => '10',
                'tip_style' => array(
                    'color' => '#1085e4',
                    'shadow' => true,
                    'rounded' => false,
                    'style' => '',
                ) ,
                'tip_position' => array(
                    'my' => 'top left',
                    'at' => 'bottom right',
                ) ,
                'tip_effect' => array(
                    'show' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'mouseover',
                    ) ,
                    'hide' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'click mouseleave',
                    )
                )
            )
        ) , array(
            'context' => 'advanced',
            'priority' => 'default'
        ));
    }
	
    $metabox->add_section('page', array(
        'title' => esc_html__('Page Header', 'clinicmaster') ,
        'desc' => esc_html__('Header settings for the page.', 'clinicmaster') ,
        'icon' => 'fa fa-window-maximize',
        'fields' => array(
			array(
                'id' => 'page_header_setting',
                'type' => 'button_set',
                'title' => esc_html__('Page Header Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
            ),
            array(
                'id' => 'page_header_style',
                'type' => 'image_select',
                'title' => esc_html__('Header Style', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose header style. White header is set as default header for this page.', 'clinicmaster') ,
                'options' => $header_style_options,
                'default' => clinicmaster_get_opt('header_style') ,
                'force_output' => true,
				'required' => array(
                    0 => 'page_header_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ) ,
			array(
				'id' 		=> 'page_header_menu',
				'type' 		=> 'button_set',
				'title'     => esc_html__('Header Menu Color', 'clinicmaster') ,
				'options' 	=> array(
					'header-light' 		=> esc_html__('Light', 'clinicmaster') ,
					'' 		=> esc_html__('Dark', 'clinicmaster') ,
				   
				) ,
				'default'   => 'header-light',
				'required' => array(
					
						0 => 'page_header_style',
						1 => 'equals',
						2 => 'header_2',
				),
			),
        )
    ));
	
	$metabox->add_section('page', array(
        'title' => esc_html__('Page Banner', 'clinicmaster') ,
        'desc' => esc_html__('Settings for page banner.', 'clinicmaster') ,
        'icon' => 'fa fa-television',
        'fields' => array(
            array(
                'id' => 'page_banner_setting',
                'type' => 'button_set',
                'title' => esc_html__('Page Banner Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
            ),
            array(
                'id' => 'page_banner_on',
                'type' => 'switch',
                'title' => esc_html__('Page Banner', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('page_general_banner_on') ,
                'required' => array(
                    0 => 'page_banner_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ),
			array(
				'id' 		=> 'page_banner_layout',
				'type' 		=> 'image_select',
				'title' 	=> esc_html__('Page Banner Layout', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
				'height' 	=> '80',
				'options' 	=> $page_banner_layout_options,
				'default' 	=> 'banner_layout_1',
				'required' 	=> array(0 => 'page_banner_on', 1 => 'equals', 2 => '1')
			),
			 array(
                'id' => 'page_banner_height',
                'type' => 'image_select',
                'title' => esc_html__('Page Banner Height', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose the height for all tag page banner. Default : Medium Banner', 'clinicmaster') ,
                'options' => $page_banner_options,
                'height' => '40',
                'default' => clinicmaster_get_opt('page_general_banner_height') ,
                'required' => array(
                    0 => 'page_banner_on',
                    1 => 'equals',
                    2 => '1'
                )
            ),
			array(
				'id' 		=> 'page_banner_image',
				'type' 		=> 'media',
				'url' 		=> true,
				'height' => '40',
				'width' => '40',
				'title' 	=> esc_html__('Page Banner Image', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter page banner image. It will work as default banner image for all pages', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' => array(
                    0 => 'page_banner_on',
                    1 => 'equals',
                    2 => '1'
                )
			), 


			array(
                'id' => 'page_banner_custom_height',
                'type' => 'slider',
                'title' => esc_html__('Page Banner Custom Height', 'clinicmaster') ,
                'desc' => esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('page_general_banner_custom_height') ,
                'min' => 100,
                'max' => 800,
                'display_value' => 'text',
                'required' => array(
                    0 => 'page_banner_height',
                    1 => 'equals',
                    2 => 'page_banner_custom'
                )
            ),
            array(
				'id' 		=> 'page_banner_social',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Page Banner Social', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,		
            
            array(
                'id'        => 'page_general_banner_social_button',
                'type'      => 'text',
                'title'     => esc_html__('Page Banner Social button', 'clinicmaster') ,
                'on'        => esc_html__('Enabled', 'clinicmaster') ,
                'off'       => esc_html__('Disabled', 'clinicmaster') ,
                'default'   => true,
                'required'  => array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_4'),
            ) , 
            array(
                'id'        => 'page_general_banner_social_button_url',
                'type'      => 'text',
                'title'     => esc_html__('Page Banner Social button url', 'clinicmaster') ,
                'on'        => esc_html__('Enabled', 'clinicmaster') ,
                'off'       => esc_html__('Disabled', 'clinicmaster') ,
                'default'   => true,
                'required'  => array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_4'),
            ) , 
            

			array(
				'id' 		=> 'page_banner_small_image',
				'type' 		=> 'media',
				'title' 	=> esc_html__('Page Banner Small Image', 'clinicmaster') ,
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
			) ,	

            array(
                'id'        => 'page_banner_items_image',
                'type'      => 'media',
                'title'     => esc_html__('Page Banner Items Image', 'clinicmaster') ,
                'required'  => array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_4'),
            ) ,
            array(
                'id'        => 'page_banner_right_image',
                'type'      => 'media',
                'title'     => esc_html__('Page Banner Right Image', 'clinicmaster') ,
                'required'  => array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_4'),
            ) ,

			array(
				'id' 		=> 'page_banner_gallery',
				'type' 		=> 'gallery',
				'url' 		=> true,
				'title' 	=> esc_html__('Page Banner Gallery', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter page banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
			) , 
			
			array(
				'id' 		=> 'page_banner_contact_on',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Page Banner Contact Info', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,		
			array(
				'id' 		=> 'page_banner_text',
				'type' 		=> 'text',
				'title' 	=> esc_html__('Page Banner Text', 'clinicmaster') ,
				'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,	
			
			array(
				'id' 		=> 'page_banner_image_overlay',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,	
			
			array(
				'id' 		=> 'page_banner_star',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Star Image', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
				
			) ,
           
            array(
                'id' => 'page_banner_title',
                'type' => 'text',
                'url' => true,
                'title' => esc_html__('Page Banner Title', 'clinicmaster') ,
                'subtitle' => esc_html__('Enter page banner title.', 'clinicmaster') ,
                'default' => '',
				'required' => array(
                    0 => 'page_banner_on',
                    1 => 'equals',
                    2 => '1'
                )
            ) ,
			
            array(
                'id' => 'page_banner_title_position',
                'type' => 'button_set',
                'options' => array(
                    'left' => esc_html__('Left', 'clinicmaster') ,
                    'center' => esc_html__('Center', 'clinicmaster')
                ),
                'title' => esc_html__('Page Banner Title Position', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose Banner Title Position To Display.', 'clinicmaster') ,
                'default' => 'center',
				'required' 	=> array(0 => 'page_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
            ) ,
			
			
            array(
                'id' => 'page_breadcrumb',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumb Area', 'clinicmaster') ,
                'subtitle' => esc_html__('Click on the tab to Enable / Disable the website breadcrumb.', 'clinicmaster') ,
                'desc' => esc_html__('This setting affects only on this page.', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('show_breadcrumb') ,
                'required' => array(
                    0 => 'page_banner_on',
                    1 => 'equals',
                    2 => '1'
                )
            ),
         
        )
    ));

    $metabox->add_section('page', array(
        'title' => esc_html__('Page Sidebar', 'clinicmaster') ,
        'desc' => esc_html__('Settings for sidebar area.', 'clinicmaster') ,
        'icon' => 'fa fa-server',
        'fields' => array(
			array(
                'id' => 'page_show_sidebar_information',
                'type'  => 'info',
				'style' => 'warning',
				'title' => esc_html__('Sidebar Information!', 'clinicmaster'),
				'icon'  => 'el-icon-info-sign',
				'desc'  => esc_html__( 'These settings only working with default template in page attribute.', 'clinicmaster'),
                'default' => clinicmaster_get_opt('page_general_show_sidebar')
				
            ) ,
            array(
                'id' => 'page_show_sidebar',
                'type' => 'switch',
                'title' => esc_html__('Sidebar', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('page_general_show_sidebar'),
            ) ,
            array(
                'id' => 'page_sidebar_layout',
                'type' => 'image_select',
                'title' => esc_html__('Sidebar Layout', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose the layout for page. (Default : Right Side).', 'clinicmaster') ,
                'options' => $sidebar_layout_options,
                'default' => clinicmaster_get_opt('page_general_sidebar_layout') ,
                'required' => array(
                    0 => 'page_show_sidebar',
                    1 => 'equals',
                    2 => '1'
                )
            ) ,
            array(
                'id' => 'page_sidebar',
                'type' => 'select',
                'data' => 'sidebars',
                'title' => esc_html__('Sidebar', 'clinicmaster') ,
                'subtitle' => esc_html__('Select sidebar for the page', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('page_general_sidebar') ,
                'required' => array(
                    0 => 'page_sidebar_layout',
                    1 => 'equals',
                    2 => array(
                        'left',
                        'right'
                    )
                )
            )
        )
		
    ));

    $metabox->add_section('page', array(
        'title' => esc_html__('Page Footer', 'clinicmaster') ,
        'desc' => esc_html__('Settings for footer area.', 'clinicmaster') ,
        'icon' => 'fa fa-home',
        'fields' => array(
			array(
                'id' => 'page_footer_setting',
                'type' => 'button_set',
                'title' => esc_html__('Page Footer Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
			),
			array(
		        'id'      => 'page_footer_on',
	            'type'    => 'switch',
	            'title'   => esc_html__('Footer', 'clinicmaster'),
	            'on'      => esc_html__('Enabled', 'clinicmaster'),
	            'off'     => esc_html__('Disabled', 'clinicmaster'),
				'default' => clinicmaster_get_opt( 'footer_on' ),
	            'required' => array(
                    0 => 'page_footer_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
		    ),
    		array(
	            'id'       => 'page_footer_style',
	            'type'     => 'image_select',
	            'height'   => '80',
	            'title'    => esc_html__('Footer Template', 'clinicmaster'),
	            'subtitle' => esc_html__('Choose a template for footer.', 'clinicmaster'),
	            'options'  => $footer_style_options,
	            'default'  => clinicmaster_get_opt( 'footer_style' ),
				'required' => array(
					array(
						0 => 'page_footer_setting',
						1 => 'equals',
						2 => 'custom'
					),
					array(
						0 => 'page_footer_on',
						1 => 'equals',
						2 => 1
					),
                )
	        ),
			
	
        )
    ));
	
    /**
     * Option for Testimonial single posts.
     *
     */
    if (!$metabox->isset_args('dz_testimonial'))
    {
        $metabox->set_args('dz_testimonial', array(
            'opt_name' => clinicmaster_get_post_opt_name() ,
            'display_name' => esc_html__('Customer Data', 'clinicmaster') ,
            'show_options_object' => false,
            'hints' => array(
                'icon' => 'el el-question-sign',
                'icon_position' => 'right',
                'icon_color' => '#1085e4',
                'icon_size' => '10',
                'tip_style' => array(
                    'color' => '#1085e4',
                    'shadow' => true,
                    'rounded' => false,
                    'style' => '',
                ) ,
                'tip_position' => array(
                    'my' => 'top left',
                    'at' => 'bottom right',
                ) ,
                'tip_effect' => array(
                    'show' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'mouseover',
                    ) ,
                    'hide' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'click mouseleave',
                    )
                )
            )
        ) , array(
            'context' => 'advanced',
            'priority' => 'default'
        ));
    }
	
	$metabox->add_section('dz_testimonial', array(
        'title' => esc_html__('Feature Post', 'clinicmaster') ,
        'icon' => 'fa fa-newspaper-o',
        'fields' => array(
            array(
                'id' => 'featured_post',
                'type' => 'checkbox',
                'title' => esc_html__('Featured Post?', 'clinicmaster') ,
                'desc' => esc_html__('Check if you want to make this post as featured post', 'clinicmaster') ,
                'default' => ''
            ) ,
        )
    ));
	
    $metabox->add_section('dz_testimonial', array(
        'title' => esc_html__('General', 'clinicmaster') ,
        'icon' => 'fa fa-newspaper-o',
        'fields' => array(
            array(
                'id' => 'testimonial_designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'clinicmaster') ,
                'desc' => esc_html__('Enter client designation', 'clinicmaster') ,
                'default' => esc_html__('Patient', 'clinicmaster') ,
            ) ,
			array(
				'id'       => 'testimonial_rating',
				'type'     => 'select',
				'title'    => esc_html__('Rating', 'clinicmaster'), 
				'desc'     => esc_html__('Select Rating.', 'clinicmaster'),
				/* Must provide key => value pairs for select options */
				'options'  => array(
					'1' => '1 Star',
					'2' => '2 Star',
					'3' => '3 Star',
					'4' => '4 Star',
					'5' => '5 Star'
				),
				'default'  => '5',
			),

             array(
                'id' => 'testimonial_heading',
                'type' => 'text',
                'title' => esc_html__('heading', 'clinicmaster') ,
                'desc' => esc_html__('Enter client designation', 'clinicmaster') ,
                'default' => esc_html__('I never thought I’d feel this Confident again!', 'clinicmaster') ,
            ) ,
            
            array(
                'id' => 'testimonial_rating_title',
                'type' => 'text',
                'title' => esc_html__('Secondary  Title', 'clinicmaster') ,
                'desc' => esc_html__('Enter Secondary Title', 'clinicmaster') ,
                'default' => esc_html__('Best Treatment', 'clinicmaster') ,
            ) ,
            
            	 array(
                'id' => 'testimonial_befor_img',
                'type' => 'media',
                'title' => esc_html__('Before Image', 'clinicmaster') ,
                'desc' => esc_html__('Enter your text', 'clinicmaster') ,
            ) , 
            	 array(
                'id' => 'testimonial_after_img',
                'type' => 'media',
                'title' => esc_html__('After Image', 'clinicmaster') ,
                'desc' => esc_html__('Enter your text', 'clinicmaster') ,
            ) , 
			array(
                'id' => 'testimonial_youtube_text',
                'type' => 'text',
                'title' => esc_html__('YouTube Text', 'clinicmaster') ,
                'desc' => esc_html__('Enter your text', 'clinicmaster') ,
                'default' => esc_html__('Watch The Video', 'clinicmaster') ,
                
            ),
			array(
                'id' => 'testimonial_youtube_link',
                'type' => 'text',
                'title' => esc_html__('YouTube Link', 'clinicmaster') ,
                'desc' => esc_html__('Enter your link', 'clinicmaster') ,
                'default' => 'https://www.youtube.com/watch?v=YwYoyQ1JdpQ',
                
            ),
		    array(
                'id' => 'testimonial_youtube_img',
                'type' => 'media',
                'title' => esc_html__('YouTube Image', 'clinicmaster') ,
                'desc' => esc_html__('Enter your text', 'clinicmaster') ,
            ) , 
        )
    ));

	
	/**
     * Option for Service single posts.
     *
     */
    if (!$metabox->isset_args('dz_service'))
    {
        $metabox->set_args('dz_service', array(
            'opt_name' => clinicmaster_get_post_opt_name() ,
            'display_name' => esc_html__('Service Settings', 'clinicmaster') ,
            'show_options_object' => false,
            'hints' => array(
                'icon' => 'el el-question-sign',
                'icon_position' => 'right',
                'icon_color' => '#1085e4',
                'icon_size' => '10',
                'tip_style' => array(
                    'color' => '#1085e4',
                    'shadow' => true,
                    'rounded' => false,
                    'style' => '',
                ) ,
                'tip_position' => array(
                    'my' => 'top left',
                    'at' => 'bottom right',
                ) ,
                'tip_effect' => array(
                    'show' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'mouseover',
                    ) ,
                    'hide' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'click mouseleave',
                    )
                )
            )
        ) , array(
            'context' => 'advanced',
            'priority' => 'default'
        ));
    }
	
	$metabox->add_section('dz_service', array(
        'title' => esc_html__('General', 'clinicmaster') ,
        'icon' => 'fa fa-newspaper-o',
        'fields' => array(
            array(
                'id' => 'featured_post',
                'type' => 'checkbox',
                'title' => esc_html__('Featured Post?', 'clinicmaster') ,
                'desc' => esc_html__('Check if you want to make this post as featured post', 'clinicmaster') ,
                'default' => ''
            ) ,
			array(
                'id' => 'service_author_image',
                'type' => 'media',
                'title' => esc_html__('Post Author Image', 'clinicmaster') ,
                'default' => ''
            ) ,
			array(
                'id' => 'service_author_name',
                'type' => 'text',
                'title' => esc_html__('Post Author Name', 'clinicmaster') ,
              
                'default' => 'Nashid Martines'
            ) ,
			array(
                'id' => 'genaral_available_doctors',
                'type' => 'text',
                'title' => esc_html__('Available Doctors', 'clinicmaster') ,
                'default' => esc_html__('25+ Doctors', 'clinicmaster') ,
            ) ,
			
			array(
				'id'       => 'service_icon_setting',
				'type'     => 'button_set',
				'title'    => esc_html__('Service Icon', 'clinicmaster'),
				'options'  => array(
					'service_icon_dz_icon'  => esc_html__('SVG', 'clinicmaster'),
					'service_icon_dz_iconpng' => esc_html__('PNG', 'clinicmaster'),
				),
				'default'  => 'service_icon_dz_icon',
			),

			array(
				'id'       => 'service_icon_dz_icon',
				'type'     => 'textarea',
				'title'    => esc_html__('SVG', 'clinicmaster'),
				'default'  => '',
				'required' => array('service_icon_setting', 'equals', 'service_icon_dz_icon'), // Show only if SVG is selected
			),

			array(
				'id'       => 'service_icon_dz_iconpng',
				'type'     => 'media',
				'title'    => esc_html__('PNG', 'clinicmaster'),
				'default'  => '',
				'library'  => array(
					'mime_types' => array('image/png') // Only allow PNG uploads
				),
				'required' => array('service_icon_setting', 'equals', 'service_icon_dz_iconpng'), // Show only if PNG is selected
			),

        )
    ));

    $metabox->add_section('dz_service', array(
        'title' => esc_html__('Service Page Header', 'clinicmaster') ,
        'desc' => esc_html__('Header settings for the page.', 'clinicmaster') ,
        'icon' => 'fa fa-window-maximize',
        'fields' => array(

            array(
                'id' => 'service_post_header_setting',
                'type' => 'button_set',
                'title' => esc_html__('Header Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
            ),
            array(
                'id' => 'service_post_header_style',
                'type' => 'image_select',
                'title' => esc_html__('Header Style', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose header style. White header is set as default header for this service.', 'clinicmaster') ,
                'options' => $header_style_options,
                'default' => clinicmaster_get_opt('header_style') ,
                'force_output' => true,
                'required' => array(
                    0 => 'service_post_header_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ) ,
			array(
				'id' 		=> 'service_post_header_menu',
				'type' 		=> 'button_set',
				'title'     => esc_html__('Header Menu Color', 'clinicmaster') ,
				'options' 	=> array(
					'header-light' 		=> esc_html__('Light', 'clinicmaster') ,
					'' 		=> esc_html__('Dark', 'clinicmaster') ,
				   
				) ,
				'default'   => 'header-light',
				'required' => array(
					
						0 => 'service_post_header_style',
						1 => 'equals',
						2 => 'header_2',
				),
			),
        )
    )); 
	
	
    $metabox->add_section('dz_service', array(
        'title' => esc_html__('Service Post Banner', 'clinicmaster') ,
        'desc' => esc_html__('Settings for post banner.', 'clinicmaster') ,
        'icon' => 'fa fa-television',
        'fields' => array(
            array(
                'id' => 'service_post_banner_setting',
                'type' => 'button_set',
                'title' => esc_html__('Post Banner Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
				
            ) ,
			
             array(
                'id' => 'service_post_banner_on',
                'type' => 'switch',
                'title' => esc_html__('Post Banner', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('post_general_banner_on') ,
                'required' => array(
                    0 => 'service_post_banner_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ) ,
			array(
				'id' 		=> 'service_post_banner_layout',
				'type' 		=> 'image_select',
				'title' 	=> esc_html__('Post Banner Layout', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
				'height' 	=> '80',
				'options' 	=> $page_banner_layout_options,
				'default' 	=> 'banner_layout_1',
				'required' 	=> array(0 => 'service_post_banner_on', 1 => 'equals', 2 => '1')
			) ,
            array(
                'id' => 'service_post_banner_height',
                'type' => 'image_select',
                'title' => esc_html__('Post Banner Height', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose the height for all tag page banner. Default : Medium Banner', 'clinicmaster') ,
                'options' => $page_banner_options,
                'height' => '40',
                'default' => clinicmaster_get_opt('post_general_banner_height') ,
                'required' => array(
                    0 => 'service_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
			array(
                'id' => 'service_post_banner_custom_height',
                'type' => 'slider',
                'title' => esc_html__('Post Banner Custom Height', 'clinicmaster') ,
                'desc' => esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('post_general_banner_custom_height') ,
                'min' => 100,
                'max' => 800,
                'display_value' => 'text',
                'required' => array(
                    0 => 'service_post_banner_height',
                    1 => 'equals',
                    2 => 'page_banner_custom'
                )
            ) ,
			array(
				'id' 		=> 'service_post_banner_image',
				'type' 		=> 'media',
				'url' 		=> true,
				'height' => '40',
				'width' => '40',
				'title' 	=> esc_html__('Post Banner Image', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter page banner image. It will work as default banner image for all pages', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' => array(
                    0 => 'service_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
			) , 
			array(
                'id' => 'service_post_banner_title_position',
                'type' => 'button_set',
                'options' => array(
                    'left' => esc_html__('Left', 'clinicmaster') ,
                    'center' => esc_html__('Center', 'clinicmaster')
                ),
                'title' => esc_html__('Post Banner Title Position', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose Banner Title Position To Display.', 'clinicmaster') ,
                'default' => 'center',
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2','banner_layout_4')),
            ) ,
           array(
				'id' 		=> 'service_post_banner_social',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Post Banner Social', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,		
			array(
				'id' 		=> 'service_post_banner_small_image',
				'type' 		=> 'media',
				'title' 	=> esc_html__('Post Banner Small Image', 'clinicmaster') ,
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
			) ,	
         
            array(
                'id'        => 'service_post_banner_items_image',
                'type'      => 'media',
                'title'     => esc_html__('Page Banner Items Image', 'clinicmaster') ,
                'required' => array(
                    0 => 'service_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
            array(
                'id'        => 'service_post_banner_right_image',
                'type'      => 'media',
                'title'     => esc_html__('Page Banner Right Image', 'clinicmaster') ,
                'required' => array(
                    0 => 'service_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,

            array(
                'id'        => 'service_post_banner_social_btn',
                'type'      => 'text',
                'title'     => esc_html__('Page Banner Corner Btn', 'clinicmaster') ,
                'default'   => esc_html__(' SERVICE', 'clinicmaster'),
                'required'  => array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_4'),
            ) ,     
            array(
                'id'        => 'service_post_banner_social_btn_link',
                'type'      => 'text',
                'title'     => esc_html__('Page Banner Corner Btn Link', 'clinicmaster') ,
                'default'   => esc_html__(' SERVICE', 'clinicmaster'),
                'required'  => array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_4'),
            ) ,     


			array(
				'id' 		=> 'service_post_banner_gallery',
				'type' 		=> 'gallery',
				'url' 		=> true,
				'title' 	=> esc_html__('Post Banner Gallery', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter post banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
			) , 
			
			array(
				'id' 		=> 'service_post_banner_contact_on',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Post Banner Contact Info', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,		
			array(
				'id' 		=> 'service_post_banner_text',
				'type' 		=> 'text',
				'title' 	=> esc_html__('Post Banner Text', 'clinicmaster') ,
				'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,	
   
			
			array(
				'id' 		=> 'service_post_banner_image_overlay',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,	
			
			array(
				'id' 		=> 'service_post_banner_star',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Star Image', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'service_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
				
			) ,
          
            array(
                'id' => 'service_post_breadcrumb',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumb Area', 'clinicmaster') ,
                'subtitle' => esc_html__('Click on the tab to Enable / Disable the website breadcrumb.', 'clinicmaster') ,
                'desc' => esc_html__('This setting affects only on this page.', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('show_breadcrumb') ,
                'required' => array(
                    0 => 'service_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
        )
    ));

    $metabox->add_section('dz_service', array(
        'title' => esc_html__('Service Post Footer', 'clinicmaster') ,
        'desc' => esc_html__('Settings for footer area.', 'clinicmaster') ,
        'icon' => 'fa fa-home',
        'fields' => array(
            array(
                'id' => 'service_page_footer_setting',
                'type' => 'button_set',
                'title' => esc_html__('Service Post Footer Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
            ),
            array(
                'id'      => 'service_page_footer_on',
                'type'    => 'switch',
                'title'   => esc_html__('Footer', 'clinicmaster'),
                'on'      => esc_html__('Enabled', 'clinicmaster'),
                'off'     => esc_html__('Disabled', 'clinicmaster'),
                'default' => clinicmaster_get_opt( 'footer_on' ),
                'required' => array(
                    0 => 'service_page_footer_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ),
            array(
                'id'       => 'service_page_footer_style',
                'type'     => 'image_select',
                'height'   => '80',
                'title'    => esc_html__('Footer Template', 'clinicmaster'),
                'subtitle' => esc_html__('Choose a template for footer.', 'clinicmaster'),
                'options'  => $footer_style_options,
                'default'  => clinicmaster_get_opt( 'footer_style' ),
                'required' => array(
                    array(
                        0 => 'service_page_footer_setting',
                        1 => 'equals',
                        2 => 'custom'
                    ),
                    array(
                        0 => 'service_page_footer_on',
                        1 => 'equals',
                        2 => 1
                    ),
                )
            )
        )
    ));


	
	 /**
     * Option for Team single posts.
     *
     */
    if (!$metabox->isset_args('dz_team'))
    {
        $metabox->set_args('dz_team', array(
            'opt_name' => clinicmaster_get_post_opt_name() ,
            'display_name' => esc_html__('Customer Data', 'clinicmaster') ,
            'show_options_object' => false,
            'hints' => array(
                'icon' => 'el el-question-sign',
                'icon_position' => 'right',
                'icon_color' => '#1085e4',
                'icon_size' => '10',
                'tip_style' => array(
                    'color' => '#1085e4',
                    'shadow' => true,
                    'rounded' => false,
                    'style' => '',
                ) ,
                'tip_position' => array(
                    'my' => 'top left',
                    'at' => 'bottom right',
                ) ,
                'tip_effect' => array(
                    'show' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'mouseover',
                    ) ,
                    'hide' => array(
                        'effect' => 'slide',
                        'duration' => '500',
                        'event' => 'click mouseleave',
                    )
                )
            )
        ) , array(
            'context' => 'advanced',
            'priority' => 'default'
        ));
    }
	$metabox->add_section('dz_team', array(
        'title' => esc_html__('Feature Post', 'clinicmaster') ,
        'icon' => 'fa fa-newspaper-o',
        'fields' => array(
            array(
                'id' => 'featured_post',
                'type' => 'checkbox',
                'title' => esc_html__('Featured Post?', 'clinicmaster') ,
                'desc' => esc_html__('Check if you want to make this post as featured post', 'clinicmaster') ,
                'default' => ''
            ) ,
        )
    ));
    $metabox->add_section('dz_team', array(
        'title' => esc_html__('General', 'clinicmaster') ,
        'icon' => 'fa fa-newspaper-o',
        'fields' => array(
            array(
                'id' => 'team_designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'clinicmaster') ,
                'desc' => esc_html__('Enter client designation', 'clinicmaster') ,
                'default' => esc_html__('Cardiac Surgery', 'clinicmaster') ,
            ) ,
			array(
                'id' => 'genaral_skils',
                'type' => 'textarea',
                'title' => esc_html__('Skils', 'clinicmaster') ,
                'default' => esc_html__('Teeth Whitening,Root Canal', 'clinicmaster') ,
            ) ,
        )
    ));
	 $metabox->add_section('dz_team', array(
        'title' => esc_html__('Team Post Banner', 'clinicmaster') ,
        'desc' => esc_html__('Settings for post banner.', 'clinicmaster') ,
        'icon' => 'fa fa-television',
        'fields' => array(
             array(
                'id' => 'team_post_banner_setting',
                'type' => 'button_set',
                'title' => esc_html__('Post Banner Settings', 'clinicmaster') ,
                'options' => array(
                    'theme_default' => esc_html__('Theme Default', 'clinicmaster') ,
                    'custom' => esc_html__('Custom Setting', 'clinicmaster')
                ) ,
                'default' => 'theme_default',
				
            ) ,
			
            
             array(
                'id' => 'team_post_banner_on',
                'type' => 'switch',
                'title' => esc_html__('Post Banner', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('post_general_banner_on') ,
                'required' => array(
                    0 => 'team_post_banner_setting',
                    1 => 'equals',
                    2 => 'custom'
                )
            ) ,
			array(
				'id' 		=> 'team_post_banner_layout',
				'type' 		=> 'image_select',
				'title' 	=> esc_html__('Post Banner Layout', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
				'height' 	=> '80',
				'options' 	=> $page_banner_layout_options,
				'default' 	=> 'banner_layout_1',
				'required' 	=> array(0 => 'team_post_banner_on', 1 => 'equals', 2 => '1')
			) ,
            array(
                'id' => 'team_post_banner_height',
                'type' => 'image_select',
                'title' => esc_html__('Post Banner Height', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose the height for all tag page banner. Default : Medium Banner', 'clinicmaster') ,
                'options' => $page_banner_options,
                'height' => '40',
                'default' => clinicmaster_get_opt('post_general_banner_height') ,
                'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
			array(
                'id' => 'team_post_banner_custom_height',
                'type' => 'slider',
                'title' => esc_html__('Post Banner Custom Height', 'clinicmaster') ,
                'desc' => esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('post_general_banner_custom_height') ,
                'min' => 100,
                'max' => 800,
                'display_value' => 'text',
                'required' => array(
                    0 => 'team_post_banner_height',
                    1 => 'equals',
                    2 => 'page_banner_custom'
                )
            ) ,
			array(
				'id' 		=> 'team_post_banner_image',
				'type' 		=> 'media',
				'url' 		=> true,
				'height' => '40',
				'width' => '40',
				'title' 	=> esc_html__('Post Banner Image', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter page banner image. It will work as default banner image for all pages', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
			) , 

             array(
                'id'        => 'team_post_banner_items_image',
                'type'      => 'media',
                'title'     => esc_html__('Page Banner Image', 'clinicmaster') ,
                'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
            array(
                'id'        => 'team_post_banner_right_image', 
                'type'      => 'media',
                'title'     => esc_html__('Page Banner Icon Image', 'clinicmaster') ,
                'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,

                 array(
                'id'        => 'team_post_banner_social_btn',
                'type'      => 'text',
                'title'     => esc_html__('Page Banner Corner Btn', 'clinicmaster') ,
                'default'   => esc_html__(' Lets Talk', 'clinicmaster'),
                'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,     
            array(
                'id'        => 'team_post_banner_social_btn_link',
                'type'      => 'text',
                'title'     => esc_html__('Page Banner Corner Btn Link', 'clinicmaster') ,
                'default'   => esc_html__('team', 'clinicmaster'),
                'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,     

        
			array(
                'id' => 'team_post_banner_title_position',
                'type' => 'button_set',
                'options' => array(
                    'left' => esc_html__('Left', 'clinicmaster') ,
                    'center' => esc_html__('Center', 'clinicmaster')
                ),
                'title' => esc_html__('Post Banner Title Position', 'clinicmaster') ,
                'subtitle' => esc_html__('Choose Banner Title Position To Display.', 'clinicmaster') ,
                'default' => 'center',
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2','banner_layout_4')),
            ) ,
           array(
				'id' 		=> 'team_post_banner_social',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Post Banner Social', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,		
			array(
				'id' 		=> 'team_post_banner_small_image',
				'type' 		=> 'media',
				'title' 	=> esc_html__('Post Banner Small Image', 'clinicmaster') ,
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
			) ,	
			array(
				'id' 		=> 'team_post_banner_gallery',
				'type' 		=> 'gallery',
				'url' 		=> true,
				'title' 	=> esc_html__('Post Banner Gallery', 'clinicmaster') ,
				'subtitle' 	=> esc_html__('Enter post banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
				'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
			) , 
			
			array(
				'id' 		=> 'team_post_banner_contact_on',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Post Banner Contact Info', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,		
			array(
				'id' 		=> 'team_post_banner_text',
				'type' 		=> 'text',
				'title' 	=> esc_html__('Post Banner Text', 'clinicmaster') ,
				'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
			) ,	
   
			
			array(
				'id' 		=> 'team_post_banner_image_overlay',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
			) ,	
			
			array(
				'id' 		=> 'team_post_banner_star',
				'type' 		=> 'switch',
				'title' 	=> esc_html__('Banner Star Image', 'clinicmaster') ,
				'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
				'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
				'default' 	=> true,
				'required' 	=> array(0 => 'team_post_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
				
			) ,
          
            array(
                'id' => 'team_post_breadcrumb',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumb Area', 'clinicmaster') ,
                'subtitle' => esc_html__('Click on the tab to Enable / Disable the website breadcrumb.', 'clinicmaster') ,
                'desc' => esc_html__('This setting affects only on this page.', 'clinicmaster') ,
                'on' => esc_html__('Enabled', 'clinicmaster') ,
                'off' => esc_html__('Disabled', 'clinicmaster') ,
                'default' => clinicmaster_get_opt('show_breadcrumb') ,
                'required' => array(
                    0 => 'team_post_banner_on',
                    1 => 'equals',
                    2 => 1
                ) ,
            ) ,
        )
    ));
	$metabox->add_section('dz_team', array(
        'title' => esc_html__('Social Settings', 'clinicmaster') ,
        'desc' => esc_html__('Settings for page banner.', 'clinicmaster') ,
        'icon' => 'fa fa-television',
        'fields' => array(

            array(
                'id' => 'team_social_facebook',
                'type' => 'text',
                'url' => true,
                'title' => esc_html__('Facebook Link', 'clinicmaster') ,
                'desc' => esc_html__('Enter Facebook Url', 'clinicmaster') ,
                'default' => 'https://www.facebook.com'
            ) ,
            array(
                'id' => 'team_social_twitter',
                'type' => 'text',
                'url' => true,
                'title' => esc_html__('Twitter Link', 'clinicmaster') ,
                'desc' => esc_html__('Enter Twitter Url', 'clinicmaster') ,
                'default' => 'https://www.twitter.com'
            ) ,
            array(
                'id' => 'team_social_instagram',
                'type' => 'text',
                'url' => true,
                'title' => esc_html__('Instagram Link', 'clinicmaster') ,
                'desc' => esc_html__('Enter Instagram Url', 'clinicmaster') ,
                'default' => 'https://www.instagram.com'
            ) ,
            array(
                'id' => 'team_social_linkdin',
                'type' => 'text',
                'url' => true,
                'title' => esc_html__('Linkdin Link', 'clinicmaster') ,
                'desc' => esc_html__('Enter Linkdin Url', 'clinicmaster') ,
                'default' => 'https://www.linkdin.com'
            ),
			array(
                'id' => 'team_social_youtube',
                'type' => 'text',
                'url' => true,
                'title' => esc_html__('YouTube Link', 'clinicmaster') ,
                'desc' => esc_html__('Enter YouTube Url', 'clinicmaster') ,
                'default' => 'https://www.youtube.com'
            ) ,
        )
    ));
	
}

add_action('dsx_post_metabox_register', 'clinicmaster_page_options_register');

