<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZVideoBox extends Widget_Base 
{
	public function get_name() {
		return 'dz-video-box';
	}
	
	public function get_title() {
		return esc_html__('Video Box',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-youtube';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'video_box_element_style',
			[
				'label' 		=> esc_html__( 'Elemente Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options'    => array(
					'style_1' => 'Style 1',
					'style_2' => 'Style 2',
				),
				'default'	 => 'style_1',
				
			]
		);


       $this->add_control(
			'video_box_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'PLAY VIDEO', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'video_box_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'video_box_element_youtube_link',
			[
				'label' 		=> esc_html__( 'YouTube Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default'      => 'https://www.youtube.com/watch?v=YwYoyQ1JdpQ',
			]
		);
		
		
		
		
		$this->end_controls_section();
		
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/video_box_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}