<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZTeamDetail2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-team-detail-2';
	}
	
	public function get_title() {
		return esc_html__('Team Detail 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'team_detail_2_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Best Dermatologists', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->add_control(
			'team_detail_2_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 	=> '<strong class="text-secondary fw-semibold">'.esc_html('Dr. Nashid Martines',DZ_TH_DOMAIN).'</strong>'.esc_html__( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don"t look even slightly believable.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'team_detail_2_element_title',
			[
				'label' 		=> esc_html__( 'Contact Form Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Book Your Appointment', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
		'team_detail_2_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
				
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'user_information',
			[
				'label' => esc_html__( 'User Information', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'team_detail_2_element_item_text',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Specialty', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater->add_control(
			'team_detail_2_element_item_value',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Orthodontist Surgeon Specialize', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'team_detail_2_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'team_detail_2_element_item_text' 		=> esc_html__( 'Specialty', DZ_TH_DOMAIN ),
						'team_detail_2_element_item_value' 		=> esc_html__( 'Orthodontist Surgeon Specialize', DZ_TH_DOMAIN ),
						
					],	
					[	
						'team_detail_2_element_item_text' 		=> esc_html__( 'Degrees', DZ_TH_DOMAIN ),
						'team_detail_2_element_item_value' 		=> '<a href="javascript:void(0);">'.esc_html__( 'MBBS University of California', DZ_TH_DOMAIN ).'</a>',
						
					],	
					[	
						'team_detail_2_element_item_text' 		=> esc_html__( 'Experience', DZ_TH_DOMAIN ),
						'team_detail_2_element_item_value' 		=> esc_html__( '7 years, New York Urgent Medical Care Serving California', DZ_TH_DOMAIN ),
						
					],	
					[	
						'team_detail_2_element_item_text' 		=> esc_html__( 'Awards', DZ_TH_DOMAIN ),
						'team_detail_2_element_item_value' 		=> esc_html__( '2018 - 2019 : William Allan Award', DZ_TH_DOMAIN ),
						
					],	
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'skils',
			[
				'label' => esc_html__( 'User Skills', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'team_detail_2_element_feature_text',
			[
				'label' 		=> esc_html__( 'Feature Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'About Skills', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'team_detail_2_element_feature_list',
			[
				'label' 		=> esc_html__( 'Feature List', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Radiant Skin Dermatology', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'team_detail_2_element_skils',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'team_detail_2_element_feature_list' 		=> esc_html__( 'Radiant Skin Dermatology', DZ_TH_DOMAIN ),
						
					],	
					[	
						'team_detail_2_element_feature_list' 		=> esc_html__( 'Laser Resurfacing', DZ_TH_DOMAIN ),
						
					],
					[	
						'team_detail_2_element_feature_list' 		=> esc_html__( 'Flawless Dermatology', DZ_TH_DOMAIN ),
						
					],	
					[	
						'team_detail_2_element_feature_list' 		=> esc_html__( 'Refined Skin Dermatology', DZ_TH_DOMAIN ),
						
					],
					[	
						'team_detail_2_element_feature_list' 		=> esc_html__( 'Luminous Dermatology', DZ_TH_DOMAIN ),
						
					],
					[	
						'team_detail_2_element_feature_list' 		=> esc_html__( 'Anti Aging', DZ_TH_DOMAIN ),
						
					],
					
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'contact',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
				
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'team_detail_2_element_contact_icon',
			[
				'label' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::ICONS,
				
			]
		);
		
		$repeater->add_control(
			'team_detail_2_element_contact_text',
			[
				'label' 	=> esc_html__( 'Taxt', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Send us a Mail', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'team_detail_2_element_contact_value',
			[
				'label' 	=> esc_html__( 'Value', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your value', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'info@example.com', DZ_TH_DOMAIN ),
				
			]
			
		);
		$this->add_control(
			'team_detail_2_element_contact',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'default' 		=> [
					
					[	
						'team_detail_2_element_contact_text' 		=> esc_html__( 'Send us a Mail', DZ_TH_DOMAIN ),
						'team_detail_2_element_contact_value' 		=> esc_html__( 'info@example.com', DZ_TH_DOMAIN ),
					],	
					[	
						'team_detail_2_element_contact_text' 		=> esc_html__( 'Call Us', DZ_TH_DOMAIN ),
						'team_detail_2_element_contact_value' 		=> esc_html__( '+1 123 456 7890', DZ_TH_DOMAIN ),
					],	
					
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'schedule',
			[
				'label' => esc_html__( 'Time Schedule', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->add_control(
			'team_detail_2_element_text',
			[
				'label' 	=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'My Time Schedule', DZ_TH_DOMAIN ),
				
			]
		);
		
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'team_detail_2_element_schedule_week',
			[
				'label' 	=> esc_html__( 'Week  Name', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Monday', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'team_detail_2_element_schedule_time',
			[
				'label' 	=> esc_html__( 'Time Schedule', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your time', DZ_TH_DOMAIN ),
				'default' => '09:30 - 07:30',
			]
		);
		$this->add_control(
			'team_detail_2_element_schedule',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'team_detail_2_element_schedule_week' 		=> esc_html__( 'Monday', DZ_TH_DOMAIN ),
						'team_detail_2_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					[	
						'team_detail_2_element_schedule_week' 		=> esc_html__( 'Tuesday', DZ_TH_DOMAIN ),
						'team_detail_2_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					[	
						'team_detail_2_element_schedule_week' 		=> esc_html__( 'Wednesday', DZ_TH_DOMAIN ),
						'team_detail_2_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					[	
						'team_detail_2_element_schedule_week' 		=> esc_html__( 'Thursday', DZ_TH_DOMAIN ),
						'team_detail_2_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					[	
						'team_detail_2_element_schedule_week' 		=> esc_html__( 'Friday', DZ_TH_DOMAIN ),
						'team_detail_2_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					[	
						'team_detail_2_element_schedule_week' 		=> esc_html__( 'Saturday', DZ_TH_DOMAIN ),
						'team_detail_2_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					
					
				],
			]
		);
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'gift',
			[
				'label' => esc_html__( 'Gift', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'team_detail_2_element_awards',
			[
				'label' 	=> esc_html__( 'Gift Text', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'My Awards', DZ_TH_DOMAIN ),
				
			]
		); 
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'team_detail_2_element_gift_title',
			[
				'label' 		=> esc_html__( 'Gift Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'ClinicMaster 2025', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater->add_control(
			'team_detail_2_element_gift_description',
			[
				'label' 	=> esc_html__( 'Gift Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'team_detail_2_element_gift_img',
			[
				'label' 		=> esc_html__( 'Gift Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$repeater->add_control(
			'team_detail_2_element_gift_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'team_detail_2_element_gift_text_link',
			[
				'label' 		=> esc_html__( 'Text Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'default'   => 'https://clinicmaster.wprdx.com/medical/appointment',
			]
		);
		
		
		$this->add_control(
			'team_detail_2_element_gift',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				 'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				], 
				'default' 		=> [
					[	
						'team_detail_2_element_gift_title' 	=> esc_html__( 'ClinicMaster 2025', DZ_TH_DOMAIN ),
						'team_detail_2_element_gift_description' 	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
						'team_detail_2_element_gift_text' 	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
						'team_detail_2_element_gift_text_link' 	=> 'https://clinicmaster.wprdx.com/medical/appointment',
						
					],	
					[	
						'team_detail_2_element_gift_title' 	=> esc_html__( 'ClinicMaster 2025', DZ_TH_DOMAIN ),
						'team_detail_2_element_gift_description' 	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
						'team_detail_2_element_gift_text' 	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
						'team_detail_2_element_gift_text_link' 	=> 'https://clinicmaster.wprdx.com/medical/appointment',
						
					],	
					
					
				],
			]
		);
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'team_detail_2_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/team_detail_2_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}