<?php
namespace DZElementor\Widgets;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; 

class DZHelpingpeople extends Widget_Base {

    public function get_name() {
        return 'dz-helping-people';
    }

    public function get_title() {
        return esc_html__('Content Tab', 'dz-th-domain');
    }

    public function get_icon() {
        return 'eicon-nerd';
    }

    public function get_categories() {
        return ['clinicmaster'];
    }

    public function get_keywords() {
        return ['tab', 'content', 'helping', 'people'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'general',
            ['label' => esc_html__('General', 'dz-th-domain')]
        );

        $this->add_control(
            'service_tab_element_title',
            [
                'label' => esc_html__('Title', 'dz-th-domain'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('We Are Helping People Who Are', 'dz-th-domain'),
                'placeholder' => esc_html__('Enter your title', 'dz-th-domain'),
                'label_block' => true,
            ]
        );

      
        $repeater = new Repeater();

        $repeater->add_control(
            'tab_title_text',
            [
                'label' => esc_html__('Tab Title', 'dz-th-domain'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter your title', 'dz-th-domain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_icon',
            [
                'label' => esc_html__('Icon', 'dz-th-domain'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_content_heading',
            [
                'label' => esc_html__('Tab Heading', 'dz-th-domain'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Holistic Wellness at the Maternity Health Center', 'dz-th-domain'),
                'placeholder' => esc_html__('Enter your title', 'dz-th-domain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_content_description',
            [
                'label' => esc_html__('Tab Description', 'dz-th-domain'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('It is a long established fact that a reader will be distracted...', 'dz-th-domain'),
                'placeholder' => esc_html__('Enter your description', 'dz-th-domain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'element_feature_description',
            [
                'label' => esc_html__('Feature Listing (Comma Separated)', 'dz-th-domain'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Radiant Skin Dermatology, Laser Resurfacing, Flawless Dermatology', 'dz-th-domain'),
                'rows' => 5,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'dz-th-domain'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Click Here', 'dz-th-domain'),
                'placeholder' => esc_html__('Enter your button text', 'dz-th-domain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__('Button Link', 'dz-th-domain'),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__('Enter your link', 'dz-th-domain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'listing_background_image',
            [
                'label' => esc_html__('Listing Background Image', 'dz-th-domain'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/wp-content/uploads/2025/04/img2.png'
                ],
                'label_block' => true,
            ]
        );

      
        $this->add_control(
            'form_fields',
            [
                'label' => __('Form Fields', 'dz-th-domain'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title_text' => esc_html__('Sample Tab', 'dz-th-domain'),
                        'button_text' => esc_html__('Learn More', 'dz-th-domain'),
                        'button_link' => ['url' => '#'],
                        'listing_background_image' => ['url' => get_template_directory_uri() . '/wp-content/uploads/2025/04/img2.png'],
                    ],
                ],
                'title_field' => '{{{ tab_title_text }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        DZTemplate::show_dz_template('dz-inc/elementor/elements/tab_content_element.php', $settings);
    }

    protected function content_template() {
       
    }
}
