<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZServiceDetail3 extends Widget_Base 
{
	public function get_name() {
		return 'dz-service-detail-3';
	}
	
	public function get_title() {
		return esc_html__('Service Details 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-single-page';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'service_detail_3_element_image',
			[
				'label' => esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' => Controls_Manager::MEDIA,
				
				
			]
		);
		
		$this->add_control(
			'service_detail_3_element_title',
			[
				'label' => esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Cosmetic Dermatology', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->add_control(
			'service_detail_3_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',				
				'default'=> '<p>' . esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry`s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.',DZ_TH_DOMAIN) . '</p><p>' .
				esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry`s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including.',DZ_TH_DOMAIN) . '</p>',
				'rows'		=>  5, 
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
			
			$this->add_control(
			'service_detail_3_element_img_gallery',
			[
				'label' 		=> esc_html__( 'Image Gallery', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
				
			]
		);
		
		$this->end_controls_section();
		
		
	
		
		$this->start_controls_section(
			'sidebar',
			[
				'label' => esc_html__( 'Sidebar Section', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'service_detail_3_element_selected_sidebar',
			[
				'label' 	 => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebars(),	
			]
		);
		
		$this->add_control(
			'service_detail_3_element_sidebar_layout',
			[
				'label' 	 => esc_html__( 'Sidebar Selection', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebar_layout_options_list(),				
				'default'	 =>  'left',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/service_detail_3_element.php',$settings);
	
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleCompareSwiper();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}