<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPricingTable6 extends Widget_Base 
{
	public function get_name() {
		return 'dz-pricign-table-6';
	}
	
	public function get_title() {
		return esc_html__('Pricing Table 6',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-price-table';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_6_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Flexible Pricing Plans', DZ_TH_DOMAIN ),
			]
		);
		
    
		
		$this->add_control(
			'pricing_table_6_element_description',
			[
				'label' 	=> esc_html__( 'Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_6_element_plan',
			[
				'label' 		=> esc_html__( 'Plan Duration', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Per Monthly',
			]
		);
		$this->add_control(
			'pricing_table_6_element_button',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'View All Service',
			]
		);
		$this->add_control(
			'pricing_table_6_element_button_url',
			[
				'label' 		=> esc_html__( 'Button Url', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 		=> [],
			]
		);



		
		
		$this->end_controls_section();
		
		
			$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater = new \Elementor\Repeater();

		
		
		
		$repeater->add_control(
			'pricing_table_6_element_plan_price',
			[
				'label' 		=> esc_html__( 'Plan Price  ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '$49', DZ_TH_DOMAIN ),
				
			]
		);

		$repeater->add_control(
			'pricing_table_6_element_plan_title',
			[
				'label' 		=> esc_html__( 'Plan Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Post Pregnancy', DZ_TH_DOMAIN ),
				
			]
		);
		
		$repeater->add_control(
			'pricing_table_6_element_plan_description',
			[
				'label' 		=> esc_html__( 'Plan Description ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'For most businesses that want to otpimize web queries ', DZ_TH_DOMAIN ),
			]
		);
	
	    $repeater->add_control(
			'pricing_table_6_element_poinlist_title',
			[
				'label' 		=> esc_html__( 'Plan Point List Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'What You’ll Get', DZ_TH_DOMAIN ),
			]
		);

		$repeater->add_control(
			'pricing_table_6_element_point_list',
			[
				'label' => esc_html__( 'Plan point list', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' 	=> true,
				'placeholder' => esc_html__( 'Type your content here', DZ_TH_DOMAIN ),
				'default' 		=> '<li>'.esc_html__( 'Dental cleanings', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental examinations', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'X-rays', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Fluoride treatments', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental sealants', DZ_TH_DOMAIN ).'</li>',
			]
		);
		$repeater->add_control(
			'pricing_table_6_element_plan_button_text',
			[
				'label' 		=> esc_html__( 'Plan Button text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Purchase Now', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'pricing_table_6_element_plan_button_link',
			[
				'label' 		=> esc_html__( 'Plan Button link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				 'default' 	=> [],
		
			]
		);
		$this->add_control(
			'pricing_table_6_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),			
				'default' 		=> [
					[
						
						'pricing_table_6_element_plan_price' => '39',
						'pricing_table_6_element_plan_title' => esc_html__( 'Basic Checkup', DZ_TH_DOMAIN ),
						'pricing_table_6_element_plan_description' => esc_html__( 'It is a long established fact that a reader will be distracted ', DZ_TH_DOMAIN ),
						'pricing_table_6_element_poinlist_title	' => '<span>'.esc_html__( 'What You’ll Get', DZ_TH_DOMAIN ).'</span><li>',
						'pricing_table_6_element_point_list' => '<li>'.esc_html__( 'Consultations', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '24x7 Support', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '1 month checkup free', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Free Medicines', DZ_TH_DOMAIN ).'</li>',
						'pricing_table_6_element_item_button_text' =>esc_html__( 'Purchase Now', DZ_TH_DOMAIN ),
						'pricing_table_6_element_plan_button_link' => 'http://nitesh-pc/products/clinicmaster/fatloss/pricing-table/',
					],
					
					[
			
						'pricing_table_6_element_plan_price' => '99',
						'pricing_table_6_element_item_title' => esc_html__( 'Super Checkup', DZ_TH_DOMAIN ),
						'pricing_table_6_element_plan_description' => esc_html__( 'It is a long established fact that  a reader will be distracted.', DZ_TH_DOMAIN ),
						'pricing_table_6_element_poinlist_title	' => '<span>'.esc_html__( 'What You’ll Get', DZ_TH_DOMAIN ).'</span><li>',  
						'pricing_table_6_element_point_list' => '<li>'.esc_html__( 'Consultations', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '24x7 Support', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '1 month checkup free', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Free Medicines', DZ_TH_DOMAIN ).'</li>',
					    'pricing_table_6_element_item_button_text' =>esc_html__( 'Purchase Now', DZ_TH_DOMAIN ),
						'pricing_table_6_element_plan_button_link' => 'http://nitesh-pc/products/clinicmaster/fatloss/pricing-table/',
					],
					
					
				],
			]
		);
		$this->end_controls_section();

	
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_6_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/pricing_table_6_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}