<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPricingTable1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-pricign-table-1';
	}
	
	public function get_title() {
		return esc_html__('Pricing Table 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( '', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
			'pricing_table_1_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		
		$this->add_control(
			'pricing_table_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> '',
			]
		);
		
		
		$this->add_control(
			'pricing_table_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> '',
			]
		);
		
		
		
		$this->add_control(
			'pricing_table_1_element_title2',
			[
				'label' 		=> esc_html__( 'Title 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Service Plan', DZ_TH_DOMAIN ).'<span class="badge">'.esc_html__( '20% Off', DZ_TH_DOMAIN ).'</span>',
			]
		);
		
		
		$this->add_control(
			'pricing_table_1_element_description2',
			[
				'label' 	=> esc_html__( 'Enter Description 2 .', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose your workspace plan according to your organisational plan', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_1_element_feature_list',
			[
				'label' 	=> esc_html__( 'Feature list ( Comma Separated )', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'separator'	=>  'default',
				'rows'		=>  5,
				'default' 		=> esc_html__( 'Cardiovascular Services,Weight Management, Dental Services, Women`s Health, Emergency Medicine, Family Medicine, 24/7 customer support, Video Call Support', DZ_TH_DOMAIN ),
			]
		);
		
		 
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'pricing_table_1_element_item_plan',
			[
				'label' 		=> esc_html__( 'Select Plan', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options'	=> array(
						'free' => esc_html__( 'Free',DZ_TH_DOMAIN ),
						'paid' => esc_html__( 'Paid',DZ_TH_DOMAIN ),
					),
				'default' 		=> 'free',
			]
		);
		$repeater->add_control(
			'pricing_table_1_element_item_price',
			[
				'label' 		=> esc_html__( 'Price', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '$49', DZ_TH_DOMAIN ),
				'condition'		=>[
					'pricing_table_1_element_item_plan' =>	'paid',	
				],
			]
		);
		$repeater->add_control(
			'pricing_table_1_element_item_unit',
			[
				'label' 		=> esc_html__( 'Unit', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options'	=> array(
						'lifetime' => esc_html__( 'Lifetime',DZ_TH_DOMAIN ),
						'month' => esc_html__( 'Month',DZ_TH_DOMAIN ),
						'year' => esc_html__( 'Year',DZ_TH_DOMAIN ),
					),
				'default' 		=> 'lifetime',
			]
		);
		$repeater->add_control(
			'pricing_table_1_element_item_free_plan',
			[
				'label' 		=> esc_html__( 'Free Plan', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your  text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Free', DZ_TH_DOMAIN ),
				'condition'		=>[
					'pricing_table_1_element_item_plan' =>	'free',	
				],
			]
		);
		$repeater->add_control(
			'pricing_table_1_element_item_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose This Plan', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'pricing_table_1_element_item_content',
			[
				'label' => esc_html__( 'Content', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' 	=> true,
				'placeholder' => esc_html__( 'Type your content here', DZ_TH_DOMAIN ),
				'default' 		=> '<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>',
			]
		);
		
		
		$this->add_control(
			'pricing_table_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				
				'default' 		=> [
					[
						'pricing_table_1_element_item_plan' => 'free',
						'pricing_table_1_element_item_price' => '',
						'pricing_table_1_element_item_unit' => 'lifetime',
						'pricing_table_1_element_item_free_plan' => esc_html__( 'Free', DZ_TH_DOMAIN ),
						'pricing_table_1_element_item_text' => esc_html__( 'Choose This Plan', DZ_TH_DOMAIN ),
						'pricing_table_1_element_item_content' => '<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>',
					],
					
					[
						'pricing_table_1_element_item_plan' => 'paid',
						'pricing_table_1_element_item_price' => '$25',
						'pricing_table_1_element_item_unit' => 'month',
						'pricing_table_1_element_item_free_plan' => '',
						'pricing_table_1_element_item_text' => esc_html__( 'Choose This Plan', DZ_TH_DOMAIN ),
						'pricing_table_1_element_item_content' => '<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li class="disable"><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>',
					],
					[
						'pricing_table_1_element_item_plan' => 'paid',
						'pricing_table_1_element_item_price' => '$40',
						'pricing_table_1_element_item_unit' => 'month',
						'pricing_table_1_element_item_free_plan' => '',
						'pricing_table_1_element_item_text' => esc_html__( 'Choose This Plan', DZ_TH_DOMAIN ),
						'pricing_table_1_element_item_content' => '<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg" alt=""></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>
									<li><img src="'.get_template_directory_uri().'/assets/images/check.svg"></li>',
					],
				],
			]
		);
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/pricing_table_1_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handlePricingTabs();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}