<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPostListing1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-post-listing-1';
	}
	
	public function get_title() {
		return esc_html__('Post Listing 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_1_element_style',
			[
				'label' 	 => esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Style', DZ_TH_DOMAIN),
								'style_1' => esc_html__('Style 1',DZ_TH_DOMAIN),
								'style_2' => esc_html__('Style 2',DZ_TH_DOMAIN),
								'style_3' => esc_html__('Style 3',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'style_1',
				
			]
		);
		
		
		$this->add_control(
			'post_listing_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Our Services', DZ_TH_DOMAIN ),
				'condition' => [
					'post_listing_1_element_style' => 'style_3',
				],
			
			]
		);

		$this->add_control(
			'post_listing_1_subicon',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'post_listing_1_element_style' => 'style_3',
				],
			]
		);

		
		
		$this->add_control(
			'post_listing_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'News And Update', DZ_TH_DOMAIN ),
				'condition' => [
					'post_listing_1_element_style' => 'style_3',
				],
			]
		);
		$this->add_control(
			'post_listing_1_element_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'post_listing_1_element_style' => 'style_3',
				],
			]
		);
		
		      
		$this->add_control(
			'post_listing_1_change_button_to_link',
			[
				'label' 		=> esc_html__( 'Change Button To Link (ON/OFF)', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				
				
			]
		);
        
		$this->add_control(
			'post_listing_1_element_background_color',
			[
				'label' 		=> esc_html__( 'Background Color', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'background', DZ_TH_DOMAIN ),
				
			]
		);



		$this->add_control(
			'post_listing_1_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'View All', DZ_TH_DOMAIN ),
				'condition' => [
					'post_listing_1_element_style' => 'style_3',
				],
			]
		);
		$this->add_control(
			'post_listing_1_element_button_link',
			[
				'label' 		=> esc_html__( 'Button link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
		
				'condition' => [
					'post_listing_1_element_style' => 'style_3',
				],
			]
		);
		
		$this->add_control(
			'post_listing_1_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_1_element_only_featured_posts',
			[
				'label' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_1_element_pagination_style',
			[
				'label' 	 => esc_html__( 'Pagination Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_pagination_options_list(),				
				'default'	 =>  'no',
			]
		);		
		
		$this->add_control(
			'post_listing_1_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=>  7,
				'min'           => 0,
				'title'			=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_1_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'	 	=>  8,
				'min'           => 0,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_1_element_cols',
			[
				'label' 		=> esc_html__( 'Select Column', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_column_options_list(),				
				'default'		=>  'col_2',
			]
		);
		$this->add_control(
			'post_listing_1_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),				
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'post_listing_1_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'sidebar',
			[
				'label' => esc_html__( 'Sidebar Section', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_1_element_selected_sidebar',
			[
				'label' 	 => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebars(),	
				'default'	 =>  '0',
			]
		);
		
		$this->add_control(
			'post_listing_1_element_sidebar_layout',
			[
				'label' 	 => esc_html__( 'Sidebar Selection', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebar_layout_options_list(),				
				'default'	 =>  'left',
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'post_listing_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		$this->add_control(
			'post_listing_1_element_show_date',
			[
				'label' 		=> esc_html__( 'Show Date', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default'	 =>  'yes',
			]
		);
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/post_listing_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}