<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner6 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-6';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 6',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
		}
	
	public function get_categories() {
		return [ 'clinicmaster-banner' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_6_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Fuel Your Body, Nourish Your Life', DZ_TH_DOMAIN ),
			]
		);
 
        $this->add_control(
			'home_banner_6_element_subtitle',
			[
				'label' 		=> esc_html__( 'SubTitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'	 => esc_html__( 'Best Nutrition', DZ_TH_DOMAIN ),

			]
		);
		
		$this->add_control(
			'home_banner_6_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_6_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'home_banner_6_element_img',
			[
				'label' 		=> esc_html__( 'Banner Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'home_banner_6_element_social',
			[
				'label' => esc_html__( 'Show Social Links', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'home_banner_6_element_fun_fact',
			[
				'label' 		=> esc_html__( 'Corner Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'LET’S TALK', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_6_element_fun_fact_url',
			[
				'label' 		=> esc_html__( 'Corner Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'Enter your text url', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'corner_button_show',
			[
				'label' => esc_html__( 'corner button show', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'home_banner_6_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'About Us', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_6_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				
			]
		);
		
		
		$this->end_controls_section();
		

		$this->start_controls_section(
			'Fruits icons images',
			[
				'label' => esc_html__( 'Fruits icons', DZ_TH_DOMAIN ),
			]
		);
	
   
   
		$this->add_control(
			'home_banner_6_element_icon_1',
			[
				'label' 		=> esc_html__( 'Banner Image icon1', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);
   
		$this->add_control(
			'home_banner_6_element_icon_2',
			[
				'label' 		=> esc_html__( 'Banner Image icon2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);
		$this->add_control(
			'home_banner_6_element_icon_3',
			[
				'label' 		=> esc_html__( 'Banner Image icon3', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);


    	$this->end_controls_section();		





	
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_6_element.php',$settings);
				
		
	}
	
	protected function content_template() 
	{

    }
}