<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHealthytips extends Widget_Base 
{
	public function get_name() {
		return 'dz-healthytips';
	}
	
	public function get_title() {
		return esc_html__('Healthy tips',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-sidebar';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		
		$this->add_control(
			'healthy_tips_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'	 => esc_html__( 'MoreCollectionExplore Beyond Skin Deep Personalized Care for Your Unique Beauty Journey description At MediZone', DZ_TH_DOMAIN ),
				
			]
		);
		
		
		$this->add_control(
			'healthy_tips_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'	 => esc_html__( 'We believe healthy, radiant skin is achievable for everyone. We combine advanced dermatology with innovative cosmetic solutions to address your unique skin concerns. Our team of board-certified dermatologists and experienced aestheticians create personalized treatment plans to achieve your desired results, whether it`s treating acne, restoring sun damage, or enhancing your natural beauty. Explore our website to learn more about our services and discover the confidence that comes with feeling your best in your own skin.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'healthy_tips_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'user_profile_element_feature_title',
			[
				'label' 		=> esc_html__( 'Feature Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'About Skills', DZ_TH_DOMAIN ),
				
		
				]

		);
		
		
		$this->add_control(
			'user_profile_element_feature_description',
			[
				'label' 	=> esc_html__( 'Feature Listing. ( Comma Seperated)', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'separator'	=>  'default',
				'rows'		=>  5,
				'default'   	=> esc_html__( 'Radiant Skin Dermatology, Laser Resurfacing, Flawless Dermatology, Refined Skin Dermatology, Luminous Dermatology, Anti Aging', DZ_TH_DOMAIN ),
		         
		
				]
		);
	
		
		
		$this->end_controls_section();
 
		

		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'healthy_tips_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/healthy_tips_element.php',$settings);
	
		
	}
	
	protected function content_template() 
	{

    }
}