<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZFaqListing2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-faq-listing-2';
	}
	
	public function get_title() {
		return esc_html__('Faq Listing 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'faq_listing_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Have any questions?', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->add_control(
			'faq_listing_2_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',				
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'faq_listing_2_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'faq_category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'faq_listing_2_element_search',
			[
				'label' 		=> esc_html__( 'Search ', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 	=> 'yes',
			]
		);
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'faq_listing_2_element_text_limit',
			[
				'label' 		=> esc_html__( 'Description Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'min'           => 0,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=>  7,
				'title'			=> esc_html__( 'Description Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Description Text Limit', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'faq_listing_2_element_title_text_limit',
			[
				'label' 		=> esc_html__( 'Title Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=>  8,  
				'min'           => 0,
				'title'			=> esc_html__( 'Title Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Title Text Limit', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'faq_listing_2_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'	 	=>  6,
				'min'           => 0,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'faq_listing_2_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),				
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'faq_listing_2_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);
		
		
		$this->end_controls_section();

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/faq_listing_2_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}