<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox3 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-3';
	}
	
	public function get_title() {
		return esc_html__('Content Box 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_3_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
					'style_3' => esc_html__( 'Style 3', DZ_TH_DOMAIN ),
					'style_4' => esc_html__( 'Style 4', DZ_TH_DOMAIN ),
					'style_5' => esc_html__( 'Style 5', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		
		$this->add_control(
			'content_box_3_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( '', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => array('style_2','style_1'),
				],
			]
		);
		$this->add_control(
			'content_box_3_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'content_box_3_element_style' => array('style_2','style_1'),
				],
			]
		);
		
		$this->add_control(
			'content_box_3_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'My First Visit', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_3_element_decoter_name',
			[
				'label' 		=> esc_html__( 'Doctor Name', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your name', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dr. Nashid Martines', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => array('style_5'),
				],
			]
		);
		
		$this->add_control(
			'content_box_3_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'We warmly welcome new patients of all ages to our practice. During your first visit, you will have the chance to meet our dedicated team and get acquainted with Dr. Nambisan. We are committed to educating you about your dental needs and addressing any questions or concerns you may have about your treatment.', DZ_TH_DOMAIN ).'<br>'.esc_html__( 'Our goal is to provide you with the highest standard of dental care available today. Thank you for choosing our dental office. We look forward to meeting you and helping you achieve optimal oral health.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_3_element_img',
			[
				'label' 		=> esc_html__( 'Image ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'content_box_3_element_style' => array('style_2','style_1','style_4','style_5'),
				],
			]
		);
		$this->add_control(
			'content_box_3_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'content_box_3_element_style' => 'style_3',
				],
			]
		);
		$this->add_control(
			'content_box_3_element_signechar_img',
			[
				'label' 		=> esc_html__( 'Upload Signechar Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'content_box_3_element_style' => array('style_4','style_5'),
				],
			]
		);
		$this->add_control(
			'content_box_3_element_signechar_text',
			[
				'label' 		=> esc_html__( 'Signechar Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dr. Nashid Martines', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => array('style_4','style_5'),
				],
			]
		);
		$this->add_control(
			'content_box_3_element_feature_text',
			[
				'label' 		=> esc_html__( 'Feature Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Our Services Include:', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => 'style_2',
				],
			]
		);
		$this->add_control(
			'content_box_3_element_feature_list',
			[
				'label' 	=> esc_html__( 'Feature List (Comma Seperated).', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Feature List. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Feature List Here', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => 'style_2',
				],
				'default'   => esc_html__( 'Comprehensive Specialties, Research and Development, Emergency Services, Advanced Imaging Services, Intensive Care Units (ICUs), Rehabilitation Services, Telemedicine Facilities, Patient-Centric Approach, Multidisciplinary Team, Health Information Technology', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_3_element_description2',
			[
				'label' 	=> esc_html__( 'Enter Description 2.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => 'style_2',
				],
				'default'   => esc_html__( 'We warmly welcome new patients of all ages to our practice. During your first visit, you will have the chance to meet our dedicated team and get acquainted with Dr. Nambisan. We are committed to educating you about your dental needs and addressing any questions or concerns you may have about your treatment.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_3_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Appointment', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => array('style_3','style_4','style_5'),
				],
			]
		);
		$this->add_control(
			'content_box_3_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_3_element_style' => array('style_3','style_4','style_5'),
				],
			]
		);
		
		
		$this->end_controls_section();
		
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_3_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-2',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_3_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}