<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContactForm4 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-form-4';
	}
	
	public function get_title() {
		return esc_html__('Contact Form 4',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
	}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
	
		$this->add_control(
		'contact_form_4_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
			]
		);



        

		$this->add_control(
			'contact_form_4_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'contact_form_4_element_item_img',
			[
				'label'       => esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type'        => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'contact_form_4_element_item_title',
			[
				'label'       => esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'     => esc_html__( 'We Care About Your Dental Health', DZ_TH_DOMAIN ),
			]
		);

		$repeater->add_control(
			'contact_form_4_element_item_description',
			[
				'label'       => esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'  => true,
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'separator'   => 'default',
				'rows'        => 5,
				'description' => esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'     => wp_kses_post( '247/Plot No. 39, 15th Phase, Colony, Kukatpally, Hyderabad' ),
			]
		);

		$this->add_control(
			'contact_form_4_element_item',
			[
				'label'   => esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
						'contact_form_4_element_item_title'       => 'Address',
						'contact_form_4_element_item_description' => wp_kses_post( '1247/Plot No. 39, 15th Phase, Colony, <br> Kukatpally, Hyderabad' ),
					],
					[
						'contact_form_4_element_item_title'       => 'Call Us',
						'contact_form_4_element_item_description' => wp_kses_post( '+1 123 456 7890 <br> +0 987-654-3210' ),
					],
					[
						'contact_form_4_element_item_title'       => 'Send a mail',
						'contact_form_4_element_item_description' => wp_kses_post( 'info@example.com <br> ClinicMaster@example.com' ),
					],
					[
						'contact_form_4_element_item_title'       => 'Opening Time',
						'contact_form_4_element_item_description' => wp_kses_post( 'Mon-Thu: 8:00am-5:00pm <br> Fri: 8:00am-1:00pm' ),
					],
				],
			]
		);

		$this->end_controls_section();

		


		
		
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_form_4_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>