<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContactForm1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-form-1';
	}
	
	public function get_title() {
		return esc_html__('Contact Form 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
	}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'content_form_1_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		
		$this->add_control(
			'contact_form_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( '', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
			'contact_form_1_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'contact_form_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Connect with Us for ', DZ_TH_DOMAIN ) .'<br>' .esc_html__( 'Your Healthcare Needs', DZ_TH_DOMAIN ),
			]
		);		
		
		$this->add_control(
			'contact_form_1_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Reach out for support, feedback, or to schedule an appointment. Fill out the form, and we`ll promptly assist you and confirm your visit with our healthcare professionals.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_form_1_element_form_text',
			[
				'label' 		=> esc_html__( 'Form Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Make An ', DZ_TH_DOMAIN ).'<span>'.esc_html__( 'Appointment ', DZ_TH_DOMAIN ).'</span> <br>'.esc_html__( 'Apply For Treatments ', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_form_1_element_form_description',
			[
				'label' 		=> esc_html__( 'Enter Form Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'You can react us anytime', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_form_1_element_contact_us',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
				
			]
		);
		
	
		$this->add_control(
		'contact_form_1_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
			]
		);

		$this->add_control(
			'contact_form_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'gallery',
			[
				'label' => esc_html__( 'Gallery', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_form_1_element_gallery_img',
			[
				'label' 		=> esc_html__( 'Gallery Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
			]
		);
		
		$this->add_control(
			'contact_form_1_element_gallery_text',
			[
				'label' 		=> esc_html__( 'Gallery Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'	 => esc_html__( 'Talk to over 215 doctor', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_form_1_element_link',
			[
				'label' 		=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'rating',
			[
				'label' => esc_html__( 'Rating', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_form_1_element_rating',
			[
				'label' 		=> esc_html__( 'Rating', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your rating', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '4.8', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_form_1_element_rating_text',
			[
				'label' 		=> esc_html__( 'Rating Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '12k+ ratings on google', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_form_1_element_star_rating',
			[
				'label' => esc_html__( 'Star Rating', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'default' => 5,
			]
		);
		
		$this->end_controls_section(); 
		
		
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_form_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>