<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZBmicalculator extends Widget_Base 
{
	public function get_name() {
		return 'BMI_calculator';
	}
	
	public function get_title() {
		return esc_html__('BMI calculator',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-calendar';
		}
	
	public function get_categories() {
		return [ 'clinicmaster-banner' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'BMI_calculator_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Calculate Body Mass Index', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'BMI_calculator_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'BMI_calculator_button_text',
			[
				'label' 		=> esc_html__( 'Calculator Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Calculate', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'BMI_calculator_youtube_link',
			[
				'label' 		=> esc_html__( 'YouTube Link url', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
				'default'   => 'https://www.youtube.com/watch?v=o8OgzQdA70c',
			]
		);
		
		$this->end_controls_section();
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/BMI_calculator_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}