<?php
/*
Template Name: ClinicMaster - Consulting, Corporate Business Template

Variable
	$apiKey : Mail Champ Api
	$listID : List Id of mail champ
	$email : Subscription Email
	$fname, $lname, $phone, $subject : You can use these variables when you would add these in your mail champ list form.	
*/
if( !function_exists( "dz_mailchimp" ) ){
function dz_mailchimp() {
	
	$dzRes = array();
	$email =   "";
	$msg = "";
	$ISValidated = false;
	/******************************************************************************************************
	START ->  Mailchimp Setting > dz_mailchimp_api_key, dz_mailchimp_list_id
	******************************************************************************************************/
	$apiKey = ""; /*<!-- Put Your Mail Champ API Key -->*/
	$listID = "";/*<!-- Put Your Mail Champ List ID -->*/
	$a = dexignzone_get_opt('mailchimp');
	
	$apiKey = dexignzone_get_opt('mailchimp_api_key');
	$listID = dexignzone_get_opt('mailchimp_list_id');
	
	$ISValidated = false;	
	$msg = __('There is something worng in mailchimp settings', 'dzcore' );
	
	if(dexignzone_get_opt('mailchimp')){
			$apiKey = isset($apiKey) ? $apiKey : "" ; 
			$listID = isset($listID) ? $listID : "" ; 
			
			//$apiKey = '273484578e7414b10b2ef39f18ff49ee-us16';
			//$listID = 'c905f0cf1b';	
			
			if(isset($_POST)){
				
				$email	= isset( $_POST['dzEmail'] ) ? $_POST['dzEmail'] : "";
				
				$name 	= isset( $_POST['dzName'] ) ? $_POST['dzName'] : "";
				$fname = $lname = '';
				if(!empty($name))
				{
					$name_arr = explode(' ',$name);
					$fname = !empty($name_arr[0])?$name_arr[0]:'';
					$lname = !empty($name_arr[1])?$name_arr[1]:'';
				}
				$ISValidated = true;
				if(  $apiKey == "" ){
					$ISValidated = false;	
					$msg = __('Please enter Mailchimp API Key.', 'dzcore' );
				}
				if(  $listID == ""){
					$ISValidated = false;	
					$msg = __('Please enter Mailchimp list ID.', 'dzcore' );
				}
				if(  $email == ""){
					$ISValidated = false;	
					$msg = __('Please enter email.', 'dzcore' );
				}else{
					if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
						 $ISValidated= false;
						 $msg = __('Please enter valid email.', 'dzcore' );
					} 
				}
			   if( $ISValidated   ){
					$SuccessStatus = false;
					$email = trim(strip_tags($email));
					// MailChimp API credentials
					
					// MailChimp API URL
					$memberID = md5(strtolower($email));
					$dataCenter = substr($apiKey,strpos($apiKey,'-')+1);
					$url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listID . '/members/' . $memberID;
					
					// member information
					//$main_field = array('email_address' => $email,'status' => 'subscribed');
					$json = json_encode([
						'email_address' => $email,'status' => 'subscribed',
						 'merge_fields'  => [
							'FNAME'       => $fname,
							'LNAME'       => $lname,
							//'PHONE'     => $phone,
							//'SUBJECT'   => $subject,
						] 
					]);
					
					// send a HTTP POST request with curl
					$ch = curl_init($url);
					curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
					curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLOPT_TIMEOUT, 10);
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
					$result = curl_exec($ch);
					$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
					curl_close($ch);
					
					// store the status message based on response code
					if ($httpCode == 200) {
						$msg =  __('You have successfully subscribed.', 'dzcore' );
						$SuccessStatus = true;
					} else {
						switch ($httpCode) {
							case 214:
								$msg = __('You are already subscribed.', 'dzcore' );
								break;
							default:
								$msg =  __('Problem while processing '.$httpCode, 'dzcore' );
								break;
						}
					}
			}else{
				$msg =  __('Method Not allowed.', 'dzcore' );
			}
		}else{
			/********************SEND EMAIL HERE ****************/
			$msg =  __('Please enable mailchimp setting.', 'dzcore' );
		}
	}
	
	if( $ISValidated ){
		if( $SuccessStatus ){
		  echo '<div class="gen alert dz-alert alert-success ">'.$msg."</div>";
		}else{
		  echo '<div class="gen alert dz-alert alert-danger ">'.$msg."</div>";
		}
	}else{
		echo '<div class="gen alert dz-alert alert-danger ">'.$msg."</div>";
	}
	exit;

    wp_die(); // this is required to terminate immediately and return a proper response
}
add_action( 'wp_ajax_dz_mailchimp', 'dz_mailchimp' );
add_action( 'wp_ajax_nopriv_dz_mailchimp', 'dz_mailchimp' );
}