<?php

if ( ! class_exists( 'Dexignzone_DZ_Faq_Category_icon' ) ) {

class Dexignzone_DZ_Faq_Category_icon{
	

  public function __construct() {
    //
  }
 
	 /*
	  * Initialize the class and start calling our hooks and filters
	  * @since 1.0.0
	 */
	 public function init() {
		add_action( 'faq_category_add_form_fields', array ( $this, 'dz_add_faq_category_icon' ), 10, 2 ); // Field
		add_action( 'created_faq_category', array ( $this, 'dz_save_faq_category_icon' ), 10, 2 ); // save
		add_action( 'faq_category_edit_form_fields', array ( $this, 'dz_update_faq_category_icon' ), 10, 2 );  // Update inside 
		add_action( 'edited_faq_category', array ( $this, 'dz_updated_faq_category_icon' ), 10, 2 );  // Update Outside
		add_action( 'admin_enqueue_scripts', array( $this, 'dz_load_media' ) );
		
		// save our taxonomy image while edit or create term
		add_action( 'admin_footer', array ( $this, 'dz_add_script' ) );
	 }

	public function dz_load_media() {
		if( ! isset( $_GET['taxonomy'] ) || $_GET['taxonomy'] != 'faq_category' ) {
		   return;
		}
		//wp_enqueue_media();
	}
	 
	 /*
	  * Add a form field in the new category page
	  * @since 1.0.0
	 */
	 
	 public function dz_add_faq_category_icon($taxonomy){ 
	
	 ?>
		<div class="form-field term-group">
			
			<p>
			   <input type="button" class="button button-secondary dz_media_button" id="dz_media_button" name="dz_media_button" value="<?php _e( 'Add Image', DZ_TH_DOMAIN ); ?>" />
			   <input type="button" class="button button-secondary dz_media_remove" id="dz_media_remove" name="dz_media_remove" value="<?php _e( 'Remove Image', DZ_TH_DOMAIN ); ?>" />
			</p>
			
		</div>
		
		<div class="form-field term-group-wrap">
			<label for="faq-category-icon"><?php _e( 'Icon Type', DZ_TH_DOMAIN ); ?></label>
			<p>
			   <input type="radio" id="faq-category-icon-type" name="faq-category-icon-type" value="image" checked> Image
			   <input type="radio" id="faq-category-icon-type" name="faq-category-icon-type" value="icon"> Icon
			</p>
			<p>
				<label for="faq-category-icon"><?php _e( 'Icon', DZ_TH_DOMAIN ); ?></label>
				<input type="text" id="faq-category-icon" name="faq-category-icon" placeholder="fa fa-user" value="fa fa-user">
			</p>
		</div>
		
		
		
	<?php	 
	 }
	 /*
	  * Save the form field
	  * @since 1.0.0
	 */
	 public function dz_save_faq_category_icon( $term_id, $tt_id ) {
	    if( isset( $_POST['faq-category-icon-type'] ) && '' !== $_POST['faq-category-icon-type'] ){
			$icon_type = $_POST['faq-category-icon-type'];
			add_term_meta( $term_id, 'faq-category-icon-type', $icon_type, true );
		}
	   
	    if( isset( $_POST['faq-category-image-id'] ) && '' !== $_POST['faq-category-image-id'] ){
			$image = $_POST['faq-category-image-id'];
			add_term_meta( $term_id, 'faq-category-image', $image, true );
	    }
	   
		if( isset( $_POST['faq-category-icon'] ) && '' !== $_POST['faq-category-icon'] ){
			$icon = $_POST['faq-category-icon'];
			add_term_meta( $term_id, 'faq-category-icon', $icon, true );
		}
	 }
	 
	 /*
	  * Edit the form field
	  * @since 1.0.0
	 */
	 public function dz_update_faq_category_icon( $term, $taxonomy ) { ?>
	    <tr class="form-field term-group-wrap">
			<th scope="row">
			  <label for="faq-category-icon"><?php _e( 'Icon', DZ_TH_DOMAIN ); ?></label>
			</th>
			
			<td>
			   <?php $icon_type = get_term_meta ( $term->term_id, 'faq-category-icon-type', true );  ?>
			   <input type="radio" id="faq-category-icon-type" name="faq-category-icon-type" value="image" <?php echo ($icon_type == 'image')?'checked':'' ?>> Image
			   <input type="radio" id="faq-category-icon-type" name="faq-category-icon-type" value="icon" <?php echo ($icon_type == 'icon')?'checked':'' ?>> Icon
			</td>
			
		</tr>
	   
		<tr class="form-field term-group-wrap">
			<td></td>
			
			<td>
			   <!--
			   <label for="faq-category-image"><?php //_e( 'Image', DZ_TH_DOMAIN ); ?></label>
			   <?php //$image = get_term_meta ( $term->term_id, 'faq-category-image', true );  ?>
			   <input type="file" id="faq-category-image" name="faq-category-image" value="<?php echo esc_attr($image); ?>">
			   -->
			   <?php $image_id = get_term_meta ( $term -> term_id, 'faq-category-image-id', true ); ?>
			   <div class="form-field term-group">
				<label for="faq-category-image-id"><?php _e('Image', DZ_TH_DOMAIN); ?></label>
				<input type="hidden" id="faq-category-image-id" name="faq-category-image-id" class="custom_media_url" value="">
				<div id="category-image-wrapper">
					 <?php if ( $image_id ) { ?>
					   <?php echo wp_get_attachment_image ( $image_id, 'thumbnail' ); ?>
					 <?php } ?>
				</div>
				 <p>
				   <input type="button" class="button button-secondary dz_media_button" id="dz_media_button" name="dz_media_button" value="<?php _e( 'Add Image', DZ_TH_DOMAIN ); ?>" />
				   <input type="button" class="button button-secondary dz_media_remove" id="dz_media_remove" name="dz_media_remove" value="<?php _e( 'Remove Image', DZ_TH_DOMAIN ); ?>" />
				</p>
			   </div>
			   
			   
			   
			</td>
			<td>
			  <label for="faq-category-icon"><?php _e( 'Icon', DZ_TH_DOMAIN ); ?></label>
			  <?php $icon = get_term_meta ( $term->term_id, 'faq-category-icon', true );  ?>
			  <input type="text" id="faq-category-icon" name="faq-category-icon" placeholder="fa fa-user" value="<?php echo esc_attr($icon); ?>">
			</td>
		</tr>
	 <?php
	 }

	/*
	 * Update the form field value
	 * @since 1.0.0
	 */
	public function dz_updated_faq_category_icon($term_id, $tt_id ) {
	   
	    if( isset( $_POST['faq-category-icon-type'] ) && '' !== $_POST['faq-category-icon-type'] ){
			$icon = $_POST['faq-category-icon-type'];
			 
			update_term_meta ( $term_id, 'faq-category-icon-type', $icon );
		} else {
			update_term_meta ( $term_id, 'faq-category-icon-type', '' );
		}
		
		if( isset( $_POST['faq-category-image-id'] ) && '' !== $_POST['faq-category-image-id'] ){
			$icon = $_POST['faq-category-image-id'];
			 
			update_term_meta ( $term_id, 'faq-category-image-id', $icon );
		} else {
			update_term_meta ( $term_id, 'faq-category-image-id', '' );
		}
	   
		if( isset( $_POST['faq-category-icon'] ) && '' !== $_POST['faq-category-icon'] ){
			$icon = $_POST['faq-category-icon'];
			 
			update_term_meta ( $term_id, 'faq-category-icon', $icon );
		} else {
			update_term_meta ( $term_id, 'faq-category-icon', '' );
		}
	}
	
	/*
		 * Add script
		 * @since 1.0.0
		 */
	public function dz_add_script() { ?>
	   <script>
			jQuery(document).ready( function($) {
				function dz_media_upload(button_class) {
					var _custom_media = true,
					_orig_send_attachment = wp.media.editor.send.attachment;
					$('body').on('click', button_class, function(e) {
						var button_id = '#'+$(this).attr('id');
						var send_attachment_bkp = wp.media.editor.send.attachment;
						var button = $(button_id);
						_custom_media = true;
						wp.media.editor.send.attachment = function(props, attachment){
							if ( _custom_media ) {
							   $('#faq-category-image-id').val(attachment.id);
							   $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
							   $('#category-image-wrapper .custom_media_image').attr('src',attachment.url).css('display','block');
							} else {
							   return _orig_send_attachment.apply( button_id, [props, attachment] );
							}
						}
						wp.media.editor.open(button);
						return false;
					});
				}
				dz_media_upload('.dz_media_button.button'); 
				$('body').on('click','.dz_media_remove',function(){
				   $('#faq-category-image-id').val('');
				   $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
				});
		 
				$(document).ajaxComplete(function(event, xhr, settings) {
					var queryStringArr = settings.data.split('&');
					if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
						var xml = xhr.responseXML;
						$response = $(xml).find('term_id').text();
						if($response!=""){
							// Clear the thumb image
							$('#category-image-wrapper').html('');
						}
					}
				});
			});
	 </script>
	 <?php 
	}
	
}
	 
	$Dexignzone_DZ_Faq_Category_icon = new Dexignzone_DZ_Faq_Category_icon();
	$Dexignzone_DZ_Faq_Category_icon -> init(); 
}