<?php 
$query_args = array(
	'post_type' => 'dz_team',
	'post_status' => 'publish',
	'posts_per_page'    => $team_slider_2_element_no_of_posts,
	'orderby' => $team_slider_2_element_orderby,
	'order' => $team_slider_2_element_order,
	'ignore_sticky_posts' => true,
);



if (!empty($team_slider_2_element_posts_in_categories) && !empty($team_slider_2_element_posts_in_categories[0])) {

	$team_slider_2_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($team_slider_2_element_posts_in_categories, 'team_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'team_category',
		'field' => 'id',
		'terms' => $team_slider_2_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$element_content = !empty($team_slider_2_element_content) ? $team_slider_2_element_content : 'content-inner'; 
$content_text_limit = $team_slider_2_element_text_limit;
$query = new WP_Query($query_args);

if (!empty($query->have_posts())) {

?>
<section class="<?php echo esc_attr($element_content); ?>">
		<div class="container">
			
			<div class="section-head style-1 text-center">
				<?php if(!empty($team_slider_2_element_subtitle)){ ?>
					<span class="sub-title text-primary sub-title-icon">
						<?php if(!empty($team_slider_2_element_icon_img['id'])){ ?>
							<img src="<?php echo esc_url($team_slider_2_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
						<?php } ?>
						<?php echo esc_html($team_slider_2_element_subtitle); ?>
					</span>
				<?php } ?>
				<?php if(!empty($team_slider_2_element_title)){ ?>
				<h2 class="title m-b10"><?php echo wp_kses($team_slider_2_element_title, clinicmaster_allowed_html_tag()); ?></h2>
				<?php }  ?>
			</div>
			<div class="swiper-btn-center-lr swiper-btn-offest-lg">			
				<div class="swiper dz-team-swiper2">
					<div class="swiper-wrapper">
						<?php
						$num = 1;			
						while ($query->have_posts()) {
							$query->the_post();
							global $post;
							$post_id = $post->ID;
							$no_image_class = (!has_post_thumbnail()) ? 'no-image-box' : '';
							$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
							$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);
							$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
							$skils = clinicmaster_get_post_meta(get_the_id(), 'genaral_skils');
							$team_social_data = clinicmaster_get_team_social_link($post_id);
							$class = ($num == 1) ? 'active' :'';
						?>
							<div class="swiper-slide">
								<div class="dz-team style-1 <?php echo esc_attr($class); ?> box-hover">
									<?php if (has_post_thumbnail()) { ?>
									<div class="dz-media">
										<?php echo the_post_thumbnail('full'); ?>
										
										<?php  if(!empty($team_social_data['any_fill'] )){ ?>
											<ul class="dz-social">
											
												<?php foreach($team_social_data['data'] as $key => $value) {
													if(!empty($value['url'])){
												?>
													<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
												<?php }
													}
												?>	
											</ul>
										<?php } ?>
										
									</div>
									<?php } ?>
									<div class="dz-content">
										<div class="clearfix">
											<?php if( !empty($post_title) ){ ?>
											<h3 class="dz-name"><a href="<?php  echo esc_url(get_the_permalink($post)); ?>"><?php echo esc_html($post_title);  ?></a></h3>
											<?php }
											if( !empty($designation)){ ?> 
												<span class="dz-position"><?php echo esc_html($designation); ?></span>
											<?php } ?>
										
										</div>
									</div>
								</div>		
							</div>
							<?php $num++;
						} ?>
					</div>
				</div>
				<div class="team-swiper-prev swiper1-button-next btn-prev">
					<svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M39.5833 25H10.4167" stroke="var(--bs-secondary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M25 10.4165L10.4167 24.9998L25 39.5832" stroke="var(--bs-secondary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					</svg>
				</div>
				<div class="team-swiper-next swiper1-button-next btn-next">
					<svg width="51" height="50" viewBox="0 0 51 50" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M10.6027 25H40.2902" stroke="var(--bs-secondary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M25.4464 10.4165L40.2902 24.9998L25.4464 39.5832" stroke="var(--bs-secondary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					</svg>
				</div>
				<div class="swiper-pagination style-1 pt-2 position-relative d-block d-lg-none"></div>
			</div>
		</div>
</section>
<?php } ?>