<?php
$blog_view = "post_listing_1";
$page_no = 1;

$query_args = array(
	'post_type'         => 'post',
	'post_status'       => 'publish',
	'posts_per_page'    => $post_listing_1_element_no_of_posts,
	'order'             => $post_listing_1_element_order,
	'ignore_sticky_posts' => true,
);

if ($post_listing_1_element_orderby == 'views_count') {
	$query_args['meta_key'] = '_views_count';
} else {
	$query_args['orderby']  = $post_listing_1_element_orderby;
}

$post_listing_1_element_image_preference = !empty($post_listing_1_element_image_preference) ? $post_listing_1_element_image_preference : 'all_posts';

if ($post_listing_1_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($post_listing_1_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}

if (!empty($post_listing_1_element_posts_in_categories) && !empty($post_listing_1_element_posts_in_categories[0])) {

	$post_listing_1_element_posts_in_categories = implode(',', $post_listing_1_element_posts_in_categories);
	$query_args['category_name'] = $post_listing_1_element_posts_in_categories;
} else {
	$post_listing_1_element_posts_in_categories = '';
}

if ($post_listing_1_element_only_featured_posts == 'true') {
	$query_args['meta_key'] = 'featured_post';
	$query_args['meta_value'] = 1;
	$query_args['meta_compare'] = 'LIKE';
}
$padding_clas = '';
$style = !empty( $post_listing_1_element_style) ?  $post_listing_1_element_style :'style_1';
if ($post_listing_1_element_selected_sidebar == 'No_Sidebar' || !is_active_sidebar($post_listing_1_element_selected_sidebar) || !clinicmaster_is_theme_sidebar_active()) {
	$col_classes = 'col-lg-12 col-md-12  col-sm-12 col-12';
} else {
	if($style != 'style_1'){
		$col_classes = ' col-xl-8 col-lg-12 m-b30  ';
		$sid_class = 'col-xl-4 col-lg-12 m-b30 ';
	}else{
		$padding_clas = 'p-0';
		$col_classes = 'col-xl-9 col-lg-12 m-b30 pe-xl-5 ';
		$sid_class = 'col-xl-3 col-lg-12 ';
	}
	
}

$query = new WP_Query($query_args);

$blog_view_container = '';
if ($post_listing_1_element_pagination_style == 'load_more') {
	$blog_view_container = $blog_view . "_LoadMoreContainer";
}
global $clinicmaster_query_result;
$clinicmaster_query_result['posts'] = $query->posts;
$clinicmaster_query_result['posts_per_page'] = $post_listing_1_element_no_of_posts;
$clinicmaster_query_result['current_page'] = $page_no;
$clinicmaster_query_result['side_bar'] = $post_listing_1_element_selected_sidebar;
$clinicmaster_query_result['title_text_limit'] = $post_listing_1_element_text_limit;
$clinicmaster_query_result['show_column'] = $post_listing_1_element_cols;
$clinicmaster_query_result['sidebar_layout'] = $post_listing_1_element_sidebar_layout;
$clinicmaster_query_result['blog_view_container'] = $blog_view_container;
$clinicmaster_query_result['show_date'] = $post_listing_1_element_show_date;
$clinicmaster_query_result['element_style'] = $style;
$max_num_pages = $query->max_num_pages;
$content_calss = !empty($post_listing_1_element_content) ? $post_listing_1_element_content : 'content-inner';
$class = '';
$img = $post_listing_1_element_img;
if(!empty($img['id']) && ( $style == 'style_3')){
	$class = 'bg-light';
}elseif($style == 'style_2'){
	$class = 'bg-light';
}
$clinicmaster_option = getDZThemeReduxOption();
$sidebar_class 	= !empty($clinicmaster_option['sidebar_bg_color']) ? $clinicmaster_option['sidebar_bg_color']: '';

if ($query->have_posts()) {

?>

<section class="<?php echo esc_attr($content_calss.' '.$class); ?>" <?php if(!empty($img['id'])){ ?> style="background-image: url(<?php echo esc_url($img['url']) ?>);" <?php } ?>>
	<div class="container">
		<?php if(!empty($post_listing_1_element_style) && $post_listing_1_element_style == 'style_3'){ ?>
		<div class="section-head style-2 m-b30 row align-items-end">
		<?php if(!empty($post_listing_1_element_title)){ ?>
			<div class="col-xl-7 col-md-9">
				<h2 class="title m-b0 fw-semibold"><?php echo esc_html($post_listing_1_element_title); ?> </h2>
			</div>
		<?php } ?>
		<?php if(!empty($post_listing_1_element_button_text) && !empty($post_listing_1_element_button_link['url'])){
			$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($post_listing_1_element_button_link);
			?>
			<div class="col-xl-5 col-md-3 text-lg-end d-none d-md-block">
				<a href="<?php echo esc_url($post_listing_1_element_button_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn btn-icon btn-secondary">
					<?php echo esc_html($post_listing_1_element_button_text); ?>
					<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
				</a>
			</div>
		<?php } ?>
		</div>
		<?php } ?>
		<div class="row ">
			<?php
			if (($post_listing_1_element_sidebar_layout == 'left') && 	is_active_sidebar($post_listing_1_element_selected_sidebar) && clinicmaster_is_theme_sidebar_active()) {	
			?>
				<div class="<?php echo esc_attr($sid_class); ?>">
					<aside class="side-bar sticky-top @@dir m-b30 <?php echo esc_attr($sidebar_class .' '. $padding_clas); ?>">
						<?php dynamic_sidebar($post_listing_1_element_selected_sidebar); ?>
					</aside>
				</div>
			<?php } ?>
			<div class="<?php echo esc_attr($col_classes); ?>">
				<div <?php if (!empty($blog_view_container)) { ?> id="<?php echo esc_attr($blog_view_container) ?>" <?php } ?> class="row">
					<?php get_template_part('dz-inc/elementor/ajax/post_listing_1_ajax'); ?>
				</div>
				<?php
				if ($post_listing_1_element_pagination_style == 'load_more') {
					$blog_view_btn = $blog_view . "_LoadMoreBtn";
					$blog_view_container = $blog_view . "_LoadMoreContainer";

					if (1 < $max_num_pages) {
				?>
						<!-- Pagination start -->
						<div class="reload-btn col-12 text-center  m-t30 m-lg-t0">
							<a href="javascript:void(0);" class="btn btn-lg btn-rounded btn-primary btn-hover2 btn-shadow loadmore-btn dz-load-more" id="<?php echo esc_attr($blog_view_btn); ?>" data-ajax-container="<?php echo esc_js($blog_view_container); ?>" data-blog-view="<?php echo esc_js($blog_view); ?>" data-max-num-pages="<?php echo esc_js($max_num_pages); ?>" data-posts-per-page="<?php echo esc_js($post_listing_1_element_no_of_posts); ?>" data-image-preference="<?php echo esc_js($post_listing_1_element_image_preference); ?>" data-only-featured-post="<?php echo esc_js($post_listing_1_element_only_featured_posts) ?>" data-post-order="<?php echo esc_js($post_listing_1_element_order) ?>" data-post-order-by="<?php echo esc_js($post_listing_1_element_orderby) ?>" data-posts-in-categories="<?php echo esc_js($post_listing_1_element_posts_in_categories); ?>" data-side-bar="<?php echo esc_js($post_listing_1_element_selected_sidebar); ?>" data-show-column="<?php echo esc_js($post_listing_1_element_cols); ?>" data-title-text-limit="<?php echo esc_js($post_listing_1_element_text_limit); ?>" data-show-date="<?php echo esc_js($post_listing_1_element_show_date); ?>" data-element-style="<?php echo esc_js($post_listing_1_element_style); ?>" >
								
								<?php echo esc_html__('Load More', 'clinicmaster'); ?>
								<span class="right-icon dz-load"><i class="feather icon-refresh-ccw"></i></span>
								
							</a>
						</div>
						<!-- Pagination End -->
				<?php
					}
				}
				?>
			</div>
			
				
			<?php
			if (($post_listing_1_element_sidebar_layout == 'right') && 	is_active_sidebar($post_listing_1_element_selected_sidebar) && clinicmaster_is_theme_sidebar_active()) {	
			?>
				<div class="<?php echo esc_attr($sid_class); ?>">
					<aside class="side-bar sticky-top @@dir m-b30  <?php echo esc_attr($sidebar_class .' '. $padding_clas); ?>">
						<?php dynamic_sidebar($post_listing_1_element_selected_sidebar); ?>
					</aside>
				</div>
			<?php } ?>
		</div>
	</div>
</section>
<?php } ?>