<?php 
$gallery = $partner_slider_1_element_img_gallery;
$element_content = !empty($partner_slider_1_element_content) ? $partner_slider_1_element_content : 'content-inner';
$css_class = !empty($partner_slider_1_element_css_class) ? $partner_slider_1_element_css_class : '';
?>
<section class="<?php echo esc_attr($element_content .' '.$css_class ); ?>">
	<div class="container">
		<div class="row align-items-center">
			<?php if(!empty($partner_slider_1_element_title) || !empty($partner_slider_1_element_subtitle)){ ?>
			<div class="col-xl-4">
				<div class="section-head style-1 m-b30">
					<?php if(!empty($partner_slider_1_element_subtitle)){ ?>
						<span class="sub-title text-primary sub-title-icon">
							<?php if(!empty($partner_slider_1_element_icon_img['id'])){ ?>
								<img src="<?php echo esc_url($partner_slider_1_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
							<?php } ?>
							<?php echo esc_html($partner_slider_1_element_subtitle); ?>
						</span>
					<?php } ?>
					<?php if(!empty($partner_slider_1_element_title)){ ?>
						<h2 class="title m-b0"><?php echo esc_html($partner_slider_1_element_title); ?></h2>
					<?php } ?>
				</div>
			</div>
			<?php }
			if(!empty($gallery)){ ?>
			<div class="col-xl-8 m-b30">
				<div class="swiper client-swiper2">
					<div class="swiper-wrapper">
						<?php foreach($gallery as $val){ ?>
						<div class="swiper-slide">
							<div class="clients-logo2">
								<img src="<?php echo esc_url($val['url']); ?>" alt="<?php echo esc_attr('Image', 'clinicmaster'); ?>">
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>