<?php // Admin Page
if( ! class_exists( 'Wp_Admin_Page' ) ){
	class Wp_Admin_Page {
		
		
		function __construct(){
			
			add_action( 'after_switch_theme', array( $this, 'clinicmaster_theme_activation_redirect' ) ); 
			
			/* Theme purchase code verification and activation */
			add_action( 'wp_ajax_clinicmaster_theme_verify',   array( $this,'clinicmaster_theme_verification' ) );
			add_action( 'wp_ajax_nopriv_clinicmaster_theme_verify',  array( $this,'clinicmaster_theme_verification' ) );
			
			
		}
		
		public function clinicmaster_theme_verification(){
			
		
			$nonce = $_POST['dexignzone_verify_nonce'];	
			if ( ! wp_verify_nonce( $nonce, 'clinicmaster_theme_verify^%&^%' ) ) {
				wp_die ( esc_html__( 'Busted', 'clinicmaster' ) );
			}		
			require_once( CLINICMASTER_ROOT . 'dz-inc/admin/templates/token_verification.php' );
			$verfy_obj = new DexignZone_Purchase_Code_Verification();
			$status = $verfy_obj->verify_token();
			wp_send_json($status);
			
			wp_die('finshed');
		}
		
		
		
		public function clinicmaster_theme_activation_redirect(){
			
			if( isset( $_GET['activated'] ) ) {
				if ( wp_redirect( admin_url( 'admin.php?page=dz-theme-verification' ) ) ) {
					exit;
				}
			}
		}
	
	}
	new Wp_Admin_Page();
}
