<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}


class DexignZone_Purchase_Code_Verification {
		
	public $api_url = 'https://support.w3itexperts.com/apis/verify_purchase_code';
	
	
	public function token_api_call( $email, $purchase_code ) {
		
		global $wp_version;
		
		$current_theme = wp_get_theme();
		$theme_name = ($current_theme->parent() == false) ? $current_theme->get( 'Name' ) : $current_theme->parent()->get( 'Name' );

		$args = array(
			'body'       => array(
				'purchase_code'	=> $purchase_code,
				'email'		    => $email,
				'url'	        => esc_url( home_url( '/' ) ),
				'theme'		    => esc_attr( $theme_name ),
				'server_data'	=> $_SERVER
			)
		);

		$response         = wp_remote_post( esc_url_raw( $this->api_url ), $args );		
		$response_code    = wp_remote_retrieve_response_code( $response );
		$response_message = wp_remote_retrieve_response_message( $response );
		
		 if ( empty( $response_code ) && is_wp_error( $response ) ) {
			return $response;
		} 

		 if ( 200 !== $response_code && ! empty( $response_message ) ) {
			return new WP_Error( $response_code, $response_message );
		}
		if ( 200 !== $response_code ) {
			return new WP_Error( $response_code, esc_html__( 'An unknown API error occurred.', 'clinicmaster' ) );
		}
		$data = wp_remote_retrieve_body( $response ); 
		if ( null === $data ) {
			return new WP_Error( 'api_error', esc_html__( 'An unknown API error occurred.', 'clinicmaster' ) );
		} 
		$data = json_decode( $data, true );
		
		return $data;
	}
	
	public function verify_token(){
		
		$email = $_POST['dexignzone_registration_email'];
		if ( empty( $email ) ) {
			return array( 'error_message' => esc_html__( 'Email id is required.', 'clinicmaster' ) );
		}elseif( !is_email( $email ) ){
			return array( 'error_message' => esc_html__( 'Email id is invalid.', 'clinicmaster' ) );
		}
		
		$purchase_code = sanitize_text_field( $_POST['dexignzone_purchase_code'] );
		if ( empty( $purchase_code ) ) {
			return array( 'error_message' => esc_html__( 'Purchase code is required.', 'clinicmaster' ) );
		}
	
		$data = $this->token_api_call( $email, $purchase_code );
		
		if( isset( $data['status'] ) && ( $data['status'] == true )) {
			update_option( 'verified_purchase_status', $data['status'] );
			update_option( 'verified_code', $purchase_code );
			//$this->dz_plugin_download($data);
			return array( 
				'status' => 'success',
				'message' => $data['message'],
			);
			
		}else{
			
			return array( 
				'status' => $data['status'], 
				'error_message' => $data['message'], 
			);
		}
		
		
	}
	
	public function check_theme_activated(){
		$verified_status = get_option( 'verified_purchase_status' );
		
		if( !empty( $verified_status ) && ($verified_status == true) ){
			$token = get_option( 'verified_code' );
			return $token;
		}
		return false;
	}
	
	public function dz_plugin_download($plugin_data){
	
		
		 // Check if WordPress is loaded
		if ( ! function_exists( 'wp_get_current_user' ) ) {
			require_once( dirname( __FILE__ ) . '/wp-load.php' );
		}

		// Load WordPress filesystem
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . '/wp-admin/includes/file.php';
		}
			
		// Initialize the WP_Filesystem
		if ( ! WP_Filesystem() ) {
			echo "Failed to initialize WP_Filesystem.";
			return;
		}
		
		
		// Path to store the downloaded zip file
		if($plugin_data['data']){
			foreach($plugin_data['data'] as $key => $value){
				$file_check = '';
				if($key == 'dz-redux'){
					$extract_path = DZ_INC.'/dz-redux';
					$zip_path = DZ_INC.'/dz-redux/dz-redux.zip';
					$file_check = DZ_INC.'/dz-redux/theme-options.php';
				}else if($key == 'thirdparty'){
					$extract_path = DZ_INC;
					$zip_path = DZ_INC.'/thirdparty.zip';
					$file_check = DZ_INC.'/thirdparty/tgm-plugin-activation/plugins.php';
				}
				 if(!file_exists($zip_path) && !file_exists($file_check)){
					// Download the zip file
					$zip_data = file_get_contents($value);
					if ($zip_data === false) {
						//echo "Failed to download the zip file.";
						return;
					}
					// Save the zip file
					if (file_put_contents($zip_path, $zip_data) === false) {
						//echo "Failed to save the zip file.";
						return;
					} 
					$unzip_result = unzip_file( $zip_path, $extract_path );
					if ( is_wp_error( $unzip_result ) ) {
						//echo "Failed to extract the zip file: " . $unzip_result->get_error_message();
						return;
					}else{
						if ( file_exists( $zip_path ) ) {
							 unlink( $zip_path );
						}
					}  
				} 
			}
		}
	}
	
	public function dz_plugin_delete(){
		
		$array = array(
			DZ_INC.'/thirdparty',
			DZ_INC.'/dz-redux/theme-options.php',
			DZ_INC.'/dz-redux/page-options.php',
		);
		

		// Call the function to delete the directory and its contents
		foreach($array as $directory){
			// Specify the directory you want to delete
			
			$result = $this->deleteDirectory($directory);	
		}
		if ($result) {
			echo 'Directory deleted successfully.';
		} else {
			echo 'Failed to delete directory.';
		}
		
	}
	
	
	public function deleteDirectory($dir) {
		/**
		 * Recursively delete a directory and its contents.
		 *
		 * @param string $dir The directory path
		 *
		 * @return bool True on success, false on failure
		 */
		
		if (!file_exists($dir)) {
			return true;
		}

		if (!is_dir($dir)) {
			return unlink($dir);
		}

		foreach (scandir($dir) as $item) {
			if ($item == '.' || $item == '..') {
				continue;
			}

			if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
				return false;
			}
		}

		return rmdir($dir);
	}

	
}