<?php

/**
 * VC Composer array
 *
 * @package Student WP
 * @author DexignZone
 * @version 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Restricted' );
}


$orderby_options = array(
					'0'             =>

esc_html__('Choose Order', DZ_TH_DOMAIN),
					'date'			=>	esc_html__('Date', DZ_TH_DOMAIN),
					'title'			=>	esc_html__('Title', DZ_TH_DOMAIN),
					'name'			=>	esc_html__('Name', DZ_TH_DOMAIN),
					'author'		=>	esc_html__('Author', DZ_TH_DOMAIN),
					'comment_count' =>	esc_html__('Comment Count', DZ_TH_DOMAIN),
					'views_count' 	=>	esc_html__('View Count', DZ_TH_DOMAIN),
					'rand' 		  	=>	esc_html__('Random', DZ_TH_DOMAIN) 
					);
$orderby_options = array_flip($orderby_options);
					
$cat_orderby_options = array(
					'date'=>esc_html__('Date', DZ_TH_DOMAIN),
						'title'=>esc_html__('Title', DZ_TH_DOMAIN),
						'name'=>esc_html__('Name', DZ_TH_DOMAIN),
						'random' =>esc_html__('Random', DZ_TH_DOMAIN) 
					);
$cat_orderby_options = array_flip($cat_orderby_options);

/*'normal' => 'Normal', we will not give normal page loading paginaton in elements  */ 
$pagination_options = array(
					'no' => 'No Pagination',
					'load_more' => 'Ajax Load More Button',
					/*'infinate_scroll' => 'Infinite Scroll', */
					);

$pagination_options = array_flip($pagination_options);

$order_options = array(
                  '0'  =>  esc_html__('Choose Sorting', DZ_TH_DOMAIN),
                  'ASC'=>esc_html__('Ascending', DZ_TH_DOMAIN),
                  'DESC'=>esc_html__('Descending', DZ_TH_DOMAIN) 
                 );
$order_options = array_flip($order_options);

$column_options = array_flip( array('Select Option'=>esc_html__('Choose Column',DZ_TH_DOMAIN),'col_2'=>esc_html__('2 Column', DZ_TH_DOMAIN),'col_3'=>esc_html__('3 Column', DZ_TH_DOMAIN),'col_4'=>esc_html__('4 Column', DZ_TH_DOMAIN) ) );
$container_options = array_flip( array(esc_html__('Select Options',DZ_TH_DOMAIN)=>'Choose Layout',esc_html__('container-fluid', DZ_TH_DOMAIN)=>'Wide',esc_html__('container', DZ_TH_DOMAIN)=>'Box') );


$sidebar_layout_options = array_flip( array(esc_html__('Select Options',DZ_TH_DOMAIN)=>'Choose Sidebar Layout',esc_html__('left', DZ_TH_DOMAIN)=>'Left Sidebar',esc_html__('right', DZ_TH_DOMAIN)=>'Right Sidebar' ) );


$selected_sidebar_options = dz_get_sidebars();
$selected_sidebar_options = array_flip($selected_sidebar_options);

$selected_sidebar_options = array(esc_html__('Choose Sidebar') => '') + $selected_sidebar_options ;

$image_preference_options = array('all_posts'=>'All Posts', 'image_post_only'=>'Image Post Only', 'text_post_only' => 'Text Post Only'); 
$image_preference_options = array_flip($image_preference_options);
$post_by_label_options = array('all_posts'=>'All Posts', 'sticky_only' => 'Sticky Only', 'featured_only' => 'Featured Only');
$post_by_label_options = array_flip($post_by_label_options);

$contact_form_options_arr = get_posts(array('post_type'     => 'wpcf7_contact_form','numberposts'   => -1));
$contact_form_options = wp_list_pluck($contact_form_options_arr, 'post_title', 'post_name');
$contact_form_options = array(0=>esc_html__('Choose Category',DZ_TH_DOMAIN)) + $contact_form_options ;
$contact_form_options = array_flip($contact_form_options);

$posts_in_categories_options = dz_get_categories(array('taxonomy' => 'category'),true);
$posts_in_categories_options = array_flip($posts_in_categories_options);

$team_categories_options = dz_get_cpt_category('team_category','slug') ;
$service_categories_options = dz_get_cpt_category('service_category','slug') ;
$faq_categories_options = dz_get_cpt_category('faq_category','slug') ;
$testimonials_categories_options = dz_get_cpt_category('testimonial_category','slug') ;
$portfolio_categories_options = dz_get_cpt_category('portfolio_category','slug') ;

$sidebar_element_options =  array_flip( array('Select Options'=>esc_html__('Choose Sidebar',DZ_TH_DOMAIN),'left'=>esc_html__('Left', DZ_TH_DOMAIN),'right'=>esc_html__('Right', DZ_TH_DOMAIN)));

$position_element_options =  array_flip( array('Select Options'=>esc_html__('Choose Sidebar',DZ_TH_DOMAIN),'left'=>esc_html__('Left', DZ_TH_DOMAIN),'right'=>esc_html__('Right', DZ_TH_DOMAIN)));


$team_element_style = array_flip( array(esc_html__('Select Options',DZ_TH_DOMAIN)=>'Choose Style','style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN) ));

$service_element_style = array_flip( array(esc_html__('Select Options',DZ_TH_DOMAIN)=>'Choose Style',esc_html__('style_1', DZ_TH_DOMAIN)=>'Style 1',esc_html__('style_2', DZ_TH_DOMAIN)=>'Style 2',esc_html__('style_3', DZ_TH_DOMAIN)=>'Style 3' ));

$testimonial_element_style = array_flip( array(esc_html__('Select Options',DZ_TH_DOMAIN)=>'Choose Style','style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN),'style_4'=>esc_html__('Style 4', DZ_TH_DOMAIN) ));



$section_background_options = array(
									'0'		 =>esc_html__('Choose Background',DZ_TH_DOMAIN),
									'bg-gray'=>esc_html__('Primary Background',DZ_TH_DOMAIN),
									''		 =>esc_html__('White Background',DZ_TH_DOMAIN)
									);

$section_background_options = array_flip($section_background_options);

$section_padding_options = array(
								''			   =>esc_html__('Choose Padding',DZ_TH_DOMAIN),
								'content-inner'=>esc_html__('Padding Top-100 Bottom-70',DZ_TH_DOMAIN),
								'content-inner-1'=>esc_html__('Padding Top-Bottom-100',DZ_TH_DOMAIN),
								'content-inner-2'=>esc_html__('Padding Top-100 Bottom-0',DZ_TH_DOMAIN)
								);
								
$section_padding_options = array_flip($section_padding_options);

$active_options = array(
						''=>esc_html__('Inactive',DZ_TH_DOMAIN),
						'active'=>esc_html__('Active',DZ_TH_DOMAIN)
					  );
					  
$active_options = array_flip($active_options);					  

$options = array();

$blog_posts = get_posts(array('post_type'     => 'post','numberposts'   => -1));
$blog_posts = wp_list_pluck($blog_posts, 'post_title', 'ID');
$blog_posts_arr = array();
foreach($blog_posts as $post_id =>  $post_name){
	$blog_posts_arr[] = array('label'=>$post_name,'value'=>$post_id);
}

/*=================================================================================*/
$dz_sc = array();


$dz_sc['dz_home_banner_1_element']	=	array(
      'name' 		=> esc_html__('Home Banner 1', DZ_TH_DOMAIN),
      'base' 		=> 'dz_home_banner_1_element',
      'class' 		=> '',
      'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
      'icon' 		=> 'dz-element-vc' ,
      'description' => esc_html__('Shows Home Banner 1.', DZ_TH_DOMAIN),	
      'params' 		=> array(
          array(
             'type'         => 'textarea',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
             'value'        => esc_html__('HOW WE CAN HELP YOUR', DZ_TH_DOMAIN ). '<span class="text-primary">'.esc_html__('BUSINESS', DZ_TH_DOMAIN ).'</span>',
             'param_name'   => 'home_banner_1_element_title',
             'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
             'group'        => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
             'type'         => 'textfield',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
             'value'        => esc_html__('WE CREATE IDEAS', DZ_TH_DOMAIN ),
             'param_name'   => 'home_banner_1_element_subtitle',
             'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
             'group'        => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
            'type'          => 'textarea',
            'holder'        => 'div',
            'class'         => '',
            'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
            'value'         => esc_html__('Morbi sed lacus nec risus finibus feugiat et fermentum nibh. Pellentesque vitae ante at elit fringilla ac at purus.', DZ_TH_DOMAIN ),
            'param_name'    => 'home_banner_1_element_description',
            'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
            'group'         => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
             'type'         => 'vc_link',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Link 1', DZ_TH_DOMAIN),
             'param_name'   => 'home_banner_1_element_link',
             'description'  => esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
             'type'         => 'attach_image',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
             'param_name'   => 'home_banner_1_element_bg_img',
             'description'  => esc_html__('Enter the Slider Image to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
          ),
          array(
             'type'         => 'attach_image',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Moving Image 1', DZ_TH_DOMAIN),
             'param_name'   => 'home_banner_1_element_moving_image1',
             'description'  => esc_html__('Enter the Moving Image 1 to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
          ),
          
          array(
             'type'         => 'attach_image',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Main Image 1', DZ_TH_DOMAIN),
             'param_name'   => 'home_banner_1_element_main_image1',
             'description'  => esc_html__('Enter the Main Image 1 to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
          ),
          array(
             'type'         => 'attach_image',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Main Image 2', DZ_TH_DOMAIN),
             'param_name'   => 'home_banner_1_element_main_image2',
             'description'  => esc_html__('Enter the Main Image 2 to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
          ),
      ),
			
);

$dz_sc['dz_home_banner_2_element']	=	array(
		'name' 		=> esc_html__('Home Banner 2', DZ_TH_DOMAIN),
		'base' 		=> 'dz_home_banner_2_element',
		'class' 	=> '',
		'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
		'icon' 		=> 'dz-element-vc' ,
		'description'=> esc_html__('Shows Home Banner 2.', DZ_TH_DOMAIN),	
		'params' 	=> array(
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
				'value'        => esc_html__('Freelance Product Designer Running', DZ_TH_DOMAIN ),
				'param_name'   => 'home_banner_2_element_title',
				'description'  => __('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'value'        => esc_html__('WE ARE THE BEST', DZ_TH_DOMAIN ),
				'param_name'   => 'home_banner_2_element_subtitle',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'          => 'textarea',
				'holder'        => 'div',
				'class'         => '',
				'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
				'value'         => esc_html__('We develop the relationships that underpin the next phase in your organisation’s growth.', DZ_TH_DOMAIN ),
				'param_name'    => 'home_banner_2_element_description',
				'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN ),
			),
		  
			array(
				'type'          => 'textarea',
				'holder'        => 'div',
				'class'         => '',
				'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
				'value'         => esc_html__("Master's degree in designing,Outstanding mobile design", DZ_TH_DOMAIN ),
				'param_name'    => 'home_banner_2_element_description2',
				'description'   => esc_html__('Enter The Section Description Comma Seprated to Show.', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN ),
			),
		  
			array(
				'type'         => 'vc_link',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Link 1', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_2_element_link',
				'description'  => esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_2_element_bg_img',
				'description'  => esc_html__('Enter the Slider Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Moving Image 1', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_2_element_moving_image1',
				'description'  => esc_html__('Enter the Moving Image 1 to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Moving Image 2', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_2_element_moving_image2',
				'description'  => esc_html__('Enter the Moving Image 2 to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
      ),
			
);

$dz_sc['dz_home_banner_3_element']	=	array(
      'name' 		=> esc_html__('Home Banner 3', DZ_TH_DOMAIN),
      'base' 		=> 'dz_home_banner_3_element',
      'class'		=> '',
      'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
      'icon' 		=> 'dz-element-vc' ,
      'description' => esc_html__('Shows Home Banner 3.', DZ_TH_DOMAIN),	
      'params' 		=> array(
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
				'value'        => esc_html__('We Design Interfaces That Users Love', DZ_TH_DOMAIN ),
				'param_name'   => 'home_banner_3_element_title',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'value'        => esc_html__('We Are Product Designer From India', DZ_TH_DOMAIN ),
				'param_name'   => 'home_banner_3_element_subtitle',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'          => 'textarea',
				'holder'        => 'div',
				'class'         => '',
				'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
				'value'         => esc_html__('Morbi sed lacus nec risus finibus feugiat et fermentum nibh. Pellentesque vitae ante at elit fringilla ac at purus.', DZ_TH_DOMAIN ),
				'param_name'    => 'home_banner_3_element_description',
				'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'vc_link',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Link 1', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_3_element_link',
				'description'  => esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_3_element_bg_img',
				'description'  => esc_html__('Enter the Slider Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image 2', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_3_element_bg_img2',
				'description'  => esc_html__('Enter the Slider Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Main Image', DZ_TH_DOMAIN),
				'param_name'   => 'home_banner_3_element_main_image',
				'description'  => esc_html__('Enter the Main Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
      ),
			
);



/* Content Box 1 */
$dz_sc['dz_content_box_1_element']	=	array(
      'name' 		=> esc_html__('Content Box 1', DZ_TH_DOMAIN),
      'base' 		=> 'dz_content_box_1_element',
      'class' 		=> '',
      'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
      'icon' 		=> 'dz-element-vc' ,
      'description' => esc_html__('Shows Content Box 1.', DZ_TH_DOMAIN),	
      'params' 		=> array(
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
				'value'        => esc_html__('How We Can Help You Achieve Your Business Goal', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_1_element_title',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'value'        => esc_html__('About Us', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_1_element_subtitle',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'          => 'textarea_html',
				'holder'        => 'div',
				'class'         => '',
				'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
				'value'         => esc_html__('Morbi sed lacus nec risus finibus feugiat et fermentum nibh. Pellentesque vitae ante at elit fringilla ac at purus.', DZ_TH_DOMAIN ),
				'param_name'    => 'content',
				'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'vc_link',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Link 1', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_1_element_link',
				'description'  => esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_1_element_image',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_1_element_bg_img',
				'description'  => esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type' 			=> 'dropdown',
				'holder' 		=> 'div',
				'class' 		=> '',
				'heading' 		=> esc_html__('Image Position', DZ_TH_DOMAIN),
				'param_name' 	=> 'content_box_1_element_position',
				'value' 		=> $position_element_options,
				'description'	=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
				'group' 		=> esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Author Name', DZ_TH_DOMAIN ),
				'value'        => esc_html__('CEO Jhone Doe', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_1_author_name',
				'description'  => esc_html__('Enter The Author to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('Author', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Author Signature', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_1_element_author_signature',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Author', DZ_TH_DOMAIN ),
			),
      ),
			
);

/* Content Box 2 */
$dz_sc['dz_content_box_2_element']	=	array(
        'name' 			=> esc_html__('Content Box 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_content_box_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Content Box 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
				'value'        => esc_html__('Our Working Process To Help Your Boost Your Business', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_2_element_title',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'value'        => esc_html__('Fetures', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_2_element_subtitle',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_2_element_image',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'dropdown',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Image Position', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_2_element_position',
				'value'        => $position_element_options,
				'description'  => esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			//Group Start
			array(
              'type' 		=> 'param_group',
              'value' 		=> '',
              'param_name' 	=> 'content_box_2_element_item',
              'group' 		=> esc_html__('Features', DZ_TH_DOMAIN),
              'params' 		=> array(
					array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name' => 'content_box_2_element_item_title',
                       'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
                    array(
						'type' 		=> 'textarea',
						'holder' 	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
						'param_name'=> 'content_box_2_element_item_description',
						'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
					),
					array(
                        'type' 		=> 'dropdown',
                        'heading' 	=> esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
                        'value' 	=> array(
                          esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
                          esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
                          esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
                        ),
                        'param_name' => 'content_box_2_element_item_icon_list',
                        'description'=> esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
                        
                    ),
                    array(
                        'type' 			=> 'iconpicker',
                        'heading' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
                        'param_name' 	=> 'content_box_2_element_item_icon_fontawesome',
                        'settings' 		=> array(
                            'emptyIcon' => true, // default true, display an 'EMPTY' icon?
                            'type' 		=> 'fontawesome',
                            'iconsPerPage'=> 200, // default 100, how many icons per/page to display
                        ),
						'dependency' 	=> array(
							'element' 	=> 'content_box_2_element_item_icon_list',
							'value' 	=> 'fontawesome',
						),
                        'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                    ),
                    array(
                        'type' 			=> 'iconpicker',
                        'heading' 		=> esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
                        'param_name' 	=> 'content_box_2_element_item_icon_themify',
                        'settings' 		=> array(
                          'emptyIcon' 	=> true,
                          'type' 		=> 'themify',
                          'iconsPerPage'=> 200,
                        ),
                        'dependency' 	=> array(
                          'element' 	=> 'content_box_2_element_item_icon_list',
                          'value' 		=> 'themify',
                        ),
                        'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        
                    ),
                    array(
                        'type' 			=> 'iconpicker',
                        'heading' 		=> esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
                        'param_name' 	=> 'content_box_2_element_item_icon_flaticon',
                        'settings' 		=> array(
                          'emptyIcon' 	=> true,
                          'type' 		=> 'flaticon',
                          'iconsPerPage'=> 200,
                        ),
                        'dependency' 	=> array(
                          'element' 	=> 'content_box_2_element_item_icon_list',
                          'value' 		=> 'flaticon',
                        ),
                        'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                    ),
				),
			),//Group End
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'=> 'content_box_2_element_section_padding',
				'value'		=> $section_padding_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
      ),
	);

/* Content Box 3 */
$dz_sc['dz_content_box_3_element']	=	array(
        'name' 			=> esc_html__('Content Box 3', DZ_TH_DOMAIN),
        'base' 			=> 'dz_content_box_3_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Content Box 3.', DZ_TH_DOMAIN),	
        'params' 		=> array(
          array(
             'type'         => 'textfield',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
             'value'        => esc_html__('You Want To Showcase Your Website In Top Join With Us', DZ_TH_DOMAIN ),
             'param_name'   => 'content_box_3_element_title',
             'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
             'group'        => esc_html__('General', DZ_TH_DOMAIN ),
          ),
         
          array(
             'type'         => 'vc_link',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Link 1', DZ_TH_DOMAIN),
             'param_name'   => 'content_box_3_element_link',
             'description'  => esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
             'type'         => 'attach_image',
             'holder'       => 'div',
             'class'        => '',
             'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
             'param_name'   => 'content_box_3_element_bg_img',
             'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
             'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
          ),
      ),
	);

/* Content Box 4 */
$dz_sc['dz_content_box_4_element']	=	array(
        'name' 			=> esc_html__('Content Box 4', DZ_TH_DOMAIN),
        'base' 			=> 'dz_content_box_4_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description'	=> esc_html__('Shows Content Box 4.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
				'value'        => esc_html__('We Have Creative Team To Build Your Business Website Better', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_4_element_title',
				'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         	 => 'textfield',
				'holder'       	 => 'div',
				'class'        	 => '',
				'heading'      	 => esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'value'        	 => esc_html__('ABOUT US', DZ_TH_DOMAIN ),
				'param_name'   	 => 'content_box_4_element_subtitle',
				'description'  	 => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        	 => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         	 => 'textarea_html',
				'holder'       	 => 'div',
				'class'        	 => '',
				'heading'      	 => esc_html__('Description', DZ_TH_DOMAIN ),
				'value'          => esc_html__('Proin laoreet leo vel enim gravida, at porttitor metus ultricies. Cras eu velit enim. Vivamus blandit, dolor ut aliquet rutrum, ex elit mattis sapien, non molestie felis neque et nulla. Sed euismod turpis id nibh suscipit semper. Pellentesque dapibus risus arcu.', DZ_TH_DOMAIN ),
				'param_name'    => 'content',
				'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'          => 'exploded_textarea',
				'holder'        => 'div',
				'class'         => '',
				'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
				'value'         => esc_html__('Proin laoreet leo vel enim gravida
				, at porttitor metus ultricies. Cras eu velit enim. Vivamus blandit
				, dolor ut aliquet rutrum
				, ex elit mattis sapien', DZ_TH_DOMAIN ),
				'param_name'    => 'content_box_4_element_description',
				'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'vc_link',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Link 1', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_4_element_link',
				'description'  => esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_4_element_image',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_4_element_bg_img',
				'description'  => esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type' 			=> 'dropdown',
				'holder' 		=> 'div',
				'class' 		=> '',
				'heading' 		=> esc_html__('Image Position', DZ_TH_DOMAIN),
				'param_name'	=> 'content_box_4_element_position',
				'value' 		=> $position_element_options,
				'description'	=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
				'group' 		=> esc_html__('Image', DZ_TH_DOMAIN ),
			),
        ),
      );
    

/* Content Box 5 */
$dz_sc['dz_content_box_5_element']	=	array(
        'name' 		=> esc_html__('Content Box 5', DZ_TH_DOMAIN),
        'base' 		=> 'dz_content_box_5_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Content Box 5.', DZ_TH_DOMAIN),	
        'params' 	=> array(
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
					'value'        => esc_html__('Behind The Story Of Slack Digital Agency', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_5_element_title',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
					'value'        => esc_html__('Our Features', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_5_element_subtitle',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
        
				array(
					'type'         => 'attach_image',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
					'param_name'   => 'content_box_5_element_bg_img',
					'description'  => esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
					'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
				),
			  
				array(
					'type'         => 'attach_image',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
					'param_name'   => 'content_box_5_element_image',
					'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
					'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
				),
				array(
					'type' 			=> 'dropdown',
					'holder' 		=> 'div',
					'class' 		=> '',
					'heading' 		=> esc_html__('Image Position', DZ_TH_DOMAIN),
					'param_name' 	=> 'content_box_5_element_position',
					'value' 		=> $position_element_options,
					'description'	=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
					'group' 		=> esc_html__('Image', DZ_TH_DOMAIN ),
				),
              //Group Start
              array(
                  'type' 		=> 'param_group',
                  'value' 		=> '',
                  'param_name' 	=> 'content_box_5_element_item',
                  'group' 		=> esc_html__('Features', DZ_TH_DOMAIN),
                  'params' 		=> array(
						array(
                           'type' 		=> 'textfield',
                           'holder' 	=> 'div',
                           'class' 		=> '',
                           'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                           'param_name' => 'content_box_5_element_item_title',
                           'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                        ),
                        array(
							'type' 		=> 'textarea',
							'holder' 	=> 'div',
							'class' 	=> '',
							'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
							'param_name'=> 'content_box_5_element_item_description',
							'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
						),
						array(
							'type' 		=> 'dropdown',
							'heading' 	=> esc_html__( 'Active Table', DZ_TH_DOMAIN ),
							'param_name'=> 'content_box_5_element_item_active',
							'value'		=> $active_options,
						),
						array(
							'type' 			=> 'dropdown',
							'heading' 		=> esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
							'value' 		=> array(
								esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
								esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
								esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
							),
							'param_name' 	=> 'content_box_5_element_item_icon_list',
							'description' 	=> esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
                        
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_5_element_item_icon_fontawesome',
							'settings' 		=> array(
								'emptyIcon' => true, // default true, display an 'EMPTY' icon?
								'type' 		=> 'fontawesome',
								'iconsPerPage'=> 200, // default 100, how many icons per/page to display
							),
							'dependency' 	=> array(
								'element' 	=> 'content_box_5_element_item_icon_list',
								'value' 	=> 'fontawesome',
							),
                          
                          'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_5_element_item_icon_themify',
							'settings' 		=> array(
								'emptyIcon' => true,
								'type' 		=> 'themify',
								'iconsPerPage'=> 200,
							),
							'dependency' 	=> array(
								'element' 	=> 'content_box_5_element_item_icon_list',
								'value' 	=> 'themify',
							),
							'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_5_element_item_icon_flaticon',
							'settings' 		=> array(
							'emptyIcon' 	=> true,
							'type' 		=> 'flaticon',
							'iconsPerPage'=> 200,
							),
							'dependency' 	=> array(
							'element' 	=> 'content_box_5_element_item_icon_list',
							'value' 		=> 'flaticon',
							),
							'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        
						),
					  
					),
				),//Group End
		),
			
	);

/* Content Box 6 */
$dz_sc['dz_content_box_6_element']	=	array(
        'name' 		=> esc_html__('Content Box 6', DZ_TH_DOMAIN),
        'base' 		=> 'dz_content_box_6_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Content Box 6.', DZ_TH_DOMAIN),	
        'params' 	=> array(
			array(
				'type'         => 'textfield',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
				'value'        => esc_html__('Why Our Agency', DZ_TH_DOMAIN ),
				'param_name'   => 'content_box_6_element_title',
				'description'  => __('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type' 			=> 'textarea',
				'holder' 		=> 'div',
				'class' 		=> '',
				'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
				'group'        	=> esc_html__('General', DZ_TH_DOMAIN ),
				'value'        	=> esc_html__('In dictum aliquam turpis lacinia iaculis. Fusce vel malesuada magna. Nulla vel maximus risus. Donec volutpat metus lacinia.', DZ_TH_DOMAIN ),
				'param_name' 	=> 'content_box_6_element_description',
				'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
				'param_name'   => 'content_box_6_element_image',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type' 			=> 'dropdown',
				'holder' 		=> 'div',
				'class' 		=> '',
				'heading' 		=> esc_html__('Image Position', DZ_TH_DOMAIN),
				'param_name' 	=> 'content_box_6_element_position',
				'value' 		=> $position_element_options,
				'description'	=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
				'group'			=> esc_html__('Image', DZ_TH_DOMAIN ),
			),
          
			//Group Start
			array(
				'type' 			=> 'param_group',
				'value' 		=> '',
				'param_name' 	=> 'content_box_6_element_item',
				'group' 		=> esc_html__('Features', DZ_TH_DOMAIN),
				'params' 		=> array(
                    array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
					   'value'		=> esc_html__('Idea & Analysis Gathering', DZ_TH_DOMAIN ),
                       'param_name' => 'content_box_6_element_item_title',
                       'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
                    array(
						'type' 		=> 'textfield',
						'holder'	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
						'value'		=> esc_html__('Maecenas laoreet efficitur sagittis. Aliquam eleifend nisl leo, sit amet consequat augue.', DZ_TH_DOMAIN ),
						'param_name'=> 'content_box_6_element_item_description',
						'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
					),
					array(
                        'type' 		=> 'dropdown',
                        'heading' 	=> esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
                        'value' 	=> array(
							esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
							esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
							esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
                        ),
                        'param_name' => 'content_box_6_element_item_icon_list',
                        'description'=> esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
                        
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => esc_html__( 'Icon', DZ_TH_DOMAIN ),
                        'param_name' => 'content_box_6_element_item_icon_fontawesome',
                        'settings' => array(
                          'emptyIcon' => true, // default true, display an 'EMPTY' icon?
                          'type' => 'fontawesome',
                          'iconsPerPage' => 200, // default 100, how many icons per/page to display
                        ),
                        'dependency' => array(
                          'element' => 'content_box_6_element_item_icon_list',
                          'value' => 'fontawesome',
                        ),
                        
                        'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
                        'param_name' => 'content_box_6_element_item_icon_themify',
                        'settings' => array(
                          'emptyIcon' => true,
                          'type' => 'themify',
                          'iconsPerPage' => 200,
                        ),
                        'dependency' => array(
                          'element' => 'content_box_6_element_item_icon_list',
                          'value' => 'themify',
                        ),
                        'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
                        'param_name' => 'content_box_6_element_item_icon_flaticon',
                        'settings' => array(
                          'emptyIcon' => true,
                          'type' => 'flaticon',
                          'iconsPerPage' => 200,
                        ),
                        'dependency' => array(
                          'element' => 'content_box_6_element_item_icon_list',
                          'value' => 'flaticon',
                        ),
                        'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        
                    ),
				),
			),//Group End
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'=> 'content_box_6_element_section_background',
				'value'		=> $section_background_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'=> 'content_box_6_element_section_padding',
				'value'		=> $section_padding_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
		),
			
	);

/* Content Box 7 */
$dz_sc['dz_content_box_7_element']	=	array(
        'name' 		=> esc_html__('Content Box 7', DZ_TH_DOMAIN),
        'base' 		=> 'dz_content_box_7_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Content Box 7.', DZ_TH_DOMAIN),	
        'params' 	=> array(
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
					'value'        => esc_html__('We Have Creative Team To Build Your Business Website Better', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_7_element_title',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'          => 'textarea',
					'holder'        => 'div',
					'class'         => '',
					'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
					'value'         => esc_html__('Proin laoreet leo vel enim gravida, at porttitor metus ultricies. Cras eu velit enim. Vivamus blandit, dolor ut aliquet rutrum, ex elit mattis sapien, non molestie felis neque et nulla. Sed euismod turpis id nibh suscipit semper. Pellentesque dapibus risus arcu.', DZ_TH_DOMAIN ),
					'param_name'    => 'content_box_7_element_description',
					'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
					'group'         => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'         => 'attach_image',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
					'param_name'   => 'content_box_7_element_image',
					'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
					'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
				),
				//Group Start
				array(
					'type' 		=> 'param_group',
					'value' 	=> '',
					'param_name'=> 'content_box_7_element_item',
					'group' 	=> esc_html__('Features', DZ_TH_DOMAIN),
					'params' 	=> array(
						array(
							'type' 			=> 'textfield',
							'holder' 		=> 'div',
							'class' 		=> '',
							'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_7_element_item_title',
							'description'	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                        ),
                        array(
							'type' 			=> 'textarea',
							'holder' 		=> 'div',
							'class' 		=> '',
							'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
							'param_name'	=> 'content_box_7_element_item_description',
							'description'	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
						),
						array(
							'type' 			=> 'dropdown',
							'heading' 		=> esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
							'value' 		=> array(
								esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
								esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
								esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
							),
							'param_name'	=> 'content_box_7_element_item_icon_list',
							'description' 	=> esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),               
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_7_element_item_icon_fontawesome',
							'settings' 		=> array(
								'emptyIcon' => true, // default true, display an 'EMPTY' icon?
								'type' 		=> 'fontawesome',
								'iconsPerPage'=> 200, // default 100, how many icons per/page to display
							),
							'dependency' 	=> array(
								'element' 	=> 'content_box_7_element_item_icon_list',
								'value' 	=> 'fontawesome',
							),
							'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_7_element_item_icon_themify',
							'settings' 		=> array(
								'emptyIcon' => true,
								'type' 		=> 'themify',
								'iconsPerPage'=> 200,
							),
							'dependency' 	=> array(
								'element' 	=> 'content_box_7_element_item_icon_list',
								'value' 	=> 'themify',
							),
							'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        ),
						array(
							'type' => 'iconpicker',
							'heading' => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
							'param_name' => 'content_box_7_element_item_icon_flaticon',
							'settings' => array(
							'emptyIcon' => true,
							'type' => 'flaticon',
							'iconsPerPage' => 200,
							),
							'dependency' => array(
							'element' => 'content_box_7_element_item_icon_list',
							'value' => 'flaticon',
							),
							'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						),
					),
				),//Group End
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
					'param_name'=> 'content_box_7_element_section_background',
					'value'		=> $section_background_options,
					'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
				),
			),
		);

/* Content Box 8 */
$dz_sc['dz_content_box_8_element']	=	array(
        'name' 		=> esc_html__('Content Box 8', DZ_TH_DOMAIN),
        'base' 		=> 'dz_content_box_8_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Content Box 8.', DZ_TH_DOMAIN),	
        'params' 	=> array(
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
					'value'        => esc_html__('Watch How Our Team Help You To Achive Goal', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_8_element_title',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
                 'type'         => 'textfield',
                 'holder'       => 'div',
                 'class'        => '',
                 'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
                 'value'        => esc_html__('Watch Us', DZ_TH_DOMAIN ),
                 'param_name'   => 'content_box_8_element_subtitle',
                 'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                 'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'      => 'textarea',
					'holder'    => 'div',
					'class'     => '',
					'heading'   => esc_html__('Description', DZ_TH_DOMAIN ),
					'value'     => esc_html__('Suspendisse euismod eget lacus quis mattis. Nunc ut auctor justo, et pulvinar lorem nteger tempor nisi venenatis', DZ_TH_DOMAIN ),
					'param_name' => 'content_box_8_element_description',
					'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
					'group'      => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'       => 'attach_image',
					'holder'     => 'div',
					'class'      => '',
					'heading'    => esc_html__('Video Image', DZ_TH_DOMAIN),
					'param_name' => 'content_box_8_element_video_image',
					'description'=> esc_html__('Enter the Video Image to show.', DZ_TH_DOMAIN),
					'group'      => esc_html__('Video', DZ_TH_DOMAIN ),
				),
				array(
					'type'       => 'textfield',
					'holder'     => 'div',
					'class'      => '',
					'heading'    => esc_html__('Youtube Link', DZ_TH_DOMAIN ),
					'param_name' => 'content_box_8_element_youtube_link',
					'value'      => esc_html__('https://www.youtube.com/watch?v=oanM6RTmmm4', DZ_TH_DOMAIN ),
					'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'      => esc_html__('Video', DZ_TH_DOMAIN ),
				),
				
				//Group Start
				array(
					'type' 		=> 'param_group',
					'value' 	=> '',
					'param_name'=> 'content_box_8_element_item',
					'group' 	=> esc_html__('Features', DZ_TH_DOMAIN),
					'params' 	=> array(
						array(
							'type' 			=> 'textfield',
							'holder' 		=> 'div',
							'class' 		=> '',
							'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_8_element_item_title',
							'value'      	=> esc_html__('Online Support', DZ_TH_DOMAIN ),
							'description'	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                        ),
                        array(
							'type' 			=> 'textarea',
							'holder' 		=> 'div',
							'class' 		=> '',
							'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
							'param_name'	=> 'content_box_8_element_item_description',
							'value'      	=> esc_html__('Quisque efficitur consequat turpis, eget consequat risus vulputate eunc ligula.', DZ_TH_DOMAIN ),
							'description'	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
						),
						array(
							'type' 			=> 'dropdown',
							'heading' 		=> esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
							'value' 		=> array(
								esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
								esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
								esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
							),
							'param_name'	=> 'content_box_8_element_item_icon_list',
							'description' 	=> esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),               
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_8_element_item_icon_fontawesome',
							'settings' 		=> array(
								'emptyIcon' => true, // default true, display an 'EMPTY' icon?
								'type' 		=> 'fontawesome',
								'iconsPerPage'=> 200, // default 100, how many icons per/page to display
							),
							'dependency' 	=> array(
								'element' 	=> 'content_box_8_element_item_icon_list',
								'value' 	=> 'fontawesome',
							),
							'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						),
						array(
							'type' 			=> 'iconpicker',
							'heading' 		=> esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
							'param_name' 	=> 'content_box_8_element_item_icon_themify',
							'settings' 		=> array(
								'emptyIcon' => true,
								'type' 		=> 'themify',
								'iconsPerPage'=> 200,
							),
							'dependency' 	=> array(
								'element' 	=> 'content_box_8_element_item_icon_list',
								'value' 	=> 'themify',
							),
							'description' 	=> esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                        ),
						array(
							'type' => 'iconpicker',
							'heading' => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
							'param_name' => 'content_box_8_element_item_icon_flaticon',
							'settings' => array(
							'emptyIcon' => true,
							'type' => 'flaticon',
							'iconsPerPage' => 200,
							),
							'dependency' => array(
							'element' => 'content_box_8_element_item_icon_list',
							'value' => 'flaticon',
							),
							'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						),
					),
				),//Group End
				
		),
			
);

/* Content Box 9 */
$dz_sc['dz_content_box_9_element']	=	array(
        'name' 		=> esc_html__('Content Box 9', DZ_TH_DOMAIN),
        'base' 		=> 'dz_content_box_9_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Content Box 9.', DZ_TH_DOMAIN),	
        'params' 	=> array(
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
					'value'        => esc_html__('Watch Us How Our Team Work Togather', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_9_element_title',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'          => 'textarea',
					'holder'        => 'div',
					'class'         => '',
					'heading'       => esc_html__('Description', DZ_TH_DOMAIN ),
					'value'         => esc_html__('Praesent fermentum nisl at ipsum facilisis viverra. Ut elementum accumsan finibus. Cras placerat lacinia mi, ac dictum ante. Donec libero enim, tincidunt sit amet venenatis id, maximus eu quam. ', DZ_TH_DOMAIN ),
					'param_name'    => 'content_box_9_element_description',
					'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
					'group'         => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'          => 'exploded_textarea',
					'holder'        => 'div',
					'class'         => '',
					'heading'       => esc_html__('Feature List', DZ_TH_DOMAIN ),
					'value'         => esc_html__('
										Suspendisse ullamcorper mollis orci in facilisis.
										Etiam orci magna, accumsan varius enim volutpat.
										Donec fringilla velit risus, in imperdiet turpis euismod quis.
					', DZ_TH_DOMAIN ),
					'param_name'    => 'content_box_9_element_feature_list',
					'description'   => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
					'group'         => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'         => 'attach_image',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Video Image', DZ_TH_DOMAIN),
					'param_name'   => 'content_box_9_element_video_image',
					'description'  => esc_html__('Enter the Video Image to show.', DZ_TH_DOMAIN),
					'group'        => esc_html__('Video', DZ_TH_DOMAIN ),
				),
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Youtube Link', DZ_TH_DOMAIN ),
					'value'        => esc_html__('https://www.youtube.com/watch?v=oanM6RTmmm4', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_9_element_youtube_link',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('Video', DZ_TH_DOMAIN ),
				),
			),
			
);


/* Content Box 10 */
$dz_sc['dz_content_box_10_element']	=	array(
        'name' 		=> esc_html__('Content Box 10', DZ_TH_DOMAIN),
        'base' 		=> 'dz_content_box_10_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Content Box 10.', DZ_TH_DOMAIN),	
        'params' 	=> array(
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
					'value'        => esc_html__('We Have Best Experience In All Our Business Services', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_10_element_title',
					'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'         => 'textfield',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Subtitle', DZ_TH_DOMAIN ),
					'value'        => esc_html__('OUR SKILLS', DZ_TH_DOMAIN ),
					'param_name'   => 'content_box_10_element_subtitle',
					'description'  => __('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
					'group'        => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'          => 'textarea',
					'holder'        => 'div',
					'class'         => '',
					'heading'       => __('Description', DZ_TH_DOMAIN ),
					'value'         => esc_html__('Proin laoreet leo vel enim gravida, at porttitor metus ultricies. Cras eu velit enim. Vivamus blandit, dolor ut aliquet rutrum, ex elit mattis sapien, non molestie felis neque et nulla. Sed euismod turpis id nibh suscipit semper. Pellentesque dapibus risus arcu.', DZ_TH_DOMAIN ),
					'param_name'    => 'content_box_10_element_description',
					'description'   => __('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
					'group'         => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'         => 'attach_image',
					'holder'       => 'div',
					'class'        => '',
					'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
					'param_name'   => 'content_box_10_element_image',
					'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
					'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
				),
				array(
					'type' => 'attach_image',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__('Background Image', DZ_TH_DOMAIN),
					'param_name' => 'content_box_10_element_bg_img',
					'description' => esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
					'group'       => esc_html__('Image', DZ_TH_DOMAIN ),
				),
				array(
					'type'          => 'dropdown',
					'holder'        => 'div',
					'class'         => '',
					'heading'       => esc_html__('Image Position', DZ_TH_DOMAIN),
					'param_name'    => 'content_box_10_element_position',
					'value'         => $position_element_options,
					'description'	=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
					'group'         => esc_html__('Image', DZ_TH_DOMAIN ),
				),
				//Group Start
				array(
					'type'      => 'param_group',
					'value'     => '',
					'param_name'=> 'content_box_10_element_item',
					'group'     => esc_html__('Progress Bar', DZ_TH_DOMAIN),
					'params'    => array(
						array(
							'type'     => 'textfield',
							'holder'   => 'div',
							'class'    => '',
							'heading'  => esc_html__('Title', DZ_TH_DOMAIN ),
							'param_name'=> 'content_box_10_element_item_title',
							'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
						),
						array(
							'type'     => 'textfield',
							'holder'   => 'div',
							'class'    => '',
							'heading'  => esc_html__('Description', DZ_TH_DOMAIN ),
							'param_name'=> 'content_box_10_element_item_number',
							'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
						),
					),
				),//Group End
        ),
			
);


/* Company Info */
$dz_sc['dz_company_info_element']	=	array(
        'name' 		=> esc_html__('Company Info', DZ_TH_DOMAIN),
        'base' 		=> 'dz_company_info_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Company Info.', DZ_TH_DOMAIN),	
        'params' 	=> array(
			//Group Start
			array(
				'type'      => 'param_group',
				'value'     => '',
				'param_name'=> 'company_info_element_item',
				'group'     => esc_html__('Company Info', DZ_TH_DOMAIN),
				'params'    => array(
                    array(
                       'type'     	=> 'textfield',
                       'holder'   	=> 'div',
                       'class'    	=> '',
                       'heading'  	=> esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name'	=> 'company_info_element_item_title',
                       'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
                    array(
                       'type'     	=> 'textarea',
                       'holder'   	=> 'div',
                       'class'    	=> '',
                       'heading'  	=> esc_html__('Description', DZ_TH_DOMAIN ),
                       'param_name'	=> 'company_info_element_item_description',
                       'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN )
					),
					array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
                        'value'       => array(
                          esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
                          esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
                          esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
                        ),
                        'param_name'  => 'company_info_element_item_icon_list',
                        'description' => esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
                
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon', DZ_TH_DOMAIN ),
                        'param_name'    => 'company_info_element_item_icon_fontawesome',
                        'settings'      => array(
                          'emptyIcon'   => true, // default true, display an 'EMPTY' icon?
                          'type'        => 'fontawesome',
                          'iconsPerPage'=> 200, // default 100, how many icons per/page to display
                        ),
                        'dependency'    => array(
                          'element'     => 'company_info_element_item_icon_list',
                          'value'       => 'fontawesome',
                        ),
                        
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
                        'param_name'    => 'company_info_element_item_icon_themify',
                        'settings'      => array(
                          'emptyIcon'   => true,
                          'type'        => 'themify',
                          'iconsPerPage'=> 200,
                        ),
                        'dependency'    => array(
                          'element'     => 'company_info_element_item_icon_list',
                          'value'       => 'themify',
                        ),
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
                        'param_name'    => 'company_info_element_item_icon_flaticon',
                        'settings'      => array(
                        'emptyIcon'     => true,
                        'type'          => 'flaticon',
                        'iconsPerPage'  => 200,
                        ),
                        'dependency'    => array(
                        'element'       => 'company_info_element_item_icon_list',
                        'value'         => 'flaticon',
                        ),
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                
					),
				),
			),//Group End
		  
			array(
				'type' 		  		=> 'checkbox',
				'heading' 			=> esc_html__( 'Show Icon Cenetr', DZ_TH_DOMAIN ),
				'param_name' 		=> 'company_info_element_section_center',
				'description'		=> esc_html__( 'Show Icon Cenetr.', DZ_TH_DOMAIN ),
				'group' 			=> esc_html__('Extra', DZ_TH_DOMAIN)
			),
        ),
			
);

/* Video Section */
$dz_sc['dz_video_section_element']	=	array(
        'name'        => esc_html__('Video Section', DZ_TH_DOMAIN),
        'base'        => 'dz_video_section_element',
        'class'       => '',
        'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon'        => 'dz-element-vc' ,
        'description' => esc_html__('Shows Video Section.', DZ_TH_DOMAIN),	
        'params'      => array(
              array(
                 'type'       => 'textfield',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Title', DZ_TH_DOMAIN ),
                 'value'      => esc_html__('Watch Us', DZ_TH_DOMAIN ),
                 'param_name' => 'video_section_element_title',
                 'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                 'group'      => esc_html__('Video', DZ_TH_DOMAIN ),
              ),
             array(
                 'type'       => 'attach_image',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Video Image', DZ_TH_DOMAIN),
                 'param_name' => 'video_section_element_video_image',
                 'description'=> esc_html__('Enter the Video Image to show.', DZ_TH_DOMAIN),
                 'group'      => esc_html__('Video', DZ_TH_DOMAIN ),
              ),
              array(
                 'type'       => 'textfield',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Youtube Link', DZ_TH_DOMAIN ),
                 'value'      => esc_html__('https://www.youtube.com/watch?v=oanM6RTmmm4', DZ_TH_DOMAIN ),
                 'param_name' => 'video_section_element_youtube_link',
                 'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                 'group'      => esc_html__('Video', DZ_TH_DOMAIN ),
              ),
        ),
			
);


/* Service Listing 1 */

$dz_sc['dz_service_listing_1_element']	=	array(
		'name'        => esc_html__('Service Listing 1', DZ_TH_DOMAIN),
		'base'        => 'dz_service_listing_1_element',
		'class'       => '',
		'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
		'icon'        => 'dz-element-vc' ,
		'description' => esc_html__('Shows Post Listing style 1.', DZ_TH_DOMAIN),	
		'params' => array(
				array(
					'type'			 =>	'textfield',
					'heading' 		=>	esc_html__('Title', DZ_TH_DOMAIN ),
					'param_name'	=>	'service_listing_1_element_title',
					'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'       => 'textfield',
					'holder'     => 'div',
					'class'      => '',
					'heading'    => esc_html__('Subtitle', DZ_TH_DOMAIN ),
					'value'      => esc_html__('Services', DZ_TH_DOMAIN ),
					'param_name' => 'service_listing_1_element_subtitle',
					'description'=> esc_html__('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
					'group'      => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					'type'			=>	'textarea',
					'heading' 		=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
					'param_name'	=>	'service_listing_1_element_description',
					'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 			=> 'dropdown_multi', 
					'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
					'param_name'	=> 'service_listing_1_element_posts_in_categories',
					'value' 		=>  $service_categories_options,
					'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
					'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'       => 'attach_image',
					'holder'     => 'div',
					'class'      => '',
					'heading'    => esc_html__('Background Image', DZ_TH_DOMAIN),
					'param_name' => 'service_listing_1_element_bg_img',
					'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
					'group'      => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
					 'type' 		=> 'checkbox',
					 'heading' 	    => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
					 'param_name' 	=> 'service_listing_1_element_only_featured_posts',
					 'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
					 'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
				),
				
				array(
					'type'			=>	'dropdown',
					'heading'		=>	esc_html__('Style', DZ_TH_DOMAIN),
					'param_name'	=>	'service_listing_1_element_style',
					'value'		    =>	$service_element_style,				
					'description'	=>	esc_html__('Select Style.', DZ_TH_DOMAIN),
					'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
				  ),
				
				array(
					'type'			=>	'dropdown',
					'heading'		=>	esc_html__('Pagination Style', DZ_TH_DOMAIN ),
					'param_name'	=>	'service_listing_1_element_pagination_style',
					'description'	=>	esc_html__('You can choose pagination style from here.', DZ_TH_DOMAIN ),
					'value' 		=> $pagination_options,
					'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		  	=>	'textfield',
					'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
					'param_name'	=>	'service_listing_1_element_no_of_posts',
					'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
					'value'		  	=> '10',
					'group' 	  	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'			=>	'textfield',
					'heading'		=>	esc_html__('Title Text Limit', DZ_TH_DOMAIN ),
					'param_name'	=>	'service_listing_1_element_text_limit',
					'description'	=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
					'value'			=> 	'5',
					'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				
				array(
					 'type' 		=> 'dropdown',
					 'heading' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
					 'param_name' 	=> 'service_listing_1_element_image_preference',
					 'value'		=> $image_preference_options,
					'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'			=>	'dropdown',
					'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
					'param_name'	=>	'service_listing_1_element_orderby',
					'value'			=>	$orderby_options,
					'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'			=>	'dropdown',
					'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
					'param_name'	=>	'service_listing_1_element_order',
					'value'			=>	$order_options,			
					'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
					'param_name'=> 'service_listing_1_element_section_padding',
					'value'		=> $section_padding_options,
					'group' 	=> esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type'			=>	'dropdown',
					'heading'		=>	esc_html__('Select Column', DZ_TH_DOMAIN),
					'param_name'	=>	'service_listing_1_element_cols',
					'value'		    =>	$column_options,				
					'description'	=>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
					'group'       	=> esc_html__('Extra', DZ_TH_DOMAIN)
				),
				
				array(
					'type' 		=> 'checkbox',
					'heading' 	=> esc_html__( 'Show Section', DZ_TH_DOMAIN ),
					'param_name'=> 'service_listing_1_element_section_showpartner',
					'dependency'    => array(
					  'element'     => 'service_listing_1_element_style',
					  'value'       => 'style_1',
					),
					'description'=> esc_html__( 'Show Section.', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('Partners', DZ_TH_DOMAIN)
				),
				
				//Group Start
				array(
					'type' 		=> 'param_group',
					'value' 	=> '',
					'param_name'=> 'service_listing_1_partners_1_element_item',
					'dependency'    => array(
					  'element'     => 'service_listing_1_element_style',
					  'value'       => 'style_1',
					),
					'group' 	=> esc_html__('Partners', DZ_TH_DOMAIN),
					'params' 	=> array(
						array(
							'type' 		=> 'attach_image',
							'holder' 	=> 'div',
							'class' 	=> '',
							'heading' 	=> esc_html__('Partner Image', DZ_TH_DOMAIN),
							'param_name'=> 'service_listing_1_partners_1_element_item_main_img',
							'description'=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
						),
						array(
							'type' 		=> 'attach_image',
							'holder' 	=> 'div',
							'class' 	=> '',
							'heading' 	=> esc_html__('Partner background Image', DZ_TH_DOMAIN),
							'param_name'=> 'service_listing_1_partners_1_element_item_back_img',
							'description'=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
						),
				  ),
			  ),//Group End
			
		),

	);



/* Service Box 1 */
$dz_sc['dz_service_box_1_element']	=	array(
        'name' 			=> esc_html__('Service Box 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_service_box_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Service Box 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type'       => 'textfield',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Title', DZ_TH_DOMAIN ),
                'value'      => esc_html__('Provide Awesome Service To You', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_1_element_title',
                'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type'       => 'textfield',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'value'      => esc_html__('Services', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_1_element_subtitle',
                'description'=> esc_html__('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type'       => 'textarea',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Description', DZ_TH_DOMAIN ),
                'value'      => esc_html__('Morbi sed lacus nec risus finibus feugiat et fermentum nibh. Pellentesque vitae ante at elit fringilla ac at purus.', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_1_element_description',
                'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'service_box_1_element_posts_in_categories',
                'value' 		=>  $service_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'       => 'attach_image',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Background Image', DZ_TH_DOMAIN),
                'param_name' => 'service_box_1_element_bg_img',
                'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'type' 		 => 'checkbox',
				'heading' 	 => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' => 'service_box_1_element_only_featured_posts',
				'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 	 => esc_html__('General', DZ_TH_DOMAIN)
			),
            array(
                'type'		  =>	'textfield',
                'heading'	  =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'  =>	'service_box_1_element_no_of_posts',
                'description' =>	esc_html__('Enter no. of Service to show per page.', DZ_TH_DOMAIN ),
                'value'		  => '10',
                'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			
            array(
                'type'		  =>	'textfield',
                'heading'	  =>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'  =>	'service_box_1_element_text_limit',
                'description' =>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'		  => 	'5',
                'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		  =>	'dropdown',
                'heading'	  =>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'  =>	'service_box_1_element_orderby',
                'value'		  =>	$orderby_options,
                'description' =>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		 =>	'dropdown',
                'heading'    =>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name' =>	'service_box_1_element_order',
                'value'		 =>	$order_options,			
                'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	 =>  esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'=> 'service_box_1_element_section_background',
				'value'		=> $section_background_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'=> 'service_box_1_element_section_padding',
				'value'		=> $section_padding_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 		=> 'checkbox',
				'heading' 	=> esc_html__( 'Show Section', DZ_TH_DOMAIN ),
				'param_name'=> 'service_box_1_element_section_showpartner',
				'description'=> esc_html__( 'Show Section.', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
		  
			//Group Start
			array(
				'type' 		=> 'param_group',
				'value' 	=> '',
				'param_name'=> 'service_box_1_partners_1_element_item',
				'group' 	=> esc_html__('Partners', DZ_TH_DOMAIN),
				'params' 	=> array(
					array(
						'type' 		=> 'attach_image',
						'holder' 	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Partner Image', DZ_TH_DOMAIN),
						'param_name'=> 'service_box_1_partners_1_element_item_main_img',
						'description'=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
					),
					array(
						'type' 		=> 'attach_image',
						'holder' 	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Partner background Image', DZ_TH_DOMAIN),
						'param_name'=> 'service_box_1_partners_1_element_item_back_img',
						'description'=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
					),
              ),
          ),//Group End
        ),
			
);

/* Service Box 2 */
$dz_sc['dz_service_box_2_element']	=	array(
        'name' 		=> esc_html__('Service Box 2', DZ_TH_DOMAIN),
        'base' 		=> 'dz_service_box_2_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Service Box 2.', DZ_TH_DOMAIN),	
        'params' 	=> array(
            array(
                'type'       => 'textfield',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Title', DZ_TH_DOMAIN ),
                'value'      => esc_html__('We Are Providing Digital Services', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_2_element_title',
                'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type'       => 'textfield',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'value'      => esc_html__('OUR SERVICES', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_2_element_subtitle',
                'description'=> esc_html__('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
                'type'       => 'textarea',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Description', DZ_TH_DOMAIN ),
                'value'      => esc_html__('', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_2_element_description',
                'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 		 => 'dropdown_multi', 
                'heading' 	 => esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_2_element_posts_in_categories',
                'value' 	 =>  $service_categories_options,
                'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 	 => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                 'type'       => 'attach_image',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Background Image', DZ_TH_DOMAIN),
                 'param_name' => 'service_box_2_element_bg_img',
                 'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
                 'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'type' 		 => 'checkbox',
				'heading' 	 => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' => 'service_box_2_element_only_featured_posts',
				'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 	 => esc_html__('General', DZ_TH_DOMAIN)
			),
            array(
                'type'		  =>	'textfield',
                'heading'	  =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'  =>	'service_box_2_element_no_of_posts',
                'description' =>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		  => '10',
                'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 		  => 'dropdown',
				'heading' 	  => esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'  => 'service_box_2_element_image_preference',
				'value'		  => $image_preference_options,
				'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
			),
            array(
                'type'		  =>	'textfield',
                'heading'	  =>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'  =>	'service_box_2_element_text_limit',
                'description' =>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'		  => 	'5',
                'group' 	  =>   esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		  =>	'dropdown',
                'heading'	  =>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'  =>	'service_box_2_element_orderby',
                'value'		  =>	$orderby_options,
                'description' =>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		  =>	'dropdown',
                'heading'	  =>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'  =>	'service_box_2_element_order',
                'value'		  =>	$order_options,			
                'description' =>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	  =>  esc_html__('Advance', DZ_TH_DOMAIN)
            ),
         ),
			
);


/* Service Box 3 */
$dz_sc['dz_service_box_3_element']	=	array(
        'name' 			=> esc_html__('Service Box 3', DZ_TH_DOMAIN),
        'base' 			=> 'dz_service_box_3_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Service Box 3.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type'       => 'textfield',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Title', DZ_TH_DOMAIN ),
                'value'      => esc_html__('Our Speciallization', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_3_element_title',
                'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type'       => 'textarea',
                'holder'     => 'div',
                'class'      => '',
                'heading'    => esc_html__('Description', DZ_TH_DOMAIN ),
                'value'      => esc_html__('Morbi sed lacus nec risus finibus feugiat et fermentum nibh. Pellentesque vitae ante at elit fringilla ac at purus.', DZ_TH_DOMAIN ),
                'param_name' => 'service_box_3_element_description',
                'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'service_box_3_element_posts_in_categories',
                'value' 		=>  $service_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' 	=> 'service_box_3_element_only_featured_posts',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
            array(
                'type'		    =>	'textfield',
                'heading'	    =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'  	=>	'service_box_3_element_no_of_posts',
                'description' 	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		    => '10',
                'group' 	    => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
	
            array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'	=>	'service_box_3_element_text_limit',
                'description'	=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'			=> 	'5',
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'	=>	'service_box_3_element_orderby',
                'value'			=>	$orderby_options,
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'	=>	'service_box_3_element_order',
                'value'			=>	$order_options,			
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
            ),
         ),
			
);

/* SERVICE DETAIL 1 */		
 $dz_sc['dz_service_detail_1_element']	=	array(
      'name' 		=> esc_html__('Service Detail', DZ_TH_DOMAIN),
      'base' 		=> 'dz_service_detail_1_element',
      'class' 		=> '',
      'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
      'icon' 		=> 'dz-element-vc' ,
      'description' => esc_html__('Shows service detail 1 element style.', DZ_TH_DOMAIN),
      'params' 		=> array(
            
            array(
				'type'			=>	'textfield',
				'holder'    	=> 'div',
				'heading'		=>	esc_html__('Section Heading', DZ_TH_DOMAIN ),
				'param_name'	=>	'service_detail_1_element_title',
				'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group'     	=> esc_html__('General', DZ_TH_DOMAIN),
            ),
            array(
				'type'			=>	'textarea',
				'holder' 		=> 'div',
				'heading'		=>	esc_html__('Section description', DZ_TH_DOMAIN ),
				'param_name'	=>	'service_detail_1_element_description',
				'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN),
            ),
            array(
				'type'			=>	'textfield',
				'holder'    	=> 'div',
				'heading'		=>	esc_html__('Section Heading', DZ_TH_DOMAIN ),
				'param_name'	=>	'service_detail_1_element_content_title',
				'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group'     	=> esc_html__('General', DZ_TH_DOMAIN),
            ),
             array(
                'type'    		=> 'textarea',
                'holder' 		=> 'div',
                'class'   		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'value'   		=> esc_html__("Lorem Ipsum is simply dummy text of the printing.,Lorem Ipsum has been the industry's standard dummy.,when an unknown printer took a galley of type and.,It has survived not only five centuries, but also.,Recently with desktop publishing software like Aldus.,Lorem Ipsum is simply dummy text of the printing.", DZ_TH_DOMAIN ),
                'param_name' 	=> 'service_detail_1_element_content_description',
                'description'	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'      	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'type'       	=> 'attach_images',
				'holder'     	=> 'div',
				'class'      	=> '',
				'heading'    	=> esc_html__('Image', DZ_TH_DOMAIN),
				'param_name' 	=> 'service_detail_1_element_images',
				'description'	=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
				'group'      	=> esc_html__('Image', DZ_TH_DOMAIN ),
            ),
			array(
				'type'       	=> 'attach_image',
				'holder'     	=> 'div',
				'class'      	=> '',
				'heading'    	=> esc_html__('Image', DZ_TH_DOMAIN),
				'param_name' 	=> 'service_detail_1_element_image',
				'description'	=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
				'group'      	=> esc_html__('Image', DZ_TH_DOMAIN ),
            ),
            array(
                'type'      	=> 'dropdown',
                'label'     	=> esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
                'param_name'	=> 'service_detail_1_element_selected_sidebar',
                'description'	=> esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
                'value'		 	=> 	$selected_sidebar_options,
                'group'      	=> esc_html__('Sidebar', DZ_TH_DOMAIN),
              ),
              array(
                'type'			=>	'dropdown',
                'label'			=>	esc_html__('Sidebar Selection', DZ_TH_DOMAIN),
                'param_name'	=>	'service_detail_1_element_sidebar_layout',
                'description'	=>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
                'value'			=> 	$sidebar_layout_options,
                'group'       	=> esc_html__('Sidebar', DZ_TH_DOMAIN),
              ),
          ),
      );

/* Counter Box 1 */
$dz_sc['dz_counter_box_1_element']	=	array(
        'name'        => esc_html__('Counter Box 1', DZ_TH_DOMAIN),
        'base'        => 'dz_counter_box_1_element',
        'class'       => '',
        'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon'        => 'dz-element-vc' ,
        'description' => esc_html__('Shows Counter Box 1.', DZ_TH_DOMAIN),	
        'params'      => array(
      
			//Group Start
			array(
				'type'       => 'param_group',
				'value'      => '',
				'param_name' => 'counter_box_1_element_item',
				'group'      => esc_html__('Counter', DZ_TH_DOMAIN),
				'params'     => array(
					array(
                       'type'         => 'textfield',
                       'holder'       => 'div',
                       'class'        => '',
                       'heading'      => esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name'   => 'counter_box_1_element_item_title',
                       'description'  => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                       'type'         => 'textfield',
                       'holder'       => 'div',
                       'class'        => '',
                       'heading'      => esc_html__('Number', DZ_TH_DOMAIN ),
                       'param_name'   => 'counter_box_1_element_item_number',
                       'description'  => esc_html__('Enter The Number to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                       'type'         => 'textfield',
                       'holder'       => 'div',
                       'class'        => '',
                       'heading'      => esc_html__('Unit', DZ_TH_DOMAIN ),
                       'param_name'   => 'counter_box_1_element_item_unit',
                       'description'  => esc_html__('Enter The Number to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
                        'value'       => array(
                          esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
                          esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
                          esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
                        ),
                        'param_name'  => 'counter_box_1_element_item_icon_list',
                        'description' => esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
                
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => __( 'Icon', DZ_TH_DOMAIN ),
                        'param_name'    => 'counter_box_1_element_item_icon_fontawesome',
                        'settings'      => array(
                          'emptyIcon'   => true, // default true, display an 'EMPTY' icon?
                          'type'        => 'fontawesome',
                          'iconsPerPage'=> 200, // default 100, how many icons per/page to display
                        ),
                        'dependency'    => array(
                          'element'     => 'counter_box_1_element_item_icon_list',
                          'value'       => 'fontawesome',
                        ),
                        
                        'description'   => __( 'Select icon from library.', DZ_TH_DOMAIN ),
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
                        'param_name'    => 'counter_box_1_element_item_icon_themify',
                        'settings'      => array(
                          'emptyIcon'   => true,
                          'type'        => 'themify',
                          'iconsPerPage'=> 200,
                        ),
                        'dependency'    => array(
                          'element'     => 'counter_box_1_element_item_icon_list',
                          'value'       => 'themify',
                        ),
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
                        'param_name'    => 'counter_box_1_element_item_icon_flaticon',
                        'settings'      => array(
                        'emptyIcon'     => true,
                        'type'          => 'flaticon',
                        'iconsPerPage'  => 200,
                        ),
                        'dependency'    => array(
                        'element'       => 'counter_box_1_element_item_icon_list',
                        'value'         => 'flaticon',
                        ),
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                
					),
				),
			),//Group End
        ),
			
);

/* Counter Box 2 */
$dz_sc['dz_counter_box_2_element']	=	array(
        'name' 			=> esc_html__('Counter Box 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_counter_box_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Counter Box 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
               'type'       => 'attach_image',
               'holder'     => 'div',
               'class'      => '',
               'heading'    => esc_html__('Background Image', DZ_TH_DOMAIN),
               'param_name' => 'counter_box_2_element_bg_img',
               'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
               'group'      => esc_html__('General', DZ_TH_DOMAIN ),
			),
			//Group Start
			array(
				'type'      => 'param_group',
				'value'     => '',
				'param_name'=> 'counter_box_2_element_item',
				'group'     => esc_html__('Counter', DZ_TH_DOMAIN),
				'params'    => array(
					array(
                       'type'       => 'textfield',
                       'holder'     => 'div',
                       'class'      => '',
                       'heading'    => esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name' => 'counter_box_2_element_item_title',
                       'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                       'type'       => 'textfield',
                       'holder'     => 'div',
                       'class'      => '',
                       'heading'    => esc_html__('Number', DZ_TH_DOMAIN ),
                       'param_name' => 'counter_box_2_element_item_number',
                       'description'=> esc_html__('Enter The Number to Show.', DZ_TH_DOMAIN )
					),
					array(
                       'type'       => 'textfield',
                       'holder'     => 'div',
                       'class'      => '',
                       'heading'    => esc_html__('Unit', DZ_TH_DOMAIN ),
                       'param_name' => 'counter_box_2_element_item_unit',
                       'description'=> esc_html__('Enter The Unit to Show.', DZ_TH_DOMAIN )
					),
					array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
                        'value'       => array(
                          esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
                          esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
                          esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
                        ),
                        'param_name'  => 'counter_box_2_element_item_icon_list',
                        'description' => esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon', DZ_TH_DOMAIN ),
                        'param_name'    => 'counter_box_2_element_item_icon_fontawesome',
                        'settings'      => array(
                          'emptyIcon'   => true, // default true, display an 'EMPTY' icon?
                          'type'        => 'fontawesome',
                          'iconsPerPage'=> 200, // default 100, how many icons per/page to display
                        ),
                        'dependency'    => array(
                          'element'     => 'counter_box_2_element_item_icon_list',
                          'value'       => 'fontawesome',
                        ),
                        
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
                        'param_name'    => 'counter_box_2_element_item_icon_themify',
                        'settings'      => array(
                          'emptyIcon'   => true,
                          'type'        => 'themify',
                          'iconsPerPage'=> 200,
                        ),
                        'dependency'    => array(
                          'element'     => 'counter_box_2_element_item_icon_list',
                          'value'       => 'themify',
                        ),
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                
					),
					array(
                        'type'          => 'iconpicker',
                        'heading'       => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
                        'param_name'    => 'counter_box_2_element_item_icon_flaticon',
                        'settings'      => array(
                        'emptyIcon'     => true,
                        'type'          => 'flaticon',
                        'iconsPerPage'  => 200,
                        ),
                        'dependency'    => array(
                        'element'       => 'counter_box_2_element_item_icon_list',
                        'value'         => 'flaticon',
                        ),
                        'description'   => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
                
					),
              
				),
			),//Group End
		),
			
);

/* Portfolio 1 */
$dz_sc['dz_portfolio_1_element']	=	array(
        'name' 		=> esc_html__('Portfolio 1', DZ_TH_DOMAIN),
        'base' 		=> 'dz_portfolio_1_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Portfolio 1.', DZ_TH_DOMAIN),	
        'params' 	=> array(
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_1_element_title',
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_1_element_subtitle',
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'textarea',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_1_element_description',
                'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'portfolio_1_element_posts_in_categories',
                'value' 		=>  $portfolio_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
                'type'		  	=>	'textfield',
                'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'	=>	'portfolio_1_element_no_of_posts',
                'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		  	=> '10',
                'group' 	  	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'	=>	'portfolio_1_element_text_limit',
                'description'	=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'			=> 	'5',
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'	=>	'portfolio_1_element_orderby',
                'value'			=>	$orderby_options,
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'	=>	'portfolio_1_element_order',
                'value'			=>	$order_options,			
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 		  	=> 'checkbox',
				'heading' 		=> esc_html__( 'Show Permalink', DZ_TH_DOMAIN ),
				'param_name' 	=> 'portfolio_1_element_show_readmore',
				'description'	=> esc_html__( 'Show Permalink.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
		  
			array(
				'type' 		  	=> 'checkbox',
				'heading' 		=> esc_html__( 'Show Large Image Link', DZ_TH_DOMAIN ),
				'param_name' 	=> 'portfolio_1_element_show_largeimagelink',
				'description'	=> esc_html__( 'Show Image Link.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
	),
			
);

/* Portfolio 2 */
$dz_sc['dz_portfolio_2_element']	=	array(
        'name' 			=> esc_html__('Portfolio 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_portfolio_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Portfolio 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_2_element_title',
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_2_element_subtitle',
                'description' 	=> esc_html__	('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'textarea',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_2_element_description',
                'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'portfolio_2_element_posts_in_categories',
                'value' 		=>  $portfolio_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'param_name'    => 'portfolio_2_element_bg_img',
				'heading'       => 'Background Image',
				'type'          => 'attach_image',  // USAGE ATTACH_IMAGE TYPE
				'description'   => 'Image Description',
				'group'         => esc_html__('General', DZ_TH_DOMAIN),
            ),
			array(
                'type'		  	=>	'textfield',
                'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'	=>	'portfolio_2_element_no_of_posts',
                'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		 	=> '10',
                'group' 	  	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'	=>	'portfolio_2_element_text_limit',
                'description'	=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'			=> 	'5',
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'	=>	'portfolio_2_element_orderby',
                'value'			=>	$orderby_options,
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'	=>	'portfolio_2_element_order',
                'value'			=>	$order_options,			
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 		  	=> 'checkbox',
				'heading' 		=> esc_html__( 'Show Author', DZ_TH_DOMAIN ),
				'param_name' 	=> 'portfolio_2_element_show_author',
				'description'	=> esc_html__( 'Show Image Link.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Show Permalink', DZ_TH_DOMAIN ),
				'param_name' 	=> 'portfolio_2_element_show_readmore',
				'description'	=> esc_html__( 'Show Permalink.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
		),
			
);


/* Portfolio 3 */
$dz_sc['dz_portfolio_3_element']	=	array(
        'name' 			=> esc_html__('Portfolio 3', DZ_TH_DOMAIN),
        'base' 			=> 'dz_portfolio_3_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Portfolio 3.', DZ_TH_DOMAIN),	
        'params' => array(
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'	=> 'portfolio_3_element_title',
                'description'	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            
            array(
                'type' 			=> 'textarea',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_3_element_description',
                'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'      	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'portfolio_3_element_posts_in_categories',
                'value' 		=>  $portfolio_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
                'type'		  	=>	'textfield',
                'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'	=>	'portfolio_3_element_no_of_posts',
                'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		  	=> '10',
                'group' 	 	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'	=>	'portfolio_3_element_text_limit',
                'description'	=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'			=> 	'5',
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'	=>	'portfolio_3_element_orderby',
                'value'			=>	$orderby_options,
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'	=>	'portfolio_3_element_order',
                'value'			=>	$order_options,			
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
			),
          
			array(
				'type' 		  	=> 'checkbox',
				'heading' 		=> esc_html__( 'Show Permalink', DZ_TH_DOMAIN ),
				'param_name' 	=> 'portfolio_3_element_show_readmore',
				'description'	=> esc_html__( 'Show Permalink.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
	),
			
);


/* Portfolio 3 */
$dz_sc['dz_portfolio_detail_1_element']	=	array(
        'name' 			=> esc_html__('Portfolio Detail 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_portfolio_detail_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Portfolio Detail 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_title',
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_subtitle',
                'description' 	=> esc_html__('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            
            array(
                'type' 			=> 'textarea',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_description',
                'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
                'type' 			=> 'textarea',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_description2',
				'value'			=> 'We support programs that create advancement opportunities for people.,Get a view of events and trends. Be updated on our recent news.,Finally, it all comes down to people. Creating a winning team.,Get a view of events and trends. Be updated on our recent news.',
                'description' 	=> esc_html__('Enter The Section Coma Seprated Description to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Client Name', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_client_title',
				'value'			=> esc_html__('Tata Chemicals', DZ_TH_DOMAIN ),
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Date', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_client_date',
				'value'			=> esc_html__('14 July, 2021', DZ_TH_DOMAIN ),
                'description' 	=> esc_html__('Enter The Date to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Website Link', DZ_TH_DOMAIN ),
                'param_name' 	=> 'portfolio_detail_1_element_client_website',
				'value'			=> esc_html__('info@hugebinary.com', DZ_TH_DOMAIN ),
                'description' 	=> esc_html__('Enter The Website Link to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
				'param_name'    => 'portfolio_detail_1_element_images',
				'heading'       => esc_html__('Multiple Image', DZ_TH_DOMAIN ),
				'type'          => 'attach_images',  // USAGE ATTACH_IMAGE TYPE
				'description'   => esc_html__('Image Description', DZ_TH_DOMAIN ),
				'group'         => esc_html__('General', DZ_TH_DOMAIN),
			),
	),
			
);

/* Testimonial Slider */
$dz_sc['dz_testimonial_slider_element']	=	array(
        'name'			=> esc_html__('Testimonial Slider', DZ_TH_DOMAIN),
        'base' 			=> 'dz_testimonial_slider_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Testimonial Slider.', DZ_TH_DOMAIN),	
        'params' 		=> array(
              array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_element_title',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
              ),
              array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_element_subtitle',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
              ),
              array(
				'type'		=>	'textarea',
				'heading'	=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
				'param_name'=>	'testimonial_slider_element_description',
				'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group'     => esc_html__('General', DZ_TH_DOMAIN)
              ),
			array(
				'param_name' => 'testimonial_slider_element_bg_img',
				'heading'    => 'Background Image',
				'type'       => 'attach_image',  // USAGE ATTACH_IMAGE TYPE
				'description'=> 'Image Description',
				'group'      => esc_html__('General', DZ_TH_DOMAIN),
			),
            array(
                'type'		=>	'dropdown_multi',
                'heading'	=>	esc_html__('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_element_posts_in_categories',
                'value' 	=>  $testimonials_categories_options,
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
            ),
			
			array(
				'type' 		=> 'checkbox',
				'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name'=> 'testimonial_slider_element_only_featured_posts',
				'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			
			array(
				'type'		=>	'dropdown',
				'heading'	=>	esc_html__('Style', DZ_TH_DOMAIN),
				'param_name'=>	'testimonial_slider_element_style',
				'value'		=>	$testimonial_element_style,				
				'description'=>	esc_html__('Select Style.', DZ_TH_DOMAIN),
				'group'     => esc_html__('Advance', DZ_TH_DOMAIN)
			),
              
            array(
				'type'		=>	'textfield',
				'heading'	=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
				'param_name'=>	'testimonial_slider_element_text_limit',
				'description'=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
				'value'		=> 	'7',
				'group'     => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		 =>	'textfield',
                'heading'	 =>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name' =>	'testimonial_slider_element_no_of_posts',
                'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		 => '10',
                'group'      => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'=> 'testimonial_slider_element_image_preference',
				'value'		=> $image_preference_options,
				'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
            array(
				'type'		 =>	'dropdown',
				'heading'	 =>	esc_html__('Order By', DZ_TH_DOMAIN),
				'param_name' =>	'testimonial_slider_element_orderby',
				'value'		 =>	$cat_orderby_options,
				'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'      => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type'		 =>	'dropdown',
				'heading'	 =>	esc_html__('Order', DZ_TH_DOMAIN),
				'param_name' =>	'testimonial_slider_element_order',
				'value'		 =>	$order_options,			
				'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'=> 'testimonial_slider_element_section_background',
				'value'		=> $section_background_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'=> 'testimonial_slider_element_section_padding',
				'value'		=> $section_padding_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
        ), 
);

/* Testimonial Slider 1 */
$dz_sc['dz_testimonial_slider_1_element']	=	array(
        'name' 		=> esc_html__('Testimonial Slider 1', DZ_TH_DOMAIN),
        'base' 		=> 'dz_testimonial_slider_1_element',
        'class' 	=> '',
        'category'	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Testimonial 1.', DZ_TH_DOMAIN),	
        'params' 	=> array(
			array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_1_element_title',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_1_element_subtitle',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type'			=>	'textarea',
				'heading'		=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
				'param_name'	=>	'testimonial_slider_1_element_description',
				'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'param_name' 	=> 'testimonial_slider_1_element_bg_img',
				'heading'    	=> 'Background Image',
				'type'       	=> 'attach_image',  // USAGE ATTACH_IMAGE TYPE
				'description'	=> 'Image Description',
				'group'      	=> esc_html__('General', DZ_TH_DOMAIN),
			),
			array(
                'type'			=>	'dropdown_multi',
                'heading'		=>	esc_html__('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_1_element_posts_in_categories',
                'value' 		=>  $testimonials_categories_options,
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' 	=> 'testimonial_slider_1_element_only_featured_posts',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
              
            array(
				'type'			=>	'textfield',
				'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
				'param_name'	=>	'testimonial_slider_1_element_text_limit',
				'description'	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
				'value'			=> 	'7',
				'group'     	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		 	=>	'textfield',
                'heading'	 	=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name' 	=>	'testimonial_slider_1_element_no_of_posts',
                'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		 	=> '10',
                'group'      	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_1_element_image_preference',
				'value'			=> $image_preference_options,
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
            array(
				'type'		 	=>	'dropdown',
				'heading'	 	=>	esc_html__('Order By', DZ_TH_DOMAIN),
				'param_name' 	=>	'testimonial_slider_1_element_orderby',
				'value'		 	=>	$cat_orderby_options,
				'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'      	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type'		 	=>	'dropdown',
				'heading'	 	=>	esc_html__('Order', DZ_TH_DOMAIN),
				'param_name' 	=>	'testimonial_slider_1_element_order',
				'value'		 	=>	$order_options,			
				'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_1_element_section_background',
				'value'			=> $section_background_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_1_element_section_padding',
				'value'			=> $section_padding_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
        ), 
);

/* Testimonial Slider 2 */
$dz_sc['dz_testimonial_slider_2_element']	=	array(
        'name' 		=> esc_html__('Testimonial Slider 2', DZ_TH_DOMAIN),
        'base' 		=> 'dz_testimonial_slider_2_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Testimonial Slider 2.', DZ_TH_DOMAIN),	
        'params' 	=> array(
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_2_element_title',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_2_element_subtitle',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_2_element_description',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'dropdown_multi',
                'heading'	=>	esc_html__('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_2_element_posts_in_categories',
                'value' 	=>  $testimonials_categories_options,
                'group'     => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
				'param_name' => 'testimonial_slider_2_element_bg_img',
				'heading'    => 'Background Image',
				'type'       => 'attach_image',  // USAGE ATTACH_IMAGE TYPE
				'description'=> 'Image Description',
				'group'      => esc_html__('General', DZ_TH_DOMAIN),
            ),
			
			array(
				'type' 		=> 'checkbox',
				'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' => 'testimonial_slider_2_element_only_featured_posts',
				'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
			),
          
            array(
				'type'		=>	'textfield',
				'heading'	=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
				'param_name'=>	'testimonial_slider_2_element_text_limit',
				'description'=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
				'value'		=> 	'7',
				'group'     => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'=>	'testimonial_slider_2_element_no_of_posts',
                'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'	    => '10',
                'group'     => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'=> 'testimonial_slider_2_element_image_preference',
				'value'		=> $image_preference_options,
				'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
            array(
				'type'		=>	'dropdown',
				'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
				'param_name'=>	'testimonial_slider_2_element_orderby',
				'value'		=>	$cat_orderby_options,
				'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'     => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type'		=>	'dropdown',
				'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
				'param_name'=>	'testimonial_slider_2_element_order',
				'value'		=>	$order_options,			
				'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'     => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
        ), 
);

/* Testimonial Slider 3 */
$dz_sc['dz_testimonial_slider_3_element']	=	array(
        'name' 			=> esc_html__('Testimonial Slider 3', DZ_TH_DOMAIN),
        'base' 			=> 'dz_testimonial_slider_3_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Testimonial 3.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_3_element_title',
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'textarea',
                'heading'		=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_3_element_description',
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'param_name'	=> 'testimonial_slider_3_element_bg_img',
                'heading'   	=> 'Background Image',
                'type'      	=> 'attach_image',  // USAGE ATTACH_IMAGE TYPE
                'description'	=> esc_html__('Image Description', DZ_TH_DOMAIN ),
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN),
            ),
            array(
                'type'			=>	'dropdown_multi',
                'heading'		=>	esc_html__('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_3_element_posts_in_categories',
                'value' 		=>  $testimonials_categories_options,
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' 	=> 'testimonial_slider_3_element_only_featured_posts',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
            array(
				'type'			=>	'textfield',
				'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
				'param_name'	=>	'testimonial_slider_3_element_text_limit',
				'description' 	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
				'value'			=> 	'7',
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_3_element_no_of_posts',
                'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'			=> '10',
                'group'       	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_3_element_image_preference',
				'value'			=> $image_preference_options,
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
            array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
				'param_name'	=>	'testimonial_slider_3_element_orderby',
				'value'		    =>	$cat_orderby_options,
				'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
              'type'			=>	'dropdown',
              'heading'			=>	esc_html__('Order', DZ_TH_DOMAIN),
              'param_name'		=>	'testimonial_slider_3_element_order',
              'value'		    =>	$order_options,			
              'description'	 	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
              'group'         	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			  
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_3_element_section_background',
				'value'			=> $section_background_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_3_element_section_padding',
				'value'			=> $section_padding_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
        ), 
);


/* Testimonial Slider 4 */
$dz_sc['dz_testimonial_slider_4_element']	=	array(
        'name' 			=> esc_html__('Testimonial Slider 4', DZ_TH_DOMAIN),
        'base' 			=> 'dz_testimonial_slider_4_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Testimonial 4.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_4_element_title',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_4_element_subtitle',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'param_name'    => 'testimonial_slider_4_element_bg_img',
                'heading'       => 'Background Image',
                'type'          => 'attach_image',  // USAGE ATTACH_IMAGE TYPE
                'description'   => 'Image Description',
                'group'         => esc_html__('General', DZ_TH_DOMAIN),
            ),
            array(
                'type'			=>	'dropdown_multi',
                'heading'		=>	esc_html__('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_4_element_posts_in_categories',
                'value' 		=>  $testimonials_categories_options,
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' 	=> 'testimonial_slider_4_element_only_featured_posts',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
            array(
				'type'			=>	'textfield',
				'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
				'param_name'	=>	'testimonial_slider_4_element_text_limit',
				'description' 	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
				'value'			=> 	'7',
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'	=>	'testimonial_slider_4_element_no_of_posts',
                'description'	=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'			=> '10',
                'group'       	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'	=> 'testimonial_slider_4_element_image_preference',
				'value'			=> $image_preference_options,
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
            array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
				'param_name'	=>	'testimonial_slider_4_element_orderby',
				'value'		    =>	$cat_orderby_options,
				'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
				'param_name'	=>	'testimonial_slider_4_element_order',
				'value'		    =>	$order_options,			
				'description'   =>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group'         => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
        ), 
);

/* Contact Form 1 */
$dz_sc['dz_contact_form_1_element']	=	array(
        'name' 			=> esc_html__('Contact Form 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_contact_form_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Contact Form 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
				'type'			=>	'textfield',
				'heading'		=>	esc_html__('Title', DZ_TH_DOMAIN ),
				'param_name'	=>	'contact_form_1_element_title',
				'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
				'type'			=>	'textfield',
				'heading'		=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'param_name'	=>	'contact_form_1_element_subtitle',
				'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
				'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
               'type'         	=> 'attach_image',
               'holder'       	=> 'div',
               'class'        	=> '',
               'heading'      	=> esc_html__('Background Image', DZ_TH_DOMAIN),
               'param_name'   	=> 'contact_form_1_element_bg_img',
               'description'  	=> esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
               'group'        	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
               'type'         	=> 'attach_image',
               'holder'       	=> 'div',
               'class'        	=> '',
               'heading'      	=> esc_html__('Image', DZ_TH_DOMAIN),
               'param_name'   	=> 'contact_form_1_element_image',
               'description'  	=> esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
               'group'        	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Contact Form', DZ_TH_DOMAIN ),
				'param_name'	=>	'contact_form_1_element_contact_form',
				'description'	=>	esc_html__('Choose Contact Form to show.', DZ_TH_DOMAIN ),
				'value'		    =>  $contact_form_options,
				'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
	),
			
);


/* Contact Form 2 */
$dz_sc['dz_contact_form_2_element']	=	array(
        'name' 			=> esc_html__('Contact Form 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_contact_form_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Contact Form 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
				'type'			=>	'textfield',
				'heading'		=>	esc_html__('Title', DZ_TH_DOMAIN ),
				'param_name'	=>	'contact_form_2_element_title',
				'value'			=> 	esc_html__('Get In Touch With Us', DZ_TH_DOMAIN ),
				'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
			array(
                'type'			=>	'textarea',
                'heading'		=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
                'param_name'	=>	'contact_form_2_element_description',
                'value'			=> 	esc_html__('Suspendisse arcu odio, placerat sit amet mi quis, consequat euismod ex.', DZ_TH_DOMAIN ),
                'group'     	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
               'type'         	=> 'attach_image',
               'holder'       	=> 'div',
               'class'        	=> '',
               'heading'      	=> esc_html__('Left Side Image', DZ_TH_DOMAIN),
               'param_name'   	=> 'contact_form_2_element_image',
               'description'  	=> esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
               'group'        	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			
			array(
               'type'         	=> 'attach_image',
               'holder'       	=> 'div',
               'class'        	=> '',
               'heading'      	=> esc_html__('Background Image', DZ_TH_DOMAIN),
               'param_name'   	=> 'contact_form_2_element_bg_img',
               'description'  	=> esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
               'group'        	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            
            array(
              'type'			=>	'dropdown',
              'heading'			=>	esc_html__('Contact Form', DZ_TH_DOMAIN ),
              'param_name'		=>	'contact_form_2_element_contact_form',
              'description'		=>	esc_html__('Choose Contact Form to show.', DZ_TH_DOMAIN ),
              'value'		    =>  $contact_form_options,
              'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
	),
			
);

/* Contact Form 3 */
$dz_sc['dz_contact_form_3_element']	=	array(
        'name' 			=> esc_html__('Contact Form 3', DZ_TH_DOMAIN),
        'base' 			=> 'dz_contact_form_3_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Contact Form 3.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
               'type'         => 'attach_image',
               'holder'       => 'div',
               'class'        => '',
               'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
               'param_name'   => 'contact_form_3_element_bg_img',
               'description'  => esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
               'group'        => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
               'type'         => 'attach_image',
               'holder'       => 'div',
               'class'        => '',
               'heading'      => esc_html__('Left Side Image', DZ_TH_DOMAIN),
               'param_name'   => 'contact_form_3_element_image',
               'description'  => esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
               'group'        => esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'type' 		=> 'dropdown',
				'holder'	=> 'div',
				'class'		=> '',
				'heading'	=> esc_html__('Image Position', DZ_TH_DOMAIN),
				'param_name'=> 'contact_form_3_element_image_position',
				'value' 	=> $position_element_options,
				'description'=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
				'group'		 => esc_html__('General', DZ_TH_DOMAIN ),
			),
            array(
              'type'			  =>	'dropdown',
              'heading'			=>	esc_html__('Contact Form', DZ_TH_DOMAIN ),
              'param_name'	=>	'contact_form_3_element_contact_form',
              'description'	=>	esc_html__('Choose Contact Form to show.', DZ_TH_DOMAIN ),
              'value'		    =>  $contact_form_options,
              'group'       => esc_html__('General', DZ_TH_DOMAIN)
            ),
        ),
			
);

/* Contact Form 4 */
$dz_sc['dz_contact_form_4_element']	=	array(
        'name' 			=> esc_html__('Contact Form 4', DZ_TH_DOMAIN),
        'base' 			=> 'dz_contact_form_4_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Contact Form 4.', DZ_TH_DOMAIN),	
        'params' 		=> array(
			array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Contact Form', DZ_TH_DOMAIN ),
				'param_name'  	=>	'contact_form_4_element_contact_form',
				'description' 	=>	esc_html__('Choose Contact Form to show.', DZ_TH_DOMAIN ),
				'value'		 	=>  $contact_form_options,
				'group'       	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
               'type'         	=> 'attach_image',
               'holder'       	=> 'div',
               'class'        	=> '',
               'heading'      	=> esc_html__('Background Image', DZ_TH_DOMAIN),
               'param_name'   	=> 'contact_form_4_element_bg_img',
               'description'  	=> esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
               'group'        	=> esc_html__('Image', DZ_TH_DOMAIN ),
            ),
			array(
				'type' 			=> 'textarea_safe',
				'heading' 		=> esc_html__( 'Google Map', DZ_TH_DOMAIN ),
				'param_name' 	=> 'contact_form_4_element_map_iframe',
				'description' 	=> esc_html__( 'Enter Iframe', DZ_TH_DOMAIN ),
            ),
      ),
	);
	
	
/* Google Map */
$dz_sc['dz_google_map_element']	=	array(
        'name' 		=> esc_html__('Google Map', DZ_TH_DOMAIN),
        'base' 		=> 'dz_google_map_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Google Map.', DZ_TH_DOMAIN),	
        'params' => array(
			array(
				'type' 			=> 'textarea_safe',
				'heading' 		=> esc_html__( 'Google Map', DZ_TH_DOMAIN ),
				'param_name' 	=> 'google_map_element_map_iframe',
				'description' 	=> esc_html__( 'Enter Iframe', DZ_TH_DOMAIN ),
            ),
      ),
	);

/* Team 1 */
$dz_sc['dz_team_1_element']	=	array(
        'name' 			=> esc_html__('Team 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_team_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Team 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                'value'			=> 	esc_html__('Our Best Expertise', DZ_TH_DOMAIN ),
                'param_name' 	=> 'team_1_element_title',
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'textfield',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'value'			=> 	esc_html__('Team ', DZ_TH_DOMAIN ),
                'param_name' 	=> 'team_1_element_subtitle',
                'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'textarea',
                'holder' 		=> 'div',
                'class' 		=> '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                'value'			=> 	esc_html__('Subscribe To Our Newsletter For Latest Update Of Finanical Services ', DZ_TH_DOMAIN ),
                'param_name' 	=> 'team_1_element_description',
                'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'type' 			=> 'attach_image',
				'holder' 		=> 'div',
				'class' 		=> '',
				'heading' 		=> esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name' 	=> 'team_1_element_bg_img',
				'description' 	=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
				'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
			),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'team_1_element_posts_in_categories',
                'value' 		=>  $team_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' 	=> 'team_1_element_only_featured_posts',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type'		    =>	'textfield',
				'heading'	    =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
				'param_name'    =>	'team_1_element_no_of_posts',
				'description'   =>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
				'value'		    => '10',
				'group' 	    => esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_1_element_image_preference',
				'value'			=> $image_preference_options,
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'	=>	'team_1_element_orderby',
                'value'			=>	$cat_orderby_options,
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'	=>	'team_1_element_order',
                'value'			=>	$order_options,			
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 		  	=> 'checkbox',
				'heading' 		=> esc_html__( 'Show Social Link', DZ_TH_DOMAIN ),
				'param_name' 	=> 'team_1_element_show_social_link',
				'description'	=> esc_html__( 'Show Social Link.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_1_element_section_background',
				'value'			=> $section_background_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_1_element_section_padding',
				'value'			=> $section_padding_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
		  
        ),
			
);


/* Team 2 */
$dz_sc['dz_team_2_element']	=	array(
        'name' 			=> esc_html__('Team 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_team_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Team 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
                array(
                    'type' 			=> 'textfield',
                    'holder' 		=> 'div',
                    'class' 		=> '',
                    'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                    'param_name' 	=> 'team_2_element_title',
                    'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                    'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
                ),
					array(
                       'type' 		=> 'textarea',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
                       'param_name' => 'team_2_element_description',
                       'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                       'group'      => esc_html__('General', DZ_TH_DOMAIN ),
					),
					array(
						'type' 		=> 'attach_image',
						'holder' 	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Background Image', DZ_TH_DOMAIN),
						'param_name'=> 'team_2_element_bg_img',
						'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
						'group'     => esc_html__('General', DZ_TH_DOMAIN ),
					),
					array(
						'type' 		=> 'dropdown_multi', 
						'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
						'param_name'=> 'team_2_element_posts_in_categories',
						'value' 	=>  $team_categories_options,
						'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
						'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
					),
					array(
						'type' 		=> 'checkbox',
						'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
						'param_name'=> 'team_2_element_only_featured_posts',
						'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
						'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
					),
                
					array(
						'type'		=>	'textfield',
						'heading'	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
						'param_name'=>	'team_2_element_no_of_posts',
						'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
						'value'		=> '10',
						'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
					),
					array(
						'type' 		=> 'dropdown',
						'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
						'param_name'=> 'team_2_element_image_preference',
						'value'		=> $image_preference_options,
						'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
					),
					array(
						'type'		=>	'dropdown',
						'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
						'param_name'=>	'team_2_element_orderby',
						'value'	   	=>	$cat_orderby_options,
						'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
						'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
					),
					array(
						'type'		=>	'dropdown',
						'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
						'param_name'=>	'team_2_element_order',
						'value'		 =>	$order_options,			
						'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
						'group' 	=>  esc_html__('Advance', DZ_TH_DOMAIN)
					),
					array(
						'type' 		 => 'checkbox',
						'heading' 	 => esc_html__( 'Show Social Link', DZ_TH_DOMAIN ),
						'param_name' => 'team_2_element_show_social_link',
						'description'=> esc_html__( 'Show Social Link.', DZ_TH_DOMAIN ),
						'group' 		  => esc_html__('Advance', DZ_TH_DOMAIN)
					),
					array(
						'type' 		 => 'dropdown',
						'heading' 	 => esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
						'param_name' => 'team_2_element_section_padding',
						'value'		 => $section_padding_options,
						'group' 	 => esc_html__('Section', DZ_TH_DOMAIN)
					),
        ),
			
);


/* Team 3 */
$dz_sc['dz_team_3_element']	=	array(
        'name' 			=> esc_html__('Team 3', DZ_TH_DOMAIN),
        'base' 			=> 'dz_team_3_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Team 3.', DZ_TH_DOMAIN),	
        'params' 		=> array(
				array(
					'type' 		=> 'textfield',
					'holder' 	=> 'div',
					'class' 	=> '',
					'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
					'param_name'=> 'team_3_element_title',
					'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
					'group'     => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
				   'type' 		=> 'textarea',
				   'holder' 	=> 'div',
				   'class' 		=> '',
				   'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
				   'param_name' => 'team_3_element_description',
				   'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				   'group'      => esc_html__('General', DZ_TH_DOMAIN ),
				),
				array(
				  'type' 		=> 'dropdown_multi', 
				  'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
				  'param_name'	=> 'team_3_element_posts_in_categories',
				  'value' 		=>  $team_categories_options,
				  'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
				  'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'checkbox',
					'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
					'param_name'=> 'team_3_element_only_featured_posts',
					'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
	
				array(
					'type'		 =>	'textfield',
					'heading'	 =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
					'param_name' =>	'team_3_element_no_of_posts',
					'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
					'value'		 => '10',
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
					'param_name'=> 'team_3_element_image_preference',
					'value'		=> $image_preference_options,
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
					'param_name'=>	'team_3_element_orderby',
					'value'		=>	$cat_orderby_options,
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
					'param_name'=>	'team_3_element_order',
					'value'		=>	$order_options,			
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=>  esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
					'param_name'=> 'team_3_element_section_background',
					'value'		=> $section_background_options,
					'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
					'param_name'=> 'team_3_element_section_padding',
					'value'		=> $section_padding_options,
					'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
				),
        ),
			
);


/* Team Listing 1 */
$dz_sc['dz_team_listing_1_element']	=	array(
        'name' 			=> esc_html__('Team Listing 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_team_listing_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Team Listing 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
			array(
			   'type' 			=> 'textfield',
			   'holder' 		=> 'div',
			   'class' 			=> '',
			   'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
			   'param_name' 	=> 'team_listing_1_element_title',
			   'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
			   'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type' 			=> 'textarea',
				'holder' 		=> 'div',
				'class' 		=> '',
				'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
				'param_name' 	=> 'team_listing_1_element_description',
				'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type' 			=> 'dropdown_multi', 
				'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_listing_1_element_posts_in_categories',
				'value' 		=>  $team_categories_options,
				'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'checkbox',
				'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'param_name' 	=> 'team_listing_1_element_only_featured_posts',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
			  'type'			=>	'dropdown',
			  'heading'			=>	esc_html__('Style', DZ_TH_DOMAIN),
			  'param_name'		=>	'team_listing_1_element_style',
			  'value'		    =>	$team_element_style,				
			  'description'	    =>	esc_html__('Select Style.', DZ_TH_DOMAIN),
			  'group'           => esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type'		  	=>	'textfield',
				'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
				'param_name'	=>	'team_listing_1_element_no_of_posts',
				'description'	=>	esc_html__('Enter no. of team to show per page.', DZ_TH_DOMAIN ),
				'value'		  	=> '10',
				'group' 	  	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Pagination Style', DZ_TH_DOMAIN ),
				'param_name'	=>	'team_listing_1_element_pagination_style',
				'description'	=>	esc_html__('You can choose pagination style from here.', DZ_TH_DOMAIN ),
				'value' 		=> $pagination_options,
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_listing_1_element_image_preference',
				'value'			=> $image_preference_options,
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type'			=>	'dropdown',
				'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
				'param_name'	=>	'team_listing_1_element_orderby',
				'value'			=>	$cat_orderby_options,
				'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				  'type'		=>	'dropdown',
				  'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
				  'param_name'	=>	'team_listing_1_element_order',
				  'value'		=>	$order_options,			
				  'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				  'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_listing_1_element_section_background',
				'value'			=> $section_background_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'	=> 'team_listing_1_element_section_padding',
				'value'			=> $section_padding_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
			  'type'			=>	'dropdown',
			  'heading'			=>	esc_html__('Select Column', DZ_TH_DOMAIN),
			  'param_name'		=>	'team_listing_1_element_cols',
			  'value'		    =>	$column_options,				
			  'description'		=>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
			  'group'       	=> esc_html__('Advance', DZ_TH_DOMAIN)
			),
        ),
			
);

/* Partners 1 */
$dz_sc['dz_partners_1_element']	=	array(
        'name' 			=> esc_html__('Partners 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_partners_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Partners 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
			array(
				'type' 		=> 'textfield',
				'holder' 	=> 'div',
				'class' 	=> '',
				'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
				'param_name' => 'partners_1_element_title',
				'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
				'group'      => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type' 		=> 'textarea',
				'holder' 	=> 'div',
				'class' 	=> '',
				'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
				'param_name'=> 'partners_1_element_description',
				'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
				'group'     => esc_html__('General', DZ_TH_DOMAIN ),
			),
			array(
				'type' 		=> 'attach_image',
				'holder' 	=> 'div',
				'class' 	=> '',
				'heading' 	=> esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'=> 'partners_1_element_bg_img',
				'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
				'group'     => esc_html__('General', DZ_TH_DOMAIN ),
			),
          
          //Group Start
          array(
              'type' 		=> 'param_group',
              'value' 		=> '',
              'param_name' 	=> 'partners_1_element_item',
              'group' 		=> esc_html__('Partners', DZ_TH_DOMAIN),
              'params' 		=> array(
					array(
						'type' 			=> 'attach_image',
						'holder' 		=> 'div',
						'class' 		=> '',
						'heading' 		=> esc_html__('Partner Image', DZ_TH_DOMAIN),
						'param_name' 	=> 'partners_1_element_item_main_img',
						'description' 	=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
					),
					array(
						'type' 			=> 'attach_image',
						'holder' 		=> 'div',
						'class' 		=> '',
						'heading' 		=> esc_html__('Partner background Image', DZ_TH_DOMAIN),
						'param_name' 	=> 'partners_1_element_item_back_img',
						'description' 	=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
					),
              ),
          ),//Group End
        ),
	);

/* Partners 2 */
$dz_sc['dz_partners_2_element']	=	array(
        'name' 			=> esc_html__('Partners 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_partners_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Partners 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
          array(
               'type' 		=> 'textfield',
               'holder' 	=> 'div',
               'class' 		=> '',
               'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
               'param_name' => 'partners_2_element_title',
               'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
               'group'      => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
               'type' 		=> 'textarea',
               'holder' 	=> 'div',
               'class' 		=> '',
               'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
               'param_name' => 'partners_2_element_description',
               'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
               'group'      => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          //Group Start
          array(
              'type' 		=> 'param_group',
              'value' 		=> '',
              'param_name' 	=> 'partners_2_element_item',
              'group' 		=> esc_html__('Partners', DZ_TH_DOMAIN),
              'params' 		=> array(
					array(
						'type' 		=> 'attach_image',
						'holder' 	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Partner Image', DZ_TH_DOMAIN),
						'param_name'=> 'partners_2_element_item_main_img',
						'description'=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
					),
					array(
						'type' 		=> 'attach_image',
						'holder' 	=> 'div',
						'class' 	=> '',
						'heading' 	=> esc_html__('Partner background Image', DZ_TH_DOMAIN),
						'param_name'=> 'partners_2_element_item_back_img',
						'description'=> esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
					),
              ),
          ),//Group End
	),
			
);

/* Faq 1 */
$dz_sc['dz_faq_1_element']	=	array(
        'name' 			=> esc_html__('Faq 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_faq_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Faq 1', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                 'type'       => 'textfield',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Title', DZ_TH_DOMAIN ),
                 'value'      => esc_html__('Provide Awesome Service To You', DZ_TH_DOMAIN ),
                 'param_name' => 'faq_1_element_title',
                 'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                 'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            
            array(
                 'type'       => 'textarea',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Description', DZ_TH_DOMAIN ),
                 'value'      => esc_html__('Morbi sed lacus nec risus finibus feugiat et fermentum nibh. Pellentesque vitae ante at elit fringilla ac at purus.', DZ_TH_DOMAIN ),
                 'param_name' => 'faq_1_element_description',
                 'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                 'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 			=> 'dropdown_multi', 
                'heading' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'	=> 'faq_1_element_posts_in_categories',
                'value' 		=>  $faq_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 		  => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                 'type'       => 'attach_image',
                 'holder'     => 'div',
                 'class'      => '',
                 'heading'    => esc_html__('Background Image', DZ_TH_DOMAIN),
                 'param_name' => 'faq_1_element_bg_img',
                 'description'=> esc_html__('Enter the Section Background Image to show.', DZ_TH_DOMAIN),
                 'group'      => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
               'type'         => 'attach_image',
               'holder'       => 'div',
               'class'        => '',
               'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
               'param_name'   => 'faq_1_element_image',
               'description'  => esc_html__('Enter the Section Image to show.', DZ_TH_DOMAIN),
               'group' 		  => esc_html__('General', DZ_TH_DOMAIN)
            ),
			array(
				'type' 			=> 'dropdown',
				'holder'		=> 'div',
				'class'			=> '',
				'heading'		=> esc_html__('Image Position', DZ_TH_DOMAIN),
				'param_name'	=> 'faq_1_element_image_position',
				'value' 		=> $position_element_options,
				'description'	=>	esc_html__('Select the Image Position.', DZ_TH_DOMAIN),
				'group'		 	=> esc_html__('General', DZ_TH_DOMAIN ),
			),
            array(
                'type'		  	=>	'textfield',
                'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'  	=>	'faq_1_element_no_of_posts',
                'description' 	=>	esc_html__('Enter no. of Service to show per page.', DZ_TH_DOMAIN ),
                'value'		  	=> 	'10',
                'group' 	  	=> 	esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            
            array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'	=>	'faq_1_element_orderby',
                'value'			=>	$cat_orderby_options,
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'			=>	'dropdown',
                'heading'		=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'	=>	'faq_1_element_order',
                'value'			=>	$order_options,			
                'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 		=>  esc_html__('Advance', DZ_TH_DOMAIN)
            ),
	),
			
);

/* Newsletter 1 */
$dz_sc['dz_newsletter_1_element']	=	array(
        'name' 			=> esc_html__('Newsletter 1', DZ_TH_DOMAIN),
        'base' 			=> 'dz_newsletter_1_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Newsletter 1.', DZ_TH_DOMAIN),	
        'params' 		=> array(
			array(
				'type'		=>	'textfield',
				'heading' 	=>	esc_html__('Title', DZ_TH_DOMAIN ),
				'param_name'=>	'newsletter_1_element_title',
				'value'		=> 	esc_html__('Subscribe To Our Newsletter For Latest Update Of Finanical Services ', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type'		=>	'textfield',
				'heading' 	=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
				'param_name'=>	'newsletter_1_element_subtitle',
				'value'		=> 	esc_html__('Newsletter', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type'		=>	'textarea',
				'heading' 	=>	esc_html__('Description', DZ_TH_DOMAIN ),
				'param_name'=>	'newsletter_1_element_description',
				'value'		=> 	esc_html__('Curabitur eleifend nibh sit amet ex posuere, vel malesuada turpis pretium. Quisque et tincidunt risus, a tempor massa. Cras tempor egestas libero, eu laoreet enim pharetra non.', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'newsletter_1_element_bg_img',
				'description'  => esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
				'param_name'   => 'newsletter_1_element_image',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('Image', DZ_TH_DOMAIN ),
			),
	),
			
);

/* Newsletter 2 */
$dz_sc['dz_newsletter_2_element']	=	array(
        'name' 		=> esc_html__('Newsletter 2', DZ_TH_DOMAIN),
        'base' 		=> 'dz_newsletter_2_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Newsletter 2.', DZ_TH_DOMAIN),	
        'params' 	=> array(
			array(
				'type'			  =>	'textfield',
				'heading' 		=>	esc_html__('Title', DZ_TH_DOMAIN ),
				'param_name'	=>	'newsletter_2_element_title',
				'value'			  => 	esc_html__('Subscribe To Our Newsletter For Latest Update Of New Products', DZ_TH_DOMAIN ),
				'group' 		  => esc_html__('General', DZ_TH_DOMAIN)
			),
			array(
                'type' => 'textarea',
                'holder' => 'div',
                'class' => '',
                'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
				'value'		=> 'Donec ut mattis orci. In sit amet posuere urna, eget consectetur purus. Donec ex tortor, consectetur nec eros condimentum, tincidunt facilisis est.',
                'param_name' 	=> 'newsletter_2_element_description',
                'description' => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'       => esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'newsletter_2_element_bg_img',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
	),
			
);

/* Price Table 1 */
$dz_sc['dz_pricing_table_1_element']	=	array(
        'name' 		=> esc_html__('Price Table 1', DZ_TH_DOMAIN),
        'base' 		=> 'dz_pricing_table_1_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Price Table 1.', DZ_TH_DOMAIN),	
        'params' 	=> array(
            array(
                'type' 		=> 'textfield',
                'holder' 	=> 'div',
                'class' 	=> '',
                'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'=> 'pricing_table_1_element_title',
                'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 		=> 'textfield',
                'holder' 	=> 'div',
                'class' 	=> '',
                'heading' 	=> esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name'=> 'pricing_table_1_element_subtitle',
                'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 		=> 'textarea',
                'holder' 	=> 'div',
                'class' 	=> '',
                'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name'=> 'pricing_table_1_element_description',
                'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
				'type'         => 'attach_image',
				'holder'       => 'div',
				'class'        => '',
				'heading'      => esc_html__('Background Image', DZ_TH_DOMAIN),
				'param_name'   => 'pricing_table_1_element_bg_img',
				'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
				'group'        => esc_html__('General', DZ_TH_DOMAIN ),
			),
          //Group Start
          array(
              'type' 		=> 'param_group',
              'param_name' 	=> 'pricing_table_1_element_item',
              'group' 		=> esc_html__('Pricing', DZ_TH_DOMAIN),
              'params' 		=> array(
					array(
                       'type' 		=> 'textfield',
                       'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_1_element_item_title',
                       'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                       'type' 		=> 'textarea',
                       'heading' 	=> esc_html__('Small Description', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_1_element_item_description',
					   'value'		=> 'Aliquam dui lacus, lobortis quis sapien non.',
                       'description'=> esc_html__('Enter The Small Description to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                       'type' 		=> 'textfield',
                       'heading' 	=> esc_html__('Price', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_1_element_item_pricing',
                       'description'=> esc_html__('Enter The Price to Show.', DZ_TH_DOMAIN )
					), 
					array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Currency', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_1_element_item_currency',
                       'description'=> esc_html__('Enter The Unit to Show.', DZ_TH_DOMAIN )
					), 
					array(
                       'type' 		=> 'textfield',
                       'heading' 	=> esc_html__('Unit', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_1_element_item_unit',
                       'description'=> esc_html__('Enter The Unit to Show.', DZ_TH_DOMAIN )
					), 
					array(
                        'type' 		=> 'textarea',
                        'heading' 	=> esc_html__( 'Features', DZ_TH_DOMAIN ),
                        'param_name'=> 'pricing_table_1_element_item_pricing_text',
                        'description'=> esc_html__( 'Please Enter Seprated value in each line with comma seperation.', DZ_TH_DOMAIN ),
					),
					array(
                       'type' 		=> 'vc_link',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Link', DZ_TH_DOMAIN),
                       'param_name' => 'pricing_table_1_element_item_link',
                       'description'=> esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
					),
					array(
						'type' 		=> 'dropdown',
						'heading' 	=> esc_html__( 'Active Table', DZ_TH_DOMAIN ),
						'param_name'=> 'pricing_table_1_element_item_active',
						'value'		=> $active_options,
					),
              ),
          ),//Group End
		  array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'=> 'pricing_table_1_element_section_background',
				'value'		=> $section_background_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 		=> 'dropdown',
				'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'=> 'pricing_table_1_element_section_padding',
				'value'		=> $section_padding_options,
				'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
			),
	),
			
);

/* Price Table 2 */
$dz_sc['dz_pricing_table_2_element']	=	array(
        'name' 		=> esc_html__('Price Table 2', DZ_TH_DOMAIN),
        'base' 		=> 'dz_pricing_table_2_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Price Table 2.', DZ_TH_DOMAIN),	
        'params' 	=> array(
            array(
                'type' 	=> 'textfield',
                'holder' 	=> 'div',
                'class' 	=> '',
                'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                'param_name'=> 'pricing_table_2_element_title',
                'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                'group'     => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' => 'textfield',
                'holder' => 'div',
                'class' => '',
                'heading' => esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'param_name' => 'pricing_table_2_element_subtitle',
                'description' => esc_html__('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
                'group'       => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            
            array(
                'type' => 'textarea',
                'holder' => 'div',
                'class' => '',
                'heading' => esc_html__('Description', DZ_TH_DOMAIN ),
                'param_name' => 'pricing_table_2_element_description',
                'description' => esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                'group'       => esc_html__('General', DZ_TH_DOMAIN ),
            ),
			array(
				'param_name'    => 'pricing_table_2_element_bg_img',
				'heading'       => esc_html__('Background Image', DZ_TH_DOMAIN),
				'type'          => 'attach_image',  // USAGE ATTACH_IMAGE TYPE
				'description'   => esc_html__('Image Description', DZ_TH_DOMAIN),
				'group'         => esc_html__('General', DZ_TH_DOMAIN),
            ),
          //Group Start
          array(
              'type' 		=> 'param_group',
              'param_name' 	=> 'pricing_table_2_element_item',
              'group' 		=> esc_html__('Pricing', DZ_TH_DOMAIN),
              'params' 		=> array(
					array(
                       'type' 			=> 'textfield',
                       'holder' 		=> 'div',
                       'class' 			=> '',
                       'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name' 	=> 'pricing_table_2_element_item_title',
                       'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
					),
					array(
						'param_name'    => 'pricing_table_2_element_item_img',
						'heading'       => esc_html__('Image', DZ_TH_DOMAIN),
						'type'          => 'attach_image',  // USAGE ATTACH_IMAGE TYPE
						'description'   => esc_html__('Image Description', DZ_TH_DOMAIN),
						'group'         => esc_html__('General', DZ_TH_DOMAIN),
					),
					array(
                       'type' 			=> 'textfield',
                       'holder' 		=> 'div',
                       'class' 			=> '',
                       'heading' 		=> esc_html__('Month Price', DZ_TH_DOMAIN ),
                       'param_name' 	=> 'pricing_table_2_element_item_month_pricing',
                       'description' 	=> esc_html__('Enter The Price to Show.', DZ_TH_DOMAIN )
					), 
					array(
                       'type' 			=> 'textfield',
                       'holder' 		=> 'div',
                       'class' 			=> '',
                       'heading' 		=> esc_html__('Year Price', DZ_TH_DOMAIN ),
                       'param_name' 	=> 'pricing_table_2_element_item_year_pricing',
                       'description' 	=> esc_html__('Enter The Price to Show.', DZ_TH_DOMAIN )
					), 
					array(
                       'type' 			=> 'textfield',
                       'holder' 		=> 'div',
                       'class' 			=> '',
                       'heading' 		=> esc_html__('Currency', DZ_TH_DOMAIN ),
                       'param_name' 	=> 'pricing_table_2_element_item_unit',
                       'description' 	=> esc_html__('Enter The Unit to Show.', DZ_TH_DOMAIN )
					), 
					array(
                        'type' 			=> 'textarea',
                        'heading' 		=> esc_html__( 'Features', DZ_TH_DOMAIN ),
                        'param_name' 	=> 'pricing_table_2_element_item_pricing_text',
                        'description' 	=> esc_html__( 'Please Enter Seprated value in each line comma seperated.', DZ_TH_DOMAIN ),
					),
					array(
                       'type' 			=> 'vc_link',
                       'holder' 		=> 'div',
                       'class' 			=> '',
                       'heading' 		=> esc_html__('Link', DZ_TH_DOMAIN),
                       'param_name' 	=> 'pricing_table_2_element_item_link',
                       'description' 	=> esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
					),
					array(
						'type' 			=> 'dropdown',
						'heading' 		=> esc_html__( 'Active Table', DZ_TH_DOMAIN ),
						'param_name'	=> 'pricing_table_2_element_item_active',
						'value'			=> $active_options,
					),
                  
              ),
          ),//Group End
		  array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'	=> 'pricing_table_2_element_section_background',
				'value'			=> $section_background_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'	=> 'pricing_table_2_element_section_padding',
				'value'			=> $section_padding_options,
				'group' 		=> esc_html__('Section', DZ_TH_DOMAIN)
			),
	),
			
);

/* Price Table 3 */
$dz_sc['dz_pricing_table_3_element']	=	array(
        'name' => esc_html__('Price Table 3', DZ_TH_DOMAIN),
        'base' => 'dz_pricing_table_3_element',
        'class' => '',
        'category' => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' => 'dz-element-vc' ,
        'description' => esc_html__('Shows Price Table 3.', DZ_TH_DOMAIN),	
        'params' => array(
            array(
                 'type' 		=> 'textfield',
                 'holder' 		=> 'div',
                 'class' 		=> '',
                 'heading' 		=> esc_html__('Title', DZ_TH_DOMAIN ),
                 'param_name'	=> 'pricing_table_3_element_title',
                 'description' 	=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN ),
                 'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            
            array(
                 'type' 		=> 'textarea',
                 'holder' 		=> 'div',
                 'class' 		=> '',
                 'heading' 		=> esc_html__('Description', DZ_TH_DOMAIN ),
                 'param_name' 	=> 'pricing_table_3_element_description',
                 'description' 	=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
                 'group'       	=> esc_html__('General', DZ_TH_DOMAIN ),
            ),
            //Group Start
          array(
              'type' 			=> 'param_group',
              'param_name' 		=> 'pricing_table_3_element_item',
              'group' 			=> esc_html__('Pricing', DZ_TH_DOMAIN),
              'params' 			=> array(
                  array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_3_element_item_title',
                       'description' => esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                  ),
                  array(
                     'type'         => 'attach_image',
                     'holder'       => 'div',
                     'class'        => '',
                     'heading'      => esc_html__('Image', DZ_TH_DOMAIN),
                     'param_name'   => 'pricing_table_3_element_item_image',
                     'description'  => esc_html__('Enter the Image to show.', DZ_TH_DOMAIN),
                  ),
                  array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Price', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_3_element_item_pricing',
                       'description'=> esc_html__('Enter The Price to Show.', DZ_TH_DOMAIN )
                  ), 
				  array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Currency', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_3_element_item_currency',
                       'description'=> esc_html__('Enter The Unit to Show.', DZ_TH_DOMAIN )
                  ), 
                  array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Unit', DZ_TH_DOMAIN ),
                       'param_name' => 'pricing_table_3_element_item_unit',
                       'description'=> esc_html__('Enter The Unit to Show.', DZ_TH_DOMAIN )
                  ), 
                  array(
                        'type' 		=> 'textarea',
                        'heading' 	=> esc_html__( 'Features', DZ_TH_DOMAIN ),
                        'param_name'=> 'pricing_table_3_element_item_pricing_text',
                        'description'=> esc_html__( 'Please Enter Seprated value in each line with comma seperated.', DZ_TH_DOMAIN ),
                  ),
                  array(
                       'type' 		=> 'vc_link',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Link', DZ_TH_DOMAIN),
                       'param_name' => 'pricing_table_3_element_item_link',
                       'description'=> esc_html__('Enter the Section link to show.', DZ_TH_DOMAIN),
                  ),
                  array(
						'type' 		=> 'dropdown',
						'heading' 	=> esc_html__( 'Active Table', DZ_TH_DOMAIN ),
						'param_name'=> 'pricing_table_3_element_item_active',
						'value'		=> $active_options,
					),
              ),
          ),//Group End
		  array(
				'type' 				=> 'dropdown',
				'heading' 			=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
				'param_name'		=> 'pricing_table_3_element_section_background',
				'value'				=> $section_background_options,
				'group' 			=> esc_html__('Section', DZ_TH_DOMAIN)
			),
			array(
				'type' 				=> 'dropdown',
				'heading' 			=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
				'param_name'		=> 'pricing_table_3_element_section_padding',
				'value'				=> $section_padding_options,
				'group' 			=> esc_html__('Section', DZ_TH_DOMAIN)
			),
	),
			
);

/* Icon Box 1 */
$dz_sc['dz_icon_box_1_element']	=	array(
        'name' => esc_html__('Icon Box 1', DZ_TH_DOMAIN),
        'base' => 'dz_icon_box_1_element',
        'class' => '',
        'category' => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' => 'dz-element-vc' ,
        'description' => esc_html__('Shows Icon Box 1.', DZ_TH_DOMAIN),	
        'params' => array(
          array(
               'type' 		=> 'textfield',
               'holder' 	=> 'div',
               'class' 		=> '',
               'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
               'param_name' => 'icon_box_1_element_title',
               'description'=> __('Enter The Title to Show.', DZ_TH_DOMAIN ),
               'group'      => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
               'type' 		=> 'textfield',
               'holder' 	=> 'div',
               'class' 		=> '',
               'heading' 	=> esc_html__('Subtitle', DZ_TH_DOMAIN ),
               'param_name' => 'icon_box_1_element_subtitle',
               'description'=> esc_html__('Enter The Subtitle to Show.', DZ_TH_DOMAIN ),
               'group'      => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          array(
               'type' 		=> 'textarea',
               'holder' 	=> 'div',
               'class' 		=> '',
               'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
               'param_name' => 'icon_box_1_element_description',
               'description'=> esc_html__('Enter The Section Description to Show.', DZ_TH_DOMAIN ),
               'group'      => esc_html__('General', DZ_TH_DOMAIN ),
          ),
          
          //Group Start
          array(
              'type' 		=> 'param_group',
              'value' 		=> '',
              'param_name' 	=> 'icon_box_1_element_item',
              'group' 		=> esc_html__('Icon Box', DZ_TH_DOMAIN),
              'params' 		=> array(
					array(
                       'type' 		=> 'textfield',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Title', DZ_TH_DOMAIN ),
                       'param_name' => 'icon_box_1_element_item_title',
                       'description'=> esc_html__('Enter The Title to Show.', DZ_TH_DOMAIN )
                    ),
					array(
                       'type' 		=> 'textarea',
                       'holder' 	=> 'div',
                       'class' 		=> '',
                       'heading' 	=> esc_html__('Description', DZ_TH_DOMAIN ),
                       'param_name' => 'icon_box_1_element_item_description',
                       'description'=> esc_html__('Enter The Description to Show.', DZ_TH_DOMAIN )
					),
					array(
						'type' 		=> 'dropdown',
						'heading' 	=> esc_html__( 'Icon Library', DZ_TH_DOMAIN ),
						'value' 	=> array(
						  esc_html__( 'Font Awesome', DZ_TH_DOMAIN ) => 'fontawesome',
						  esc_html__( 'Flaticon', DZ_TH_DOMAIN ) => 'flaticon',
						  esc_html__( 'Themify', DZ_TH_DOMAIN ) => 'themify',
						),
						'param_name' => 'icon_box_1_element_item_icon_list',
						'description'=> esc_html__( 'Select icon library.', DZ_TH_DOMAIN ),
					),
					array(
					  'type' 		=> 'iconpicker',
					  'heading' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
					  'param_name' 	=> 'icon_box_1_element_item_icon_fontawesome',
					  
					  'settings' 	=> array(
						'emptyIcon' => true, // default true, display an 'EMPTY' icon?
						'type' => 'fontawesome',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					  ),
					  'dependency' => array(
						'element' => 'icon_box_1_element_item_icon_list',
						'value' => 'fontawesome',
					  ),
					  
					  'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
				    ),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon Themify', DZ_TH_DOMAIN ),
						'param_name' => 'icon_box_1_element_item_icon_themify',
						
						'settings' => array(
						  'emptyIcon' => true,
						  'type' => 'themify',
						  'iconsPerPage' => 200,
						),
						'dependency' => array(
						  'element' => 'icon_box_1_element_item_icon_list',
						  'value' => 'themify',
						),
						'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon Flaticon', DZ_TH_DOMAIN ),
						'param_name' => 'icon_box_1_element_item_icon_flaticon',
						
						'settings' => array(
						  'emptyIcon' => true,
						  'type' => 'flaticon',
						  'iconsPerPage' => 200,
						),
						'dependency' => array(
						  'element' => 'icon_box_1_element_item_icon_list',
						  'value' => 'flaticon',
						),
						'description' => esc_html__( 'Select icon from library.', DZ_TH_DOMAIN ),
						
					),
              ),
          ),//Group End
	),
			
);
        
/* post slider 1 */
$dz_sc['dz_post_slider_1_element']	=	array(
        'name' 		=> esc_html__('Post Slider 1', DZ_TH_DOMAIN),
        'base' 		=> 'dz_post_slider_1_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Post Slider style 1.', DZ_TH_DOMAIN),	
        'params' 	=> array(
              array(
                'type'			=>	'textfield',
                'heading' 		=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'value'     	=> esc_html__('', DZ_TH_DOMAIN ),
                'param_name'	=>	'post_slider_1_element_title',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
              ),
              array(
                'type'			=>	'textfield',
                'heading' 		=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'value'     	=> esc_html__('', DZ_TH_DOMAIN ),
                'param_name'	=>	'post_slider_1_element_subtitle',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
              ),
              array(
                'type'			=>	'textarea',
                'heading' 		=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
                'value'     	=> esc_html__('', DZ_TH_DOMAIN ),
                'param_name'	=>	'post_slider_1_element_description',
                'value'			=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
              ),
              array(
                 'type'       	=> 'attach_image',
                 'holder'     	=> 'div',
                 'class'      	=> '',
                 'heading'    	=> esc_html__('Background Image', DZ_TH_DOMAIN),
                 'param_name' 	=> 'post_slider_1_element_bg_img',
                 'description'	=> esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
                 'group'      	=> esc_html__('General', DZ_TH_DOMAIN ),
              ),
              array(
                'type' 		 	=> 'dropdown_multi', 
                'heading' 	 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name' 	=> 'post_slider_1_element_posts_in_categories',
                'value' 	 	=>  $posts_in_categories_options,
                'description'	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 	 	=> esc_html__('General', DZ_TH_DOMAIN)
              ),
              array(
                'type'			=>	'textfield',
                'heading'		=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'	=>	'post_slider_1_element_text_limit',
                'description'	=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'			=> 	'5',
                'group' 		=> esc_html__('Advance', DZ_TH_DOMAIN)
              ),
				array(
                  'type'		=>	'textfield',
                  'heading'	  	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                  'param_name'	=>	'post_slider_1_element_no_of_posts',
                  'description'	=>	esc_html__('Enter no. of post to show per page.', DZ_TH_DOMAIN ),
                  'value'		=> '3',
                  'group' 	  	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'checkbox',
					'heading' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
					'param_name' 	=> 'post_slider_1_element_only_featured_posts',
					'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
					'group' 		=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
					'param_name'=> 'post_slider_1_element_image_preference',
					'value'		=> $image_preference_options,
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
					'param_name'=>	'post_slider_1_element_orderby',
					'value'		=>	$orderby_options,
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
					'param_name'=>	'post_slider_1_element_order',
					'value'		=>	$order_options,			
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=>  esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'checkbox',
					'heading' 	=> esc_html__( 'Show Date', DZ_TH_DOMAIN ),
					'param_name'=> 'post_slider_1_element_show_date',
					'description'=> esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		 => 'checkbox',
					'heading' 	 => esc_html__( 'Show Share', DZ_TH_DOMAIN ),
					'param_name' => 'post_slider_1_element_show_share',
					'description'=> esc_html__( 'Choose to Show Share.', DZ_TH_DOMAIN ),
					'group' 	 => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		 => 'checkbox',
					'heading' 	 => esc_html__( 'Show Comment', DZ_TH_DOMAIN ),
					'param_name' => 'post_slider_1_element_show_comment',
					'description'=> esc_html__( 'Choose to Show Comment.', DZ_TH_DOMAIN ),
					'group' 	 => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Section Background', DZ_TH_DOMAIN ),
					'param_name'=> 'post_slider_1_element_section_background',
					'value'		=> $section_background_options,
					'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Section Padding', DZ_TH_DOMAIN ),
					'param_name'=> 'post_slider_1_element_section_padding',
					'value'		=> $section_padding_options,
					'group' 	=> esc_html__('Section', DZ_TH_DOMAIN)
				),
			
			),
		);
      
/* post slider 2 */
$dz_sc['dz_post_slider_2_element']	=	array(
        'name' 			=> esc_html__('Post Slider 2', DZ_TH_DOMAIN),
        'base' 			=> 'dz_post_slider_2_element',
        'class' 		=> '',
        'category' 		=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 			=> 'dz-element-vc' ,
        'description' 	=> esc_html__('Shows Post Slider style 2.', DZ_TH_DOMAIN),	
        'params' 		=> array(
            array(
                'type'		=>	'textfield',
                'heading' 	=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'value'     => esc_html__('', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_2_element_title',
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'   =>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'value'     => esc_html__('', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_2_element_subtitle',
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textarea',
                'heading' 	=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
                'value'     => esc_html__('', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_2_element_description',
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type' 		=> 'dropdown_multi', 
                'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'=> 'post_slider_2_element_posts_in_categories',
                'value' 	=>  $posts_in_categories_options,
                'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_2_element_text_limit',
                'description'=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'		=> 	'5',
                'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'	   	 =>	'textfield',
                'heading'	 =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name' =>	'post_slider_2_element_no_of_posts',
                'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'	     => '3',
                'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
			array(
                'type' 	  	  => 'checkbox',
                'heading' 	  => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
                'param_name'  => 'post_slider_2_element_only_featured_posts',
                'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
                'group' 	  => esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type' 		 => 'dropdown',
                'heading' 	 => esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
                'param_name' => 'post_slider_2_element_image_preference',
                'value'		 => $image_preference_options,
                'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		 =>	'dropdown',
                'heading'	 =>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name' =>	'post_slider_2_element_orderby',
                'value'		 =>	$orderby_options,
                'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type'		 =>	'dropdown',
				'heading'	 =>	esc_html__('Order', DZ_TH_DOMAIN),
				'param_name' =>	'post_slider_2_element_order',
				'value'		 =>	$order_options,			
				'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
				'group' 		  =>  esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type' 		 => 'checkbox',
				'heading' 	 => esc_html__( 'Show Date', DZ_TH_DOMAIN ),
				'param_name' => 'post_slider_2_element_show_date',
				'description'=> esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
				'group' 	 => esc_html__('Extra', DZ_TH_DOMAIN)
            ),
            array(
				'type' 		 => 'checkbox',
				'heading' 	 => esc_html__( 'Show Share', DZ_TH_DOMAIN ),
				'param_name' => 'post_slider_2_element_show_share',
				'description'=> esc_html__( 'Choose to Show Share.', DZ_TH_DOMAIN ),
				'group' 	 => esc_html__('Extra', DZ_TH_DOMAIN)
            ),
            array(
				'type' 		 => 'checkbox',
				'heading' 	 => esc_html__( 'Show Comment', DZ_TH_DOMAIN ),
				'param_name' => 'post_slider_2_element_show_comment',
				'description'=> esc_html__( 'Choose to Show Comment.', DZ_TH_DOMAIN ),
				'group' 	 => esc_html__('Extra', DZ_TH_DOMAIN)
            ),
        ),
	);
			

/* post slider 3 */
$dz_sc['dz_post_slider_3_element']	=	array(
        'name' 		=> esc_html__('Post Slider 3', DZ_TH_DOMAIN),
        'base' 		=> 'dz_post_slider_3_element',
        'class' 	=> '',
        'category' 	=> esc_html__('ClinicMaster', DZ_TH_DOMAIN),
        'icon' 		=> 'dz-element-vc' ,
        'description'=> esc_html__('Shows Post Slider style 3.', DZ_TH_DOMAIN),	
        'params' 	=> array(
            array(
                'type'		=>	'textfield',
                'heading' 	=>	esc_html__('Title', DZ_TH_DOMAIN ),
                'value'     => esc_html__('', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_3_element_title',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading' 	=>	esc_html__('Subtitle', DZ_TH_DOMAIN ),
                'value'     => esc_html__('', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_3_element_subtitle',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textarea',
                'heading' 	=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
                'value'     => esc_html__('', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_3_element_description',
                'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
			array(
                'type'      => 'attach_image',
                'holder'    => 'div',
                'class'     => '',
                'heading'   => esc_html__('Background Image', DZ_TH_DOMAIN),
                'param_name'=> 'post_slider_3_element_bg_img',
                'description'=> esc_html__('Enter the Background Image to show.', DZ_TH_DOMAIN),
                'group'     => esc_html__('General', DZ_TH_DOMAIN ),
            ),
            array(
                'type' 		=> 'dropdown_multi', 
                'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
                'param_name'=> 'post_slider_3_element_posts_in_categories',
                'value' 	=>  $posts_in_categories_options,
                'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_3_element_text_limit',
                'description'=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
                'value'		=> 	'5',
                'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'textfield',
                'heading'	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
                'param_name'=>	'post_slider_3_element_no_of_posts',
                'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
                'value'		=> '3',
                'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type' 		=> 'checkbox',
                'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
                'param_name'=> 'post_slider_3_element_only_featured_posts',
                'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
                'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
            ),
            array(
                'type' 		=> 'dropdown',
                'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
                'param_name'=> 'post_slider_3_element_image_preference',
                'value'		=> $image_preference_options,
                'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'dropdown',
                'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
                'param_name'=>	'post_slider_3_element_orderby',
                'value'		=>	$orderby_options,
                'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
                'type'		=>	'dropdown',
                'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
                'param_name'=>	'post_slider_3_element_order',
                'value'		=>	$order_options,			
                'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
                'group' 	=>  esc_html__('Advance', DZ_TH_DOMAIN)
            ),
            array(
				'type' 		=> 'checkbox',
				'heading' 	=> esc_html__( 'Show Date', DZ_TH_DOMAIN ),
				'param_name'=> 'post_slider_3_element_show_date',
				'description'=> esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('Extra', DZ_TH_DOMAIN)
            ),
            array(
				'type' 		=> 'checkbox',
				'heading' 	=> esc_html__( 'Show Category', DZ_TH_DOMAIN ),
				'param_name'=> 'post_slider_3_element_show_category',
				'description'=> esc_html__( 'Choose to Show Category.', DZ_TH_DOMAIN ),
				'group' 	=> esc_html__('Extra', DZ_TH_DOMAIN)
            ),
              
			),
		);

/* post listing 1 */
$dz_sc['dz_post_listing_1_element']	=	array(
		'name'        => esc_html__('Post Listing 1', DZ_TH_DOMAIN),
		'base'        => 'dz_post_listing_1_element',
		'class'       => '',
		'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
		'icon'        => 'dz-element-vc' ,
		'description' => esc_html__('Shows Post Listing style 1.', DZ_TH_DOMAIN),	
		'params' 	  => array(
				array(
					'type'		=>	'textfield',
					'heading' 	=>	esc_html__('Title', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_1_element_title',
					'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textarea',
					'heading' 	=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_1_element_description',
					'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown_multi', 
					'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_1_element_posts_in_categories',
					'value' 	=>  $posts_in_categories_options,
					'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'checkbox',
					'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_1_element_only_featured_posts',
					'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Pagination Style', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_1_element_pagination_style',
					'description'=>	esc_html__('You can choose pagination style from here.', DZ_TH_DOMAIN ),
					'value' 	=> $pagination_options,
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		 =>	'textfield',
					'heading'	 =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
					'param_name' =>	'post_listing_1_element_no_of_posts',
					'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
					'value'		 => '10',
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textfield',
					'heading'	=>	esc_html__('Title Text Limit', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_1_element_title_text_limit',
					'description'=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
					'value'		=> 	'5',
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textfield',
					'heading'	=>	esc_html__('Description Text Limit', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_1_element_description_text_limit',
					'description'=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
					'value'		=> 	'5',
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_1_element_image_preference',
					'value'		=> $image_preference_options,
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
					'param_name'=>	'post_listing_1_element_orderby',
					'value'		=>	$orderby_options,
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
					'param_name'=>	'post_listing_1_element_order',
					'value'		=>	$order_options,			
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	 =>  esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
				  'type'		=>	'dropdown',
				  'heading'		=>	esc_html__('Select Column', DZ_TH_DOMAIN),
				  'param_name'	=>	'post_listing_1_element_cols',
				  'value'		=>	$column_options,				
				  'description'	=>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
				  'group'       => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
					'param_name' => 'post_listing_1_element_selected_sidebar',
					'value'      => $selected_sidebar_options,
					'description'=> esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
					'group'      => esc_html__('Sidebar', DZ_TH_DOMAIN)
				),
				array(
					'type'	      =>	'dropdown',
					'heading'     =>	esc_html__('Sidebar Selection', DZ_TH_DOMAIN),
					'param_name'  =>	'post_listing_1_element_sidebar_layout',
					'value'		  =>	$sidebar_layout_options,			
					'description' =>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
					'group'       =>  esc_html__('Sidebar', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Date', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_1_element_show_date',
					'description' => esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Share', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_1_element_show_share',
					'description' => esc_html__( 'Choose to Show Share.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Comment', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_1_element_show_comment',
					'description' => esc_html__( 'Choose to Show Comment.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
		),

	);

/* post listing 2 */
$dz_sc['dz_post_listing_2_element']	=	array(
		'name'        => esc_html__('Post Listing 2', DZ_TH_DOMAIN),
		'base'        => 'dz_post_listing_2_element',
		'class'       => '',
		'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
		'icon'        => 'dz-element-vc' ,
		'description' => esc_html__('Shows Post Listing style 2.', DZ_TH_DOMAIN),	
		'params' 	  => array(
				array(
					'type'		=>	'textfield',
					'heading' 	=>	esc_html__('Title', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_2_element_title',
					'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
					'group' 	=>  esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textarea',
					'heading' 	=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_2_element_description',
					'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
					'group' 	=>  esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown_multi', 
					'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_2_element_posts_in_categories',
					'value' 	=>  $posts_in_categories_options,
					'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					 'type' 	 => 'checkbox',
					 'heading' 	 => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
					 'param_name'=> 'post_listing_2_element_only_featured_posts',
					 'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
					 'group' 	 => esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'		 =>	'dropdown',
					'heading'	 =>	esc_html__('Pagination Style', DZ_TH_DOMAIN ),
					'param_name' =>	'post_listing_2_element_pagination_style',
					'description'=>	esc_html__('You can choose pagination style from here.', DZ_TH_DOMAIN ),
					'value' 	 => $pagination_options,
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		 =>	'textfield',
					'heading'	 =>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
					'param_name' =>	'post_listing_2_element_text_limit',
					'description'=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
					'value'		 => 	'7',
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		  =>	'textfield',
					'heading'	  =>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
					'param_name'  =>	'post_listing_2_element_no_of_posts',
					'description' =>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
					'value'		  => '10',
					'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'dropdown',
					'heading' 	  => esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_2_element_image_preference',
					'value'		  => $image_preference_options,
					'group' 	  => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		 =>	'dropdown',
					'heading'	 =>	esc_html__('Order By', DZ_TH_DOMAIN),
					'param_name' =>	'post_listing_2_element_orderby',
					'value'		 =>	$orderby_options,
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'	     =>	'dropdown',
					'heading'	 =>	esc_html__('Order', DZ_TH_DOMAIN),
					'param_name' =>	'post_listing_2_element_order',
					'value'		 =>	$order_options,			
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
				   'type'        => 'dropdown',
				   'heading'     => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
				   'param_name'  => 'post_listing_2_element_selected_sidebar',
				   'value'       => $selected_sidebar_options,
				   'description' => esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
					'group'      => esc_html__('Sidebar', DZ_TH_DOMAIN)
				),
				array(
					'type'	      =>	'dropdown',
					'heading'     =>	esc_html__('Sidebar Selection', DZ_TH_DOMAIN),
					'param_name'  =>	'post_listing_2_element_sidebar_layout',
					'value'		  =>	$sidebar_layout_options,			
					'description' =>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
					'group'       => esc_html__('Sidebar', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Date', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_2_element_show_date',
					'description' => esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Author', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_2_element_show_author',
					'description' => esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Share', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_2_element_show_share',
					'description' => esc_html__( 'Choose to Show Share.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Comment', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_2_element_show_comment',
					'description' => esc_html__( 'Choose to Show Comment.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
		),
			
	);	
	
/* post listing 3 */
$dz_sc['dz_post_listing_3_element']	=	array(
		'name'        => esc_html__('Post Listing 3', DZ_TH_DOMAIN),
		'base'        => 'dz_post_listing_3_element',
		'class'       => '',
		'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
		'icon'        => 'dz-element-vc' ,
		'description' => esc_html__('Shows Post Listing style 3.', DZ_TH_DOMAIN),	
		'params' => array(
				array(
					'type'		=>	'textfield',
					'heading' 	=>	esc_html__('Title', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_3_element_title',
					'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
					'group' 	=>  esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textarea',
					'heading' 	=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_3_element_description',
					'value'		=> 	esc_html__('', DZ_TH_DOMAIN ),
					'group' 	=>  esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown_multi', 
					'heading' 	=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_3_element_posts_in_categories',
					'value' 	=>  $posts_in_categories_options,
					'description'=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
					'group' 	=> esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'checkbox',
					'heading' 	=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_3_element_only_featured_posts',
					'description'=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
					'group' 	 => esc_html__('General', DZ_TH_DOMAIN)
				),
				array(
					'type'		 =>	'dropdown',
					'heading'	 =>	esc_html__('Pagination Style', DZ_TH_DOMAIN ),
					'param_name' =>	'post_listing_3_element_pagination_style',
					'description'=>	esc_html__('You can choose pagination style from here.', DZ_TH_DOMAIN ),
					'value' 	 => $pagination_options,
					'group' 	 => esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textfield',
					'heading'	=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_3_element_text_limit',
					'description'=>	esc_html__('Enter text limit', DZ_TH_DOMAIN ),
					'value'		=> 	'7',
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'textfield',
					'heading'	=>	esc_html__('No. of Posts Per Page', DZ_TH_DOMAIN ),
					'param_name'=>	'post_listing_3_element_no_of_posts',
					'description'=>	esc_html__('Enter no. of portfolio to show per page.', DZ_TH_DOMAIN ),
					'value'		=> '10',
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type' 		=> 'dropdown',
					'heading' 	=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
					'param_name'=> 'post_listing_3_element_image_preference',
					'value'		=> $image_preference_options,
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order By', DZ_TH_DOMAIN),
					'param_name'=>	'post_listing_3_element_orderby',
					'value'		=>	$orderby_options,
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'		=>	'dropdown',
					'heading'	=>	esc_html__('Order', DZ_TH_DOMAIN),
					'param_name'=>	'post_listing_3_element_order',
					'value'		=>	$order_options,
					'description'=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
					'group' 	=> esc_html__('Advance', DZ_TH_DOMAIN)
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
					'param_name' => 'post_listing_3_element_selected_sidebar',
					'value'      => $selected_sidebar_options,
					'description'=> esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
					'group'      => esc_html__('Sidebar', DZ_TH_DOMAIN)
				),
				array(
					'type'	      =>	'dropdown',
					'heading'     =>	esc_html__('Sidebar Selection', DZ_TH_DOMAIN),
					'param_name'  =>	'post_listing_3_element_sidebar_layout',
					'value'		  =>	$sidebar_layout_options,
					'description' =>	esc_html__('Select Sidebar or show with out sidebar.', DZ_TH_DOMAIN),
					'group'       => esc_html__('Sidebar', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Date', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_3_element_show_date',
					'description' => esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Author', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_3_element_show_author',
					'description' => esc_html__( 'Choose to Show Date.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Share', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_3_element_show_share',
					'description' => esc_html__( 'Choose to Show Share.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
				array(
					'type' 		  => 'checkbox',
					'heading' 	  => esc_html__( 'Show Comment', DZ_TH_DOMAIN ),
					'param_name'  => 'post_listing_3_element_show_comment',
					'description' => esc_html__( 'Choose to Show Comment.', DZ_TH_DOMAIN ),
					'group' 	  => esc_html__('Extra', DZ_TH_DOMAIN)
				),
			),
	);

/* Site Down */
$dz_sc['dz_sitedown_element']	=	array(
					'name'        => esc_html__('Site Down', DZ_TH_DOMAIN),
					'base'        => 'dz_sitedown_element',
					'class'       => '',
					'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
					'icon'        => 'dz-element-vc' ,
					'description' => esc_html__('Show Site Down.', DZ_TH_DOMAIN),
					'params' => array(
					),
			);

/* Coming Soon */
$dz_sc['dz_comingsoon_element']	=	array(
					'name'        => esc_html__('Coming Soon', DZ_TH_DOMAIN),
					'base'        => 'dz_comingsoon_element',
					'class'       => '',
					'category'    => esc_html__('ClinicMaster', DZ_TH_DOMAIN),
					'icon'        => 'dz-element-vc' ,
					'description' => esc_html__('Show Coming Soon.', DZ_TH_DOMAIN),
					'params' => array(
					),
			);   
/*----------------------------------------------------------------------------*/
$dz_sc = apply_filters( '_dz_shortcodes_array', $dz_sc );
	
return $dz_sc;