<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as TagsModule;
class DZContactForm2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-form-2';
	}
	
	public function get_title() {
		return esc_html__('Contact Form 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
	}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_form_2_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		
		
		 $this->add_control(
			'contact_form_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Contact Information ', DZ_TH_DOMAIN ),
				'condition' => [
					'contact_form_2_element_style' => 'style_1',
				],
			]
		);		
		 $this->add_control(
			'contact_form_2_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Thank you for visiting our website. We are here to assist you with any inquiries you may have.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'condition' => [
					'contact_form_2_element_style' => 'style_1',
				],
			]
		); 
		
		
		$this->add_control(
			'contact_form_2_element_form_text',
			[
				'label' 		=> esc_html__( 'Form Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Get in Touch With us', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_form_2_element_form_description',
			[
				'label' 		=> esc_html__( 'Form Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'If you have any questions, you can contact us. Please, fill out the form below.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'condition' => [
					'contact_form_2_element_style' => 'style_1',
				],
			]
		);  
		$this->add_control(
			'contact_form_2_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'contact_form_2_element_style' => 'style_1',
				],
			
			]
		);
		$this->add_control(
			'contact_form_2_element_img2',
			[
				'label' 		=> esc_html__( 'Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'contact_form_2_element_style' => 'style_1',
				],
			
			]
		);
		$this->add_control(
			'contact_form_2_element_img3',
			[
				'label' 		=> esc_html__( 'Image 3', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'contact_form_2_element_style' => 'style_1',
				],
			
			]
		);
		
		$this->add_control(
			'contact_form_2_element_form_bg_img',
			[
				'label' 		=> esc_html__( 'Form Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'contact_form_2_element_style' => 'style_2',
				],
			]
		);
		
	
		$this->add_control(
		'contact_form_2_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
			]
		);
		
		$default_address = esc_html__( 'London Eye, London, United Kingdom', DZ_TH_DOMAIN );
		$this->add_control(
			'address',
			[
				'label' => esc_html__( 'Location', 'elementor' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
					'categories' => [
						TagsModule::POST_META_CATEGORY,
					],
				],
				'ai' => [
					'active' => false,
				],
				'placeholder' => $default_address,
				'default' => $default_address,
				'label_block' => true,
				'condition' => [
					'contact_form_2_element_style' => 'style_2',
				],
			]
			
		);
		
		$this->add_control(
			'contact_form_2_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
				'condition' => [
					'contact_form_2_element_style' => 'style_2',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'Contact',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'contact_form_2_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Working Hours:', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'contact_form_2_element_item_description',
			[
				'label' 	=> esc_html__( 'Description', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => esc_html__( 'Mon-Thu: 8:00am-5:00pm', DZ_TH_DOMAIN ). '</br>'. esc_html__( 'Fri: 8:00am-1:00pm', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'contact_form_2_element_item_icon',
			[
				'label' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::ICONS,	
			]
		); 
		
		
		
		
		$this->add_control(
			'contact_form_2_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'default' 		=> [
					[	
						'contact_form_2_element_item_title' 		=> esc_html__( 'Working Hours:', DZ_TH_DOMAIN ),
						'contact_form_2_element_item_description' 	=> esc_html__( 'Mon-Thu: 8:00am-5:00pm', DZ_TH_DOMAIN ). '</br>'. esc_html__( 'Fri: 8:00am-1:00pm', DZ_TH_DOMAIN ),
					],
					[	
						'contact_form_2_element_item_title' 		=> esc_html__( 'Office Address:', DZ_TH_DOMAIN ),
						'contact_form_2_element_item_description' 	=> esc_html__( '764 15768 Delmer Shoals,', DZ_TH_DOMAIN ). '</br>'. esc_html__( 'Eliasport, FL 04331-6195', DZ_TH_DOMAIN ),
					],
					
				],
			]
		);
	
		$this->end_controls_section(); 
		
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_form_2_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>