<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as TagsModule;

class DZContactBox1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-box-1';
	}
	
	public function get_title() {
		return esc_html__('Contact Box 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-inner-section';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'       => esc_html__( 'Get in Touch with us', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'contact_box_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'       => esc_html__( 'Lorem Ipsum is simply dummy', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_1_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'       => esc_html__( 'Appointment', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_1_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_1_element_contact_info',
			[
				'label' 		=> esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::SWITCHER ,
				'default'       => 'yes',
				
			]
		);
		$default_address = esc_html__( 'London Eye, London, United Kingdom', 'elementor' );
		$this->add_control(
			'address',
			[
				'label' => esc_html__( 'Location', 'elementor' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
					'categories' => [
						TagsModule::POST_META_CATEGORY,
					],
				],
				'ai' => [
					'active' => false,
				],
				'placeholder' => $default_address,
				'default' => $default_address,
				'label_block' => true,
			]
		);

		
		
		$this->end_controls_section();
		
	
	
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_box_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}