<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as TagsModule;
class DZAppointmentForm2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-appointment-form-2';
	}
	
	public function get_title() {
		return esc_html__('Appointment Form 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'appointment_form_2_element_title',
			[
				'label' 		=> esc_html__( 'Form Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Book Your Appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_form_2_element_address_text',
			[
				'label' 		=> esc_html__( 'Address Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Office Address:', DZ_TH_DOMAIN ),
			]
		);
		
		$default_address = esc_html__( '234 Oak Drive, Villagetown, USA', DZ_TH_DOMAIN );
		$this->add_control(
			'address',
			[
				'label' => esc_html__( 'Location', 'elementor' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
					'categories' => [
						TagsModule::POST_META_CATEGORY,
					],
				],
				'ai' => [
					'active' => false,
				],
				'placeholder' => $default_address,
				'default' => $default_address,
				'label_block' => true,
			]
		);
		$this->add_control(
			'appointment_form_2_element_hours_text',
			[
				'label' 		=> esc_html__( 'Hours Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Working Hours:', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_form_2_element_hours',
			[
				'label' 		=> esc_html__( 'Hours', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Text', DZ_TH_DOMAIN ),
				'default' 	=> 'Mon-Thu: 8:00am-5:00pm </br> Fri: 8:00am-1:00pm'
			]
		);
		
		$this->add_control(
		'appointment_form_2_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
			]
		);
		
		
		
		$this->end_controls_section();
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/appointment_form_2_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}