<?php

function clinicmaster_dzbase()
{
	return $GLOBALS['_dz_base'];
}

/**
 * Check if WooCommerce is active
 **/
function clinicmaster_is_woocommerce_active() {
	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
		return true;
	} else {
		return false;
	}
}

/** A function to fetch the categories from wordpress */
function clinicmaster_get_categories($arg = false)
{
	global $wp_taxonomies;

	$clinicmaster_categories_default_args = array(
		'orderby'            => 'ID',
		'order'              => 'ASC',
		'hide_empty'         => 1,
		'hierarchical'       => true,
	);

	if (!empty($arg['taxonomy']) && isset($wp_taxonomies[$arg['taxonomy']])) {
		$clinicmaster_categories_default_args['taxonomy'] = $arg['taxonomy'];
	}

	$categories = get_categories($clinicmaster_categories_default_args);
	$cats = array();

	if (!is_wp_error($categories)) {
		foreach ($categories as $category) {
			$cats[$category->slug] = wp_kses($category->name, 'string');
		}
	}
	return $cats;
}

// function clinicmaster_get_the_breadcrumb($class = null)
// {
	// global $wp_query;

	// $queried_object = get_queried_object();
	// $breadcrumb = '';
	// $delimiter = ' ';
	// $before = '<li class="breadcrumb-item">';
	// $after = '</li>';
	// if (!is_home()) {
		// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(home_url('/')) . '"> ' . esc_html__('Home', 'clinicmaster') . '</a></li>';

		// /** If category or single post */
		// if (is_category()) {

			// $cat_obj = $wp_query->get_queried_object();
			// $this_category = get_category($cat_obj->term_id);

			// if ($this_category->parent != 0) {
				// $parent_category = get_category($this_category->parent);
				// $parent_string = get_category_parents($parent_category, TRUE, '@');
				// $parent_tree = explode('@', $parent_string);
				// $parent_tree = array_filter($parent_tree);
				// foreach ($parent_tree as $cat_link) {
					// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($cat_link, clinicmaster_allowed_html_tag()) . '</li>';
				// }
			// }
			// $single_cat_title = single_cat_title('', FALSE);
			// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($single_cat_title, clinicmaster_allowed_html_tag()) . '</li>';
		// } elseif (is_tax()) {
			// $term_link = !empty($queried_object) ? get_term_link($queried_object) : '';
			// $term_name = !empty($queried_object->name) ? $queried_object->name : '';
			// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($term_link) . '">' . wp_kses($term_name, clinicmaster_allowed_html_tag()) . '</a></li>';
		// } elseif (is_page())
		// /** If WP pages */
		// {
			// global $post;

			// if ($post->post_parent) {
				// $anc = get_post_ancestors($post->ID);
				// foreach ($anc as $ancestor) {
					// $perma_link = get_permalink($ancestor);
					// $ancestor_title = get_the_title($ancestor);
					// $post_title = get_the_title($post->ID);
					// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($perma_link) . '">' . wp_kses($ancestor_title, clinicmaster_allowed_html_tag()) . '</a></li>';
				// }
				// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($post_title, 'string') . '</li>';
			// } else {
				// $post_title = get_the_title();
				// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($post_title, 'string') . '</li>';
			// }
		// } elseif (is_singular()) {

			// if ($category = wp_get_object_terms(get_the_ID(), 'category')) {
				// if (!is_wp_error($category)) {
					// $term_link = get_term_link(clinicmaster_set($category, '0'));
					// $name = clinicmaster_set(clinicmaster_set($category, '0'), 'name');
					// $title = get_the_title();
					// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($term_link) . '">' . wp_kses($name, clinicmaster_allowed_html_tag()) . '</a></li>';
					// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($title, 'string') . '</li>';
				// } else {
					// $title = get_the_title();
					// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($title, 'string') . '</li>';
				// }
			// } else {
				// $title = add_theme_support('', false);
				// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($title, 'string') . '</li>';
			// }
		// } elseif (is_tag()) {
			// $term_link = get_term_link($queried_object);
			// $title = single_tag_title('', FALSE);
			// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($term_link) . '">' . wp_kses($title, 'string') . '</a></li>';
			// /**If tag template*/
		// } elseif (is_day()) {
			// $time = get_the_time('F jS, Y');
			// $breadcrumb .= '<li class="breadcrumb-item"><a href="#">' . esc_html__('Archive for ', 'clinicmaster') . wp_kses($time, 'string') . '</a></li>';
			// /** If daily Archives */
		// } elseif (is_month()) {
			// $link = get_month_link(get_the_time('Y'), get_the_time('m'));
			// $time = get_the_time('F, Y');
			// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($link) . '">' . esc_html__('Archive for ', 'clinicmaster') . wp_kses($time, 'string') . '</a></li>';
			// /** If montly Archives */
		// } elseif (is_year()) {
			// $link = get_year_link(get_the_time('Y'));
			// $time = get_the_time('Y');
			// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($link) . '">' . esc_html__('Archive for ', 'clinicmaster') . wp_kses($time, 'string') . '</a></li>';
			// /** If year Archives */
		// } elseif (is_author()) {
			// $link = get_author_posts_url(get_the_author_meta("ID"));
			// $author = get_the_author();
			// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($link) . '">' . esc_html__('Archive for ', 'clinicmaster') . wp_kses($author, 'string') . '</a></li>';
			// /** If author Archives */
		// } elseif (is_search()) {
			// $search_query = get_search_query();
			// $breadcrumb .= '<li class="breadcrumb-item">' . esc_html__('Search Results for ', 'clinicmaster') . wp_kses($search_query, clinicmaster_allowed_html_tag()) . '</li>';
			// /** if search template */
		// } elseif (is_404()) {
			// $breadcrumb .= '<li class="breadcrumb-item">' . esc_html__('404 - Not Found', 'clinicmaster') . '</li>';
			// /** if search template */
		// } elseif (function_exists('is_shop') && is_shop()) {
			// $term_name = !empty(clinicmaster_get_opt('woocommerce_page_title')) ? clinicmaster_get_opt('woocommerce_page_title') : get_the_title(wc_get_page_id('shop'));
			// $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($term_name, 'string') . '</li>';
			// /** if search template */
		// } elseif (is_archive()) {

			// $breadcrumb .= '<li class="breadcrumb-item"><a href="#">' .  add_theme_support('', false) . '</a></li>';
		// } else {

			// $link = get_permalink();
			// $title = get_the_title();
			// if (!empty($title)) {
				// $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($link) . '">' . esc_html($title) . '</a></li>';
				// /** Default value */
			// }
		// }

		// /* To hide if only one li is available */
		// if (substr_count($breadcrumb, '<li class="breadcrumb-item">') <= 1) {
			// $breadcrumb = '';
		// }
	// }

	// if (!empty($breadcrumb)) {
		// $breadcrumb = '<ul class="breadcrumb ' . $class . '">' . $breadcrumb . '</ul>';
	// }
	// return $breadcrumb;
// }
function clinicmaster_get_the_breadcrumb($class = null)
{
    global $wp_query;

    $queried_object = get_queried_object();
    $breadcrumb = '';
    $delimiter = ' ';
    $before = '<li class="breadcrumb-item">';
    $after = '</li>';
    if (!is_home()) {
        $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(home_url('/')) . '"> ' . esc_html__('Home', 'clinicmaster') . '</a></li>';

        if (is_category()) {
            $cat_obj = $wp_query->get_queried_object();
            $this_category = get_category($cat_obj->term_id);

            if (!empty($this_category->parent)) {
                $parent_category = get_category($this_category->parent);
                $parent_string = get_category_parents($parent_category, true, '@');
                $parent_tree = array_filter(explode('@', $parent_string));

                foreach ($parent_tree as $cat_link) {
                    $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses($cat_link, clinicmaster_allowed_html_tag()) . '</li>';
                }
            }

            $single_cat_title = single_cat_title('', false);
            $breadcrumb .= '<li class="breadcrumb-item">' . wp_kses_post($single_cat_title) . '</li>';
        } elseif (is_tax()) {
            if (!empty($queried_object)) {
                $term_link = get_term_link($queried_object);
                $term_name = !empty($queried_object->name) ? $queried_object->name : '';
                $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($term_link) . '">' . wp_kses_post($term_name) . '</a></li>';
            }
        } elseif (is_page()) {
            global $post;
            if ($post->post_parent) {
                $ancestors = get_post_ancestors($post->ID);
                foreach (array_reverse($ancestors) as $ancestor) {
                    $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(get_permalink($ancestor)) . '">' . esc_html(get_the_title($ancestor)) . '</a></li>';
                }
            }
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html(get_the_title()) . '</li>';
        } elseif (is_singular()) {
            $category = wp_get_object_terms(get_the_ID(), 'category');
            if (!empty($category) && !is_wp_error($category)) {
                $category_data = reset($category);
                $term_link = get_term_link($category_data);
                $name = $category_data->name;
                $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($term_link) . '">' . esc_html($name) . '</a></li>';
            }
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html(get_the_title()) . '</li>';
        } elseif (is_tag()) {
            $term_link = get_term_link($queried_object);
            $title = single_tag_title('', false);
            $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url($term_link) . '">' . esc_html($title) . '</a></li>';
        } elseif (is_day()) {
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html__('Archive for ', 'clinicmaster') . esc_html(get_the_time('F jS, Y')) . '</li>';
        } elseif (is_month()) {
            $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(get_month_link(get_the_time('Y'), get_the_time('m'))) . '">' . esc_html__('Archive for ', 'clinicmaster') . esc_html(get_the_time('F, Y')) . '</a></li>';
        } elseif (is_year()) {
            $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(get_year_link(get_the_time('Y'))) . '">' . esc_html__('Archive for ', 'clinicmaster') . esc_html(get_the_time('Y')) . '</a></li>';
        } elseif (is_author()) {
            $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(get_author_posts_url(get_the_author_meta("ID"))) . '">' . esc_html__('Archive for ', 'clinicmaster') . esc_html(get_the_author()) . '</a></li>';
        } elseif (is_search()) {
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html__('Search Results for ', 'clinicmaster') . esc_html(get_search_query()) . '</li>';
        } elseif (is_404()) {
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html__('404 - Not Found', 'clinicmaster') . '</li>';
        } elseif (function_exists('is_shop') && is_shop()) {
            $term_name = !empty(clinicmaster_get_opt('woocommerce_page_title')) ? clinicmaster_get_opt('woocommerce_page_title') : get_the_title(wc_get_page_id('shop'));
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html($term_name) . '</li>';
        } elseif (is_archive()) {
            $breadcrumb .= '<li class="breadcrumb-item">' . esc_html__('Archive', 'clinicmaster') . '</li>';
        } else {
            $breadcrumb .= '<li class="breadcrumb-item"><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></li>';
        }

        // Agar sirf ek breadcrumb item ho, toh usko empty kar do
        if (substr_count($breadcrumb, '<li class="breadcrumb-item">') <= 1) {
            $breadcrumb = '';
        }
    }

    if (!empty($breadcrumb)) {
        $breadcrumb = '<ul class="breadcrumb ' . esc_attr($class) . '">' . $breadcrumb . '</ul>';
    }

    return $breadcrumb;
}

function clinicmaster_bunch_list_comments($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment;
	$email = clinicmaster_set($comment, 'comment_author_email');
	$avatar = get_avatar($email, 130);
	$comment_id = get_comment_ID();
	$author_link = get_comment_author($comment_id);
	$comment_date_link = get_month_link(get_the_date('Y'), get_the_date('m'));
	$comment_date = get_comment_date('F j, Y', $comment_id);
?>
	<li <?php comment_class('comment'); ?> id="comment-<?php comment_ID(); ?>">
		<div class="comment-body" id="div-comment-<?php comment_ID(); ?>">
			<div class="comment-author vcard">
				<?php echo wp_kses($avatar, clinicmaster_allowed_html_tag()); ?>

				<cite class="fn">
					<?php echo wp_kses($author_link, clinicmaster_allowed_html_tag()); ?>
				</cite>

				<span class="says">
					<?php esc_html_e('says:', 'clinicmaster'); ?>
				</span>
			</div>

			<div class="comment-content ic-page-text">
				<?php comment_text(); ?>
			</div>

			<div class="reply">
				<?php
				comment_reply_link(
					array_merge(
						$args,
						array(
							'depth' => $depth,
							'max_depth' => $args['max_depth'],
							'reply_text' => '<i class="fa fa-reply"></i>' . esc_html__('Reply', 'clinicmaster'),
							'add_below' => 'div-comment',
						)
					)
				);
				?>
			</div>
		</div>
		<?php
	}

	add_filter('comment_form_defaults', 'clinicmaster_move_comment_field');
	function clinicmaster_move_comment_field($input)
	{
		if ('comment_form_defaults' === current_filter() && !is_user_logged_in()) {
			// Copy the field to our internal variable …
			$textarea = $input['comment_field'];
			$input['comment_field'] = '';
			// … and remove it from the defaults array.
			$input['fields']['comment_field'] = $textarea;
		}

		return $input;
	}

	/**
	 * returns the formatted form of the comments
	 *
	 * @param	array	$args		an array of arguments to be filtered
	 * @param	int		$post_id	if form is called within the loop then post_id is optional
	 *
	 * @return	string	Return the comment form
	 */
	function clinicmaster_bunch_comment_form($args = array(), $post_id = null, $review = false)
	{
		if (null === $post_id) {
			$post_id = get_the_ID();
		} else {
			$id = $post_id;
		}
		$commenter = wp_get_current_commenter();
		$user = wp_get_current_user();
		$user_identity = $user->exists() ? $user->display_name : '';
		$args = wp_parse_args($args);
		if (!isset($args['format'])) {
			$args['format'] = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';
		}
		$req      = get_option('require_name_email');
		$aria_req = ($req ? " aria-required='true'" : '');
		$html5    = 'html5' === $args['format'];
		$fields   =  array(
			'author' => '<p class="comment-form-author"><input id="name" placeholder="' . esc_attr__('Author', 'clinicmaster') . '"  name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" ' . $aria_req . ' /></p>',
			'email'  => ' <p class="comment-form-email"><input id="email" required placeholder="' . esc_attr__('Email', 'clinicmaster') . '" name="email" ' . ($html5 ? 'type="email"' : 'type="text"') . ' value="' . esc_attr($commenter['comment_author_email']) . '" ' . $aria_req . ' /></p>',
		);
		$required_text = sprintf(' ' . esc_html__('Required fields are marked %s', 'clinicmaster'), '<span class="required">*</span>');
		/**
		 * Filter the default comment form fields.
		 *
		 * @since 3.0.0
		 *
		 * @param array $fields The default comment fields.
		 */
		$clinicmaster_col = (is_user_logged_in()) ? 'col-md-12' : '';
		$fields = apply_filters('comment_form_default_fields', $fields);
		$defaults = array(
			'fields'               => $fields,
			'comment_field'        => '<p class="comment-form-comment"><textarea id="comments" placeholder="' . esc_attr__('Type Comment Here', 'clinicmaster') . '" class="form-control4" name="comment" cols="45" rows="3" aria-required="true" required="required"></textarea></p>',
			'must_log_in'          => '<p class="col-md-12 col-sm-12">' . sprintf(__('You must be <a href="%s">logged in</a> to post a comment.', 'clinicmaster'), esc_url(wp_login_url(apply_filters('the_permalink', get_permalink($post_id))))) . '</p>',
			'logged_in_as'         => '<p class="col-md-12 col-sm-12">' . sprintf(__('Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="' . esc_attr__('Log out of this account', 'clinicmaster') . '">' . esc_html__('Log out?', 'clinicmaster') . '</a>', 'clinicmaster'), get_edit_user_link(), $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</p>',
			'comment_notes_before' => '',
			'comment_notes_after'  => '',
			'id_form'              => 'comments_form',
			'id_submit'            => 'submit',
			'class_submit'         => 'submit btn btn-primary btn-rounded btn-lg filled',
			'title_reply'          => esc_html__('Good Comment', 'clinicmaster'),
			'title_reply_to'       => esc_html__('Leave a Reply to %s', 'clinicmaster'),
			'cancel_reply_link'    => esc_html__('Cancel reply', 'clinicmaster'),
			'label_submit'         => esc_html__('Submit Now ', 'clinicmaster'),
			'title_reply_before'   => '<div class="widget-title"><h4 class="title">',
			'title_reply_after'    => '</h4></div>',
			'format'               => 'xhtml',
		);
		/**
		 * Filter the comment form default arguments.
		 *
		 * Use 'comment_form_default_fields' to filter the comment fields.
		 *
		 * @since 3.0.0
		 *
		 * @param array $defaults The default comment form arguments.
		 */
		$args = wp_parse_args($args, apply_filters('comment_form_defaults', $defaults));

		if (comments_open($post_id)) : ?>
			<?php
			/**
			 * Fires before the comment form.
			 *
			 * @since 3.0.0
			 */
			do_action('comment_form_before');
			?>
			<div id="respond" class="default-form comment-respond style-1 m-b30">
				<?php if (get_option('comment_registration') && !is_user_logged_in()) : ?>
					<?php echo wp_kses($args['must_log_in'], clinicmaster_allowed_html_tag()); ?>
					<?php
					/**
					 * Fires after the HTML-formatted 'must log in after' message in the comment form.
					 *
					 * @since 3.0.0
					 */
					do_action('comment_form_must_log_in_after');
					?>
				<?php else : ?>
					<div class="clearfix">
						<?php
						echo comment_form($args, $post_id);
						?>
					</div>
				<?php endif; ?>
			</div><!-- #respond -->
		<?php
			/**
			 * Fires after the comment form.
			 *
			 * @since 3.0.0
			 */
			do_action('comment_form_after');
		else :
			/**
			 * Fires after the comment form if comments are closed.
			 *
			 * @since 3.0.0
			 */
			do_action('comment_form_comments_closed');
		endif;
	}

	function clinicmaster_the_pagination($query = array(), $args = array(), $echo = 1)
	{
		global $wp_query;


		if (!empty($query)) {
			$temp_query = $wp_query;
			$wp_query   = NULL;
			$wp_query   = $query;
		}

		$paged = get_query_var('paged');

		$default =  array(
			'base' => str_replace(99999, '%#%', esc_url(get_pagenum_link(99999))),
			'format' => '?paged=%#%',
			'current' => max(1, $paged),
			'total' => $wp_query->max_num_pages,
			'prev_text' => '<i class="fas fa-chevron-left"></i>',
			'next_text' => '<i class="fas fa-chevron-right"></i>',
			'type' => 'list',
			'add_args' => false,
			'show_all' => true,
		);

		$args = wp_parse_args($args, $default);
		$pagination_link = !empty(paginate_links($args)) ? paginate_links($args) : '';
		$pagination = str_replace("<ul class='page-numbers'", '<ul class="pagination style-1 text-center m-b30 m-t40"', $pagination_link);
		$pagination = $pagination;

		echo wp_kses($pagination, clinicmaster_allowed_html_tag());
	}

	function clinicmaster_trim($text, $len, $more = null)
	{
		
		$text = strip_shortcodes($text);
		$text = str_replace(']]>', ']]&gt;', $text);
		$excerpt_length = apply_filters('excerpt_length', $len);	/* Issue Remaining */
		$excerpt_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');
		$excerpt_more = ($more) ? $more : '.';
		$text = wp_trim_words($text, $len, $excerpt_more);

		return $text;
	}

	/**
	 *
	 * Excerpt More Settings
	 *
	 */
	function clinicmaster_excerpt_more()
	{
		return ' ';
	}
	add_filter('excerpt_more', 'clinicmaster_excerpt_more');

	/* Used on footer and header area */
	/* Used on footer and header area */
	function clinicmaster_get_social_icons($show_position = 'all', $default_class = 'dz-social', $header_social_key = '', $show_icon_name = false)
	{
		$options = clinicmaster_dzbase()->option();

		$output = '';
		$target = !empty($options['social_link_target']) ? $options['social_link_target'] : '_self';
		$social_link_options = clinicmaster_social_link_options();

		if ($show_position == 'header') {

			/*reCheck function and rebuild it for fast performance */

			$clinicmaster_option = getDZThemeReduxOption();
			if (is_array($header_social_key)) {
				$header_social_links = $header_social_key;
			} else {
				
				$header_social_links = clinicmaster_set($clinicmaster_option, $header_social_key,'');
			}


			$header_show_links = [];
			$updated_social_links = array();
			if (!empty($header_social_links) && is_array($header_social_links)) {
				foreach ($header_social_links as $key => $value) {
					if ($value == 1) {
						$header_show_links[] = $key;
					}
				}
			}
			if (!empty($social_link_options) && is_array($social_link_options)) {
				foreach ($social_link_options as $social_key => $social_link) {
					if (in_array($social_link['id'], $header_show_links)) {
						$updated_social_links[$social_key] = $social_link;
					}
				}
			}

			$social_link_options = $updated_social_links;
		}

		if (!empty($social_link_options)) {
			foreach ($social_link_options as $social_link) {


				$id = $social_link['id'];
				$sl_id = 'social_' . $id . '_url';

				$sl_title = $social_link['title'];
				if (!empty($show_icon_name)) {
					if (!empty($options[$sl_id])) {
						if($id == 'twitter'){
							$icon_class = 'fa-brands fa-x-twitter';
						}elseif($id == 'facebook'){
							$icon_class = 'fa fa-facebook';
						}else{
							$icon_class = 'fab fa-'.$id;
						}
						$output .= '<li><a target="' . esc_attr($target) . '" href="' . esc_url($options[$sl_id]) . '">' . $sl_title . '</a></li>' . "\n";
					}
				} else {
					if (!empty($options[$sl_id])) {
	
						if($id == 'twitter'){
							$icon_class = 'fa-brands fa-x-twitter';
						}elseif($id == 'facebook'){
							$icon_class = 'fa fa-facebook';
						}else{
							$icon_class = 'fab fa-'.$id;
						}
						$output .= '<li><a target="' . esc_attr($target) . '" href="' . esc_url($options[$sl_id]) . '"  class="' . esc_attr($default_class) . '"><i class="'. $icon_class . '" ></i> </a></li>' . "\n";
					}
				}
			}
		}
		return $output;
	}

	function clinicmaster_short_description($excerpt = '', $content = '', $limit = 250, $more = null)
	{

		if (empty($excerpt) && empty($content)) {
			return false;
		}

		$short_description = '';

		if (!empty($excerpt)) {
			$short_description = $excerpt;
		} else {
			if (has_blocks($content)) {
				$blocks = parse_blocks($content);

				foreach ($blocks as $k) {
					if ($k['blockName'] === 'core/paragraph') {
						if (!empty($k['innerHTML'])) {
							$short_description = $k['innerHTML'];
							break;
						}
					}
				}
			} else {
				$short_description = $content;
			}
		}
		$short_description = clinicmaster_trim($short_description, $limit, $more);

		return $short_description;
	}
	/*
		Ajax - Home pages listing
	*/


	function clinicmaster_load_posts_by_ajax_callback()
	{
		check_ajax_referer('ajax_security_key', 'security');
		global $clinicmaster_query_result;
		
		$post_type = !empty($_POST['post_type']) ? sanitize_text_field($_POST['post_type']) : 'post';

		$query_args = array(
			'post_type' 		=> $post_type,
			'post_status' 		=> 'publish',
			'posts_per_page'   	=> sanitize_text_field($_POST['posts_per_page']),
			'paged' 			=> sanitize_text_field($_POST['page']),
			'order' 			=> sanitize_text_field($_POST['post_order']),
			'ignore_sticky_posts' => true,
		);


		if (!empty($_POST['posts_image_preference']) && $_POST['posts_image_preference'] == 'image_post_only') {
			$query_args['meta_query'] = array(
				array(
					'key' => '_thumbnail_id',
					'compare' => 'EXISTS'
				),
			);
		} elseif (!empty($_POST['posts_image_preference']) && $_POST['posts_image_preference'] == 'text_post_only') {
			$query_args['meta_query'] = array(
				array(
					'key' => '_thumbnail_id',
					'compare' => 'Not EXISTS'
				),
			);
		}

		if (!empty($_POST['posts_in_categories']) && $_POST['posts_in_categories']) {

			if (!empty($_POST['post_type']) && $_POST['post_type'] != 'post') {
				/* This is category searching only for custom post type */
				$cat_arr = explode(',', sanitize_text_field($_POST['posts_in_categories']));


				if ($post_type == 'product') {

					$taxonomy = 'product_cat';
				} else {

					$taxonomy = get_object_taxonomies($post_type);
					$taxonomy = !empty($taxonomy[0]) ? $taxonomy[0] : 'category';
				}


				$query_args['tax_query'][] = array(
					'taxonomy' => $taxonomy,
					'field' => 'slug',
					'terms' => $cat_arr,
					'operator' => 'IN'
				);
			} else {
				$query_args['category_name'] = sanitize_text_field($_POST['posts_in_categories']);
			}
		}

		if (!empty($_POST['post_by_label']) && $_POST['post_by_label'] == 'sticky_only') {
			$query_args['post__in']	= get_option('sticky_posts');
			$query_args['ignore_sticky_posts']	= true;
		}

		if (!empty($_POST['only_featured_post']) && $_POST['only_featured_post'] == 'yes') {
			$query_args['meta_key'] = 'featured_post';
			$query_args['meta_value'] = 1;
			$query_args['meta_compare'] = 'LIKE';
		}

		if (!empty($_POST['post_order_by']) && $_POST['post_order_by'] == 'views_count') {
			$query_args['meta_key']	= '_views_count';
		} else {
			$query_args['orderby']	= !empty($_POST['post_order_by']) ? sanitize_text_field($_POST['post_order_by']): '';
		}



		$query = new WP_Query($query_args);
		$clinicmaster_query_result['posts'] = $query->posts;
		$clinicmaster_query_result['posts_per_page'] = !empty($_POST['posts_per_page']) ? sanitize_text_field($_POST['posts_per_page']) : '';
		$clinicmaster_query_result['current_page'] = !empty($_POST['page']) ? sanitize_text_field($_POST['page']): '';
		$clinicmaster_query_result['side_bar'] = !empty($_POST['side_bar']) ? sanitize_text_field($_POST['side_bar']): '';
		$clinicmaster_query_result['title_text_limit'] = !empty($_POST['title_text_limit']) ? sanitize_text_field($_POST['title_text_limit']): '';
		$clinicmaster_query_result['description_text_limit'] = !empty($_POST['description_text_limit']) ? sanitize_text_field($_POST['description_text_limit']): '';

		$clinicmaster_query_result['theme_color'] = !empty($_POST['theme_color']) ?		sanitize_text_field($_POST['theme_color']) : 'dark';
		$clinicmaster_query_result['desination_on'] = !empty($_POST['desination_on']) ?	sanitize_text_field($_POST['desination_on']) : '';
		$clinicmaster_query_result['social_on'] = !empty($_POST['social_on']) ?	sanitize_text_field($_POST['social_on']) : '';
		$clinicmaster_query_result['team_detail'] = !empty($_POST['team_detail']) ?	sanitize_text_field($_POST['team_detail']) : '';
		$clinicmaster_query_result['read_more'] = !empty($_POST['read_more']) ?			sanitize_text_field($_POST['read_more']) : '';
		$clinicmaster_query_result['hide_category'] = !empty($_POST['hide_category']) ?	sanitize_text_field($_POST['hide_category']) : '';
		$clinicmaster_query_result['show_date'] = !empty($_POST['show_date']) ?			sanitize_text_field($_POST['show_date']) : '';
		$clinicmaster_query_result['show_author'] = !empty($_POST['show_author']) ?		sanitize_text_field($_POST['show_author']) : '';
		$clinicmaster_query_result['show_comment'] = !empty($_POST['show_comment']) ?	sanitize_text_field($_POST['show_comment']) : '';
		$clinicmaster_query_result['show_share'] = !empty($_POST['show_share']) ?		sanitize_text_field($_POST['show_share']) : '';
		$clinicmaster_query_result['show_column'] = !empty($_POST['show_column']) ?		sanitize_text_field($_POST['show_column']) : '';
		$clinicmaster_query_result['element_style'] = !empty($_POST['element_style']) ?	sanitize_text_field($_POST['element_style']) : 'style_1';
		$clinicmaster_query_result['total_post'] = !empty($_POST['total_post']) ?		sanitize_text_field($_POST['total_post']) : '';
		$clinicmaster_query_result['appointment_text'] = !empty($_POST['appointment_text']) ?		sanitize_text_field($_POST['appointment_text']) : '';
		$clinicmaster_query_result['appointment_link'] = !empty($_POST['appointment_link']) ?		sanitize_text_field($_POST['appointment_link']) : '';
		$clinicmaster_query_result['listing_bg_img'] = !empty($_POST['listing_bg_img']) ?		sanitize_text_field($_POST['listing_bg_img']) : '';

		switch ($_POST['blog_view']) {
			case "post_listing_1":
				get_template_part('dz-inc/elementor/ajax/post_listing_1_ajax');
				break;
			case "post_listing_2":
				get_template_part('dz-inc/elementor/ajax/post_listing_2_ajax');
				break;
			case "team_listing_1":
				get_template_part('dz-inc/elementor/ajax/team_listing_1_ajax');
				break;
			case "service_listing_1":
				get_template_part('dz-inc/elementor/ajax/service_listing_1_ajax');
				break;
			case "service_listing_2":
				get_template_part('dz-inc/elementor/ajax/service_listing_2_ajax');
			break;
			case "testimonial_listing_1":
				get_template_part('dz-inc/elementor/ajax/testimonial_listing_1_ajax');
			break;
			case "testimonial_listing_2":
				get_template_part('dz-inc/elementor/ajax/testimonial_listing_2_ajax');
			break;
			case "product_listing_1":
				get_template_part('dz-inc/elementor/ajax/product_listing_1_ajax');
			break;
		}
		unset($GLOBALS['clinicmaster_query_result']);
		wp_reset_postdata();
		wp_die();
	}

	add_action('wp_ajax_load_posts_by_ajax', 'clinicmaster_load_posts_by_ajax_callback');
	add_action('wp_ajax_nopriv_load_posts_by_ajax', 'clinicmaster_load_posts_by_ajax_callback');

	/*
		AJAX - Mega menu
	*/
	function clinicmaster_load_mega_menu_posts_ajax_callback()
	{
		check_ajax_referer('ajax_security_key', 'security');
		global $clinicmaster_query_result;
		$query_args = array(
			'post_type' 		=> 'post',
			'post_status' 		=> 'publish',
			'posts_per_page'   	=> sanitize_text_field($_POST['posts_per_page']),
			'paged' 			=> sanitize_text_field($_POST['page']),
			'ignore_sticky_posts' => true,
			'orderby' 			=> 'date',
			'order' 			=> 'DESC',
		);

		if ($_POST['posts_in_categories']) {
			$query_args['cat'] = sanitize_text_field($_POST['posts_in_categories']);
		}

		if ($_POST['mega_menu_images_only'] == 'yes') {
			$query_args['meta_query'] = array(
				array(
					'key' => '_thumbnail_id',
					'compare' => 'EXISTS'
				),
			);
		}

		$query = new WP_Query($query_args);
		set_query_var('query', $query);
		get_template_part('dz-inc/ajax/mega_menu_ajax');
		wp_reset_postdata();
		wp_die();
	}

	add_action('wp_ajax_load_mega_menu_posts_by_ajax', 'clinicmaster_load_mega_menu_posts_ajax_callback');
	add_action('wp_ajax_nopriv_load_mega_menu_posts_by_ajax', 'clinicmaster_load_mega_menu_posts_ajax_callback');

	/*
		AJAX - Categories, Search, Tags, Archive, Author
	*/
	function clinicmaster_load_common_page_posts_ajax_callback()
	{
		check_ajax_referer('ajax_security_key', 'security');
		$clinicmaster_query_result = array();

		$query_args = array(
			'post_type' 		=> 'post',
			'post_status' 		=> 'publish',
			'posts_per_page'   	=> sanitize_text_field($_POST['posts_per_page']),
			'paged' 			=> sanitize_text_field($_POST['page']),
			'ignore_sticky_posts' => true,
		);

		$orderby = isset($_POST['orderby']) ?	sanitize_text_field($_POST['orderby']) : 'date';
		$order   = isset($_POST['order']) ?		sanitize_text_field($_POST['order'])   : 'DESC';

		if ($orderby == '_views_count') {
			$query_args['meta_key']	= '_views_count';
			$query_args['order'] = 'DESC';
			$query_args['orderby'] = '_views_count';
		} else {
			$query_args['orderby']	= $orderby;
		}

		$query_args['order'] = $order;

		$template = '';

		if ($_POST['page_view'] == 'author') {
			$query_args['author'] = $_POST['object_data'];
			$template = 'author_ajax';
		}
		if ($_POST['page_view'] == 'category') {
			$query_args['cat'] = $_POST['object_data'];
			$template = 'category_ajax';
		}
		if ($_POST['page_view'] == 'search') {
			$query_args['s'] = $_POST['object_data'];
			$template = 'search_ajax';
		}
		if ($_POST['page_view'] == 'tag') {
			$query_args['tag_id'] = $_POST['object_data'];
			$template = 'tag_ajax';
		}
		if ($_POST['page_view'] == 'archive') {
			$object_data = explode('/', $_POST['object_data']);
			$query_args['year'] = $object_data[0];

			if (isset($object_data[1]) && !empty($object_data[1])) {
				$query_args['monthnum'] = $object_data[1];
			}

			$template = 'archive_ajax';
		}

		$query = new WP_Query($query_args);
		set_query_var('clinicmaster_query_result', $query);
		get_template_part('dz-inc/ajax/' . $template);
		wp_reset_postdata();
		wp_die();
	}
	add_action('wp_ajax_load_common_page_posts_ajax', 'clinicmaster_load_common_page_posts_ajax_callback');
	add_action('wp_ajax_nopriv_load_common_page_posts_ajax', 'clinicmaster_load_common_page_posts_ajax_callback');


	/*
		AJAX - index page :-
	*/
	function clinicmaster_load_latest_posts_ajax_callback()
	{
		check_ajax_referer('ajax_security_key', 'security');
		$clinicmaster_query_result = array();
		$query_args = array(
			'post_type' 		=> 'post',
			'post_status' 		=> 'publish',
			'posts_per_page'   	=> sanitize_text_field($_POST['posts_per_page']),
			'paged' 			=> sanitize_text_field($_POST['page']),
			'orderby' 			=> 'post_date',
			'ignore_sticky_posts' => true,
			'order' 			=> 'DESC',
		);

		$query = new WP_Query($query_args);
		set_query_var('clinicmaster_query_result', $query);
		get_template_part('dz-inc/ajax/index_ajax');
		wp_reset_postdata();
		wp_die();
	}
	add_action('wp_ajax_load_latest_posts_ajax', 'clinicmaster_load_latest_posts_ajax_callback');
	add_action('wp_ajax_nopriv_load_latest_posts_ajax', 'clinicmaster_load_latest_posts_ajax_callback');


	/*
		AJAX - Theme status changed :-
		-- change website mode from coming to live mode
	*/
	function clinicmaster_change_theme_status_ajax()
	{
		check_ajax_referer('ajax_security_key', 'security');

		if (class_exists('Redux')) {
			Redux::set_option(clinicmaster_get_opt_name(), 'website_status', 'live_mode');
		}

		return true;

		wp_reset_postdata();
		wp_die();
	}
	add_action('wp_ajax_change_theme_status_ajax', 'clinicmaster_change_theme_status_ajax');
	add_action('wp_ajax_nopriv_change_theme_status_ajax', 'clinicmaster_change_theme_status_ajax');

	/* Run Code */
	if (!function_exists('clinicmaster_shortcode')) {
		function clinicmaster_shortcode($output)
		{
			return $output;
		}
	}
	/* Run Code END */
	if (!function_exists('clinicmaster_share_us')) {

		function clinicmaster_share_us($post_id = '', $post_title = '', $share_on = '', $productsingle = '', $class = array('', ''))
		{
		
			$social_sharing = clinicmaster_get_opt('social_sharing_on_post');

			/* Control Post Sharing */
			if (!$social_sharing) {
				return false;
			}
			/* Control Post Sharing END */

			$response 			= '';
			$options			= get_option('clinicmaster_theme_options');
			$share_sort_links	= clinicmaster_set($options, 'share_sort_link');
			
			$social_share_link	= array(
				'facebook' => 'http://www.facebook.com/sharer.php?u=' . esc_url(get_permalink($post_id)),
				'twitter' => 'https://twitter.com/share?url=' . esc_url(get_permalink($post_id)) . '&text=' . esc_attr($post_title),
				'google-plus' => 'https://plus.google.com/share?url=' . esc_url(get_permalink($post_id)),
				'linkedin' => 'http://www.linkedin.com/shareArticle?url=' . esc_url(get_permalink($post_id)) . '&title=' . esc_attr($post_title),
				'pinterest' => 'http://pinterest.com/pin/create/button/?url=' . esc_url(get_permalink($post_id)) . '&media=' . esc_url(get_the_post_thumbnail_url($post_id)) . '&description=' . esc_attr($post_title),
				'reddit' => 'http://reddit.com/submit?url=' . esc_url(get_permalink($post_id)) . '&title=' . esc_attr($post_title),
				'tumblr' => 'http://www.tumblr.com/share/link?url=' . esc_url(get_permalink($post_id)) . '&name=' . esc_attr($post_title),
				'digg' => 'http://digg.com/submit?url=' . esc_url(get_permalink($post_id)) . '&title=' . esc_attr($post_title),
			);

			if ($share_on == 'PostSingle') {
				$response = '<div class="post-social-icons-wrap "><ul class="post-social-icons">';
			} elseif ($share_on == 'Jobs') {
				$response = '<h4 class="twm-s-title">' . esc_html__('Share Profile', 'clinicmaster') . '</h4><div class="twm-social-tags">';
			} elseif (!empty($productsingle) && $productsingle == 'productSingle' && !empty($share_sort_links)) {
				$response = '<ul class="'.$class[0].'"><li><strong>' . esc_html__('Share:', 'clinicmaster') . '</strong></li>';
			} else {
				
				$response = '<ul class="post-social-icons ' . $class[0] . '">';
			}


			if (!empty($share_sort_links)) {
				foreach ($share_sort_links as $icon_key => $icon_value) {

					$anchor_class = '';
					if ($share_on == 'PostSingle') {
						if ($icon_key == 'facebook') {
							$anchor_class = 'fab fa-facebook-f';
						} elseif ($icon_key == 'linkedin') {
							$anchor_class = 'fab fa-linkedin-in';
						} elseif($icon_key == 'twitter') {
							$anchor_class = 'fa-brands fa-x-twitter';
						} else {
							$anchor_class = 'fab fa-'.$icon_key;
						}
						
					} else {
						if ($icon_key == 'facebook') {
							$anchor_class = 'fa fa-facebook-f';
						} elseif ($icon_key == 'linkedin') {
							$anchor_class = 'fab fa-linkedin-in';
						} elseif($icon_key == 'twitter') {
							$anchor_class = 'fa-brands fa-x-twitter';
						} else {
							$anchor_class = 'fab fa-'.$icon_key;
						}
						
					}
					if ($icon_value) {
						if ($share_on == 'Jobs') {
							switch ($icon_key) {
								case "facebook":
									$link_clr = 'fb-clr';
									break;
								case "twitter":
									$link_clr = 'tw-clr';
									break;
								case "linkedin":
									$link_clr = 'link-clr';
									break;
								case "pinterest":
									$link_clr = 'pinte-clr';
									break;
								case "google-plus":
									$link_clr = 'whats-clr';
									break;
								default:
									$link_clr = 'fb-clr';
							}
							$response .= '<a class="' . $link_clr . '" href="' . esc_url($social_share_link[$icon_key]) . '" target="_blank" >' . esc_html($icon_key_name) . '</a> ';
						} else if ($share_on == 'PostSingle') {
							$response .= '<li class="position-static"><a class="' . $anchor_class . '" href="' . esc_url($social_share_link[$icon_key]) . '" target="_blank" ></a></li> ';
						}else{
							$response .= '<li><a class="' . $anchor_class . '" href="' . esc_url($social_share_link[$icon_key]) . '" target="_blank" ></a></li> ';
						}
					}
				}
			}
			if ($share_on == 'PostSingle') {
				$response .= '</ul></div>';
			} elseif ($share_on == 'Jobs') {
				$response .= '</div>';
			} elseif (!empty($productsingle) && $productsingle == 'productSingle' && !empty($share_sort_links)) {
				$response .= '</ul>';
			} else {
				$response .= '</ul>';
			}
			
			return $response;
		}
	}

	if (!function_exists('clinicmaster_author_social_link')) {

		function clinicmaster_author_social_arr()
		{
			$author_social_arr = array(
				'url' => array('icon' => 'fas fa-globe', 'text' => 'Globe'),
				'facebook' => array('icon' => 'fa fa-facebook-f', 'text' => 'Facebook'),
				'twitter' => array('icon' => 'fa-brands fa-x-twitter', 'text' => 'Twitter'),
				'linkedin' => array('icon' => 'fab fa-linkedin-in', 'text' => 'Linkedin'),
				'dribbble' => array('icon' => 'fab fa-dribbble', 'text' => 'Dribble'),
				'github' => array('icon' => 'fab fa-github', 'text' => 'Github'),
				'flickr' => array('icon' => 'fab fa-flickr', 'text' => 'Flickr'),
				'google-plus' => array('icon' => 'fab fa-google-plus', 'text' => 'Google Plus'),
				'youtube' => array('icon' => 'fab fa-youtube', 'text' => 'Youtube'),
			);

			return $author_social_arr;
		}
	}


	function clinicmaster_get_website_logo($logo_key = 'site_logo', $logoclass = '', $class_on = '')
	{
		$clinicmaster_option = getDZThemeReduxOption();
		$allowed_html_tags = clinicmaster_allowed_html_tag();

		$page_logo_setting = $output = $class = '';

		$logo_type = !empty($clinicmaster_option['logo_type']) ? $clinicmaster_option['logo_type'] : '';

		if ($logoclass != 'none' && $logo_key == 'site_other_logo') {
			if (!empty($class_on)) {
				$class = 'text-logo ';
			} else {
				$class = 'text-logo logo-light';
			}
		} else if ($logoclass != 'none' && $logo_key == 'site_logo') {
			if (!empty($class_on)) {
				$class = 'text-logo ';
			} else {
				$class = 'text-logo logo-dark';
			}
		}
		$class = !empty($class) ? 'class="' . $class . '"' : '';

		// Logo URL
		$logo_url = !empty($clinicmaster_option[$logo_key]) ? $clinicmaster_option[$logo_key] : 'site_logo';
		$logo_title = !empty($clinicmaster_option['logo_title']) ? $clinicmaster_option['logo_title'] : '';
		$logo_alt = !empty($clinicmaster_option['logo_alt']) ? $clinicmaster_option['logo_alt'] : '';


		

		if ($logo_type == 'text_logo') {
			$logo_text 	= 	clinicmaster_get_opt('logo_text', esc_html__('ClinicMaster', 'clinicmaster'));
			$logo_tag 	= 	clinicmaster_get_opt('tag_line', esc_html__('Architecture Theme', 'clinicmaster'));

			$output .= '<div ' . $class . '>';
			if (!empty($logo_text)) {
				$output .= '<h1 class="site-title">';
				$output .= '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr($logo_title) . '">';
				$output .= esc_html($logo_text);
				$output .= '</a>';
				$output .= '</h1>';
			}
			if (!empty($logo_tag)) {
				$output .= '<p class="site-description">';
				$output .= esc_html($logo_tag);
				$output .= '</p>';
			}
			$output .= '</div>';
		} else {
			$output .= '<a href="' . esc_url(home_url('/')) . '" ' . $class . ' title="' . esc_attr($logo_title) . '">';
			$output .= '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr($logo_alt) . '" class="' . esc_attr($logoclass) . '"/>';
			$output .= '</a>';
		}

		echo wp_kses($output, $allowed_html_tags);
	}
	add_action('clinicmaster_get_logo', 'clinicmaster_get_website_logo', 10, 4);


	function clinicmaster_get_super_user_data($userMeta = '')
	{

		$admin_email = get_option('admin_email');
		$adminDetail = get_user_by('email', $admin_email);
		if (isset($adminDetail->data->ID)) {
			$userMetaValue = get_the_author_meta($userMeta, $adminDetail->data->ID);
			return $userMetaValue;
		}
	}

	function clinicmaster_get_super_user_displayname($userMeta = "")
	{

		$admin_email = get_option('admin_email');
		$adminDetail = get_user_by('email', $admin_email);

		return $adminDetail->data->display_name;
	}

	function clinicmaster_get_super_user_description()
	{

		$admin_email = get_option('admin_email');
		$adminDetail = get_user_by('email', $admin_email);
		$meta = get_user_meta($adminDetail->data->ID);
		$description = !empty($meta['description'][0]) ? $meta['description'][0] : '';
		return $description;
	}

	function clinicmaster_get_domain($url)
	{
		$pieces = parse_url($url);
		$domain = isset($pieces['host']) ? $pieces['host'] : '';
		if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)) {
			return $regs['domain'];
		}
		return false;
	}
	function clinicmaster_get_youtube_video_id($video_url)
	{
		$res = 0;
		if (preg_match("/(youtube.com|youtu.be)\/(watch)?(\?v=)?(\S+)?/", $video_url, $res)) {
			return $res[4];
		} else {
			return 0;
		}
	}

	/* Show Only One Category : only for demo */
	function clinicmaster_get_the_category_list($cat_list, $b)
	{
		$category = array();
		$category[] = $cat_list[0];
		return $category;
	}


	/* Show Only One Category : only for demo END */

	/* Hide Some Category From Widget : only for demo */
	function clinicmaster_exclude_widget_categories($args)
	{
		$hide_selected_cat 	= clinicmaster_get_opt('hide_selected_cat');
		if (!empty($hide_selected_cat)) {
			$hide_selected_cat = implode(',', $hide_selected_cat);
			$args['exclude'] = $hide_selected_cat;
			return $args;
		}
	}

	/* Hide Some Category From Widget : only for demo END */

	/* Show Feature Image In Post Listing */
	function clinicmaster_custom_columns($columns)
	{
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'featured_image' => 'Image',
			'title' => 'Title',
			'comments' => '<span class="vers"><div title="Comments" class="comment-grey-bubble"></div></span>',
			'author' => 'Author',
			'categories' => 'Cateogies',
			'tags' => 'Tags',
			'date' => 'Date',
		);
		return $columns;
	}


	function clinicmaster_custom_columns_data($column, $post_id)
	{
		switch ($column) {
			case 'featured_image':
				the_post_thumbnail('thumbnail');
				break;
		}
	}
	/* Show Feature Image In Post Listing END */


	function clinicmaster_ext_options()
	{
		$show_only_one_cat 			= clinicmaster_get_opt('show_only_one_cat');
		$hide_cat_from_widget 		= clinicmaster_get_opt('hide_cat_from_widget');
		$show_image_on_post_list 	= clinicmaster_get_opt('show_image_on_post_list');

		if ($show_only_one_cat) {
			add_action('the_category_list', 'clinicmaster_get_the_category_list', 10, 2);
		}

		if ($hide_cat_from_widget) {
			add_filter('widget_categories_args', 'clinicmaster_exclude_widget_categories');
		}
		if ($show_image_on_post_list) {
			add_filter('manage_post_posts_columns', 'clinicmaster_custom_columns');
			add_action('manage_post_posts_custom_column', 'clinicmaster_custom_columns_data', 10, 2);
		}
	}

	add_action('init', 'clinicmaster_ext_options');


	function clinicmaster_is_theme_sidebar_active()
	{
		return clinicmaster_get_opt('show_sidebar', true);
	}

	function clinicmaster_show_post_view_count_view($views)
	{
		$post_view_on = clinicmaster_get_opt('post_view_on', false);
		$view_html = '';
		if ($post_view_on) {
			$post_start_view = clinicmaster_get_opt('post_start_view', 0);
			$views	= $views + $post_start_view;

			$view_html = '<li class="post-view"> <i class="fas fa-eye fa-fw" ></i><a href="javascript:void(0);"><span>' . wp_kses($views, 'string') . '</span></a></li>';
		}

		return $view_html;
	}

	function clinicmaster_get_banner($only_title = false, $title_class = true)
	{
		$clinicmaster_option = getDZThemeReduxOption(); 
		$theme_options = clinicmaster_get_theme_option();
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		$general_phone_number   = !empty($clinicmaster_option['general_phone_number']) ? $clinicmaster_option['general_phone_number']:''; 
		$general_phone_icon 	= !empty($clinicmaster_option['general_phone_icon']) ? $clinicmaster_option['general_phone_icon']: '';
		$bnr_style = "style=";
		$class = '';
		$page_id = $overlay_class = $text_position = '';

		//$page_general_banner_star = !empty($theme_options['page_general_banner_star']) ? 1: 0 ;
		$template_name = 'page_general';
		if (is_page()) {
			$template_name 			= 'page_general';
			$page_banner_setting	= clinicmaster_dzbase()->get_meta('page_banner_setting');
		} else if (function_exists('is_shop') && is_shop() || function_exists('is_product_category') && is_product_category()) {
			$page_banner_setting = clinicmaster_dzbase()->get_meta('page_banner_setting', get_option('woocommerce_shop_page_id'));
			$page_banner_setting	=	!empty($page_banner_setting) ? $page_banner_setting : 'theme_default';
			$page_id = get_option('woocommerce_shop_page_id');
		}

		$page_banner_setting	= !empty($page_banner_setting) ? $page_banner_setting : 'theme_default';
		$title_prefix			= '';

		if (is_author()) {
			$template_name	= 'author_page';
			$title_prefix	= esc_html__('Author :', 'clinicmaster');
		} else if (is_search()) {
			$template_name	= 'search_page';
			$title_prefix	= esc_html__('Search :', 'clinicmaster');
		} else if (is_category()) {
			$template_name	= 'category_page';
			$title_prefix	= esc_html__('Category :', 'clinicmaster');
		} else if (clinicmaster_is_woocommerce_active() && ((function_exists('is_shop') && is_shop()) || (function_exists('is_product_category') && is_product_category()))) {
			$template_name	= 'woocommerce_page';
			$title_prefix	= esc_html__('Product :', 'clinicmaster');
		} else if (is_tag()) {
			$template_name	= 'tag_page';
			$title_prefix	= esc_html__('Tag :', 'clinicmaster');
		} else if (function_exists('tribe_is_event') && tribe_is_event()) {

			$template_name	= 'archive_page';
			$title_prefix	= '';
		} else if (is_archive()) {

			$template_name	= 'archive_page';
			$title_prefix	= esc_html__('Archive :', 'clinicmaster');
		}

		$page_banner_title = $page_banner_sub_title = '';

		if ($page_banner_setting == 'custom') {

			$show_banner				= clinicmaster_dzbase()->get_meta('page_banner_on', $page_id);
			$banner_height				= clinicmaster_dzbase()->get_meta('page_banner_height');
			$custom_height				= clinicmaster_dzbase()->get_meta('page_banner_custom_height', $page_id);
			$page_banner_sub_title		= clinicmaster_dzbase()->get_meta('page_banner_sub_title', $page_id);
			$show_breadcrumb 			= clinicmaster_dzbase()->get_meta('page_breadcrumb', $page_id);
			$page_banner_title			= clinicmaster_dzbase()->get_meta('page_banner_title', $page_id);
			$page_banner_title_position	= clinicmaster_dzbase()->get_meta('page_banner_title_position', $page_id);
			$banner_image   			= clinicmaster_dzbase()->get_meta('page_banner_image', $page_id);
			$overlay   					= clinicmaster_dzbase()->get_meta('page_banner_image_overlay', $page_id);
			$banner_layout   			= clinicmaster_dzbase()->get_meta('page_banner_layout', $page_id);
			$page_social   				= clinicmaster_dzbase()->get_meta('page_banner_social', $page_id);
			$page_small_image   		= clinicmaster_dzbase()->get_meta('page_banner_small_image', $page_id);
			$page_banner_gallery   		= clinicmaster_dzbase()->get_meta('page_banner_gallery', $page_id);
			$page_contact_on   			= clinicmaster_dzbase()->get_meta('page_banner_contact_on', $page_id);
			$banner_text   		    	= clinicmaster_dzbase()->get_meta('page_banner_text', $page_id);
			$banner_star 				= clinicmaster_dzbase()->get_meta('page_banner_star', $page_id); 
			
		} else {
			$title_prefix   = !empty($theme_options[$template_name . '_title']) ? $theme_options[$template_name . '_title'] : $title_prefix;
			$show_banner   	= isset($theme_options[$template_name . '_banner_on']) ? $theme_options[$template_name . '_banner_on'] : true;
			$banner_height  = !empty($theme_options[$template_name . '_banner_height']) ? $theme_options[$template_name . '_banner_height'] : 'page_banner_small';
			$custom_height  = !empty($theme_options[$template_name . '_banner_custom_height']) ? $theme_options[$template_name . '_banner_custom_height'] : '100';
			$page_banner_title	= clinicmaster_dzbase()->get_meta('page_banner_title');
			$page_banner_title_position  = !empty($theme_options[$template_name . '_title_position']) ? $theme_options[$template_name . '_title_position'] : 'right';
			$show_breadcrumb  = isset($theme_options['show_breadcrumb']) ? $theme_options['show_breadcrumb'] : true;

			$banner_image  = !empty($theme_options[$template_name . '_banner_image']) ? $theme_options[$template_name . '_banner_image'] : '';
			
			$banner_layout  = !empty($theme_options[$template_name . '_banner_layout']) ? $theme_options[$template_name . '_banner_layout'] : 'banner_layout_1';
			$page_social  = !empty($theme_options[$template_name . '_banner_social']) ? $theme_options[$template_name . '_banner_social'] : '';
			$page_small_image  = !empty($theme_options[$template_name . '_banner_small_image']) ? $theme_options[$template_name . '_banner_small_image'] : '';
			$page_banner_gallery  = !empty($theme_options[$template_name . '_banner_gallery']) ? $theme_options[$template_name . '_banner_gallery'] : '';
			$page_contact_on  = !empty($theme_options[$template_name . '_banner_contact_on']) ? $theme_options[$template_name . '_banner_contact_on'] : '';
			$banner_text  = !empty($theme_options[$template_name . '_banner_text']) ? $theme_options[$template_name . '_banner_text'] : '';
			$overlay  = !empty($theme_options[$template_name . '_banner_image_overlay']) ? $theme_options[$template_name . '_banner_image_overlay'] : '';
			$banner_star = !empty($theme_options[$template_name . '_banner_star']) ? $theme_options[$template_name . '_banner_star']: '' ;
			
		}
		
		
		if (!empty($overlay)) {
			if($banner_layout == 'banner_layout_2'){
				$overlay_class  = ' overlay-black-middle';
			}if($banner_layout == 'banner_layout_1'){
				$overlay_class  = ' overlay-secondary-middle';
			}
		}
			
		if (!empty($banner_image['id']) && ($banner_layout != 'banner_layout_3')) {
			$bnr_style .= 'background-image:url(' . esc_url($banner_image['url']) . ');';
		}
		
		
		if($banner_layout == 'banner_layout_2'){  
			$css_class = ($banner_star == 1)? 'style-1' : 'style-3';
			$text_position = ($page_banner_title_position == 'left') ? 'text-start' : 'text-center';
		}elseif($banner_layout == 'banner_layout_3'){
			$css_class = 'style-2';
			$page_banner_title_position = '';
		}else{
			$css_class = 'dz-banner-dark';
			$text_position = ($page_banner_title_position == 'left') ? 'text-start' : 'text-center';
		}

		$banner_class = 'dz-bnr-inr  '. $css_class . $class . $overlay_class;
		$banner_custom_height = '';
		if ($banner_height == 'page_banner_big') {
			$banner_class .= ' dz-bnr-inr-lg ';
		} else if ($banner_height == 'page_banner_medium') {
			$banner_class .= ' dz-bnr-inr-md ';
		} else if ($banner_height == 'page_banner_small') {
			$banner_class .= ' dz-bnr-inr-sm ';
		} else if ($banner_height == 'page_banner_custom') {
			//but you can't add height attribute here as per themeforest requirement
			$banner_custom_height = '--dz-banner-height:' . $custom_height . 'px; ';
			$banner_class .= ' dz-bnr-inr-sm ';
			$bnr_style .= $banner_custom_height;
		}



		$class_title =  $title_class ? 'dz-bnr-inr-entry d-table-cell ' : '';
		

		$title_output = '<div class="' . $class_title . ' ' . $text_position . '">';
		if($banner_layout == 'banner_layout_3'){			
			$title_output .=	'<div class="dz-bnr-inr-flex"><div class="bnr-info">';
		}
		$title_output .=	'<h1>';

		if (is_page() || is_single()) {
			global $post;
			$title = isset($post->post_title) ? sanitize_text_field($post->post_title) : '';
		} else {
			$title = add_theme_support('', 0);
		}

		if ($title) {
			if (
				clinicmaster_is_woocommerce_active() &&
				(function_exists('is_shop') && is_shop() || function_exists('is_product_category') && is_product_category())
			) {
				$title_prefix = ''; /* To remove extra product word from title */

				$page_banner_title = clinicmaster_set($theme_options, 'woocommerce_page_title');
			}

			if (!empty($page_banner_title)) {
				$title = $page_banner_title;
			} else {
				$title = $title_prefix . ' ' . $title;
			}

			$title_output .= wp_kses($title, 'string');
		} else {
			$title_output .= clinicmaster_set($theme_options, 'blog_page_title', esc_html__('Blog', 'clinicmaster'));
		}

		$title_output .= 	'</h1>';

		if ($show_breadcrumb && !is_front_page()) {
			$title_output .= '<nav aria-label="breadcrumb" class="breadcrumb-row">' .
				clinicmaster_get_the_breadcrumb()
				. '</nav>';
		}
			if($banner_layout == 'banner_layout_3'){
				$title_output .=	'</div>';
					if(!empty($banner_image['id'])){ 
						$title_output .= '<div class="bnr-media">'. wp_get_attachment_image($banner_image['id'] ,'full') .'</div> ';
					}
				$title_output .=	'</div>';
			} 
		$title_output .=	'</div>';
		/* Set Title HTML END */


		if ($only_title) {
			return $title_output;
		}

		if ($show_banner) {
		?>
			<!-- Banner  -->

			<div class="<?php echo esc_attr($banner_class); ?> " <?php echo esc_attr($bnr_style); ?>>
				<div class="container">
					<?php echo wp_kses($title_output, $allowed_html_tags); ?>
					
				</div>
				<?php if($banner_layout == 'banner_layout_1'){ 
					 if(!empty($page_contact_on) && ($banner_layout == 'banner_layout_1') && !empty($general_phone_number)){ ?>
					<div class="dz-btn">
						<a href="tel:<?php echo esc_attr($general_phone_number); ?>" class="btn btn-lg btn-icon btn-primary radius-xl btn-shadow mb-3 mb-sm-0">
							<?php if(!empty($general_phone_icon)){ ?>
							<span class="left-icon">
								<i class="<?php echo esc_attr($general_phone_icon); ?>"></i>
							</span>
							<?php }
							echo esc_html($general_phone_number);
							?>
						</a>					
					</div>
					<?php }
					if(!empty($banner_text)){	?>
					<span class="text-vertical"><?php echo esc_html($banner_text); ?></span>
					<?php }
					if(!empty($page_social)){ ?>
					<ul class="dz-social">
						<?php echo clinicmaster_get_social_icons('','','',false); ?>
					</ul>
				<?php } 
				}
				if($banner_layout == 'banner_layout_2'){ 	 
					if(!empty($page_social)){ ?>
					<div class="vertical-info left">
					
						<ul class="social-list">
							<?php echo clinicmaster_get_social_icons('','','',true); ?>
						</ul>
					
					</div>
				<?php }if($banner_star){?>
					<div class="blur1"></div>
					<div class="blur2"></div>
					<?php } if(!empty($page_small_image['id'])){ ?>
					<div class="elip"><?php echo wp_get_attachment_image($page_small_image['id'] ); ?></div>
					<?php } if($banner_star){ ?>
					<div class="item1">
						<svg width="61" height="61" viewBox="0 0 61 61" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M30.5 0L34.4251 26.5749L61 30.5L34.4251 34.4251L30.5 61L26.5749 34.4251L0 30.5L26.5749 26.5749L30.5 0Z" fill="var(--bs-primary)"/>
						</svg>
					</div>
					<div class="item2">
						<svg width="102" height="102" viewBox="0 0 102 102" fill="none" xmlns="http://www.w3.org/2000/svg">
							<g filter="url(#filter0_d_102_123)">
							<path d="M51 40L52.4156 49.5844L62 51L52.4156 52.4156L51 62L49.5844 52.4156L40 51L49.5844 49.5844L51 40Z" fill="var(--bs-primary)"/>
							</g>
							<defs>
							<filter id="filter0_d_102_123" x="0" y="0" width="102" height="102" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
							<feFlood flood-opacity="0" result="BackgroundImageFix"/>
							<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
							<feOffset/>
							<feGaussianBlur stdDeviation="20"/>
							<feComposite in2="hardAlpha" operator="out"/>
							<feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"/>
							<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_102_123"/>
							<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_102_123" result="shape"/>
							</filter>
							</defs>
						</svg>					
					</div>
					<div class="item3">
						<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M15 0L16.9304 13.0696L30 15L16.9304 16.9304L15 30L13.0696 16.9304L0 15L13.0696 13.0696L15 0Z" fill="var(--bs-primary)"/>
						</svg>					
					</div>
					<?php }}
				if($banner_layout == 'banner_layout_3' && !is_array($page_banner_gallery)){
					$attachment_id = explode(',', $page_banner_gallery);
					$num = 1;
					foreach($attachment_id as $val){ 
					$count_class = 'move-'.$num;
					if($num <= 3){
					?>
					<div class="item<?php echo esc_attr($num); ?>">
						<?php echo wp_get_attachment_image($val ,'', '' , array('class'=> $count_class)); ?>
					</div>
					<?php } $num++;
					} ?>
					<svg class="banner-shape" viewBox="0 0 1920 180" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M1921 164.375C1734.2 -139.225 527.167 48.8754 -33 180.875H1921V164.375Z" fill="var(--bs-primary)"></path>
						<path d="M1921 164.375C1714.2 -59.2247 527.167 58.8754 -33 180.875H1921V164.375Z" fill="white"></path>
					</svg>
					<div class="banner-shape4"></div>
					<div class="banner-shape5"></div>
				<?php } ?>
			</div>

		<?php

		}
	}




	function clinicmaster_get_post_banner()
	{
		if (!is_single()) {
			return false;
		}
		
		$bnr_style = "style=";
		$class = $overlay_class = $text_position = '';

		$clinicmaster_option = getDZThemeReduxOption();
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		$theme_options = clinicmaster_get_theme_option();
		$general_phone_number   = !empty($clinicmaster_option['general_phone_number']) ? $clinicmaster_option['general_phone_number']:''; 
		$general_phone_icon 	= !empty($clinicmaster_option['general_phone_icon']) ? $clinicmaster_option['general_phone_icon']: '';
		
		$post_key = 'post';
		if (is_singular('dz_service')) {

			$post_key = 'service_post';
			$post_banner_setting	= clinicmaster_dzbase()->get_meta('service_post_banner_setting');
			$post_banner_setting	= !empty($post_banner_setting) ? $post_banner_setting : 'theme_default';
		} elseif (is_singular('dz_team')) {

			$post_key = 'team_post';
			$post_banner_setting	= clinicmaster_dzbase()->get_meta('team_post_banner_setting');
			$post_banner_setting	= !empty($post_banner_setting) ? $post_banner_setting : 'theme_default';
		} else {
			$post_banner_setting	= clinicmaster_dzbase()->get_meta('post_banner_setting');
			$post_banner_setting	= !empty($post_banner_setting) ? $post_banner_setting : 'theme_default';
		}

		if ($post_banner_setting == 'custom') { 

			$show_banner	 		= clinicmaster_dzbase()->get_meta($post_key . '_banner_on');
			$banner_height	 		= clinicmaster_dzbase()->get_meta($post_key . '_banner_height');
			$custom_height	 		= clinicmaster_dzbase()->get_meta($post_key . '_banner_custom_height');
			$post_general_title_position = clinicmaster_dzbase()->get_meta($post_key . '_banner_title_position');
			$show_breadcrumb 		= clinicmaster_dzbase()->get_meta($post_key . '_breadcrumb');
			$banner_image   		= clinicmaster_dzbase()->get_meta($post_key . '_banner_image');
			$overlay   		        = clinicmaster_dzbase()->get_meta($post_key . '_banner_image_overlay');
			$banner_layout   		= clinicmaster_dzbase()->get_meta($post_key . '_banner_layout');
			$page_social   			= clinicmaster_dzbase()->get_meta($post_key . '_banner_social');
			$page_small_image   	= clinicmaster_dzbase()->get_meta($post_key . '_banner_small_image');
			$page_banner_gallery   	= clinicmaster_dzbase()->get_meta($post_key . '_banner_gallery');
			$page_contact_on   		= clinicmaster_dzbase()->get_meta($post_key . '_banner_contact_on');
			$banner_text   		    = clinicmaster_dzbase()->get_meta($post_key . '_banner_text');
			$banner_star 			= clinicmaster_dzbase()->get_meta($post_key . '_banner_star'); 
			
		} else { 

			$show_banner   	= isset($theme_options['post_general_banner_on']) ? $theme_options['post_general_banner_on'] : '';
			$banner_height  = !empty($theme_options['post_general_banner_height']) ? $theme_options['post_general_banner_height'] : 'page_banner_medium';
			$custom_height  = !empty($theme_options['post_general_banner_custom_height']) ? $theme_options['post_general_banner_custom_height'] : '100';
			$post_general_title_position  = !empty($theme_options['post_general_title_position']) ? $theme_options['post_general_title_position'] : 'right';
			$show_breadcrumb  = isset($theme_options['show_breadcrumb']) ? $theme_options['show_breadcrumb'] : true;
			$banner_layout  = !empty($theme_options['post_general_banner_layout']) ? $theme_options['post_general_banner_layout'] : '';
			$banner_image  = !empty($theme_options['post_general_banner_image']) ? $theme_options['post_general_banner_image'] : '';
			$page_social  = isset($theme_options['post_general_banner_social']) ? $theme_options['post_general_banner_social'] : '';
			$page_small_image  = !empty($theme_options['post_general_banner_small_image']) ? $theme_options['post_general_banner_small_image'] : '';
			$page_banner_gallery  = !empty($theme_options['post_general_banner_gallery']) ? $theme_options['post_general_banner_gallery'] : '';
			$banner_text  = !empty($theme_options['post_general_banner_text']) ? $theme_options['post_general_banner_text'] : '';
			$page_contact_on  = isset($theme_options['post_general_banner_contact_on']) ? $theme_options['post_general_banner_contact_on'] : '';
			$overlay  = isset($theme_options['post_general_banner_image_overlay']) ? $theme_options['post_general_banner_image_overlay'] : '';
			$banner_star  = isset($theme_options['post_general_banner_star']) ? $theme_options['post_general_banner_star'] : '';
			
		}
		
		if (!empty($overlay)) {
			if($banner_layout == 'banner_layout_2'){
				$overlay_class  = ' overlay-black-middle';
			}if($banner_layout == 'banner_layout_1'){
				$overlay_class  = ' overlay-secondary-middle';
			}
		}
		if (!empty($banner_image['id']) && ($banner_layout != 'banner_layout_3')) {
			$bnr_style .= 'background-image:url(' . esc_url($banner_image['url']) . ');';
		}
		
		
		if($banner_layout == 'banner_layout_2'){
			$css_class = 'style-3';
			$text_position = ($post_general_title_position == 'left') ? 'text-start' : 'text-center';
		}elseif($banner_layout == 'banner_layout_3'){
			$css_class = 'style-2';
		}else{
			$css_class = 'dz-banner-dark';
			$text_position = ($post_general_title_position == 'left') ? 'text-start' : 'text-center';
		}

		
		$banner_class = 'dz-bnr-inr  '. $css_class . $class . $overlay_class;
		$banner_custom_height = '';
		if ($banner_height == 'page_banner_big') {
			$banner_class .= ' dz-bnr-inr-lg ';
		} else if ($banner_height == 'page_banner_medium') {
			$banner_class .= ' dz-bnr-inr-md ';
		} else if ($banner_height == 'page_banner_small') {
			$banner_class .= ' dz-bnr-inr-sm ';
		} else if ($banner_height == 'page_banner_custom') {
			//but you can't add height attribute here as per themeforest requirement
			$banner_custom_height = '--dz-banner-height:' . $custom_height . 'px; ';
			$banner_class .= ' dz-bnr-inr-md ';
			$bnr_style .= $banner_custom_height;
		}

		
		if ($show_banner) {
		?>

			<!-- Banner  -->

			<div class="<?php echo esc_attr($banner_class); ?>" <?php echo esc_attr($bnr_style); ?>>
				
				<div class="container">
					<div class="dz-bnr-inr-entry d-table-cell <?php echo esc_attr($text_position); ?>">
						<?php if($banner_layout == 'banner_layout_3'){ ?>			
							<div class="dz-bnr-inr-flex"><div class="bnr-info">
						<?php } ?>
						<h1>
							<?php

							if (is_page() || is_single()) {
								global $post;
								$title = isset($post->post_title) ? sanitize_text_field($post->post_title) : '';
							} else {
								$title = add_theme_support('', 0);
							}

							if ($title) {
								echo wp_kses($title, 'string');
							} else {
								echo clinicmaster_set($theme_options, 'blog_page_title', esc_html__('Blog', 'clinicmaster'));
							}
							?>
						</h1>

						<!-- Breadcrumb row -->
						<?php if ($show_breadcrumb && !is_front_page()) { ?>
							<nav aria-label="breadcrumb" class="breadcrumb-row">
								<?php echo clinicmaster_get_the_breadcrumb(); ?>
							</nav>
						<?php } ?>
						<!-- Breadcrumb row END -->
						<?php 
						if($banner_layout == 'banner_layout_3'){ ?>
								</div>
								<?php 
								if(!empty($banner_image['id'])){  ?>
									<div class="bnr-media"> <?php echo wp_get_attachment_image($banner_image['id'] ,'full'); ?> </div>
								<?php } ?>
							</div>
						<?php } ?>
					</div>
				</div>
				<?php if($banner_layout == 'banner_layout_1'){ 
					 if(!empty($page_contact_on) && ($banner_layout == 'banner_layout_1') && !empty($general_phone_number)){ ?>
					<div class="dz-btn">
						<a href="tel:<?php echo esc_attr($general_phone_number); ?>" class="btn btn-lg btn-icon btn-primary radius-xl btn-shadow mb-3 mb-sm-0">
							<?php if(!empty($general_phone_icon)){ ?>
							<span class="left-icon">
								<i class="<?php echo esc_attr($general_phone_icon); ?>"></i>
							</span>
							<?php }
							echo esc_html($general_phone_number);
							?>
						</a>					
					</div>
					<?php }
					if(!empty($banner_text)){	?>
					<span class="text-vertical"><?php echo esc_html($banner_text); ?></span>
					<?php }
					if(!empty($page_social)){ ?>
					<ul class="dz-social">
						<?php echo clinicmaster_get_social_icons('','','',false); ?>
					</ul>
				<?php } 
				}
				if($banner_layout == 'banner_layout_2'){  if(!empty($page_social)){	 ?>
					<div class="vertical-info left">
						<ul class="social-list">
							<?php echo clinicmaster_get_social_icons('','','',true); ?>
						</ul>
						<?php }?>
					</div>
					<!-- <div class="blur1"></div> -->
					<!-- <div class="blur2"></div> -->
					<?php if(!empty($page_small_image['id'])){ ?>
					<div class="elip"><?php echo wp_get_attachment_image($page_small_image['id'] ,''); ?></div>
					<?php } if(!empty($banner_star)){?>
					 <div class="item1">
						<svg width="61" height="61" viewBox="0 0 61 61" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M30.5 0L34.4251 26.5749L61 30.5L34.4251 34.4251L30.5 61L26.5749 34.4251L0 30.5L26.5749 26.5749L30.5 0Z" fill="#F46700"/>
						</svg>
					</div>
					<div class="item2">
						<svg width="102" height="102" viewBox="0 0 102 102" fill="none" xmlns="http://www.w3.org/2000/svg">
							<g filter="url(#filter0_d_102_123)">
							<path d="M51 40L52.4156 49.5844L62 51L52.4156 52.4156L51 62L49.5844 52.4156L40 51L49.5844 49.5844L51 40Z" fill="#F46700"/>
							</g>
							<defs>
							<filter id="filter0_d_102_123" x="0" y="0" width="102" height="102" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
							<feFlood flood-opacity="0" result="BackgroundImageFix"/>
							<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
							<feOffset/>
							<feGaussianBlur stdDeviation="20"/>
							<feComposite in2="hardAlpha" operator="out"/>
							<feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"/>
							<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_102_123"/>
							<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_102_123" result="shape"/>
							</filter>
							</defs>
						</svg>					
					</div>
					<div class="item3">
						<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M15 0L16.9304 13.0696L30 15L16.9304 16.9304L15 30L13.0696 16.9304L0 15L13.0696 13.0696L15 0Z" fill="#F46700"/>
						</svg>					
					</div> 
				<?php }}
				if($banner_layout == 'banner_layout_3' && !is_array($page_banner_gallery)){
					$attachment_id = explode(',', $page_banner_gallery);
					$num = 1;
					foreach($attachment_id as $val){ 
					$count_class = 'move-'.$num;
					if($num <= 3){
					?>
					<div class="item<?php echo esc_attr($num); ?>">
						<?php echo wp_get_attachment_image($val ,'', '' , array('class'=> $count_class)); ?>
					</div>
					<?php } $num++;
					} ?>
					<svg class="banner-shape" viewBox="0 0 1920 180" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M1921 164.375C1734.2 -139.225 527.167 48.8754 -33 180.875H1921V164.375Z" fill="var(--bs-primary)"></path>
						<path d="M1921 164.375C1714.2 -59.2247 527.167 58.8754 -33 180.875H1921V164.375Z" fill="white"></path>
					</svg>
					<div class="banner-shape4"></div>
					<div class="banner-shape5"></div>
				<?php } ?>

			</div>
		<?php

		}
	}



	function clinicmaster_is_post_banner_enable()
	{
		if (!is_single()) {
			return false;
		}
		$post_key = 'post';
		$post_banner_setting	= clinicmaster_dzbase()->get_meta('post_banner_setting');
		$post_banner_setting	= !empty($post_banner_setting) ? $post_banner_setting : 'theme_default';

		if ($post_banner_setting == 'custom') {
			$show_banner = clinicmaster_dzbase()->get_meta($post_key . '_banner_on');
		} else {
			$show_banner = clinicmaster_get_opt('post_general_banner_on');
		}

		return $show_banner;
	}



	function clinicmaster_get_loader()
	{
		$page_loader_image = '';
		$theme_options 	= clinicmaster_get_theme_option();
		$page_loading_on	= clinicmaster_set($theme_options, 'page_loading_on');

		if ($page_loading_on == 1) {
			$page_loader_type	= clinicmaster_set($theme_options, 'page_loader_type', 'loading_image');
			if ($page_loader_type == 'loading_image') {
				$custom_preloader = !empty($theme_options['custom_page_loader_image']) ? clinicmaster_set($theme_options['custom_page_loader_image'], 'url') : '';

				if ($custom_preloader) {
					$preloader = $custom_preloader;
				} else {
					$page_loader_image = clinicmaster_set($theme_options, 'page_loader_image', 'loading1');
					
					$preloader 	= get_template_directory_uri() . '/dz-inc/assets/images/loading-images/' . $page_loader_image . '.svg';
				}
			} elseif ($page_loader_type == 'advanced_loader') {
				$page_loader = clinicmaster_set($theme_options, 'advanced_page_loader_image', 'loading1');
			}
		}
		?>


		<?php if ($page_loading_on == 1) {

			if ($page_loader_type == 'loading_image') {

	

		?>

				<?php if ($page_loader_image == 'loading1') {
					$theme_name = get_bloginfo( 'name' );	
					$array_item = str_split($theme_name); 
					?>

					<div id="loading-area" class="dz-preloader-1">
						<div class="preloader-inner">
							<svg class="dz_svg" width="240" height="240" viewBox="0 0 240 240">
								<circle class="dz_ring dz_ring_1" cx="120" cy="120" r="105" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 660" stroke-dashoffset="-330" stroke-linecap="round"></circle>
								<circle class="dz_ring dz_ring_2" cx="120" cy="120" r="35" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 220" stroke-dashoffset="-110" stroke-linecap="round"></circle>
								<circle class="dz_ring dz_ring_3" cx="85" cy="120" r="70" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 440" stroke-linecap="round"></circle>
								<circle class="dz_ring dz_ring_4" cx="155" cy="120" r="70" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 440" stroke-linecap="round"></circle>
							</svg>
						</div>
					</div>
			<?php } elseif($page_loader_image == 'loading2'){ ?>
					
					<div class="dz-preloader-2" id="loading-area">
					<div class="loader"><?php echo esc_html__('Loading ...', 'clinicmaster'); ?></div>
					</div>
			<?php }elseif($page_loader_image == 'loading3'){ ?>
					<div class="dz-preloader-3" id="loading-area">
					<div class="preloader-inner"></div>
					</div>
			<?php }else { ?>
					<!-- Preloader -->
					<div id="loading-area" class="<?php echo esc_attr('preloader-wrapper-1 dz-preloader-1'); ?>" style="background-image: url(<?php echo esc_url($preloader); ?>);background-repeat: no-repeat; background-position: center;"></div>
			<?php }
			} ?>

			<?php
			if ($page_loader_type == 'advanced_loader' && $page_loader == 'loading1') {
				$loader_text = clinicmaster_get_opt('advanced_page_loader_text');
				wp_enqueue_style('clinicmaster-loading1', get_template_directory_uri() . '/assets/css/loader/loading1.css');
			?>
				<div id="loading-area" class="loader2">
					<div class="box-load">
						<div class="load-logo"><?php do_action('clinicmaster_get_logo', 'site_other_logo'); ?></div>
						<h1 class="ml12"><?php echo esc_html($loader_text); ?></h1>
					</div>
				</div>
			<?php
				wp_enqueue_script('clinicmaster-anime', get_template_directory_uri() . '/assets/js/loading/anime.js', array('jquery'), '1.0', true);
				wp_enqueue_script('clinicmaster-anime-app3', get_template_directory_uri() . '/assets/js/loading/anime-app3.js', array('jquery'), '1.0', true);
			} elseif ($page_loader_type == 'advanced_loader' && $page_loader == 'loading2') {
				wp_enqueue_style('clinicmaster-loading2', get_template_directory_uri() . '/assets/css/loader/loading2.css');
			?>
				<div id="loading-area" class="line-loader preloader-wrapper-1">
					<svg viewBox="0 0 960 300">
						<symbol id="s-text">
							<text text-anchor="middle" x="50%" y="80%"><?php echo get_bloginfo('name'); ?></text>
						</symbol>
						<g class="g-ants">
							<use xlink:href="#s-text" class="text-copy"></use>
							<use xlink:href="#s-text" class="text-copy"></use>
							<use xlink:href="#s-text" class="text-copy"></use>
							<use xlink:href="#s-text" class="text-copy"></use>
							<use xlink:href="#s-text" class="text-copy"></use>
						</g>
					</svg>
				</div>
	<?php
			}
		}
	}


	function clinicmaster_isAMultipleOf4($n)
	{
		// if true, then 'n' is a multiple of 4 
		if (($n & 3) == 0)
			return true;

		// else 'n' is not a multiple of 4 
		return false;
	}

	/* Change Default WordPress Pages Sorting */
	function clinicmaster_change_default_pages_post_order($query)
	{
		$template_name = '';

		if ($query->is_author() && $query->is_main_query()) {
			$template_name	= 'author_page';
		} else if ($query->is_search() && $query->is_main_query()) {
			$template_name	= 'search_page';
		} else if ($query->is_category() && $query->is_main_query()) {
			$template_name	= 'category_page';
		} else if ($query->is_tag() && $query->is_main_query()) {
			$template_name	= 'tag_page';
		} else if ($query->is_archive() && $query->is_main_query()) {
			$template_name	= 'archive_page';
		}

		if (!empty($template_name) && !is_admin() && function_exists('is_shop') && !is_shop()) {
			$sorting_on = clinicmaster_get_opt($template_name . '_sorting_on');
			if ($sorting_on) {
				$sorting	= clinicmaster_get_opt($template_name . '_sorting');

				if ($sorting	== 'most_visited') {
					$order	=	'desc';
					$query->set('meta_key', '_views_count');
					$query->set('orderby', 'meta_value_num');
				} else {
					$sort_arr	= explode('_', $sorting);
					$orderby 	= !empty($sort_arr[0]) ? $sort_arr[0] : 'date';
					$order 		= !empty($sort_arr[1]) ? $sort_arr[1] : 'DESC';

					$query->set('orderby', $orderby);
				}

				$query->set('order', $order);
			}
		}
	}

	add_action('pre_get_posts', 'clinicmaster_change_default_pages_post_order');
	/* Change Default WordPress Pages Sorting END */

	/* Change Body Layout */
	function clinicmaster_body_layout_class($classes)
	{
		global $clinicmaster_option;

		$theme_layout = clinicmaster_get_opt('theme_layout', 'theme_layout_1');
		
		if (!empty($theme_layout)) {
			$class = '';
			if ($theme_layout == 'theme_layout_2') {
				/* Boxed Layout */
				$class .= 'boxed';
			} else if ($theme_layout == 'theme_layout_3') {
				/* Frame Layout */
				$class .= 'frame';
			}

	

			return array_merge($classes, array($class));
		}



		return $classes;
	}
	add_filter('body_class', 'clinicmaster_body_layout_class');

	function clinicmaster_body_layout_class_not_in_use($classes)
	{
		$class = '';

		$theme_layout = clinicmaster_get_opt('theme_layout');
		$theme_mode = clinicmaster_get_opt('theme_mode');

		// Theme Layout
		if (!empty($theme_layout)) {

			if ($theme_layout == 'theme_layout_2') {
				/* Boxed Layout */
				$class .= ' boxed';
			} else if ($theme_layout == 'theme_layout_3') {
				/* Frame Layout */
				$class .= ' frame';
			}
		}

		//Theme Mode
		if (!empty($theme_mode) && $theme_mode == 'dark') {
			$class .= ' layout-dark';
		}

		if (!empty($_GET['theme_mode']) && $_GET['theme_mode'] == 'dark') {
			$class .= ' layout-dark';
		} else {
			$class .= ' layout-light';
		}

		return array_merge($classes, array($class));
	}
	/* Change Body Layout END */

	/* Change Body Layout Style */
	function clinicmaster_body_layout_style()
	{
		$theme_options = clinicmaster_get_theme_option();
		$theme_layout  = clinicmaster_set($theme_options, 'theme_layout', 'theme_layout_1');
		$style = '';
		if (!empty($theme_layout) && $theme_layout != 'theme_layout_1') {
			$output   = '';
			$bg_type  = clinicmaster_set($theme_options, 'body_boxed_bg_type');
			if ($bg_type == 'bg_type_color') {
				$bg_color  = clinicmaster_set($theme_options, 'boxed_layout_bg_color');
				$custom_bg_color  = clinicmaster_set($theme_options, 'boxed_layout_custom_bg_color');

				if (!empty($custom_bg_color['color'])) {
					$output = 'background-color:' . $custom_bg_color['color'] . ';';
				} else if (!empty($bg_color)) {
					$output = 'background-color:' . $bg_color . ';';
				}
			} else if ($bg_type == 'bg_type_image') {
				$bg_image  = clinicmaster_set($theme_options, 'boxed_layout_bg_image');
				$custom_bg_image  = clinicmaster_set($theme_options, 'boxed_layout_custom_bg_image');

				if (!empty($custom_bg_image['url'])) {
					$output = 'background-image:url(' . $custom_bg_image['url'] . '); background-size: auto;';
				} else if (!empty($bg_image)) {
					$bg_image = get_template_directory_uri() . '/assets/images/switcher/background/' . $bg_image . '.jpg';
					$output = 'background-image:url(' . $bg_image . '); background-size: auto;';
				}
			} else if ($bg_type == 'bg_type_pattern') {
				$bg_pattern  = clinicmaster_set($theme_options, 'boxed_layout_bg_pattern');
				$custom_bg_pattern  = clinicmaster_set($theme_options, 'boxed_layout_custom_bg_pattern');

				

				if (!empty($custom_bg_pattern['url'])) {
					$output = 'background-image:url(' . $custom_bg_pattern['url'] . '); background-size: auto;';
				} else if (!empty($bg_pattern)) {
					$bg_pattern = get_template_directory_uri() . '/assets/images/switcher/pattern/' . $bg_pattern . '.jpg';
					$output = 'background-image:url(' . $bg_pattern . '); background-size: auto;';
				}
			}

			if (($theme_layout == 'theme_layout_3')) {
				$custom_bg_pattern_padding  = clinicmaster_set($theme_options, 'boxed_layout_bg_pattern_padding');
				$output .= ' padding:' . $custom_bg_pattern_padding . 'px;';
			}
			$style = 'style="' . $output . '"';
		}

		echo wp_kses($style, clinicmaster_allowed_html_tag());
	}
	/* Change Body Layout Style END */


	/* Get Post Meta Data */
	function clinicmaster_get_post_meta($post_id, $meta_key)
	{
		if (is_array($meta_key)) {
			$post_meta_data = array();
			$meta_data = get_post_meta($post_id);
			foreach ($meta_key as $field_key) {
				if (!empty($meta_data[$field_key])) {
					if (count($meta_data[$field_key]) == 1) {
						$post_meta_data[$field_key] = $meta_data[$field_key][0];
					} else {
						$post_meta_data[$field_key] = $meta_data[$field_key];
					}
				}
			}

			return $post_meta_data;
		} else {
			$value = get_post_meta($post_id, $meta_key);
			$value = !empty($value[0]) ? $value[0] : '';
			return $value;
		}
	}
	/* Get Post Meta Data END */


	function clinicmaster_get_category_by_post_id($post_id)
	{
		$cats = '';
		$cat_list = get_the_category($post_id);
		if (!empty($cat_list)) {
			foreach ($cat_list as $cat) {
				$cats .= '<a href="' . esc_url(get_category_link($cat->term_id)) . '" class="post-link-in">' . esc_html($cat->name) . '</a>';
			}
		}

		return $cats;
	}

	function clinicmaster_get_cpt_category($cat_list, $seprator = ' ')
	{
		$cats = '';
		if (!empty($cat_list)) {
			foreach ($cat_list as $cat) {
				$cats .= '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>' . $seprator;
			}
			$cats = rtrim($cats, $seprator);
		}
		return $cats;
	}


	function clinicmaster_filtered_output($output)
	{
		return apply_filters('clinicmaster_filtered_output', $output);
	}

	function clinicmaster_generate_uniq_id($atts)
	{
		$atts = (gettype($atts) == 'object') ? json_decode(json_encode($atts), true) : $atts;
		return 'a' . md5(implode($atts));
	}

	if (!function_exists('clinicmaster_generate_rand_number')) {
		function clinicmaster_generate_rand_number($digit = 6)
		{
			$no = substr(strtoupper(md5(uniqid(rand()))), 0, $digit);
			return $no;
		}
	}

	if (!function_exists('clinicmaster_get_container')) {
		function clinicmaster_get_container($is_sidebar)
		{
			$container = ($is_sidebar) ? 'container' : 'min-container';
			return $container;
		}
	}

	if (!function_exists('clinicmaster_get_post_tags')) {
		function clinicmaster_get_post_tags($post_id)
		{
			$tag_arr = get_the_tags($post_id);

			$output = '';
			if (!empty($tag_arr)) {
				$tag_count = count($tag_arr);

				foreach ($tag_arr as $tag_index => $tag) {
					$tag_name = ($tag_index + 1 == $tag_count) ? $tag->name : $tag->name;
					$output .= '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag_name) . '</a>';
				}
				$output .= '';
			}

			echo wp_kses($output, clinicmaster_allowed_html_tag());
		}
	}

	if (!function_exists('clinicmaster_get_cat_id_by_slug')) {
		/* Slugs may be array or comma seperated string */
		function clinicmaster_get_cat_id_by_slug($slugs, $taxonomy = 'category')
		{
			$cat_id = array();
			if (!is_array($slugs)) {
				$slugs = explode(',', $slugs);
			}

			if (!empty($slugs)) {
				foreach ($slugs as $slug) {
					$category	= get_term_by('slug', $slug, $taxonomy);
					if (!empty($category->term_id)) {
						$cat_id[]	= $category->term_id;
					}
				}
			}

			return $cat_id;
		}
	}

	/* Deafault Search Filter: remove pages from search */

	add_filter('register_post_type_args', 'clinicmaster_filter_search_result', 10, 2);

	if (!function_exists('clinicmaster_filter_search_result')) {
		function clinicmaster_filter_search_result($args, $post_type)
		{
			if (!is_admin() && $post_type == 'page') {
				$args['exclude_from_search'] = true;
			}
			return $args;
		}
	}

	if (!function_exists('clinicmaster_allowed_html_tag')) {
		function clinicmaster_allowed_html_tag()
		{
			global $clinicmaster_option;

			if (!empty($clinicmaster_option)) {
				$allowed_html_tags = clinicmaster_set($clinicmaster_option, 'allowed_html_tags');
			} else {
				$allowed_html_tags = wp_kses_allowed_html('post');
			}
			$allowed_html_tags = !empty($allowed_html_tags) ? $allowed_html_tags : 'string';
			return $allowed_html_tags;
		}
	}

	/* Elementor Function */
	function clinicmaster_elementor_get_anchor_attribute($btn_link)
	{
		$anchor_attribute = '';

		if (isset($btn_link['is_external']) && $btn_link['is_external'] == 'on') {
			$anchor_attribute .= ' target=_blank ';
		}

		if (isset($btn_link['nofollow']) && $btn_link['nofollow'] == 'on') {
			$anchor_attribute .= ' rel=nofollow';
		}

		if (!empty($btn_link['custom_attributes'])) {
			$attr_arr = explode(',', $btn_link['custom_attributes']);

			if (!empty($attr_arr)) {
				foreach ($attr_arr as $key => $value) {
					$attr_data = explode('|', $value);
					$anchor_attribute .= ' ' . $attr_data[0] . '=' . $attr_data[1] . '';
				}
			}
		}

		return $anchor_attribute;
	}


	/* CPT Team Social Links */
	function clinicmaster_get_team_social_link($post_id)
	{
		$team_social_data = array(
			'any_fill' => false,
			'data' => array()
		);

		$team_socials	= array(
			'facebook' => array(
				'key'  => 'team_social_facebook',
				'class' => 'fa fa-facebook-f',
				'url' => ''
			),
			'twitter' => array(
				'key' => 'team_social_twitter',
				'class' => 'fa-brands fa-x-twitter',
				'url' => ''
			),
			'instagram' => array(
				'key' => 'team_social_instagram',
				'class' => 'fab fa-instagram',
				'url' => ''
			),
			'linkdin' => array(
				'key' => 'team_social_linkdin',
				'class' => 'fa-brands fa-linkedin-in',
				'url' => ''
			),
			'youtube' => array(
				'key' => 'team_social_youtube',
				'class' => 'fa-brands fa-youtube',
				'url' => ''
			)
		);


		foreach ($team_socials as $key => $value) {
			$team_socials[$key]['url'] = clinicmaster_get_post_meta($post_id, $value['key']);

			if (!empty($team_socials[$key]['url'])) {
				$team_social_data['any_fill'] = true;
			}
		}

		$team_social_data['data'] = $team_socials;

		return $team_social_data;
	}


	/* Change Theme Direction LTR - RTL */
	function theme_direction()
	{
		global $clinicmaster_option;

		$rtl = clinicmaster_set($clinicmaster_option, 'rtl_on');

		if ($rtl) {
			echo 'dir="rtl"';
		}

		return false;
	}

	/**
	 * Check if plugin is active
	 **/
	function clinicmaster_check_plugin_active($plugin)
	{
		if (in_array($plugin, apply_filters('active_plugins', get_option('active_plugins')))) {
			return true;
		} else {
			return false;
		}
	}

	function isWebsiteReadyForVisitor($website_status)
	{
		if (
			$website_status == 'live_mode'
			|| (in_array($website_status, array('comingsoon_mode', 'maintenance_mode')) && is_user_logged_in())
		) {
			return true;
		} else {
			return false;
		}
	}

	/* Global variable must be in function or class */
	function getDZThemeReduxOption()
	{
		if (is_admin()) {
			clinicmaster_bunch_global_variable();
		}
		global $clinicmaster_option;
		return $clinicmaster_option;
	}


	/* Get Post Creation Date */
	function get_creation_date($entry_id = '')
	{
		$post_id  = $entry_id ? $entry_id : get_the_ID();
		$old_date = get_post_meta($post_id, '_wp_old_date', true);
		return $old_date ? // If the old date exists
			date_i18n(
				get_option('date_format'), // Retrieve the date in localized format
				strtotime($old_date)
			) : // and use the display format set on WordPress options
			get_the_date('Y'); // else, use get_the_date()
	}



	function clinicmaster_load_template_part($template_name, $part_name = null, $args = array())
	{
		ob_start();
		get_template_part($template_name, $part_name, $args);
		$var = ob_get_contents();
		ob_end_clean();
		return $var;
	}


	if (!function_exists('pr')) {
		function pr($value)
		{
			echo '<pre>';
			print_r($value);
			echo '</pre>';
		}
	}


	/* Get lazy loading image url */
	function clinicmaster_get_lazy_loading_image_url()
	{
		return CLINICMASTER_URL . 'assets/images/svg/loading.svg'; 
		
		
	}



	/* Get background image with placeholder loading image */
	function clinicmaster_get_lazy_loading_bg_img($attachment_id, $size = 'thumbnail', $attr = NULL)
	{
		$lazy_load_image =  clinicmaster_get_lazy_loading_image_url();
		return 'style="background-image: url(' . esc_url($lazy_load_image) . ');' . $attr . '" data-src="' . esc_url(wp_get_attachment_image_url($attachment_id, $size)) . '"';
	}


	/* Image Loading */
	function clinicmaster_image_load($url, $attachment_id = NULL, $size = 'thumbnail', $attr = NULL)
	{
		$lazyload = false;
		$attributes = '';

		$lazy_load_image =  clinicmaster_get_lazy_loading_image_url();
		if (!empty($attachment_id)) {
			$url = wp_get_attachment_image_url($attachment_id, $size);
		}

		if (!empty($attr)) {

			if (empty($attr['alt'])) {
				$attr['alt'] = esc_attr__('Image', 'clinicmaster');
			}

			foreach ($attr as $key => $value) {
				if ($key == 'class') {
					continue;
				}
				$attributes .= ' ' . $key . '=' . $value . '';
			}
		} else {
			$attributes .= ' alt=' . esc_attr__('Image', 'clinicmaster') . ' ';
		}

		$class = !empty($attr['class']) ? $attr['class'] : '';


		if ($lazyload) {
			$class .= ' lazy ';
			$image = '<img class="' . esc_attr($class) . '" data-src="' . esc_url($url) . '" src="' . esc_url($lazy_load_image) . '" ' . $attributes . ' >';
		} else {
			$image	= '<img class="' . esc_attr($class) . '" src="' . esc_url($url) . '" ' . $attributes . ' >';
		}

		return $image;
	}
function theme_check_activated(){
	require_once( CLINICMASTER_ROOT . 'dz-inc/admin/templates/token_verification.php' );
	if(class_exists('DexignZone_Purchase_Code_Verification')){ 
		$verification = new DexignZone_Purchase_Code_Verification();
		$verfied_status = $verification->check_theme_activated();
		return $verfied_status;
	}
	return false;
}