<?php
if (!defined('ABSPATH')) {
    die();
}
if (!class_exists('ClinicMaster_Menu_Handle')) {
    class ClinicMaster_Menu_Handle
    {
		
		public $profile_name		= 'DexignZone';
		
		public $documentation_link	= 'https://assets.wprdx.com/products/docs/clinicmaster/';
		
		public $support_link		= 'https://support.w3itexperts.com/';
		
		public $video_link			= 'https://www.youtube.com/watch?v=UkaiZmQ2rBo';
		
		
        /**
         * ClinicMaster_Menu_Handle->theme_name
         * private
         * @var string
         */
        protected $theme_name = '';

        /**
         * ClinicMaster_Menu_Handle->theme_text_domain
         * private
         * @var string
         */
        protected $theme_text_domain = '';

        public function __construct()
        {
            $current_theme = wp_get_theme();
            $this->theme_name = $current_theme->get('Name');
            $this->theme_text_domain = $current_theme->get('TextDomain');
			
			add_action('admin_menu', array($this, 'clinicmaster_add_menu'));
        }
		
		public function clinicmaster_add_menu()
        {
			add_menu_page($this->profile_name, $this->profile_name, 
						'manage_options', 
						$this->theme_text_domain, 
						array($this, 'clinicmaster_create_theme_dashboard'), 
						get_template_directory_uri().'/dz-inc/admin/images/logo.png',
						3
			);
			
            add_submenu_page($this->theme_text_domain, $this->theme_name, esc_html__('Dashboard', 'clinicmaster'), 'manage_options', $this->theme_text_domain, array($this, 'clinicmaster_create_theme_dashboard'));
			
			
			/* DZ Plugins */
			add_submenu_page(
						$this->theme_text_domain,
						esc_html__( 'DZ Plugins', 'clinicmaster' ),
						esc_html__( 'DZ Plugins', 'clinicmaster' ),
						'administrator',
						'dz-plugins',
						array( $this, 'clinicmaster_themes_plugins_tab' ) ); 
			
			/* System Status */
			add_submenu_page(
						$this->theme_text_domain,
						esc_html__( 'System Status', 'clinicmaster' ),
						esc_html__( 'System Status', 'clinicmaster' ),
						'administrator',
						'dz-system-status',
						array( $this, 'clinicmaster_themes_system_status_tab' ) );			
			add_submenu_page(
                    $this->theme_text_domain,
                    esc_html__( 'Theme Verification', 'clinicmaster' ),
                    esc_html__( 'Theme Verification', 'clinicmaster' ),
                    'administrator',
                    'dz-theme-verification',
                    array( $this, 'clinicmaster_themes_verification_tab' ) );	
            add_submenu_page(
						$this->theme_text_domain,
						esc_html__( 'Support Ticket', 'clinicmaster' ),
						esc_html__( 'Support Ticket', 'clinicmaster' ),
						'administrator',
						'dz-support-ticket',
						array( $this, 'clinicmaster_themes_support_tab' ) );
						
			add_submenu_page(
						$this->theme_text_domain,
						esc_html__( 'My Ticket', 'clinicmaster' ),
						esc_html__( 'My Ticket', 'clinicmaster' ),
						'administrator',
						'dz-my-ticket',
						array( $this, 'clinicmaster_themes_my_ticket_tab' ) );
        }

        public function clinicmaster_create_theme_dashboard()
        {
            $documentation_link		= $this->documentation_link;
            $support_link			= $this->support_link;
            $video_link				= $this->video_link;
			
			require_once get_template_directory() . '/dz-inc/admin/templates/dashboard.php';
		}
		
		function clinicmaster_themes_plugins_tab() {
			require_once get_template_directory() . '/dz-inc/admin/templates/plugins.php';
		}
		
		function clinicmaster_themes_system_status_tab() {
			require_once get_template_directory() . '/dz-inc/admin/templates/system_status.php';
		}
		 function clinicmaster_themes_verification_tab() {
            require_once get_template_directory() . '/dz-inc/admin/templates/theme_verification.php';
        }

        function clinicmaster_themes_support_tab() {
			require_once get_template_directory() . '/dz-inc/admin/templates/support.php';
		}
		
		function clinicmaster_themes_my_ticket_tab() {
			require_once get_template_directory() . '/dz-inc/admin/templates/my_ticket.php';
		}
		
        function clinicmaster_add_admin_bar($wp_admin_bar)
        {
            $theme = wp_get_theme();
            /**
             * Add "Theme Name" parent node
             */
          
			
			/**
             * Add Dashboard children node
             */
            $args = array(
                'id'     => 'dashboard',
                'title'  => esc_html__('Dashboard', 'clinicmaster'),
                'href'   => admin_url('admin.php?page=' . $theme->get("TextDomain")),
                'parent' => $theme->get("TextDomain"),
                'meta'   => array(
                    'class' => '',
                    'title' => esc_html__('Dashboard', 'clinicmaster'),
                )
            );
            $wp_admin_bar->add_node($args);

            /**
             * Add Import Export children node
             */
            if (class_exists('DZ_Import')) {
                $args = array(
                    'id'     => 'dz-import',
                    'title'  => esc_html__('Import Demo', 'clinicmaster'),
                    'href'   => admin_url('admin.php?page=dz-import'),
                    'parent' => $theme->get("TextDomain"),
                    'meta'   => array(
                        'class' => '',
                        'title' => esc_html__('Import Demo', 'clinicmaster'),
                    )
                );
                $wp_admin_bar->add_node($args);
            }
            
			/**
             * Add Theme options children node
             */
             if (class_exists('ReduxFramework')) {
                $args = array(
                    'id'     => 'theme-options',
                    'title'  => esc_html__('Theme Options', 'clinicmaster'),
                    'href'   => admin_url('admin.php?page=theme-options'),
                    'parent' => $theme->get("TextDomain"),
                    'meta'   => array(
                        'class' => '',
                        'title' => esc_html__('Import Demos', 'clinicmaster'),
                    )
                );
                $wp_admin_bar->add_node($args);
            } 
			
			
			
			
        }
    }
}
new ClinicMaster_Menu_Handle();