<?php 
	$clinicmaster_option = getDZThemeReduxOption();
	$sidebar_class 	= !empty($clinicmaster_option['sidebar_bg_color']) ? $clinicmaster_option['sidebar_bg_color']: '';
	$category_on = clinicmaster_get_opt('category_on',true);
	$date_on 	 = clinicmaster_get_opt('date_on',true);
	$tags_on 	 = clinicmaster_get_opt('tags_on',true);
	$featured_img_on 	 = clinicmaster_get_opt('featured_img_on',true); /* From Theme Options */
	
	$page_options = clinicmaster_dzbase()->get_meta();
	$padding_clas = '';
	$post_show_sidebar	= clinicmaster_dzbase()->get_meta('post_show_sidebar');
	$post_sidebar_layout	= clinicmaster_dzbase()->get_meta('post_sidebar_layout');
	$post_sidebar			= clinicmaster_dzbase()->get_meta('post_sidebar');
	$featured_image			= (isset($page_options['featured_image']))?clinicmaster_dzbase()->get_meta('featured_image'):true;
	if( !$post_show_sidebar || empty($post_sidebar) || !is_active_sidebar( $post_sidebar) || $post_sidebar_layout == 'full' || !clinicmaster_is_theme_sidebar_active())
	{
		$is_sidebar = false;
		$classes = 'col-xl-12 col-lg-12';
		$blog_classes = 'dz-blog blog-single ';
		
    }else{
		$is_sidebar = true;
		$blog_classes = 'dz-blog blog-single sidebar';
		if($sidebar_class != 'dz-medical'){
			$classes = ' col-xl-8 col-lg-8  ';
			$sid_class = 'col-xl-4 col-lg-4 dz-order-1';
		}else{
			$padding_clas = 'p-0';
			$classes = 'col-xl-9 col-lg-12 m-b30 pe-xl-5 ';
			$sid_class = 'col-xl-3 col-lg-12 ';
		}
	}
	$bg_class = ($sidebar_class == 'dz-skincare') ? 'bg-light':'';
	$social_sharing = clinicmaster_get_opt('social_sharing_on_post');
	$views_arr = get_post_meta(get_the_id(),'_views_count');
	$views = (isset($views_arr[0]))?$views_arr[0]:0;
?>
<!-- About Us -->
<div class="section-full post-header blog-single style-1 bg-white mb-0 <?php echo esc_attr($bg_class); ?>">
	<div class="dz-card text-center">
		<?php if ($featured_image && $featured_img_on && has_post_thumbnail()) { ?>
		<div class="dz-media overlay-secondary-light">
			<?php the_post_thumbnail('full'); ?>
		</div>
		<?php } ?>
		<div class="dz-info">
		<?php if(!clinicmaster_is_post_banner_enable()){ ?>
			<h1 class="dz-title text-white mx-auto">
			  <?php the_title(); ?>
			</h1>
		<?php } ?>
		<div class="dz-meta style-1 justify-content-center m-t15">
			<ul class="justify-content-center">
				<?php if(!empty($date_on)) { ?>
					<li class="post-date">
						<i class="far fa-calendar fa-fw m-r10"></i>
						<?php echo esc_html(get_the_date()); ?>
					</li>
				<?php } ?>
				
				<li class="dz-user">
					<i class="fa-solid fa-user fa-fw m-r10"></i>
					<?php esc_html_e('By', 'clinicmaster'); ?> 
					<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) )); ?>">
						<?php echo the_author_meta('display_name' , get_post_field( 'post_author', get_the_id() ) ); ?> 
					</a>
				</li>
			
				<?php echo clinicmaster_show_post_view_count_view($views); ?>
				
				<?php if($category_on) { ?>
					<li class="post-category">
						<i class="fa-solid fa-tag"></i>
						<?php echo  get_the_category_list(', '); ?>
					</li>
				<?php } ?>
			</ul>
		</div>
		</div>
	</div>	
</div>

<section class="content-inner bg-img-fix p-t60 bg-white ">
	<div class="<?php echo esc_attr(clinicmaster_get_container($is_sidebar)); ?>">
		<div class="row">
			<?php if ($post_sidebar_layout == 'left' && $is_sidebar) { ?>
				<!-- Side bar start -->
				<div class="<?php echo esc_attr($sid_class); ?>">
					<aside class="side-bar sticky-top left  <?php echo esc_attr($sidebar_class .' '.$padding_clas); ?>">
						<?php dynamic_sidebar( $post_sidebar ); ?>
					</aside>
				</div>
				<!-- Side bar END -->
			<?php } ?>
			<div class="<?php echo esc_attr($classes); ?>">
				<!-- blog start -->
				<?php while( have_posts() ){ the_post();  ?>
					<div class="<?php echo esc_attr($blog_classes); ?>">
						<div class="dz-info">
							<div class="dz-post-text text mt-0">
								<?php the_content(); ?>
							</div>
							
							<?php if(has_tag() || $social_sharing) { ?>
								<div class="dz-share-post meta-bottom bg-white">
									<?php if(has_tag() && !empty($tags_on)) { ?>
										<div class="post-tags">
											<strong><?php echo esc_html__('Tags:','clinicmaster') ?></strong>
											<?php clinicmaster_get_post_tags(get_the_id()); ?>
										</div>
									<?php }
									if(!empty($social_sharing)){
									?>		
										<div class="dz-social-icon primary-light">
										<?php echo clinicmaster_share_us(get_the_id(),get_the_title(),'','',array('','')); ?>
										</div>
									<?php } ?>
								</div>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
				
				<?php get_template_part('dz-inc/elements/author_block_element');  ?>	
				<?php get_template_part('dz-inc/elements/pagination_element'); ?>    
				<?php wp_link_pages(array('before'=>'<div class="paginate-links">'.esc_html__('Pages: ', 'clinicmaster'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>
				<?php get_template_part('dz-inc/elements/related_element');  ?>	
				<!-- blog END --> 
				<?php comments_template(); ?>					
				
				
			</div>  
			<!-- Side bar start -->
			<?php if ($post_sidebar_layout == 'right' && $is_sidebar) { ?>
				<!-- Side bar start -->
				<div class="<?php echo esc_attr($sid_class); ?>">
					<aside class="side-bar sticky-top right  <?php echo esc_attr($sidebar_class .' '.$padding_clas); ?>">
						<?php dynamic_sidebar( $post_sidebar ); ?>
					</aside>
				</div>
				<!-- Side bar END -->
			<?php } ?>
			
		</div>
	</div>
</section>
<!-- About Us End -->
