<?php	
	$post_layout_setting	= clinicmaster_dzbase()->get_meta('post_layout_setting');
	$post_pagination = '';
	
	$post_pagination	= clinicmaster_dzbase()->get_meta('post_pagination');
	$pre_next_post_on = clinicmaster_get_opt('pre_next_post_on',false);
	
	$post_pagination_view = 'With_Image';
	
	if($post_pagination && $pre_next_post_on) {
		
		$prev_post 		= get_previous_post();
		$next_post 		= get_next_post();
		
		if($post_pagination_view == 'With_Image')
		{
		?>
		<?php if (!empty( $prev_post ) || !empty( $next_post )) { ?>
		<div class="post-btn mt-0">
			<?php if (!empty( $prev_post )) { 
			
					$post_title = (has_post_thumbnail()) ? clinicmaster_trim($prev_post->post_title, 4) : $prev_post->post_title;
			?>
			<div class="prev-post">
				<a class="post-inner" href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>">
					<div class="inner-icon">
						<svg width="11" height="20" viewBox="0 0 11 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M10 1.5L1.25 10.25L10 19" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						</svg>
					</div>
					<?php
						if(has_post_thumbnail($prev_post->ID))
						{ 
							echo get_the_post_thumbnail($prev_post->ID, 'clinicmaster_100x100'); 
						}
					?>
					<div class="dz-info ms-3">
						<h6 class="title">
							<?php echo esc_html($post_title); ?> 
						</h6>
						<span class="post-date"><?php echo esc_html(get_the_date('',$prev_post->ID)); ?></span>
					</div>
				</a>
			</div>
			<?php }
				else
				{
					?>
					<div class="prev-post">
						<h6 class="start"><?php echo esc_html__('Start', 'clinicmaster'); ?></h6>
					</div>
					<?php
				}
			?>
			
			<?php if (!empty( $next_post )) { 
					$post_title = (has_post_thumbnail()) ? clinicmaster_trim($next_post->post_title, 4) : $next_post->post_title;	
			?>
			<div class="next-post">
				<a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" class="post-inner">
					<div class="dz-info me-3">
						<h6 class="title">
							<?php echo esc_html($post_title); ?> 
						</h6>
						<span class="post-date"><?php echo esc_html(get_the_date('',$next_post->ID)); ?></span>
					</div>
					<?php
						if(has_post_thumbnail($next_post->ID)) 
						{ 
							echo get_the_post_thumbnail($next_post->ID, 'clinicmaster_100x100'); 
						}
					?>
					<div class="inner-icon">
						<svg width="11" height="20" viewBox="0 0 11 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M1 18.5L9.75 9.75L1 1" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						</svg>
					</div>
				</a>
			</div>
			<?php }else
				{
					?>
					<div class="next-post">
						<h6 class="end"><?php echo esc_html__('End', 'clinicmaster'); ?></h6>
					</div>
					<?php
				}
			
			?>
		</div>
		<?php } ?>
		<?php	
		}else{
			
			$total_post 	= wp_count_posts('post','readable');
?>

			<div class="pagination-bx d-flex align-items-center justify-content-between m-b50">
				<ul class="pagination-number"></ul>
				<div class="pagination-number">
					<?php if(!empty($prev_post)) { ?>
					<a href="<?php echo esc_url(get_permalink( $prev_post->ID )); ?>" class="prev-page"><i class="fa fa-long-arrow-left"></i> <?php echo esc_html__('Prev Post','clinicmaster'); ?></a>
					<?php }else{ ?>
					<span  class="prev-page disabled"><i class="fa fa-long-arrow-left"></i> <?php echo esc_html__('Prev Post','clinicmaster'); ?></span>
					<?php } ?>
					<?php if(!empty($next_post)) { ?>
					<a href="<?php echo esc_url(get_permalink( $next_post->ID) ); ?>" class="next-page"><?php echo esc_html__('Next Post','clinicmaster'); ?> <i class="fa fa-long-arrow-right"></i></a>
					<?php }else{ ?>
					<span  class="next-page disabled"><i class="fa fa-long-arrow-right"></i> <?php echo esc_html__('Next Post','clinicmaster'); ?></span>
					<?php } ?>
				</div>
			</div>
<?php 	} 
	}
?>