<?php
$query_args = array(
	'post_type' => 'dz_testimonial',
	'post_status' => 'publish',
	'posts_per_page'    => $testimonial_slider_2_element_no_of_posts,
	'orderby' => $testimonial_slider_2_element_orderby,
	'order' => $testimonial_slider_2_element_order,
	'ignore_sticky_posts' => true,
);

$testimonial_slider_2_element_image_preference = !empty($testimonial_slider_2_element_image_preference) ? $testimonial_slider_2_element_image_preference : 'all_posts';

if ($testimonial_slider_2_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($testimonial_slider_2_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}


if (!empty($testimonial_slider_2_element_posts_in_categories) && !empty($testimonial_slider_2_element_posts_in_categories[0])) {

	$testimonial_slider_2_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($testimonial_slider_2_element_posts_in_categories, 'testimonial_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'testimonial_category',
		'field' => 'id',
		'terms' => $testimonial_slider_2_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$allowed_html_tags = clinicmaster_allowed_html_tag();
$element_content = !empty($testimonial_slider_2_element_content) ? $testimonial_slider_2_element_content : 'content-inner'; 
$content_text_limit = $testimonial_slider_2_element_text_limit;
$query = new WP_Query($query_args);

if (!empty($query->have_posts())) {
	if(!empty($testimonial_slider_2_element_image['id'])){ ?>
		<img src="<?php echo esc_url($testimonial_slider_2_element_image['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
	<?php } ?>
	<section class="<?php echo esc_attr($element_content); ?> pt-0">
	<div class="container">
		<div class="section-head style-1 text-center">
			<?php if(!empty($testimonial_slider_2_element_title)){ ?>
				<h2 class="title m-b10"><?php echo esc_html($testimonial_slider_2_element_title); ?></h2>
			<?php }
			if(!empty($testimonial_slider_2_element_description)){	?>
				<p><?php echo wp_kses($testimonial_slider_2_element_description, $allowed_html_tags); ?></p>
			<?php } ?>
		</div>
		<div class="swiper testimonial-swiper3 testimonial-wrapper3">
			<div class="swiper-wrapper">
				<?php

				while ($query->have_posts()) {
					$query->the_post();
					global $post;
					$post_id = $post->ID;
					$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
					$testimonial_designation = get_post_meta($post_id, 'testimonial_designation', true);	
					$rating_title = get_post_meta($post_id, 'testimonial_rating_title', true);	
					$youtube_text = get_post_meta($post_id, 'testimonial_youtube_text', true);	
					$youtube_link = get_post_meta($post_id, 'testimonial_youtube_link', true);	
					$testimonial_rating = get_post_meta($post_id, 'testimonial_rating', true);	
					$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);

				?>
				<div class="swiper-slide">
					<div class="testimonial-3">
						<div class="testimonial-detail">
							<?php if(!empty($short_description)){ ?>
							<div class="testimonial-contant">
								<div class="testimonial-text">
									<p><?php echo esc_html($short_description); ?></p>
								</div>
							</div>
							<?php } ?>
							<div class="testimonial-info">
								<div class="clearfix">
									<?php if(!empty($post_title)){ ?>
										<h5 class="testimonial-name"><?php echo esc_html($post_title); ?></h5>
									<?php }
									if(!empty($testimonial_designation)){ ?>
										<span class="testimonial-position"><?php echo esc_html($testimonial_designation); ?></span>
									<?php } ?>
								</div>		
							</div>		
						</div>
						<div class="testimonial-media">
							<?php if(has_post_thumbnail($post)){
								$img = get_the_post_thumbnail_url($post, 'medium'); 
								?>
								<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
							<?php } ?>
							<div class="item1">
								<div class="info-widget">
									<?php if(!empty($testimonial_rating)){ ?>
									<ul class="star-list">
										<?php 
										$star_count = $testimonial_rating;
										for($star=1;$star<=5;$star++){ 
												if($star<=$star_count){
											echo "<li><i class='fa fa-star'></i></li>";
											}
											else{
												echo "<li><i class='fa fa-star-o'></i></li>";
											}
										}		
										?>
									</ul>	
									<?php } ?>
									<?php if(!empty($rating_title)){ ?>
										<h3 class="title m-b0"><?php echo esc_html($rating_title); ?> </h3>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
			<div class="testimonial-pagination-swiper3 swiper-pagination style-1"></div>
		</div>
	</div>
</section>
<?php } ?> 
