<?php
	$blog_view = "service_listing_3";
	$page_no = 1;
	$post_type = 'dz_service';
	
	$query_args = array(	
		'post_type' 		=> $post_type,
		'post_status' 		=> 'publish',
		'posts_per_page'   	=> $service_listing_3_element_no_of_posts ,		
		'order' 			=> $service_listing_3_element_order,
		'ignore_sticky_posts' => true,
	);
	
	if($service_listing_3_element_orderby == 'views_count'){
		$query_args['meta_key']	= '_views_count';
	}
	else{
		$query_args['orderby']	= $service_listing_3_element_orderby;
	}

  
	$service_listing_3_element_image_preference = !empty($service_listing_3_element_image_preference)?$service_listing_3_element_image_preference:'all_posts';
	
	if($service_listing_3_element_image_preference == 'image_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'EXISTS'
			),
		);
	}
	elseif($service_listing_3_element_image_preference == 'text_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'Not EXISTS'
			),
		);
	}
	
	
	if(!empty($service_listing_3_element_posts_in_categories) && !empty($service_listing_3_element_posts_in_categories[0]))
	{			
		
		$service_listing_3_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($service_listing_3_element_posts_in_categories,'service_category');
		
		$query_args['tax_query'][] = array(
		'taxonomy' => 'service_category',
		'field' => 'id',
		'terms' => $service_listing_3_element_posts_in_categories1,
		'operator' => 'IN'
		); 
		$service_listing_3_element_posts_in_categories = implode(',',$service_listing_3_element_posts_in_categories);
	}else{
		$service_listing_3_element_posts_in_categories = '';
	}		
	
	
	if($service_listing_3_element_only_featured_posts == 'yes') 
	{ 		
		$query_args['meta_key'] = 'featured_post';		
		$query_args['meta_value'] = 1;				
		$query_args['meta_compare'] = 'LIKE';		
	}
	
	$query = new WP_Query($query_args);	
	
	
	
	$blog_view_container = '';
	if($service_listing_3_element_pagination_style == 'load_more')
	{
		$blog_view_container = $blog_view."_LoadMoreContainer";
	}
	
	global $clinicmaster_query_result;
	$clinicmaster_query_result['posts'] = $query->posts;	
	
	$clinicmaster_query_result['posts_per_page'] = $service_listing_3_element_no_of_posts;	
	$clinicmaster_query_result['current_page'] = $page_no;
	$clinicmaster_query_result['title_text_limit'] = $service_listing_3_element_text_limit;
	$clinicmaster_query_result['show_column'] = $service_listing_3_element_cols;
	$clinicmaster_query_result['blog_view_container'] = $blog_view_container;		
	$max_num_pages = $query->max_num_pages;	

	$element_content = !empty($service_listing_3_element_content) ? $service_listing_3_element_content :'content-inner';
	$css_class = !empty($service_listing_3_element_css_class) ? $service_listing_3_element_css_class :'';
	
	
	if($query->have_posts()) {		
?>
<section class="<?php echo esc_attr($element_content ); ?> bg-light border-top" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>); background-size: cover; background-position: center;" <?php } ?>>
	<div class="container">
		<div class="section-head style-1 m-b30 text-center">
			<?php if(!empty($service_listing_3_element_title) || !empty($service_listing_3_element_subtitle)){ ?>
				<?php if(!empty($service_listing_3_element_subtitle)){ ?>
					<span class="sub-title sub-title-icon">
					    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="22" viewBox="0 0 23 22" fill="none">
								<mask id="mask0_229_978" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="23" height="22">
								<path d="M0.5 1.90735e-06H22.5V22H0.5V1.90735e-06Z" fill="white"></path>
								</mask>
								<g mask="url(#mask0_229_978)">
									<path d="M20.1788 5.97717C20.1682 5.41802 20.1581 4.88976 20.1581 4.37878C20.1581 3.97839 19.8336 3.65385 19.4331 3.65385C16.3329 3.65385 13.9725 2.76281 12.005 0.849795C11.7235 0.576041 11.2756 0.57617 10.9943 0.849795C9.02693 2.76281 6.66691 3.65385 3.56689 3.65385C3.16651 3.65385 2.84192 3.97839 2.84192 4.37878C2.84192 4.88989 2.83191 5.41832 2.82117 5.9776C2.72182 11.1812 2.58574 18.308 11.2622 21.3154C11.3391 21.3421 11.4193 21.3555 11.4996 21.3555C11.5798 21.3555 11.6601 21.3421 11.737 21.3154C20.4141 18.3078 20.2782 11.1809 20.1788 5.97717Z" stroke="#DB479D" stroke-width="2" stroke-miterlimit="10"></path>
									<path d="M12.7863 10.4984C12.234 10.4984 11.7863 10.0507 11.7863 9.49843V7.77975H11.214V9.49843C11.214 10.0507 10.7662 10.4984 10.214 10.4984H8.49512V11.0708H10.214C10.7662 11.0708 11.214 11.5185 11.214 12.0708V13.7894H11.7863V12.0708C11.7863 11.5185 12.234 11.0708 12.7863 11.0708H14.5048V10.4984H12.7863Z" stroke="#3D203F" stroke-width="2" stroke-miterlimit="10" stroke-linejoin="round"></path>
								</g>
                             </svg> 	
					<?php echo wp_kses($service_listing_3_element_subtitle, clinicmaster_allowed_html_tag()); ?></span>
				<?php } ?>
				<?php if(!empty($service_listing_3_element_title)){ ?>
					<h2 class="title"><?php echo wp_kses($service_listing_3_element_title, clinicmaster_allowed_html_tag()); ?></h2>
				<?php } ?>
			<?php } ?>
			
		</div>
		<div <?php if(!empty($blog_view_container)){ ?> id="<?php echo esc_attr($blog_view_container) ?>" <?php } ?> class="row justify-content-center">
			<?php get_template_part('dz-inc/elementor/ajax/service_listing_3_ajax'); ?>
		</div>
		<?php
			if($service_listing_3_element_pagination_style == 'load_more')
			{	
				$blog_view_btn = $blog_view."_LoadMoreBtn";
				$blog_view_container = $blog_view."_LoadMoreContainer";
				
				if( 1 < $max_num_pages ) 
				{ 
				?>
				<!-- Pagination start -->
				<div class="reload-btn text-center mb-4">
				<a href="javascript:void(0);" class="btn btn-lg btn-icon btn-primary loadmore-btn dz-load-more" id="<?php echo esc_attr($blog_view_btn); ?>"   
					data-ajax-container = "<?php echo esc_js($blog_view_container); ?>"					
					data-post-type = "<?php echo esc_js($post_type);?>" 
					data-blog-view = "<?php echo esc_js($blog_view);?>" 
					data-max-num-pages="<?php echo esc_js($max_num_pages);?>" 
					data-posts-per-page="<?php echo esc_js($service_listing_3_element_no_of_posts);?>"
					data-only-featured-post="<?php echo esc_js($service_listing_3_element_only_featured_posts)?>" 
					data-post-order="<?php echo esc_js($service_listing_3_element_order)?>"	
					data-post-order-by="<?php echo esc_js($service_listing_3_element_orderby)?>"	
					data-listing-bg-img="<?php echo esc_js($service_listing_3_element_listing_bg_img);?>"
					data-title-text-limit="<?php echo esc_js($service_listing_3_element_text_limit);?>"
					data-show-column="<?php echo esc_js($service_listing_3_element_cols);?>" 
					data-posts-in-categories="<?php echo esc_js($service_listing_3_element_posts_in_categories);?>"
					>
					<?php echo esc_html__('Load More', 'clinicmaster'); ?>
					<span class="right-icon dz-load"><i class="feather icon-refresh-ccw"></i></span>
				</div>
				<!-- Pagination End -->
				<?php 
				}
			}
		?>
		
		<?php if(!empty($service_listing_3_element_button_text) || !empty($service_listing_3_element_text)){ ?>
		<div class="dz-separator style-4  wow fadeInUp">
			<?php if(!empty($service_listing_3_element_text)){ ?>
				<h6 class="title"><?php echo esc_html($service_listing_3_element_text); ?></h6>
			<?php } ?>
			
            

			<?php if(!empty($service_listing_3_element_button_text) && !empty($service_listing_3_element_button_link['url'])){
				$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($service_listing_3_element_button_link);
				?>	
				<a href="<?php echo esc_url($service_listing_3_element_button_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn btn-secondary separator-badge btn-rounded shadow-md"><?php echo esc_html($service_listing_3_element_button_text); ?></a>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
	
</section>		
	<?php } ?>