<?php 
if (
		$service_detail_2_element_selected_sidebar=='No_Sidebar' ||
		$service_detail_2_element_sidebar_layout == '' ||
		!is_active_sidebar( $service_detail_2_element_selected_sidebar ) ||
		!clinicmaster_is_theme_sidebar_active() 
	) 
	{
		$section_class = 'col-lg-12 single-inner order-lg-1';
	}else{
		$section_class = 'col-lg-8 single-inner order-lg-1';
	}
	$allowed_html_tag = clinicmaster_allowed_html_tag();
?>
<section class="content-inner service-single bg-light">
	<div class="container">
		<div class="row">
					<?php if ($service_detail_2_element_sidebar_layout == 'left' && 
					is_active_sidebar( $service_detail_2_element_selected_sidebar ) && 
					clinicmaster_is_theme_sidebar_active() ) 
					{ ?>
						<div class="col-lg-4 m-b30">
							<aside class="side-bar sticky-top left">
								<?php dynamic_sidebar( $service_detail_2_element_selected_sidebar ); ?>
							</aside>
						</div>
					<?php } ?>
					
					<div class="<?php echo esc_attr($section_class); ?>">
						<?php if(!empty($service_detail_2_element_image['id'])){ 
						$img = wp_get_attachment_image_url($service_detail_2_element_image['id'], 'large');
						?>
							<div class="single-media dz-media single-media height-sm radius-lg">
								<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>" class="object-fit-cover">
							</div>
						<?php } ?>
						
						<div class="content-item">
							<?php if(!empty($service_detail_2_element_title)){ ?>
								<h2>
									<?php echo wp_kses($service_detail_2_element_title, 'string'); ?>
								</h2>
							<?php } ?>
							
							<?php if(!empty($service_detail_2_element_description)){ ?>
								<p>
									<?php echo wp_kses($service_detail_2_element_description, $allowed_html_tag); ?>
								</p>
							<?php } ?>
						</div>
						<div class="content-item row g-4">
							<?php if(!empty($service_detail_2_element_feature_img['id'])){ 
								$img = wp_get_attachment_image_url($service_detail_2_element_feature_img['id'], 'clinicmaster_600x600');
								?>
								<div class="col-xl-6">
									<div class="dz-media height-sm radius-lg me-xl-4">
										<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>" class="object-fit-cover">
									</div>
								</div>
							<?php } ?>
								
							
							<div class="col-xl-6">
								<?php if(!empty($service_detail_2_element_feature_title) || !empty($service_detail_2_element_feature_description)){ ?>
									
										<?php if(!empty($service_detail_2_element_feature_title)){ ?>
											<h4><?php echo esc_html($service_detail_2_element_feature_title); ?></h4>
										<?php }
										if(!empty($service_detail_2_element_feature_description)){ ?>
											<p class="fs-6 fw-normal"><?php echo wp_kses($service_detail_2_element_feature_description,'dtring'); ?></p>
										<?php } ?>
									
								<?php } ?>
								<?php 
								$items = $service_detail_2_element_item;
								if(!empty($items)){ ?>
									<ul class="list-style-1 ">
										<?php foreach($items as $val){
										$title = $val['service_detail_2_element_item_title'];
										$description = $val['service_detail_2_element_item_description'];
										?>
										<li>
											<?php if(!empty($title)){ ?>
												<h6 class="title"><?php echo esc_html($title); ?></h6>
											<?php }
											if(!empty($description)){ ?>
												<p><?php echo wp_kses($description,'string'); ?></p>
											<?php } ?>
										</li>
										<?php } ?>
									</ul>
								<?php } ?>
								
							</div>
						</div>
						<div class="content-item">
							<?php if(!empty($service_detail_2_element_title2)){ ?>
								<h2>
									<?php echo wp_kses($service_detail_2_element_title2, 'string'); ?>
								</h2>
							<?php } ?>
							
							<?php if(!empty($service_detail_2_element_description2)){ ?>
								<p>
									<?php echo wp_kses($service_detail_2_element_description2, $allowed_html_tag); ?>
								</p>
							<?php } ?>
						</div>
						<?php if(!empty($service_detail_2_element_show_faq) && $service_detail_2_element_show_faq == 'yes'){ ?>
						<div class="content-item">
							<?php if(!empty($service_detail_2_element_faq_title)){ ?>
								<h3><?php echo esc_html($service_detail_2_element_faq_title); ?></h3>
							<?php } ?>
							<?php if(!empty($service_detail_2_element_desc)){ ?>
								<p><?php echo wp_kses($service_detail_2_element_desc,'string'); ?></p>
							<?php } 
							$query_args = array(
								'post_type'         => 'dz_faq',
								'post_status'       => 'publish',
								'posts_per_page'    => 4,
								'order'             => 'desc',
								'orderby'           => 'date',
								'ignore_sticky_posts' => true,
							);
							$query = new WP_Query($query_args);
							if($query->have_posts()) { ?>
							<div class="accordion dz-accordion style-3" id="accordionExample">
								<?php 
								$num = 1;
								while($query->have_posts())
								{ 	
									$query->the_post();
									global $post ;
									$post_id  = $post->ID;
									$post_title =  clinicmaster_trim($post->post_title, 8);
									$excerpt = $post->post_excerpt;
									$content = $post->post_content;
									$short_description = clinicmaster_short_description($excerpt, $content, 40);
										$active = ($num == 1) ? 'show' :'';
										$collapsed = ($num > 1) ? 'collapsed' :'';
									  ?>
									<div class="accordion-item wow fadeInUp" data-wow-delay="0.5s" data-wow-duration="0.8s">
										<?php if(!empty($post_title)){ ?>
											<h2 class="accordion-header">
												<button class="accordion-button <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo esc_attr($num); ?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr($num); ?>">
													<?php echo esc_html($post_title); ?>
												</button>
											</h2>
										<?php } 
										if(!empty($short_description)){ ?>
											<div id="collapseOne<?php echo esc_attr($num); ?>" class="accordion-collapse collapse  <?php echo esc_attr($active); ?>" data-bs-parent="#accordionExample">
												<div class="accordion-body">
													<p><?php echo wp_kses($short_description, 'string'); ?></p>
												</div>
											</div>
										<?php } ?>
										
									</div>
								
							<?php $num++;
							} ?>
							</div>
							<?php } ?>
						</div>
						<?php } ?>
					</div>
					
					<?php if ($service_detail_2_element_sidebar_layout == 'right' && 
					is_active_sidebar( $service_detail_2_element_selected_sidebar ) && 
					clinicmaster_is_theme_sidebar_active() ) 
					{ ?>
						<div class="col-lg-4 m-b30">
								<aside class="side-bar sticky-top right">
									<?php dynamic_sidebar( $service_detail_2_element_selected_sidebar ); ?>
								</aside>
						</div>
					<?php } ?>
		</div>
	</div>
</section>